/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include "htable.h"
#include <limits.h>

/* prime number test, from hsearch.c of the linux libc-5.3.12 */
static int is_prime( unsigned int number)
{
  unsigned div = 3;
  number |= 1;   /* Make it definitely odd.  */
  while (div*div < number && number%div != 0)
    div += 2;
  return number%div != 0;
}

/* from locale/hash.c in linux libc-5.3.12 */
static unsigned long next_prime(unsigned long seed)
{
  while (!is_prime (seed))
    seed += 2;
  return seed;
}

/* to easily try several hash function */
#define hashcode( s) helf( s)

/* WARNING : hpjw and hashval seem to be broken */

/* hash function, from the dragon, p. 481 of the french version */
unsigned int hpjw(char *c)
{
    char *p;
    unsigned h, g;

    /* randomize h */
    h = (unsigned int)c & (unsigned int)&h;
    for( p = c; *p; p++) {
	  h = (h << 4) + (*p);
	  if (!(g = h & 0xF0000000)) {
		h = h | (g >> 24);
		h = h | g;
	  }
    }
    return h;
}

/* hash function, from locale/hash.c of the linux libc-5.3.12 */
hashval(const char *key)
{
  unsigned long hval, g;
  /* Compute the hash value for the given string.  */
  hval = (unsigned int)key;
  while (*key)
    {
      hval <<= 4;
      hval += *key++;
      g = hval & (0xf << 28);
      if (g != 0)
	{
	  hval ^= g >> 24;
	  hval ^= g;
	}
    }
  return hval;
}

/* hash function, from elf/d-link/hash.c of the linux libc-5.3.12 */
unsigned long helf(char *name)
{
  unsigned long hash = 0;
  unsigned long tmp;
  
  while (*name){
    hash = (hash << 4) + *name++;
    if((tmp = hash & 0xf0000000)) hash ^= tmp >> 24;
    hash &= ~tmp;
  };
  return hash;
}

htable *hinit( unsigned long size)
{
  htable *t;
  t = (htable*)malloc( sizeof(htable));
  t->size = next_prime( size);
  t->t = (void*)calloc( t->size, sizeof( void*));
  return t;
}

void *hinsert(htable *t, char *s, void *v)
{
  unsigned int i;
  struct hentry *p;

    i =hashcode(s) % t->size;   /* compute the hash code and get the entry */
    
  /* then add v at the beginning of the list */
  if (p = (struct hentry*)malloc(sizeof(struct hentry))) {
    p->name = (char*)strdup(s);
    p->info = v;
    p->next = (t->t)[i];
    (t->t)[i] = p;
      return (void*)p;
  }
  else
    return (void*)0;
}

void *hfind(htable *t, char *s)
{
  struct hentry *p;
  unsigned int h = hashcode(s) % t->size;

/*   printf( "cherche %s avec %d\n", s, h); */
  p = (t->t)[h]; /* compute the hash code and get the entry */

  while (p && strcmp(p->name, s))
    p = p->next;

  if (p) {
/*     printf( "trouve\n"); */
    return p->info;
  }
  else
    return (void*)0;
}

void *hreplace(htable *t, char *s, void *v)
{
  unsigned int i;
  struct hentry *p, *q;
  void *r;
  
    i =hashcode(s) % t->size;   /* compute the hash code and get the entry */
    
  /* then search if an entry named s exists */
  p = t->t[i]; /* get the entries list */

  if (p && !strcmp(p->name, s)) {
    /* the entry is at the beginning of the list */
    r = p->info;
    p->info = v;
    return r;
  }
  else {
    while (p->next && !strcmp(p->next->name, s))
      p++;
        
    if (p->next) {/* the entry has been found */
      r = p->next->info;
      p->next->info = v;
      return r;
    }
    else {/* no existing entry; adds a new one */
      q = (struct hentry*)malloc(sizeof(struct hentry));
      q->name = (char*)strdup(s);
      q->info = v;
      q->next = (void*)0;
      p->next = q;
      return (void*)0;
    }
  }
}

void *hremove(htable *t, char *s)
{
  unsigned int i;
  struct hentry *p, *q;
  void *r;

  i = hashcode(s) % t->size; /* compute the hash code */
  p = t->t[i]; /* get the entry */

  if (p && !strcmp(p->name, s)) {
    /* the entry is at the beginning of the list */
    t->t[i] = p->next;
    r = p->info;
    free(p);
    return r;
  }
  else {
    while (p->next && !strcmp(p->next->name, s))
      p++;
        
    if (p->next) {
      r = p->next->info;
      q = p->next;
      p->next = p->next->next;
      free(q);
      return r;
    }
    else
      return (void*)0;
  }
}

void hfree( htable *t, void (*efree)( void *))
{
  unsigned int i;
  struct hentry *p, *q;
  
  for (i = 0; i < t->size; i++)
      if (t->t[i]) {
        p = t->t[i];
        while (p) {
	  q = p->next;
          efree( p->info);
	  free(p);
          p = q;
        }
      }
  free( t->t);
  free( t);
}

void hprint( FILE *f, htable *t, void (*eprint)( FILE*, void *))
{
  unsigned int i;
  struct hentry *p;
  
  for (i = 0; i < t->size; i++)
      if (t->t[i]) {
        p = t->t[i];
        fprintf( f, "[%3d]:\t", i);
        while (p) {
	  fprintf( f,"%s\t", p->name);
          eprint( f, p->info);
          p = p->next;
        }
        putc('\n', f);
      }
}
