/***************************************************************************/
/* value.h                                                                 */
/*                                                                         */
/* Description file for operations on Bss-values                           */
/*                                                                         */
/***************************************************************************/

/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef VALUE_H
#define VALUE_H

#include <stdio.h>
#include "integer.h"
#include "rational.h"
#include "float.h"
#include "infinity.h"


#define DEF_BSTRING_SIZE 512

enum BssType{ Integer , Rational , Float ,
	      Interval , Union_of ,
	      Minus_infinity , Plus_infinity }; 

struct bssvalue {
  enum BssType type;
  union {
    BssIntP i;
    BssRatP q;
    BssFltP f;
    /*    struct bssitv*/void *r;
    /*
    BssUofP u;
    */
    BssInfP l;
    void *p;
  } value;
};

typedef struct bssvalue BssValueType;
typedef BssValueType BssValue[1];
typedef BssValueType *BssValueP;

#include "interval.h"
/*
#include "union_of.h"
*/

#define BssIsInt(v)  ((v)[0].type == Integer)
#define BssIsRat(v)  ((v)[0].type == Rational)
#define BssIsFlt(v)  ((v)[0].type == Float)
#define BssIsItv(v)  ((v)[0].type == Interval)
#define BssIsUof(v)  ((v)[0].type == Union_of)
#define BssIsMinf(v) ((v)[0].type == Minus_infinity)
#define BssIsPinf(v) ((v)[0].type == Plus_infinity)
#define BssIsInf(v) (BssIsMinf( v) || BssIsPinf( v))

#define BssType(v)       ((v)[0].type)
#define BssGetType(v)    ((v)[0].type)
#define BssSetType(v, t) ((v)[0].type = t)

#define BssIsBasic(v) (!(BssIsItv(v)||BssIsUof(v)))

#define BssValP( v)   ((v)[0].value.p)

#define BssVal( v)    ((v)[0].value.p)
#define BssValInt( v) ((v)[0].value.i)
#define BssValRat( v) ((v)[0].value.q)
#define BssValFlt( v) ((v)[0].value.f)
#define BssValItv( v) (((struct bssitv*)((v)[0].value.r)))
/*
#define BssValUof( v) ((v)[0].value.u)
*/
#define BssValInf( v) ((v)[0].value.l)

#define BssValRef( v)    ((v)[0].value.p)
#define BssValIntRef( v) ((v)[0].value.i)
#define BssValRatRef( v) ((v)[0].value.q)
#define BssValFltRef( v) ((v)[0].value.f)
#define BssValItvRef( v) (((struct bssitv*)((v)[0].value.r)))
/*
#define BssValUofRef( v) ((v)[0].value.u)
*/
#define BssValInfRef( v) ((v)[0].value.l)

#define BssMin( v1, v2, cmp) \
    ((BssCmp( v1, v2, cmp) < 0)\
     ? v1\
     : v2)
#define BssMax( v1, v2, cmp) \
    ((BssCmp( v1, v2, cmp) > 0)\
     ? v1\
     : v2)

#define BssInit(v) (v[0].value.p = (void*)0)
     
BssValueP BssAlloc();
BssValueP BssAllocCopy( const BssValue v1);
BssValueP BssAllocInit( const enum BssType type, ...);

void BssSet( BssValue v, const enum BssType type, ...);
void BssCopy( BssValue v, const BssValue v1);
void BssFree( BssValueP v);
void BssFreeValue( BssValue v);

void BssAdd( BssValue r, const BssValue r1, const BssValue r2);
void BssSub( BssValue r, const BssValue r1, const BssValue r2);
void BssMinus( BssValue r, const BssValue r1);
void BssMul( BssValue r, const BssValue r1, const BssValue r2);
void BssDiv( BssValue r, const BssValue r1, const BssValue r2);
void BssSqrt( BssValue r, const BssValue r1);
void BssAbs( BssValue r, const BssValue r1);
void BssSqr( BssValue r, const BssValue r1);
void BssPow( BssValue r, const BssValue r1, int n);

int BssInter( BssValue r, const BssValue v1, const BssValue v2);

void BssWrite( FILE *f, const BssValue v, int precision);

int BssCmp( const BssValue v1, const BssValue v2, int *cmp);

char *Bss2bstring( const BssValue v, unsigned int *size);
BssValueP bstring2Bss( const char *s);

extern BssValue *klic2Bss( void *);
extern void *Bss2klic( const BssValue );

char *Bss2wstring( const BssValue v);
BssValueP wstring2Bss( const char *s);

#endif
