/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include "infinity.h"
#include <stdlib.h>
#include <stdio.h>

BssInfP InfAllocCopy( const BssInf v1)
{
  BssInfP i;

  i = InfAlloc();
  InfVal(i) = InfVal( v1);

  return i;
}

BssInfP InfAllocInit( char i)
{
  BssInfP v;

  v = InfAlloc();
  InfVal(v) = i;

  return v;
}

char *Inf2bstring( const BssInf v, unsigned int *size)
{
  char *s;

  s=(char*)malloc(1);
  s[0] = InfVal( v);
  *size = 1;

  return s;
}

char *Inf2wstring( const BssInf v)
{
  char *s;

  s = (char*)malloc( 8);
  sprintf( s, "l(%cInf)",InfVal(v)== MinusInf? '-':'+');

  return s;
}

BssInfP wstring2Inf( char *s)
{
  if (s[0]=='l' && s[1]=='(')
    if (s[2] =='+')
      return InfAllocInit( PlusInf);
    else
      return InfAllocInit( MinusInf);
  else
    return 0;

}
