/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include "fvar.h"
#include <stdlib.h>
#include <string.h>

#define name2tag(n) ((n) >> (unsigned int)sizeof(long)*4) 
#define name2loc(n) (((n) << sizeof(long)*4) >> sizeof(long)*4)
#define tagloc2name(t, l) (((t) << (sizeof(long)*4))| (l))

#define LIBERE

FVar *FVarAllocInit( /* char **/ int name, Location loc)
{
  FVar *v;

  v = (FVar*)malloc( sizeof( FVar));
  v->Name = name;
  v->Loc = loc;

  return v;
}

void FVarFree( FVar *v)
{
  /*  free( v->Name); */
  free( v);
}

void FVarWrite( FILE *f, FVar *v)
{
  fprintf( f, "%d@%d", FVarName( v), FVarLoc( v));
}

char *FVar2wstring( FVar *v)
{
  char *s;
  unsigned long int code, tmp;
  int size;
  int l;

  code = tagloc2name(v->Name,v->Loc);
/*   for ( l=1, n=FVarLoc( v); n > 10; l++, n /= 10);
  
  s = (char*)malloc( strlen( FVarName( v)) + 5 + l);
 
  sprintf( s, "v(%s,%d)", FVarName( v), FVarLoc(v)); */

  for (size=1, tmp=code; tmp > 9; tmp/= 10, size++);
  
  s = (char*)malloc( 4 + size);

  sprintf( s, "v(%ld)", code);

  return s;
}
		    
FVar *wstring2FVar( const char *source)
{
  int l, i;
  char *s, *p;
  unsigned long code;
  FVar *v;

  s = strdup(source);
  p = s;
  if (s[0]=='v' && s[1]=='(') {
  
/*     for ( l=0, n=&s[2]; *n != ','; l++, n++);
  
    v = (FVar*)malloc(sizeof(FVar));
    FVarName( v) = (char*)malloc( l +1);
    for( i=0; i<l; i++)
      FVarName( v)[i] = s[2 + i];
    FVarName( v)[l] = '\0';
    FVarLoc( v) = atoi( ++n); */

    s+=2;
    /*    code = strtoul( s, (char**)0, 10);*/
    code = (unsigned long)strtol( s, (char**)0, 10);
    v = (FVar*)malloc(sizeof(FVar));
    FVarName( v) = name2tag(code);
    FVarLoc( v) = name2loc(code);
  }

#ifdef LIBERE  
  free(p);
#endif  
  return v;
}

char *FVar2bstring( FVar *v, int *length)
{
  char *s;

  s = FVar2wstring( v);
  *length = strlen(s) +1;
  return s;
}

FVar *bstring2FVar( const char *s)
{
  return wstring2FVar( s);
}


char *FVarExtractVars( FVar *v, int *l)
{
  long *s;
  
  s = (long*)malloc( sizeof( long));
  s[0] = ((FVarName(v) << (sizeof(long)*4))|FVarLoc(v));
  l[0] = sizeof( long);
  
  return (char*)s;
}
