/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include "fop.h"
#include <stdarg.h>
#include <stdlib.h>

#define LIBERE

FOp *FOpAllocInit( char *name, BssFormula *left, BssFormula *right)
{
  FOp *Op;

  Op = (FOp *)malloc( sizeof( FOp));
  FOpName( Op) = (char*)strdup( name);

  FOpArgs( Op) = (Arg*)malloc( sizeof(Arg));
  LeftArg( FOpArgs( Op)) = left;
  RightArg( FOpArgs( Op)) = right;

  return Op;
}

void FOpFree( FOp *f)
{
  free(FOpName( f));
  FmlFree( LeftArg( FOpArgs( f)));
  if (FOpIsBinary( f))
    FmlFree( RightArg( FOpArgs( f)));

  free(f);
}

int isinfix( FOp *op)
{
  if (FOpIsBinary( op))
    if (!strcmp( FOpName( op), "="))
      return 1;
    else if (!strcmp( FOpName( op), "<"))
      return 1;
    else if (!strcmp( FOpName( op), ">"))
      return 1;
    else if (!strcmp( FOpName( op), ">="))
      return 1;
    else if (!strcmp( FOpName( op), "<="))
      return 1;
    else if (!strcmp( FOpName( op), "+"))
      return 1;
    else if (!strcmp( FOpName( op), "-"))
      return 1;
    else if (!strcmp( FOpName( op), "*"))
      return 1;
    else if (!strcmp( FOpName( op), "/"))
      return 1;
    else
      return 0;
  else
    return 0;
}

void FOpWrite( FILE *f, FOp *op, int precision)
{

  if (isinfix( op)) {
    putc( '(', f);
    FmlWrite( f, LeftArg( FOpArgs( op)), precision);
    fprintf( f, " %s ", FOpName( op));
    FmlWrite( f, RightArg( FOpArgs( op)), precision);
    putc( ')', f);
  }
  else {
    fprintf( f, "%s(", FOpName( op));
    FmlWrite( f, LeftArg( FOpArgs( op)), precision);
    if (FOpIsBinary( op)) {
      fputc( ',', f);
      FmlWrite( f, RightArg( FOpArgs( op)), precision);
    }
    fputc( ')', f);
  }
}

char *FOp2wstring( FOp *f)
{
  char *s, *sl, *sr;
  
  sl = Fml2wstring( LeftArg( FOpArgs( f)));
  if (FOpIsBinary( f))
    sr = Fml2wstring( RightArg( FOpArgs( f)));

  if (FOpIsBinary( f)) {
    s = (char*)malloc( strlen(FOpName( f)) +strlen(sl) +strlen(sr) +7);
    sprintf(s, "o(%s(%s,%s))", FOpName( f), sl, sr);
  }
  else {
    s = (char*)malloc( strlen(FOpName( f)) +strlen(sl) +6);
    sprintf(s, "o(%s(%s))", FOpName( f), sl);
  }

#ifdef LIBERE  
  free( sl);
  if (FOpIsBinary( f))
    free( sr);
#endif
  
  return s;
}

FOp *wstring2FOp( char *s1)
{
  char *name, *s, *p;
  int l, pile, virg, go;
  BssFormula *la, *ra;
  FOp *f;
  
  if ((s1[0]=='o') && (s1[1]=='(') && (s1[strlen(s1)-1]==')'))
    {
      p = s = strdup(s1);
      s+=2;
      /* get the name */
      l = strcspn( s, "(");
      name = (char*)malloc( l + 1);
      strncpy( name, s, l);
      name[l] = '\0';
      s += l + 1;
      /* get the left arg */
      la = wstring2Fml( s);
      
      /* get the right arg */
      /* search the beginning */
      pile = 0;
      virg = 0;
      go = 0;
      do {
	switch (s[0]) {
	case '(':
	  go++; /* then we can stop when the condition arises */
	  pile++;
	  break;
	case ',':
	  if (!pile)
	    virg++;
	  break;
	case ')':
	  pile--;
	}
	s++;
      } while (!go || pile!=0);
      /* then get it */
      if (pile ==0 && (++s)[0] != ')')
	ra = wstring2Fml( s);
      else
	ra = 0;

      f = FOpAllocInit( name, la, ra);
#ifdef LIBERE      
      free( p);
      free(name);
#endif
    }
  else
    f = (FOp*)0;
  
  return f;
}

char *FOp2bstring( FOp *f, int *length)
{
  char *s;

  s = FOp2wstring( f);
  *length = strlen( s) +1;
  return s;
}

FOp *bstring2FOp( char *s)
{
  return wstring2FOp( s);
}

char *FOpExtractVars( FOp *f, int *l)
{
  char *s, *sr;
  int ll, lr;
  
  s = FmlExtractVars( LeftArg( FOpArgs( f)), &ll);
  l[0] = ll;
  
  if (FOpIsBinary( f)) {
    sr = FmlExtractVars( RightArg( FOpArgs( f)), &lr);
    if (lr) {
      s = realloc( s, ll + lr);
      memcpy( &s[ll], sr, lr);
      l[0] += lr;
      free( sr);
    }
  }

  return s;
}
