/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef CTRS_H
#define CTRS_H

#include <stdio.h>
#include "formula.h"
#include <reps.h>

typedef struct {
  /*  char **/ int name;
  int loc;
  BssFormula *formula;
  LRep *ext;
} BssCtr;

#define CtrName( v)       ((v)->name)
#define CtrLoc( v)       ((v)->loc)
#define CtrFormula( v)      ((v)->formula)
#define CtrExt( v)     ((v)->ext)

BssCtr *CtrAllocInit( /* char **/ int name , int loc, BssFormula *formula);
/* The two following functions return a pointer to the address of the
   stored formula */
#define CtrAddRep( v, rep, formula) LRepInsert( CtrExt( v), rep, formula)
#define CtrGetRep( v, rep) LRepFind( CtrExt( v), rep)

#define CtrWhichRep( v) LRepWhich( CtrExt( v))

void CtrFree( BssCtr *v, void (*rfree)( void *));
#define CtrWrite( f, v) fprintf( f, "%d@%d", CtrName( v), CtrLoc(v));

char *Ctr2bstring( BssCtr *v, int *length);
BssCtr *bstring2Ctr( char *s);

#endif
