/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include <search.h>
#include <string.h>
#include "ctrs.h"
#include "formula.h"

BssCtr *CtrAllocInit( /* char **/ int name, int loc, BssFormula *f)
{
  BssCtr *v;

  v = (BssCtr*)malloc( sizeof( BssCtr));
  CtrName( v) = name /*(char*)strdup(name)*/;
  CtrLoc( v) = loc;
  CtrFormula( v) =  f;
  CtrExt( v) = LRepAlloc();

  return v;
}

void CtrFree( BssCtr *v, void (*rfree)( void *))
{
  FmlFree( CtrFormula (v));
  LRepFree( CtrExt( v), rfree);
  free( v);
}

char *Ctr2bstring( BssCtr *v, int *length)
{
  char *s, *fs;
  int ln, lf;

  fs = Fml2bstring( CtrFormula( v), &lf);
/*   ln = strlen( CtrName( v));
  s = (char *)malloc( lf + ln + 1); */
  s = (char *)malloc( lf + 2*sizeof(int));

  memcpy( s, &CtrName( v), sizeof(int));
  memcpy( &s[sizeof(int)], &CtrLoc( v), sizeof(int));
  memcpy( &s[2*sizeof(int)], fs, lf);

  free(fs);
  
  *length = lf + 2*sizeof(int);
  return s;
}

BssCtr *bstring2Ctr( char *s)
{
  BssCtr *c;

  c = (BssCtr*)malloc( sizeof( BssCtr));

/*   CtrName( c) = strdup( s);
  s += (strlen( CtrName( c)) + 1); */

    memcpy( &CtrName( c), s, sizeof( int));
    s+= sizeof(int);
    memcpy( &CtrLoc( c), s, sizeof( int));
    s += sizeof(int);
    CtrFormula( c) = bstring2Fml( s);

    CtrExt( c) = LRepAlloc();

  return c;
}

