/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef LOCAL_H
#define LOCAL_H

#include <vars.h>
#include <ctrs.h>

#define name2tag(n) ((n) >> (unsigned int)sizeof(long)*4) 
#define name2loc(n) (((n) << sizeof(long)*4) >> sizeof(long)*4)
#define tagloc2name(t, l) (((t) << (sizeof(long)*4))| (l))

void *LocVarAdd( long int n, BssVar *v);
BssVar *LocVarGetVar( long int name);
void *LocVarGetRep( long int name, char *rep);
void *LocVarUpdateRep( long int name, char *rep, void *value);
     
void *LocCtrAdd( long int n, BssCtr *c);
BssCtr *LocCtrGetCtr( long int name);
void *LocCtrGetRep( long int name, char *rep);

void *LocTmpAdd( long int n, char *v);

BssVar *LocVarFreeEntry( long int n);

BssCtr *LocCtrFreeEntry( long int n);

void LocFreeAll();

#endif
