/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * Term.java 2.4.3 31-Oct-1997
 */

abstract class Term {
    String name; Term next; Term arg;
    Term() {}
    boolean match(Term y) {return false;}
    Term ground() {return null;}
    Term bvground(Term x) {return null;}
    Term bvgroundL() {return null;}
    String unparse() {return "";}
    boolean beval() {return false;}
    int ieval() {return 0;}
}

class UATerm extends Term {
    UATerm(String s) {name=s;}
    boolean match(Term y) {return this==y;}
    Term ground() {return this;}
    Term bvgroundL() {return this;}
    String unparse() {return name;}
}

class ATerm extends Term {
    ATerm() {}
    ATerm(String s) {name=s;}
    ATerm(String s, Term x) {name=s; next=x;}
    boolean match(Term y) {
	if (name!=y.name) return false;
	return next.match(y.next);}
    Term ground() {return new ATerm(name, next.ground());}
    Term bvground(Term x) {return new ATerm(name,x);}
    Term bvgroundL() {return new ATermL(name);}
    String unparse() {return name+","+next.unparse();}
}

class ATermL extends ATerm {
    ATermL(String s) {name=s;}
    boolean match(Term y) {return name==y.name;}
    Term ground() {return this;}
    Term bvgroundL() {return this;}
    String unparse() {return name;}
}

class ITerm extends Term {
    int val;
    ITerm() {}
    ITerm(int i) {val=i;}
    ITerm(int i, Term x) {val=i; next=x;}
    boolean match(Term y) {
	if (!(y instanceof ITerm)||val!=((ITerm)y).val) return false;
	return next.match(y.next);}
    Term ground() {return new ITerm(val, next.ground());}
    Term bvground(Term x) {return new ITerm(val,x);}
    Term bvgroundL() {return new ITermL(val);}
    String unparse() {return Integer.toString(val)+","+next.unparse();}
}

class ITermL extends ITerm {
    ITermL(int i) {val=i;}
    boolean match(Term y) {
	return ((y instanceof ITerm)&&val==((ITerm)y).val);}
    Term ground() {return this;}
    Term bvgroundL() {return this;}
    String unparse() {return Integer.toString(val);}
    int ieval() {return val;}
}

class AVar extends Term {
    AVar(String s, Term x) {name=s; next=x;}
    boolean match(Term y) {return next.match(y.next);}
    String unparse() {return name+","+next.unparse();}
}

class AVarL extends Term {
    AVarL(String s) {name=s;}
    boolean match(Term y) {return true;}
    String unparse() {return name;}
}

class FVar extends Term {
    FVar(String s) {name=s;}
    FVar(String s, Term x) {name=s; next=x;}
    boolean match(Term y) {arg=y; return next.match(y.next);}
    String unparse() {return "?"+name+","+next.unparse();}
}

class FVarL extends Term {
    FVarL(String s) {name=s;}
    boolean match(Term y) {arg=y; return true;}
    String unparse() {return "?"+name;}
}

class BVar extends Term {
    BVar(String s, Term t) {name=s; arg=t;}
    BVar(String s, Term t, Term x) {name=s; arg=t; next=x;}
    boolean match(Term y) {
	if (arg.arg.name!=y.name) {return false;}
	if (arg.arg.arg==null) {return next.match(y.next);}
	if (arg.arg.arg.match(y.arg)) {
	    return next.match(y.next);}
	return false;}
    Term ground() {return arg.arg.bvground(next.ground());}
    String unparse() {return "!"+name+","+next.unparse();}
}

class BVarL extends Term {
    BVarL(String s, Term t) {name=s; arg=t;}
    boolean match(Term y) {
	if (arg.arg.name!=y.name) {return false;}
	if (arg.arg.arg==null) {return true;}
	return arg.arg.arg.match(y.arg);}
    Term ground() {return arg.arg.bvgroundL();}
    String unparse() {return "!"+name;}
    int ieval() {
	if (arg.arg instanceof ITerm) {return ((ITerm)arg.arg).val;}
	return 0;
    }
}

class CTerm extends Term {
    CTerm() {}
    CTerm(String s, Term a, Term x) {name=s; arg=a; next=x;}
    boolean match(Term y) {
	if (name!=y.name) return false;
	if (arg.match(y.arg)) return next.match(y.next);
	return false;}
    Term ground() {return new CTerm(name, arg.ground(), next.ground());}
    Term bvground(Term x) {return new CTerm(name,arg,x);}
    Term bvgroundL() {return new CTermL(name,arg);}
    String unparse() {return name.substring(0,name.indexOf("/"))
			     +"("+arg.unparse()+"),"+next.unparse();}
}

class CTermL extends CTerm {
    CTermL(String s, Term a) {name=s; arg=a;}
    boolean match(Term y) {
	if (name!=y.name) return false;
	return arg.match(y.arg);}
    Term ground() {return new CTermL(name, arg.ground());}
    String unparse() {return name.substring(0,name.indexOf("/"))
			     +"("+arg.unparse()+")";}
}

// eof
