/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

import java.awt.*;
import java.util.Vector;
import java.io.*;
class PTVisualizer extends Frame{
   MGTP mgtp;
   GT root_gt;
   int x,y;
   
   Panel p = new Panel();
   Panel exec_panel = new Panel();
   Panel e_but_panel = new Panel();    
   Panel readf_panel = new Panel();
   Panel zoom_panel = new Panel();
   Panel z_but_panel = new Panel();
   Panel z_txt_panel = new Panel();
   Panel z_txt_h_panel = new Panel();
   Panel z_txt_v_panel = new Panel();
   Panel cv_panel = new Panel();    
   
   Menu zoomMenu;
   Menu engineMenu;
   Menu dspMenu;
   Menu treeMenu;
 
   Button run_button;
   Button readf_button;
   Button zoom_button;
   Button reset_button;
   TextField readf_txt;
   TextField zoom_h_txt;
   TextField zoom_v_txt;
   String fil1;
   String dir1;
   
   static PTCanvas ptc;
   static int cvw_height=600;		//
   static int cvw_width=800;
   static int lgw_height=cvw_height;		//
   static int lgw_width=cvw_width;

   static int guiw_height=cvw_height+150;
   static int guiw_width=cvw_width+25;

// static Scrollbar v,h;

   Color c;
  
   PTVisualizer(){}
   public static void main(String Args[]){
         PTVisualizer ptvis=new PTVisualizer();
         ptvis.init(); 
         ptvis.show();
	 
	 ptc.gf=ptc.init();
  }

  void init(){
  	setTitle("Proof Tree Visualizer");
   	this.setLayout(new BorderLayout());

    	MenuBar menuBar = new MenuBar();
    	zoomMenu = new Menu("Zoom");
	zoomMenu.add(new MenuItem("X1"));
    	zoomMenu.add(new MenuItem("X2"));    
    	zoomMenu.add(new MenuItem("X4"));
    	zoomMenu.add(new MenuItem("X10"));
    	zoomMenu.add(new MenuItem("X50"));
    	zoomMenu.add(new MenuItem("X100"));
    	menuBar.add(zoomMenu);

    	engineMenu = new Menu("Engine");
    	engineMenu.add(new MenuItem("MGTP"));
    	engineMenu.add(new MenuItem("CMGTP"));    
    	engineMenu.add(new MenuItem("IVMGTP"));
    	menuBar.add(engineMenu);
   
    	dspMenu = new Menu("Display");
    	dspMenu.add(new MenuItem("Tree"));
    	dspMenu.add(new MenuItem("Radial"));    
    	dspMenu.add(new MenuItem("Rectangle"));
    	menuBar.add(dspMenu);

    	treeMenu = new Menu("Tree");
    	treeMenu.add(new MenuItem("Weighted"));
    	treeMenu.add(new MenuItem("Fixed"));    
    	menuBar.add(treeMenu);

   	setMenuBar(menuBar);

    	p.setLayout(new FlowLayout());
    	exec_panel.setLayout(new BorderLayout());
    	e_but_panel.setLayout(new FlowLayout());
    	readf_panel.setLayout(new BorderLayout());
    	zoom_panel.setLayout(new BorderLayout());
    	z_but_panel.setLayout(new FlowLayout());
    	z_txt_panel.setLayout(new FlowLayout());
        z_txt_h_panel.setLayout(new BorderLayout());
        z_txt_v_panel.setLayout(new BorderLayout());
    	cv_panel.setLayout(new BorderLayout());

       
    	add("North", p); 
    	add("South", cv_panel);
  
    	p.add("West",exec_panel);
    	p.add("East",zoom_panel);
  
    	readf_button=new Button(" Read File ");
    	run_button=new Button(" Run ");
    	e_but_panel.add("West",readf_button);
    	e_but_panel.add("Eest",run_button);
   
    	Label readf_label = new Label(" File Name ", 1);
    	readf_panel.add("West", readf_label);
    	readf_txt = new TextField("", 20);
    	readf_panel.add("East", readf_txt);
    
    	exec_panel.add("North",e_but_panel);
    	exec_panel.add("South",readf_panel);

    	zoom_panel.add("North",z_but_panel);
    	zoom_panel.add("South",z_txt_panel);          
        zoom_button = new Button(" Zoom ");
    	z_but_panel.add(zoom_button);
    	reset_button = new Button( "Reset ");
        z_but_panel.add(reset_button);
        
	z_txt_panel.add(z_txt_h_panel);
        z_txt_panel.add(z_txt_v_panel);
	Label zoom_h_label = new Label(" mult H ", 1);
    	Label zoom_v_label = new Label(" mult V ", 1);
        zoom_h_txt = new TextField("", 5);
    	zoom_v_txt = new TextField("", 5);
	z_txt_h_panel.add("West", zoom_h_label);
	z_txt_h_panel.add("East", zoom_h_txt);
	z_txt_v_panel.add("West", zoom_v_label);
	z_txt_v_panel.add("East", zoom_v_txt);

   	
	ptc = new PTCanvas(cvw_width,cvw_height,lgw_width,lgw_height);    
    	ptc.h=new Scrollbar(Scrollbar.HORIZONTAL,0,0,0,cvw_width);
    	ptc.v=new Scrollbar(Scrollbar.VERTICAL,0,0,0,cvw_height);    
	
        cv_panel.add("East", ptc.v);
    	cv_panel.add("South",ptc.h);
    	cv_panel.add("Center",ptc);
	c=new Color(230,230,240);
	ptc.setBackground(c);
    	ptc.resize(cvw_width,cvw_height);    
	reset_PTC();
    	resize(guiw_width,guiw_height);
  }  

  void zoom_menu_Clicked(String s){
	setCursor(CROSSHAIR_CURSOR);
	ptc.zoom_mode=true;
	System.out.println("Zoom Mode=true");
	if(s=="X1"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=1; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X2"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=2; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X4"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=4; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X10"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=10; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X50"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=50; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X100"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=100; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}

  }

  void tree_menu_Clicked(String s){
	if(s=="Weighted"){ptc.Tree_Mode='w';}
	if(s=="Fixed"){ptc.Tree_Mode='f';}
	System.out.println("Tree_Mode="+ptc.Tree_Mode);
        ptc.repaint();
  }

  public boolean handleEvent(Event evt) {
      int h_val,v_val;
      switch(evt.id){
	 case Event.WINDOW_DESTROY: 
             this.hide();         // hide the Frame
	     this.dispose();      // tell windowing system to free resources
	     System.exit(0); // exit	
	     break;
	
	 case Event.ACTION_EVENT:
             if (evt.target == readf_button){
		 readf_button_Clicked(evt);
		 break;
	     }   
	     if (evt.target == run_button){
	     	 run_button_Clicked(evt);
		 break;
	     }
             if (evt.target == zoom_button){
 	          zoom_button_Clicked(evt);
		  break;
	     }
	     if (evt.target == reset_button){
		  reset_button_Clicked(evt);
	          break;
            } 
	     if (evt.target instanceof MenuItem){
		System.out.println("MenuItem.");
		if (((MenuItem)evt.target).getParent()==zoomMenu){
			zoom_menu_Clicked((String)evt.arg);
			break;
		}
		if (((MenuItem)evt.target).getParent()==treeMenu){
			tree_menu_Clicked((String)evt.arg);
			break;
		}
	        break;
             }			

	 case Event.SCROLL_LINE_UP:	
         case Event.SCROLL_LINE_DOWN:
         case Event.SCROLL_PAGE_UP:
         case Event.SCROLL_PAGE_DOWN:
         case Event.SCROLL_ABSOLUTE:
		h_val=ptc.h.getValue();
		v_val=ptc.v.getValue();
		ptc.h.setValue(h_val);
		ptc.v.setValue(v_val);
		if(evt.id==Event.SCROLL_ABSOLUTE){
			System.out.println("SCROLL_ABSOLUTE: h_val="+h_val+",v_val="+v_val+",px="+ptc.px+",py="+ptc.py);
		}	
		else{	
			System.out.println("SCROLL_OTHERS: h_val="+h_val+",v_val="+v_val+",px="+ptc.px+",py="+ptc.py);	
		}	
		ptc.old_scroll_x=ptc.cur_scroll_x;
		ptc.old_scroll_y=ptc.cur_scroll_y;
		ptc.cur_scroll_x=(int)(h_val*ptc.cur_mult_h);
		ptc.cur_scroll_y=(int)(v_val*ptc.cur_mult_v);
		ptc.move_window(ptc.cur_scroll_x-ptc.old_scroll_x,
                                ptc.cur_scroll_y-ptc.old_scroll_y);
		if(evt.id!=Event.SCROLL_ABSOLUTE){ptc.repaint();}
		break;
	} 
	return false;
//	return super.handleEvent(evt);
  }

  void readf_button_Clicked(Event event) {
	readf_txt.setText("open file");
	selectedOpen();
      	String filename = dir1+fil1;
	try{}
	catch (Exception e){
	    System.out.println("io error for "+e.getMessage());
	}
	catch (Error e){
	    System.out.println("lang error in "+e.getMessage());
	}
	finally{	  
	    readf_txt.setText(fil1);
	}
  }

  void run_button_Clicked(Event event) {
	String[] args={"","","","","","","","","",""};
	System.out.print("Now reading file: " + dir1 + fil1 + "...\n");
	args[0]=dir1+fil1;
	mgtp=new MGTP();
	mgtp.doMGTP(args);
//	ptw=new PTWindow("Proof Tree Window");
//	ptw=new PTWindow();
//	graph=ptw.grinit();
	System.out.println("mkGT,start.");
	mgtp.pt_top.mkGT(null);
	root_gt=mgtp.pt_top;
	System.out.println("mkGT,end.");
	ptc.root_gt=root_gt;
	ptc.repaint();
  	ptc.set_scroll();
  }
  
  void selectedOpen() {
	FileDialog fd=new FileDialog(this, "Open");
	fd.setDirectory("c:\\mgtp\\prob");
	fd.setFilenameFilter(new JavaFileFilter());
	fd.show();
	fil1=fd.getFile();
	dir1=fd.getDirectory();
        System.out.println("Dir ="+dir1);
	readf_txt.setText(dir1+fil1);
  }
  
  void zoom_button_Clicked(Event evt){
        float mult_h,mult_v;
	mult_h=mygetValue(zoom_h_txt);
	mult_v=mygetValue(zoom_v_txt);
        if ((mult_h > 0)&&(mult_v > 0)){
	  ptc.old_mult_h=ptc.cur_mult_h;
	  ptc.cur_mult_h=mult_h;
	  ptc.old_mult_v=ptc.cur_mult_v;
	  ptc.cur_mult_v=mult_v;
	
	  ptc.zoom_mode=true;
        }
  }
  
  void reset_button_Clicked(Event evt){
	reset_PTC();
	ptc.repaint();
  }

  void reset_PTC(){
	ptc.px=0;
	ptc.py=0;
	ptc.cur_scroll_x=0;
	ptc.cur_scroll_y=0;
	ptc.old_scroll_x=0;
	ptc.old_scroll_y=0;
	ptc.old_mult_h=1;
	ptc.cur_mult_h=1;
	ptc.old_mult_v=1;
	ptc.cur_mult_v=1;
        ptc.lgw_height=cvw_height;		
        ptc.lgw_width=cvw_width;
	ptc.h.setValue(ptc.cur_scroll_x);
	ptc.v.setValue(ptc.cur_scroll_y);
  	zoom_h_txt.setText("1");
        zoom_v_txt.setText("1");
        ptc.set_scroll();
  }
  float mygetValue(TextField txt){
	float i;
	try{
	   i=Float.valueOf(txt.getText()).floatValue();
	}
	catch (java.lang.NumberFormatException e){
		i=0;
	} 	
        return i;
  }
}

class JavaFileFilter implements FilenameFilter{
  public boolean accept(File dir,String name){
	return name.endsWith(".mg");
  }
}

class PTCanvas extends Canvas{
  Graphics gf;
  GT root_gt;
  GTWindow agtw;
  int cvw_height; 	
  int cvw_width;
  int lgw_height;
  int lgw_width;
  int px=0;
  int py=0;
  Scrollbar h,v;
  float old_mult_h=1;
  float cur_mult_h=1;
  float old_mult_v=1;
  float cur_mult_v=1;
  int cur_scroll_x=0;
  int cur_scroll_y=0;
  int old_scroll_x=0;
  int old_scroll_y=0;
  boolean zoom_mode=false;
  boolean TwoPointMode=false;
  GT dsp_gt;
  Color dsp_cl;
  char Tree_Mode='w';
    
  PTCanvas(){}
  PTCanvas(int cvww,int cvwh,int lgww,int lgwh){
  	cvw_height=cvwh;
  	cvw_width=cvww;
  	lgw_width=lgww;
  	lgw_height=lgwh;
	
	//g=grinit();	
	//if(g==null){System.out.print("initGraph,failed.");}
  }  

  Graphics init(){
 // setBackground(Color.black);
    return getGraphics();
  }

  void mydrawLine(Graphics g,int x,int y,int to_x,int to_y){
	if((x>=0)&&(x<=cvw_width)&&(y>=0)&&(y<=cvw_height)){
		g.drawLine(x,y,to_x,to_y);
	}
	if((to_x>=0)&&(to_x<=cvw_width)&&(to_y>=0)&&(to_y<=cvw_height)){
		g.drawLine(x,y,to_x,to_y);
	}
  }
 
  void myfillOval(Graphics g,int x,int y,int dx,int dy){
	if((x>=0)&&(x<=cvw_width)&&(y>=0)&&(y<=cvw_height)){
		g.fillOval(x,y,dx,dy);
		}
	}	

  void paint_single(Graphics g,GT gt){		
	g.setColor(gt.p_color); 
	myfillOval(g,gt.x-4,gt.y-4,8,8);
	g.setColor(Color.black); 
	GT s=gt.son;					// ѤGTλҶͤ 
	while(s!=null){					// ûҤޤǣԤ 
		 mydrawLine(g,gt.x,gt.y,s.x,s.y);
		s=s.next;				// ˥ХȥϤ 
	}
  }

 void paint_all(Graphics g,GT gt){		// ȷϿޤ褹᥽å 
	if((gt.L>cvw_width)||(gt.L+gt.W<0)){return;}
		paint_single(g,gt);				// ޤ˲² 
		GT s=gt.son;					// ѤGTλҶͤ 
		while(s!=null){					// ûҤޤǣԤ 
			paint_all(g,s);				// ҶβȷϿޤ 
			s=s.next;				// ˥ХȥϤ 
	}
  }
/*
  public void changeColor(Graphics g,GT gt){
	g.setColor(Color.red);
	myfillOval(g,gt.x-4,gt.y-4,8,8);
	g.setColor(Color.black);
  }
*/
  public void redraw(GT gt,Color cl){
	if(gf==null){System.out.print("Null Graphics.");}
	gf.setColor(cl);	
	gf.fillOval(gt.x-4,gt.y-4,8,8);
	gf.setColor(Color.black);	
  }

  public void paint(Graphics g){
	if (root_gt==null)return;
//	root_gt.cood((px-ptvis.scroll_x),lgw_width,50+py-ptvis.scroll_y,(int)(50*cur_mult_v));
//	if (Tree_Mode=='w') root_gt.cood_weighted(px,lgw_width,50+py,(int)(50*cur_mult_v));
//	else root_gt.cood_fixed(px,lgw_width,50+py,(int)(50*cur_mult_v));
	if (Tree_Mode=='w') root_gt.cood_weighted(px,lgw_width,50+py,(lgw_height-50)/root_gt.gs);
	else root_gt.cood_fixed(px,lgw_width,50+py,(lgw_height-50)/root_gt.gs);
	paint_all(g,root_gt);
	System.out.println("paint: scroll_x="+cur_scroll_x+",L="+px+",w="+lgw_width+",R="+(px+lgw_width));
  }

  public boolean handleEvent(Event evt){
      switch(evt.id){
	 case Event.MOUSE_DOWN:
	    if (zoom_mode==false){
	        GT found_gt;
	        System.out.println("MOUSE_DOWN: evt.x="+evt.x+",evt.y="+evt.y);
	        if (root_gt==null){
		    System.out.println("root_gt=null");
		    break;
		}
	        found_gt=root_gt.find(evt.x,evt.y);
	        if (found_gt==null){
		    System.out.println("found_gt=null");
		    break;
		}
		if (TwoPointMode){
		    agtw.ToNode(found_gt);
		    TwoPointMode=false;
		    found_gt.p_color=Color.green;
		    dsp_gt=found_gt;	
		    agtw.mark_gt.addElement(found_gt);
		    redraw(found_gt,Color.green);
		    break;
		}
		found_gt.p_color=Color.red;
		dsp_gt=found_gt;	
		GTWindow gtw=new GTWindow(found_gt,root_gt,this); 
		gtw.mark_gt.addElement(found_gt);
		redraw(found_gt,Color.red);
		break;
	    }
	    if (zoom_mode==true){
	        int h_val=0;int v_val=0;
		lgw_width=(int)(cvw_width*cur_mult_h);
	        lgw_height=(int)(cvw_height*cur_mult_v);
		System.out.println("MOUSE_DOWN_ZOOM: lgww="+lgw_width+",lgwh="+lgw_height+",old px="+px+" ,evt.x="+evt.x+",old_mult_h="+old_mult_h+",cur_mult_h="+cur_mult_h);
	        if ((old_mult_h!=cur_mult_h)||(old_mult_v!=cur_mult_v)){
		    change_mult(evt.x,evt.y);
		}
		else move_center(evt.x,evt.y);
		repaint();
		zoom_mode=false;	
	        break;
	    }
      }
      return true;
  }

  void move_window(int dx,int dy){
	px=px-dx;
	py=py-dy;
  }
  
  void move_center(int x,int y){
	move_window(x-cvw_width/2,y-cvw_height/2);
        set_scroll();
  }	

  void change_mult(int x,int y){
	int new_x,new_y;
	new_x=(int)((-px+x)*(cur_mult_h/old_mult_h));	
	new_y=(int)((-py+y)*(cur_mult_v/old_mult_v));	
        px=0;py=0;
	move_center(new_x,new_y);
        set_scroll();
  }

  void set_scroll(){
	int h_val,v_val,l_h_val,l_v_val;
	l_h_val=cvw_width/2-px;
	l_v_val=cvw_height/2-py;
	h_val=(int)(l_h_val/cur_mult_h);
        h.setValue(h_val);
	v_val=(int)(l_v_val/cur_mult_v);
	v.setValue(v_val);
	cur_scroll_x=l_h_val;
	cur_scroll_y=l_v_val;        
  } 

}
