/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * Model.java 2.4.0 30-Oct-1997
 */

class Model {
    Term head; Model tail; int number;
    Model(Term delta, Model model, int num) {
        head=delta; tail=model; number=num;
    }
    boolean subsumes(Term[] c) {
        Term t; Model m;
	for (int i=0; i<c.length; i++) {
	    t=c[i]; m=this;
	    while (m!=null) {
		if (t.match(m.head)) {return true;}
		m=m.tail;
	    }
	}
	return false;
    }
    String unparse() {
	if (this==null) {return "[]";}
	String s="[ "; Model m=this;
	while (m.tail!=null) {
	    s=s+m.head.unparse()+", ";
	    m=m.tail;
	}
	return s+m.head.unparse()+"]";
    }

    boolean kcheck() {
      Model f=this, m=this; 
      SuccessAnte sa=new SuccessAnte();
      while (m!=null) {
	if (m.head.name.equals("k/1")) {
	  while (f!=null) { 
	    if(m.head.arg.match(f.head)) break;
	    else f=f.tail;
	  }
	  if (f==null) {
	    sa=new SuccessAnte(this.head, sa);
	    MGTP.saStack=new SAStack(sa,MGTP.saStack);
	    return true;
	  }
	}
	m=m.tail;
      }
      return false;
    }
     
    /*    Model kcheck() {
      Model k=null; Model m=this;
        while (m.tail!=null) {
          if (m.head.name.equals("k/1")) {
            k = new Model(m.head.arg,k);
          }
          m=m.tail;
        }
      return k;
    }
    boolean kk(Model c) {        
      Model t=c; Model m=this;
      while (t!=null) {
	while (m!=null) {
	  if (t.head.match(m.head)) m=null;
	  else {m=m.tail;}
	}
	if (m==null) {return true;}
	t=t.tail;
      }
      return false;
    }       */                
  
    boolean nkcheck() {
      Model f=null, m=this,n=null; 
      SuccessAnte sa=new SuccessAnte();
      f=m;
      while (m!=null) {
	if (m.head.name.equals("-k/1")) {
	  n=f;
	  while (n!=null) { 
	    if(m.head.arg.match(n.head)) break;
	    else {n=n.tail;}
	  }
	  if (n!=null) {
	    sa=new SuccessAnte(m.head, sa);
	    sa=new SuccessAnte(n.head, sa);
	    MGTP.saStack=new SAStack(sa,MGTP.saStack);
	    return true;
	  }
	}
	m=m.tail;
      }
      return false;
    }
  
}


// eof






