/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * MGTPDict.java 2.4.0 30-Oct-1997
 */

class Vpair {
    int ln; Term fvar;
    Vpair(int l, Term v) {ln=l; fvar=v;}
}

class MGTPDict extends java.util.Hashtable {
    Term uniUATerm(String s){
	s=s.intern(); Term t=(Term)get(s);
	if (t==null) {t=new UATerm(s); put(s,t);}
	return t;
    }
    Term uniVar(String s, int ln, MGTPParser mp) {
	s=s.intern(); Vpair p=(Vpair)get(s);
	if (p==null) {
	    Term fvar=new FVar(s);
	    put(s,new Vpair(ln,fvar));
	    return fvar;
	}
	if (ln>=0&&ln!=p.ln) {mp.shared=true;} // shared in Ante
	return new BVar(s,p.fvar);
    }
    Term euniVar(String s) {
	s=s.intern(); Term v=(Term)get(s);
	if (v==null) {v=new FVar(s); put(s,v); return v;}
	return new BVar(s,v);
    }
    Term euniVarL(String s){
	s=s.intern(); Term v=(Term)get(s);
	if (v==null) {v=new FVarL(s); put(s,v); return v;}
	return new BVarL(s,v);
    }
}

// eof
