/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * MGTPClauses.java 2.4.3 31-Oct-1997
 */

class CList {
    Clause head; CList tail;
    CList(Clause h) {head=h;}
    CList(Clause h, CList t) {head=h; tail=t;}
}

class Clauses {
    static String DOM="dom/1".intern();
    CList first; CList last;
    void add(Clause c) {
	if (first==null) {first=new CList(c); last=first;}
	else {last.tail=new CList(c); last=last.tail;}
    }
    String unparse() {
	String s=""; CList x=first;
	while (x!=null) {
	    s=s+x.head.unparse()+"\n";
	    x=x.tail;
	}
	return s;
    }
    void cjmPos(SuccessAnte sa) {
	CList x=first; 
	while (x!=null) {
	    Term[] c=x.head.cnsq;
	    if (c.length>1) {x.head.mgtp.disjBuf.enter(c,sa);}
	    else if (DOM!=c[0].name) {x.head.mgtp.unitBuf.enter(c,sa);}
	    else {x.head.mgtp.domsBuf.enter(c,sa);}
	    x=x.tail;
	}
    }
    boolean cjmNeg(Term delta, Model model, SuccessAnte sa) { 
	CList x=first;
	while (x!=null) {
	    if (((NClause)x.head).cjmNeg(delta,model,sa)) return true;
	    x=x.tail;
	}
	return false;
    }
    void cjmMix(Term delta, Model model, SuccessAnte sa) {
	CList x=first;
	while (x!=null) {
	    ((MClause)x.head).cjmMix(delta,model,sa);
	    x=x.tail;
	}
    }
}

abstract class Clause {
    static String DOM="dom/1".intern();
    int id; Term[] ante; int alen; Term[] cnsq; int clen; MGTP mgtp;
    Clause() {}
    String unparse() {return "";}
    String unparseAnte() {
	String s=""; int i;
	for (i=0; i<alen-1; i++) {s=s+ante[i].unparse()+", ";}
	return s+ante[i].unparse();
    }
    String unparseCnsq() {
	String s=""; int i;
	for (i=0; i<clen-1; i++) {s=s+cnsq[i].unparse()+"; ";}
	return s+cnsq[i].unparse();
    }
}

class PClause extends Clause {
    PClause(int i, Term[] c, MGTP m) {
	id=i; cnsq=c; clen=c.length; mgtp=m;}
    String unparse() {return " c"+id+": -> "+unparseCnsq()+".";}
}

class NClause extends Clause {
    Term delta; Model model;
    NClause() {}
    NClause(int i, Term[] a, MGTP m) {
	id=i; ante=a; alen=a.length; mgtp=m;}
    String unparse() {return " c"+id+": "+unparseAnte()+" -> .";}
    boolean cjmNeg(Term d, Model m, SuccessAnte sa) {
	delta=d; model=m; 
	if (ante[0].match(delta)&&
	    cjmNeg(1,sa=new SuccessAnte(delta,sa))) return true;
	for (int i=1; i<alen; i++) {
	    if (ante[i].match(delta)&&
		cjmNeg(0,i,sa=new SuccessAnte(delta,sa))) return true;
	}
	return false;
    }
    boolean cjmNeg(int n, int i, SuccessAnte sa) {
	int n1=n+1;
	if (n==i) return cjmNeg(n1,sa);
	else {
	    Term x=ante[n]; Model m=model;
	    while (m!=null) {
	      if (x.match(m.head)) {
		if (cjmNeg(n1,i,sa=new SuccessAnte(m.head,sa))) return true;
	      }
	      m=m.tail;
	    }
	}
	return false;
    }
    boolean cjmNeg(int n, SuccessAnte sa) {
	if (n>=alen) {
	    MGTP.saStack=new SAStack(sa,MGTP.saStack);
	    return true;
	}
	else {
	    Term x=ante[n]; Model m=model; int n1=n+1;
	    while (m!=null) {
	      if (x.match(m.head)) {
		if (cjmNeg(n1,sa=new SuccessAnte(m.head,sa))) return true;
	      }
	      m=m.tail;
	    }
	}
	return false;
    }
}

class ENClause extends NClause {
    ENClause(int i, Term[] a, MGTP m) {
	id=i; ante=a; alen=a.length; mgtp=m;}
    String unparse() {return "ec"+id+": "+unparseAnte()+" -> .";}
    boolean cjmNeg(Term d, Model m, SuccessAnte sa) {
	delta=d; model=m;
	return (ante[0].match(delta)&&
		cjmNeg(1,sa=new SuccessAnte(delta,sa)));
    }
}

class NXClause extends NClause {
    Term elit;
    NXClause(int i, Term[] a, Term e, MGTP m) {
	id=i; ante=a; alen=a.length; elit=e; mgtp=m;}
    String unparse() {
	return " c"+id+": "+unparseAnte()+",{"+elit.unparse()+"} -> .";}
    boolean cjmNeg(int n, SuccessAnte sa) {
	if (n>=alen) {
	    MGTP.saStack=new SAStack(sa,MGTP.saStack);
	    return elit.beval();
	}
	else {
	    Term x=ante[n]; Model m=model; int n1=n+1;
	    while (m!=null) {
		if (x.match(m.head)) {
		  if (cjmNeg(n1,sa=new SuccessAnte(m.head,sa))) return true;
		}
		m=m.tail;
	    }
	}
	return false;
    }
}

class ENXClause extends NClause {
    Term elit;
    ENXClause(int i, Term[] a, Term e, MGTP m) {
	id=i; ante=a; alen=a.length; elit=e; mgtp=m;}
    String unparse() {
	return "ec"+id+": "+unparseAnte()+",{"+elit.unparse()+"} -> .";}
    boolean cjmNeg(Term d, Model m, SuccessAnte sa) {
	delta=d; model=m;
	return (ante[0].match(delta)&&
		cjmNeg(1,sa=new SuccessAnte(delta,sa)));
    }
    boolean cjmNeg(int n, SuccessAnte sa) {
	if (n>=alen) {
	    MGTP.saStack=new SAStack(sa,MGTP.saStack);
	    return elit.beval();
	}	
	else {
	    Term x=ante[n]; Model m=model; int n1=n+1;
	    while (m!=null) {
		if (x.match(m.head)) {
		    if (cjmNeg(n1,sa=new SuccessAnte(m.head,sa))) return true;
		}
		m=m.tail;
	    }
	}
	return false;
    }
}

class MClause extends Clause {
    Term delta; Model model;
    MClause() {}
    MClause(int i, Term[] a, Term[] c, MGTP m) {
	id=i; ante=a; alen=a.length; cnsq=c; clen=c.length; mgtp=m;
    }
    String unparse() {
	return " c"+id+": "+unparseAnte()+" -> "+unparseCnsq()+".";
    }
    void cjmMix(Term d, Model m, SuccessAnte sa) {
	delta=d; model=m;
	if (ante[0].match(delta)) {
	  cjmMix(1,sa=new SuccessAnte(delta,sa));
	}
	for (int i=1; i<alen; i++) {
	    if (ante[i].match(delta)) {
	      cjmMix(0,i,sa=new SuccessAnte(delta,sa));
	    }
	}
    }
    void cjmMix(int n, int i, SuccessAnte sa) {
	int n1=n+1;
	if (n==i) {cjmMix(n1,sa);}
	else {
	    Term x=ante[n]; Model m=model;
	    while (m!=null) {
		if (x.match(m.head)) {
		  cjmMix(n1,i,sa=new SuccessAnte(m.head,sa));
		}
		m=m.tail;
	    }
	}
    }
    void cjmMix(int n, SuccessAnte sa) {
	if (n>=alen) {
	    Term[] g=new Term[clen];
	    for (int i=0; i<clen; i++) {g[i]=cnsq[i].ground();}
	    if (clen>1) {mgtp.disjBuf.enter(g,sa);}
	    else if (DOM!=g[0].name) {mgtp.unitBuf.enter(g,sa);}
	    else {mgtp.domsBuf.enter(g,sa);}
	} else {
	    Term x=ante[n]; Model m=model; int n1=n+1;
	    while (m!=null) {
		if (x.match(m.head)) {
		  cjmMix(n1,sa=new SuccessAnte(m.head,sa));
		}
		m=m.tail;
	    }
	}
    }
}

class EMClause extends MClause {
    EMClause(int i, Term[] a, Term[] c, MGTP m) {
	id=i; ante=a; alen=a.length; cnsq=c; clen=c.length; mgtp=m;
    }
    String unparse() {
	return "ec"+id+": "+unparseAnte()+" -> "+unparseCnsq()+".";
    }
    void cjmMix(Term d, Model m, SuccessAnte sa) {
	delta=d; model=m;
	if (ante[0].match(delta)) {
	  cjmMix(1,sa=new SuccessAnte(delta,sa));
	}
    }
}

class MXClause extends MClause {
    Term elit;
    MXClause(int i, Term[] a, Term e, Term[] c, MGTP m) {
	id=i; ante=a; alen=a.length; elit=e; cnsq=c; clen=c.length; mgtp=m;
    }
    String unparse() {
	return " c"+id+": "+unparseAnte()+",{"+elit.unparse()+"} -> "
	       +unparseCnsq()+".";
    }
    boolean beval(Term x, Term x1) {
	int xi=((ITerm)x.arg).val;
	int x1i=xi+1;
//	int y1i=xi+1;
//	int y2i=xi+2;
//	int y3i=xi+3;
//	int y4i=xi+4;
	x1.arg=new ITermL(x1i);
	return x1i<=100;
    }
    void cjmMix(int n, SuccessAnte sa) {
	if (n>=alen) {

//	    long time=System.currentTimeMillis();
//	    for (int j=0; j<100000; j++) {elit.beval();}
/*
	    Term x=ante[0].arg; Term x1=new FVar("X1".intern());
	    cnsq[0].arg.arg=x1;
	    for (int j=0; j<100000; j++) {beval(x,x1);}
 */
//	    time=System.currentTimeMillis()-time;
//	System.out.print("External code time: "+time+" msec\n");

	    if (!elit.beval()) return;
	    Term[] g=new Term[clen];
	    for (int i=0; i<clen; i++) {g[i]=cnsq[i].ground();}
	    if (clen>1) {mgtp.disjBuf.enter(g,sa);}
	    else if (DOM!=g[0].name) {mgtp.unitBuf.enter(g,sa);}
	    else {mgtp.domsBuf.enter(g,sa);}
	} else {
	    Term x=ante[n]; Model m=model; int n1=n+1;
	    while (m!=null) {
		if (x.match(m.head)) {
		  cjmMix(n1,sa=new SuccessAnte(m.head,sa));
		}
		m=m.tail;
	    }
	}
    }
}

class EMXClause extends MClause {
    Term elit;
    EMXClause(int i, Term[] a, Term e, Term[] c, MGTP m) {
	id=i; ante=a; alen=a.length; elit=e; cnsq=c; clen=c.length; mgtp=m;
    }
    String unparse() {
	return "ec"+id+": "+unparseAnte()+",{"+elit.unparse()
	       +"} -> "+unparseCnsq()+".";
    }
    void cjmMix(Term d, Model m, SuccessAnte sa) {
	delta=d; model=m;
	if (ante[0].match(delta)) {
	  cjmMix(1,sa=new SuccessAnte(delta,sa));
	}
    }
    void cjmMix(int n, SuccessAnte sa) {
	if (n>=alen) {
	    if (!elit.beval()) return;
	    Term[] g=new Term[clen];
	    for (int i=0; i<clen; i++) {g[i]=cnsq[i].ground();}
	    if (clen>1) {mgtp.disjBuf.enter(g,sa);}
	    else if (DOM!=g[0].name) {mgtp.unitBuf.enter(g,sa);}
	    else {mgtp.domsBuf.enter(g,sa);}
	} else {
	    Term x=ante[n]; Model m=model; int n1=n+1;
	    while (m!=null) {
		if (x.match(m.head)) {
		  cjmMix(n1,sa=new SuccessAnte(m.head,sa));
		}
		m=m.tail;
	    }
	}
    }
}

// eof
	    
