/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * MGTP.java 2.4.2 30-Oct-1997
 */

import java.io.*;

class MGTP {
    static String version="JavaMGTP 2.4.2 30-Oct-1997";
    static String author="fujita@is.kyushu-u.ac.jp";
    int bufMode; static int QUEUE=0; static int STACK=1;
    CnsqBuf unitBuf=new CnsqBuf();
    CnsqBuf disjBuf=new CnsqBuf();
    CnsqBuf domsBuf=new CnsqBuf();
    Clauses posCls=new Clauses();
    Clauses negCls=new Clauses();
    Clauses mixCls=new Clauses();
    boolean verbose=false;
    boolean ans=true,scheck=true;
    long time,time2;
    
    public static void main(String args[]) {
	MGTP mgtp=new MGTP();
	mgtp.doMGTP(args);
    }
 
    void checkOptions(String args[]) {
	for (int i=0; i<args.length; i++) {
	  System.out.print(args[i]);
	    if ("verbose".startsWith(args[i])) {
	      verbose = false; // verbose=true;
	    } else if ("stack".startsWith(args[i])) {
		bufMode=STACK;
	    } else if ("queue".startsWith(args[i])) {
	      bufMode=QUEUE;
	    }
	}
    }

  static SuccessAnte sa=new SuccessAnte();      //add
  static SAStack saStack=null;                  //add

  void doMGTP(String args[]) {
    tree=null; parent=null; root=null;
    treelist=null;prelist=null;first=null;
    idx=0;num=0;pn=0;noc=0;cn=0;depth=0;
    printtree=null; treeinf=null;
    kchecks=0;nkchecks=0;kpas=true;f=true;
    sa=new SuccessAnte();
    saStack=null;
    gstack=null; model=null; cnsq=null;

	checkOptions(args);
	time=System.currentTimeMillis();
	if (!MGTPParser.readFrom(this,args)) {
	    return;
	}

	System.gc();

	time=System.currentTimeMillis();
	posCls.cjmPos(sa);
	prove();
	time=System.currentTimeMillis()-time;

	String Ans;
	if (ans) {Ans="UNSAT";} else {Ans="SAT";}
	System.out.print(Ans+"\n");

	Tree simpleTree;
	time2=System.currentTimeMillis();
	simpleTree=root.simplify();
	simpleTree.mkGT(pt_top);
	time2=System.currentTimeMillis()-time2;

	System.out.print("pt:"+time+"msec\n");
	System.out.print("pn:"+num+"\n");
	System.out.print("pl:"+branches+"\n");
	System.out.print("st:"+time2+"msec\n");
	System.out.print("sn:"+(root.numberOfNode()-1)+"\n");
	System.out.print("sl:"+root.numberOfLeaves()+"\n");
  }

    static GStack gstack; static Model model=null; static Term[] cnsq;
    static Term delta; static int idx,num=0,pn=0,noc,cn,depth=0;
    static int atomID=0; static int nodes=0;
    static int branches=0; static int models=0; static int failedBranches=0;

    static int kchecks=0,nkchecks=0;boolean kpas=true,f=true;          //add
    static PrintTree printtree=null;static TreeInf treeinf=null;       //add
    static Tree tree,parent,root;          //add
    static TreeList treelist=null,prelist,first;                       //add
  
  GT pt_top= new GT(new UATerm("root"));

    void prove() {
      boolean fcheck;
      do {
	if (unitBuf.first==null
	    && disjBuf.first==null && domsBuf.first==null) {
	    
    	  if (kpas) {                          //add
	    if (verbose) {
                System.out.print("A model found: "
                               +model.unparse()+".\n");
	    }                                  
	     
	    noc=0;                                              //add
	    sa=new SuccessAnte(model.head, sa);
	    tree=new Tree(delta, pn, num, noc, cn, depth, sa, false);  //add
	    if (parent!=null) {
	      parent.mkTree(tree);                      //add
	    }

            branches++; models++; 
      	    ans=false; /* SAT */
	    scheck=false;
	    if (gstack==null) return;
	  }                                    //add
     	}

        if (scheck) {
	  if (kpas) {
	    if (unitBuf.first!=null) {
	      cnsq=unitBuf.first.head;
	      tree=new Tree(delta, pn, num, cnsq.length, cn, depth, 
			    unitBuf.first.successante, true);           //add
	      unitBuf.first=unitBuf.first.tail;
	    } 
	    else if (disjBuf.first!=null) {
	      cnsq=disjBuf.first.head;
	      tree=new Tree(delta, pn, num, cnsq.length, cn, depth, 
			    disjBuf.first.successante, true);           //add
	      disjBuf.first=disjBuf.first.tail;
	    }
	    else {
	      cnsq=domsBuf.first.head;
	      tree=new Tree(delta, pn, num, cnsq.length, cn, depth, 
			    domsBuf.first.successante, true);           //add
	      domsBuf.first=domsBuf.first.tail;
	    }
	    if (model!=null&&model.subsumes(cnsq)) {continue;}
	    
	    noc=cnsq.length;                             //add
            if (num!=0) {
	      depth++;                                            //add
	    } else {root=tree;}
	    if (parent!=null) {
		parent.mkTree(tree);                      //add
	    }
	    pn=num;                                     //add
	    cn=0;                                       //add
	    parent=tree;                                //add
	    
	    if (cnsq.length>1) {
	      gstack=new GStack(model, cnsq, 1, pn, depth, parent,
				unitBuf.first, unitBuf.last,
				disjBuf.first, disjBuf.last,
				domsBuf.first, domsBuf.last,
				gstack);
	    }
	    delta=cnsq[0];
	  }
	}                                       //add
	fcheck=true;
	while (fcheck) {
	  if (scheck) {
	    if (kpas) {                         //add
	      atomID++;
	      
	      if (verbose) {
		System.out.print(""+atomID+": "
                                 +delta.unparse()+".\n");
	      }
	      nodes++;
	      num++;                            //add
	      model=new Model(delta, model,num);
	      fcheck=false;
	    }                                  //add
	  }
	  if (negCls.cjmNeg(delta, model,sa) | !scheck | !kpas ) {
	      if (scheck) {
		if (kpas) {                       //add
		  if (verbose) {
		    System.out.print("A model candidate rejected: "
                                     +model.unparse()+".\n");
		  }
		}                                 //add
		
		noc=0;                                //add
		tree=new Tree(delta, pn, num, noc, cn, 
			      depth, saStack.head, true);         //add
		if (parent!=null) {
		  parent.mkTree(tree);                      //add
		}
		kpas=true;                                  //add
		
		branches++; failedBranches++;       
		if (gstack==null) return;
	      }
	      scheck=true;
	      
	      
	      /* peek stack and continue */
	      if (gstack!=null) {
		model=gstack.model;
		cnsq=gstack.cnsq;
		idx=gstack.idx;
		unitBuf.first=gstack.unitF;
		unitBuf.last =gstack.unitL;
		if (unitBuf.last!=null) {unitBuf.last.tail=null;}
		disjBuf.first=gstack.disjF;
		disjBuf.last =gstack.disjL;
		if (disjBuf.last!=null) {disjBuf.last.tail=null;}
		domsBuf.first=gstack.domsF;
		domsBuf.last =gstack.domsL;
		if (domsBuf.last!=null) {domsBuf.last.tail=null;}
		delta=cnsq[idx];
		pn=gstack.pn;                               //add
		depth=gstack.depth;                         //add
		parent=gstack.parent;                       //add
		cn=idx;                                     //add
		idx++;
		if (idx<cnsq.length) {gstack.idx=idx;}
		else {gstack=gstack.tail;} 
	      }
	      fcheck=true;
	    }
	  }
 	mixCls.cjmMix(delta,model,sa);
      } while (true);
    }
}

class GStack {
    Model model; Term[] cnsq; int idx,pn,depth; Tree parent;
    TList unitF; TList unitL; TList disjF; TList disjL;
    TList domsF; TList domsL; GStack tail;
    GStack(Model m, Term[] c, int x, int y, int z, Tree par, 
	   TList uf, TList ul, TList sf, TList sl, TList of, TList ol,
	   GStack s) {
	model=m; cnsq=c; idx=x; pn=y; depth=z; parent=par;
	unitF=uf; unitL=ul; disjF=sf; disjL=sl; domsF=of; domsL=ol;
	tail=s;}
}

class TList {
    Term[] head; TList tail; SuccessAnte successante;
    TList(Term[] h, SuccessAnte sa) {head=h; successante=sa;}
}

class CnsqBuf {
    TList first; TList last;
    CnsqBuf() {}
    void enter(Term[] c, SuccessAnte sa) {
	if (first==null) {first=new TList(c,sa); last=first;}
	else {last.tail=new TList(c,sa); last=last.tail;}
    }
    Term[] pickup() {
	Term[] delta; delta=(Term[])first.head; first=first.tail;
	return delta;  
    }
}

class SuccessAnte {
    Term label; SuccessAnte tail;
    SuccessAnte() {}
    SuccessAnte(Term c, SuccessAnte sa) {label=c; tail=sa;}
    String unparse() {
      if (this==null) {return "[]";}
      String s="[ "; SuccessAnte suc=this;
      while (suc.tail!=null) {
	s=s+suc.label.unparse()+", ";
	suc=suc.tail;
      }
      return s+"]";
    }
}

class SAStack {
    SuccessAnte head; SAStack tail;
    SAStack(SuccessAnte sa, SAStack saStack) {head=sa; tail=saStack;}
}


class PrintTree {
    Model head; PrintTree tail;
    PrintTree(Model model,PrintTree printtree) {head=model; tail=printtree;}
    String unparse() {
      if (this==null) {return "[]";}
      String s="["; PrintTree t=this,endT=null; Model startM=null,endM=null; 
      while (t!=endT) {
	while (t.tail!=endT) {
	  t=t.tail;
	}
	endM=null;
	while (t.head!=endM) {
	  startM=t.head;
	  while (t.head.tail!=endM) { 
	    t.head=t.head.tail;
	  }
	  if (t.head!=startM) {
	    s=s+t.head.head.unparse()+"<"+t.head.number+">, ";
	  }
	  else {s=s+t.head.head.unparse()+"<"+t.head.number+">";}
	  endM=t.head;
	  t.head=startM;
	}
        if (t!=this) {s=s+"],\n [";}
	else {s=s+"]";}
	endT=t;
        t=this;
      }
      return s;
    }
}


class TreeInf {
    Term label; TreeInf tail; int parnum,ownnum,numOfChi; 
    TreeInf(Term delta, TreeInf treeinf, int pn, int num, int noc) {
         label=delta; tail=treeinf; parnum=pn; ownnum=num; numOfChi=noc;
    }
    String unparse() {
	if (this==null) {return "[]";}
	String s="[ "; TreeInf t=this,endT=null;
	while (t!=endT) {
	  while (t.tail!=endT) { 
	    t=t.tail;
	  }
	  if (t!=this) {
	    s=s+t.label.unparse()+"<"+t.ownnum+">-"
		                 +t.parnum+"-"+t.numOfChi+", ";  
          }
	  else {
	    s=s+t.label.unparse()+"<"+t.ownnum+">-"
                                 +t.parnum+"-"+t.numOfChi+"]";
	  }
	  endT=t;
	  t=this;
	}
        return s;
    }

}       

class TreeList {
  Term label; TreeList tail; int parnum,ownnum,numOfChi,chinum,depth;
  TreeList(Term delta, int pn, int num, int noc, int cn, int de) {
    parnum=pn; ownnum=num; numOfChi=noc; chinum=cn; depth=de;
    label=delta;
    tail=null;
  }
  public void mkTreeList(TreeList treelist) {
    tail=treelist;
  }   
  String unparse(TreeList first) {
    if (this==null) {return "[]";}
    String s="[ "; TreeList t=first;
    while (t.tail!=null){
      s=s+t.label.unparse()+"<"+t.ownnum+">-"
                                      +t.parnum+"-"+t.numOfChi+", ";
      t=t.tail;
    }
    return s+t.label.unparse()+"<"+t.ownnum+">-"
                                      +t.parnum+"-"+t.numOfChi+"]";
  }
  String drawtree(TreeList first) {
    if (this==null) {return "";}
    String s=""; TreeList t=first; boolean exit[]; 
    while (true) {
      for (int i=0;i<t.depth; i++) {
	s=s+"     |";
      }
      s=s+"\n";
      for (int i=0;i<t.depth; i++) {
	s=s+"     |";
      }
      while (t.tail!=null && t.ownnum==t.tail.parnum) {
	s=s+t.label.unparse()+"<"+t.ownnum+">__"; 
	t=t.tail;
      }
      s=s+t.label.unparse()+"<"+t.ownnum+">\n"; 
      if (t.tail!=null) { t=t.tail; }
      else {return s;} 
    }
  }
}

class Tree {
  Term label; Tree child[]; SuccessAnte successante; 
  int parnum,ownnum,numOfChi,chinum,depth; boolean ans;
  Tree(Term delta, int pn, int num, 
       int noc, int cn, int de, SuccessAnte sa, boolean sut) {
    parnum=pn; ownnum=num; numOfChi=noc; 
    chinum=cn; depth=de; 
    label=delta;
    ans=sut;
    successante=sa;
    child=new Tree[noc]; 
    for (int i=0; i<noc; i++) {child[i]=null;}
  }

  public void mkTree(Tree tree) {
    child[tree.chinum]=tree;
  }   

  public void drawTree(String margin) {
    if (label==null) {
      if (ownnum==0) {
	System.out.print("\n");
	System.out.print(margin+"ROOT\n");
      } else System.out.print(margin+"- null<"+ownnum+">\n");
    } else {
      System.out.print(margin+"- "+label.unparse()+"<"+ownnum+">");
      if (ans) 
	System.out.print("true \n");
      else  System.out.print("false \n");
      System.out.print(margin+" "+successante.unparse()
                               +this.saList().unparse()+"\n");
    }
    for(int i=0; i<numOfChi; i++) {
      if (child[i]!=null) {
	System.out.print(margin+"  |\n");
	if (i==numOfChi-1) 
	  child[i].drawTree(margin+"   ");
	else 
	  child[i].drawTree(margin+"  |");
      }
    }
  }   

  public SuccessAnte saList() {
    SuccessAnte pwlist, salist=successante, childlist=null; 
    for (int i=0; i<numOfChi; i++) {
      if (child[i]!=null) {
	childlist=child[i].saList();
	while (childlist.label!=null) {
	  pwlist=salist;
	  while (pwlist.label!=null) {
	    if (pwlist.label.equals(childlist.label)) break;
	    pwlist=pwlist.tail;
	  }
	  if (pwlist.label==null) 
	    salist=new SuccessAnte(childlist.label, salist);
	  childlist=childlist.tail;
	}
      }
    }
    return salist;
  }
  
  public Tree simplify() {
    int newnoc=this.numOfChi;
    if (numOfChi==0) {                   
      if (!saListCheck())  label=null; 
    }
    else {                                    
      Tree newchild[];
      newchild=new Tree[numOfChi];
      for (int i=0; i<numOfChi; i++) {                
	if (child[i]!=null) {
	  newchild[i]=child[i].simplify(); 
	  if (!newchild[i].ans) ans=false;
	}
      }
      for (int i=0; i<numOfChi; i++) {                
	if (child[i]!=null) {
	    if (ans) {
	      if (newchild[i].label==null || !newchild[i].saListCheck()) { 
		newnoc=newchild[i].numOfChi;
		child=new Tree[newnoc];
		for (int n=0; n<newnoc; n++) {
		child[n]=newchild[i].child[n];
		}
		successante=newchild[i].successante;
		numOfChi=newnoc;
		break;
	      }
	    }
	    child[i].deleteElement();
	}
      }
      successante=unionAnte();
    }
    successante=this.successante;
    return this;
  }
  
  public SuccessAnte deleteElement() {
    SuccessAnte returnAnte=null;
    if (successante.label!=null) {
      while (successante.label.equals(label)) {
	successante=successante.tail;
	if (successante.label==null) return successante;
      }
      while (successante.tail.label!=null) {
	if (successante.tail.label.equals(label)) {
	  successante.tail=successante.tail.tail;
	}
	else successante=successante.tail;
      }
      if (successante.label.equals(label)) {
	successante.label=null;
      }
    }    
    return successante;
  }

  public SuccessAnte unionAnte() {
    SuccessAnte pwlist,childlist; 
    for (int i=0; i<numOfChi; i++) {
      if (child[i]!=null) {
	childlist=child[i].successante;
	while (childlist.label!=null) {
	  pwlist=successante;
	  while (pwlist.label!=null) {
	    if (pwlist.label.equals(childlist.label)) break;
	    pwlist=pwlist.tail;
	  }
	  if (pwlist.label==null) 
	    successante=new SuccessAnte(childlist.label, successante);
	  childlist=childlist.tail;
	}
      }
    }
    return successante;
  }
  
  boolean saListCheck() {
    SuccessAnte pwlist=successante;
    while(pwlist.label!=null) {
      if (this.label.equals(pwlist.label)) 
	return true;
      else pwlist=pwlist.tail;
    }
    return false;
  }
  
  Tree delete() {
    Tree own=this, newchild[]; newchild=new Tree[numOfChi];
    int n=0;
    for (int i=0; i<numOfChi; i++) { 
      newchild[i]=child[i];                       
      if (child[i].label==null) n++;
    }
    int nn=numOfChi-n;
    own.child=new Tree[nn];
    for (int i=0,j=0; i<numOfChi; i++) { 
      if (newchild[i].label!=null) {
	own.child[j]=newchild[i];
	j++;
      }
    }
    own.numOfChi=nn;
    return own;
  }

  public int numberOfNode() {
    int numberofnode=1;
    for (int i=0; i<numOfChi; i++) 
      if (child[i]!=null) numberofnode=numberofnode+child[i].numberOfNode();
    return numberofnode;  
  }

  public int numberOfLeaves() {
    int numberofleaves;
    if (numOfChi==0) numberofleaves=1;
    else numberofleaves=0;
    for (int i=0; i<numOfChi; i++) 
      if (child[i]!=null) numberofleaves=numberofleaves
                               +child[i].numberOfLeaves();
    return numberofleaves;  
  }

  public void mkGT (GT root) {
    root.son = child[0].mkGT();
    GT gt = root.son;
    for(int i=1;i < child.length;i++) {
      gt.next = child[i].mkGT();
	gt = gt.next;
    }
  }

  private GT mkGT () {
    GT gt = new GT(label);
    if (child.length == 0) {
      return gt;
    } else {
      gt.son = child[0].mkGT();
      GT gt1 = gt.son;
      for(int i=1;i < child.length;i++) {
	gt1.next = child[i].mkGT();
	gt1 = gt1.next;
      }
      return gt;
    }
  }

  String printin() {
    String s="I am ";
    if (this==null) s=s+"this=null<"+this.ownnum+">.";
    else if (this.label==null) s=s+"this.label=null<"+this.ownnum+">.";
    else s=s+this.label.unparse()+"<"+this.ownnum+">.";
    return s=s+"  In to simplify().";
  }

  String printout() {
    String s="I am ";
    if (this==null) s=s+"this=null<"+this.ownnum+">.";
    else if (this.label==null) s=s+"this.label=null<"+this.ownnum+">.";
    else s=s+this.label.unparse()+"<"+this.ownnum+">.";
    return s=s+"  Out from simplify().";
  }
}
// eof
      
   
