/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * ETerm.java 2.4.3 31-Oct-1997
 */

class ETerm extends Term {
    ETerm() {}
    ETerm(Term l, Term r) {arg=l; next=r;}
}

class PlusET extends ETerm {
    PlusET(Term lft, Term rht) {arg=lft; next=rht;}
    int ieval() {return arg.ieval()+next.ieval();}
    String unparse() {return "("+arg.unparse()+"+"+next.unparse()+")";}
}	

class MinusET extends ETerm {
    MinusET(Term lft, Term rht) {arg=lft; next=rht;}
    int ieval() {return arg.ieval()-next.ieval();}
    String unparse() {return "("+arg.unparse()+"-"+next.unparse()+")";}
}	

class TimesET extends ETerm {
    TimesET(Term lft, Term rht) {arg=lft; next=rht;}
    int ieval() {return arg.ieval()*next.ieval();}
    String unparse() {return arg.unparse()+"*"+next.unparse();}
}	

class DivET extends ETerm {
    DivET(Term lft, Term rht) {arg=lft; next=rht;}
    int ieval() {return arg.ieval()/next.ieval();}
    String unparse() {return arg.unparse()+"/"+next.unparse();}
}	

abstract class FTerm extends Term {
}

class AssignFT extends FTerm {
    AssignFT(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	arg.arg.arg=new ITermL(arg.next.ieval()); return next.beval();
    }
    String unparse() {return arg.arg.unparse()+":="+arg.next.unparse()
			     +", "+next.unparse();}
}

class AssignFTL extends FTerm {
    AssignFTL(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	arg.arg.arg=new ITermL(arg.next.ieval()); return true;
    }
    String unparse() {return arg.arg.unparse()+":="+arg.next.unparse();}
}

class EqFT extends FTerm {
    EqFT(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	if (arg.arg.ieval()!=arg.next.ieval()) {return false;}
	return next.beval();
    }
    String unparse() {return arg.arg.unparse()+"=="+arg.next.unparse()
			     +", "+next.unparse();}
}

class EqFTL extends FTerm {
    EqFTL(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	return (arg.arg.ieval()==arg.next.ieval());
    }
    String unparse() {return arg.arg.unparse()+"=="+arg.next.unparse();}
}

class NeFT extends FTerm {
    NeFT(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	if (arg.arg.ieval()==arg.next.ieval()) {return false;}
	return next.beval();
    }
    String unparse() {return arg.arg.unparse()+"!="+arg.next.unparse()
			     +", "+next.unparse();}
}

class NeFTL extends FTerm {
    NeFTL(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	return arg.arg.ieval()!=arg.next.ieval();
    }
    String unparse() {return arg.arg.unparse()+"!="+arg.next.unparse();}
}

class GtFT extends FTerm {
    GtFT(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	if (arg.arg.ieval()<=arg.next.ieval()) {return false;}
	return next.beval();
    }
    String unparse() {return arg.arg.unparse()+">"+arg.next.unparse()
			     +", "+next.unparse();}
}

class GtFTL extends FTerm {
    GtFTL(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	return (arg.arg.ieval()>arg.next.ieval());
    }
    String unparse() {return arg.arg.unparse()+">"+arg.next.unparse();}
}

class LtFT extends FTerm {
    LtFT(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	if (arg.arg.ieval()>=arg.next.ieval()) {return false;}
	return next.beval();
    }
    String unparse() {return arg.arg.unparse()+"<"+arg.next.unparse()
			     +", "+next.unparse();}
}

class LtFTL extends FTerm {
    LtFTL(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	return (arg.arg.ieval()<arg.next.ieval());
    }
    String unparse() {return arg.arg.unparse()+"<"+arg.next.unparse();}
}

class GeFT extends FTerm {
    GeFT(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	if (arg.arg.ieval()<arg.next.ieval()) {return false;}
	return next.beval();
    }
    String unparse() {return arg.arg.unparse()+">="+arg.next.unparse()
			     +", "+next.unparse();}
}

class GeFTL extends FTerm {
    GeFTL(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	return (arg.arg.ieval()>=arg.next.ieval());
    }
    String unparse() {return arg.arg.unparse()+">="+arg.next.unparse();}
}

class LeFT extends FTerm {
    LeFT(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	if (arg.arg.ieval()>arg.next.ieval()) {return false;}
	return next.beval();
    }
    String unparse() {return arg.arg.unparse()+"<="+arg.next.unparse()
			     +", "+next.unparse();}
}

class LeFTL extends FTerm {
    LeFTL(Term lft, Term rht) {arg=new ETerm(lft,rht);}
    boolean beval() {
	return (arg.arg.ieval()<=arg.next.ieval());
    }
    String unparse() {return arg.arg.unparse()+"<="+arg.next.unparse();}
}

// eof
