/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

import java.awt.*;
import java.util.Vector;
import java.io.*;
class PTVisualizer extends Frame{
   MGTP mgtp;
   GT root_gt;
   int x,y;
   
   Panel p = new Panel();
   Panel exec_panel = new Panel();
   Panel e_but_panel = new Panel();    
   Panel readf_panel = new Panel();
   Panel zoom_panel = new Panel();
   Panel z_but_panel = new Panel();
   Panel z_txt_panel = new Panel();
   Panel z_txt_h_panel = new Panel();
   Panel z_txt_v_panel = new Panel();
   Panel cv_panel = new Panel();    
   
   Menu zoomMenu;
   Menu engineMenu;
   Menu dspMenu;
   Menu treeMenu;
 
   Button run_button;
   Button readf_button;
   Button zoom_button;
   Button reset_button;
   TextField readf_txt;
   TextField zoom_h_txt;
   TextField zoom_v_txt;
   String fil1;
   String dir1;
   
   static PTCanvas ptc;
   static int cvw_height=600;		//
   static int cvw_width=800;
   static int lgw_height=cvw_height;		//
   static int lgw_width=cvw_width;

   static int guiw_height=cvw_height+150;
   static int guiw_width=cvw_width+25;

// static Scrollbar v,h;

   Color c;
  
   PTVisualizer(){}
   public static void main(String Args[]){
         PTVisualizer ptvis=new PTVisualizer();
         ptvis.init(); 
         ptvis.show();
	 
	 ptc.gf=ptc.init();
  }

  void init(){
  	setTitle("Proof Tree Visualizer");
   	this.setLayout(new BorderLayout());

    	MenuBar menuBar = new MenuBar();
    	zoomMenu = new Menu("Zoom");
	zoomMenu.add(new MenuItem("X1"));
    	zoomMenu.add(new MenuItem("X2"));    
    	zoomMenu.add(new MenuItem("X4"));
    	zoomMenu.add(new MenuItem("X10"));
    	zoomMenu.add(new MenuItem("X50"));
    	zoomMenu.add(new MenuItem("X100"));
    	menuBar.add(zoomMenu);

    	engineMenu = new Menu("Engine");
    	engineMenu.add(new MenuItem("MGTP"));
    	engineMenu.add(new MenuItem("CMGTP"));    
    	engineMenu.add(new MenuItem("IVMGTP"));
    	menuBar.add(engineMenu);
   
    	dspMenu = new Menu("Display");
    	dspMenu.add(new MenuItem("Tree"));
    	dspMenu.add(new MenuItem("Radial"));    
    	dspMenu.add(new MenuItem("Rectangle"));
    	menuBar.add(dspMenu);

//    	treeMenu = new Menu("Tree");
    	treeMenu = new Menu("Alloc");
    	treeMenu.add(new MenuItem("Weighted"));
    	treeMenu.add(new MenuItem("Fixed"));    
    	menuBar.add(treeMenu);

   	setMenuBar(menuBar);

    	p.setLayout(new FlowLayout());
    	exec_panel.setLayout(new BorderLayout());
    	e_but_panel.setLayout(new FlowLayout());
    	readf_panel.setLayout(new BorderLayout());
    	zoom_panel.setLayout(new BorderLayout());
    	z_but_panel.setLayout(new FlowLayout());
    	z_txt_panel.setLayout(new FlowLayout());
        z_txt_h_panel.setLayout(new BorderLayout());
        z_txt_v_panel.setLayout(new BorderLayout());
    	cv_panel.setLayout(new BorderLayout());

       
    	add("North", p); 
    	add("South", cv_panel);
  
    	p.add("West",exec_panel);
    	p.add("East",zoom_panel);
  
    	readf_button=new Button(" Read File ");
    	run_button=new Button(" Run ");
    	e_but_panel.add("West",readf_button);
    	e_but_panel.add("Eest",run_button);
   
    	Label readf_label = new Label(" File Name ", 1);
    	readf_panel.add("West", readf_label);
    	readf_txt = new TextField("", 20);
    	readf_panel.add("East", readf_txt);
    
    	exec_panel.add("North",e_but_panel);
    	exec_panel.add("South",readf_panel);

    	zoom_panel.add("North",z_but_panel);
    	zoom_panel.add("South",z_txt_panel);          
        zoom_button = new Button(" Zoom ");
    	z_but_panel.add(zoom_button);
    	reset_button = new Button( "Reset ");
        z_but_panel.add(reset_button);
        
	z_txt_panel.add(z_txt_h_panel);
        z_txt_panel.add(z_txt_v_panel);
	Label zoom_h_label = new Label(" mult H ", 1);
    	Label zoom_v_label = new Label(" mult V ", 1);
        zoom_h_txt = new TextField("", 5);
    	zoom_v_txt = new TextField("", 5);
	z_txt_h_panel.add("West", zoom_h_label);
	z_txt_h_panel.add("East", zoom_h_txt);
	z_txt_v_panel.add("West", zoom_v_label);
	z_txt_v_panel.add("East", zoom_v_txt);

   	
	ptc = new PTCanvas(cvw_width,cvw_height,lgw_width,lgw_height);    
    	ptc.h=new Scrollbar(Scrollbar.HORIZONTAL,0,0,0,cvw_width);
    	ptc.v=new Scrollbar(Scrollbar.VERTICAL,0,0,0,cvw_height);    
	
        cv_panel.add("East", ptc.v);
    	cv_panel.add("South",ptc.h);
    	cv_panel.add("Center",ptc);
	c=new Color(230,230,240);
	ptc.setBackground(c);
    	ptc.resize(cvw_width,cvw_height);    
	reset_PTC();
    	resize(guiw_width,guiw_height);
  }  

  void zoom_menu_Clicked(String s){
	setCursor(CROSSHAIR_CURSOR);
	ptc.zoom_mode=true;
	System.out.println("Zoom Mode=true");
	if(s=="X1"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=1; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X2"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=2; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X4"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=4; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X10"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=10; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X50"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=50; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}
	if(s=="X100"){ ptc.old_mult_h=ptc.cur_mult_h;ptc.cur_mult_h=100; 
		     ptc.old_mult_v=ptc.cur_mult_v;ptc.cur_mult_v=1;}

  }

  void tree_menu_Clicked(String s){
	if(s=="Weighted"){ptc.Tree_Mode='w';}
	if(s=="Fixed"){ptc.Tree_Mode='f';}
	System.out.println("Tree_Mode="+ptc.Tree_Mode);
	System.out.println("Tree Menue: coordinate_calc, start.");
        ptc.coordinate_calc();
	System.out.println("Tree Menue: coordinate_calc, end.");
        ptc.repaint();
  }
  void dsp_menu_Clicked(String s){
	if(s=="Tree"){ptc.Dsp_Mode='t';}
	if(s=="Radial"){ptc.Dsp_Mode='r';}
	if(s=="Rectangle"){ptc.Dsp_Mode='c';}
	System.out.println("Dsp_Mode="+ptc.Dsp_Mode);
	System.out.println("DSP Menue: coordinate_calc, start.");
        ptc.coordinate_calc();
	System.out.println("DSP Menue: coordinate_calc, end.");
        ptc.repaint();
  }

  public boolean handleEvent(Event evt) {
      int h_val,v_val;
      switch(evt.id){
	 case Event.WINDOW_DESTROY: 
             this.hide();         // hide the Frame
	     this.dispose();      // tell windowing system to free resources
	     System.exit(0); // exit	
	     break;
	
	 case Event.ACTION_EVENT:
             if (evt.target == readf_button){
		 readf_button_Clicked(evt);
		 break;
	     }   
	     if (evt.target == run_button){
	     	 run_button_Clicked(evt);
		 break;
	     }
             if (evt.target == zoom_button){
 	          zoom_button_Clicked(evt);
		  break;
	     }
	     if (evt.target == reset_button){
		  reset_button_Clicked(evt);
	          break;
            } 
	     if (evt.target instanceof MenuItem){
		System.out.println("MenuItem.");
		if (((MenuItem)evt.target).getParent()==zoomMenu){
			zoom_menu_Clicked((String)evt.arg);
			break;
		}
		if (((MenuItem)evt.target).getParent()==treeMenu){
			tree_menu_Clicked((String)evt.arg);
			break;
		}
		if (((MenuItem)evt.target).getParent()==dspMenu){
			dsp_menu_Clicked((String)evt.arg);
			break;
		}
	        
		break;
             }			

	 case Event.SCROLL_LINE_UP:	
         case Event.SCROLL_LINE_DOWN:
         case Event.SCROLL_PAGE_UP:
         case Event.SCROLL_PAGE_DOWN:
         case Event.SCROLL_ABSOLUTE:
		h_val=ptc.h.getValue();
		v_val=ptc.v.getValue();
		ptc.h.setValue(h_val);
		ptc.v.setValue(v_val);
		if(evt.id==Event.SCROLL_ABSOLUTE){
			System.out.println("SCROLL_ABSOLUTE: h_val="+h_val+",v_val="+v_val+",px="+ptc.px+",py="+ptc.py);
		}	
		else{	
			System.out.println("SCROLL_OTHERS: h_val="+h_val+",v_val="+v_val+",px="+ptc.px+",py="+ptc.py);	
		}	
		ptc.old_scroll_x=ptc.cur_scroll_x;
		ptc.old_scroll_y=ptc.cur_scroll_y;
		ptc.cur_scroll_x=(int)(h_val*ptc.cur_mult_h);
		ptc.cur_scroll_y=(int)(v_val*ptc.cur_mult_v);
		ptc.move_window(ptc.cur_scroll_x-ptc.old_scroll_x,
                                ptc.cur_scroll_y-ptc.old_scroll_y);
		if(evt.id!=Event.SCROLL_ABSOLUTE){ptc.repaint();}
		break;
	} 
	return false;
//	return super.handleEvent(evt);
  }

  void readf_button_Clicked(Event event) {
	readf_txt.setText("open file");
	selectedOpen();
      	String filename = dir1+fil1;
	try{}
	catch (Exception e){
	    System.out.println("io error for "+e.getMessage());
	}
	catch (Error e){
	    System.out.println("lang error in "+e.getMessage());
	}
	finally{	  
	    readf_txt.setText(fil1);
	}
  }

  void run_button_Clicked(Event event) {
	String[] args={"","","","","","","","","",""};
	System.out.print("Now reading file: " + dir1 + fil1 + "...\n");
	args[0]=dir1+fil1;
	mgtp=new MGTP();
	mgtp.doMGTP(args);
//	ptw=new PTWindow("Proof Tree Window");
//	ptw=new PTWindow();
//	graph=ptw.grinit();
	System.out.println("RUN Button: mkGT, start.");
	mgtp.pt_top.mkGT(null);
	root_gt=mgtp.pt_top;
	System.out.println("RUN Button: mkGT, end.");
	ptc.root_gt=root_gt;
	System.out.println("RUN Button: coordinate_calc, start.");
        ptc.coordinate_calc();
	System.out.println("RUN button: coordinate_calc, end.");
	ptc.repaint();
  	ptc.set_scroll();
  }
  
  void selectedOpen() {
	FileDialog fd=new FileDialog(this, "Open");
//	fd.setDirectory("c:\\mgtp\\prob");
	fd.setDirectory("/home/hasegawa/java/jprob");
	fd.setFilenameFilter(new JavaFileFilter());
	fd.show();
	fil1=fd.getFile();
	dir1=fd.getDirectory();
	fd.setDirectory(dir1);
        System.out.println("My Dir ="+dir1);
	readf_txt.setText(dir1+fil1);
  }
  
  void zoom_button_Clicked(Event evt){
        float mult_h,mult_v;
	mult_h=mygetValue(zoom_h_txt);
	mult_v=mygetValue(zoom_v_txt);
        if ((mult_h > 0)&&(mult_v > 0)){
	  ptc.old_mult_h=ptc.cur_mult_h;
	  ptc.cur_mult_h=mult_h;
	  ptc.old_mult_v=ptc.cur_mult_v;
	  ptc.cur_mult_v=mult_v;
	
	  ptc.zoom_mode=true;
        }
  }
  
  void reset_button_Clicked(Event evt){
	reset_PTC();
	System.out.println("Reset Button: coordinate_calc, start.");
        ptc.coordinate_calc(); // *0209
	System.out.println("Reset Button: coordinate_calc, end.");
	ptc.repaint();
  }

  void reset_PTC(){
	ptc.px=0;
	ptc.py=0;
	ptc.cur_scroll_x=0;
	ptc.cur_scroll_y=0;
	ptc.old_scroll_x=0;
	ptc.old_scroll_y=0;
	ptc.old_mult_h=1;
	ptc.cur_mult_h=1;
	ptc.old_mult_v=1;
	ptc.cur_mult_v=1;
        ptc.lgw_height=cvw_height;		
        ptc.lgw_width=cvw_width;
	ptc.h.setValue(ptc.cur_scroll_x);
	ptc.v.setValue(ptc.cur_scroll_y);
  	zoom_h_txt.setText("1");
        zoom_v_txt.setText("1");
        ptc.set_scroll();
  }
  float mygetValue(TextField txt){
	float i;
	try{
	   i=Float.valueOf(txt.getText()).floatValue();
	}
	catch (java.lang.NumberFormatException e){
		i=0;
	} 	
        return i;
  }
}

class JavaFileFilter implements FilenameFilter{
  public boolean accept(File dir,String name){
	return name.endsWith(".mg");
  }
}

class PTCanvas extends Canvas{
  Graphics gf;
  GT root_gt;
  GTWindow agtw;
  int cvw_height; 	
  int cvw_width;
  int lgw_height;
  int lgw_width;
  int px=0;
  int py=0;
  Scrollbar h,v;
  float old_mult_h=1;
  float cur_mult_h=1;
  float old_mult_v=1;
  float cur_mult_v=1;
  int cur_scroll_x=0;
  int cur_scroll_y=0;
  int old_scroll_x=0;
  int old_scroll_y=0;
  boolean zoom_mode=false;
  boolean TwoPointMode=false;
//  GT dsp_gt;
  Color dsp_cl;
  char Tree_Mode='w';
  char Dsp_Mode='t';
  int oval_r=4;
  int root_oval_r=5;
  int debug_i;
  
  PTCanvas(){}
  PTCanvas(int cvww,int cvwh,int lgww,int lgwh){
  	cvw_height=cvwh;
  	cvw_width=cvww;
  	lgw_width=lgww;
  	lgw_height=lgwh;
	
	//g=grinit();	
	//if(g==null){System.out.print("initGraph,failed.");}
  }  

  Graphics init(){
 // setBackground(Color.black);
    return getGraphics();
  }

  void mydrawLine(Graphics g,int x,int y,int to_x,int to_y){
	if((x>=0)&&(x<=cvw_width)&&(y>=0)&&(y<=cvw_height)){
        	g.drawLine(x,y,to_x,to_y);
	}
	if((to_x>=0)&&(to_x<=cvw_width)&&(to_y>=0)&&(to_y<=cvw_height)){
		g.drawLine(x,y,to_x,to_y);
	}
  }
 
  void myfillOval(Graphics g,int x,int y,int dx,int dy){
	if((x>=0)&&(x<=cvw_width)&&(y>=0)&&(y<=cvw_height)){
		g.fillOval(x,y,dx,dy);
		}
	}	

  void paint_single(Graphics g,GT gt){		
        int ror=root_oval_r,rod=ror*2;
        int or=oval_r,od=or*2;
	g.setColor(gt.p_color); 
	if (gt==root_gt) 
            myfillOval(g,scaleAdjust_x(gt.x)-ror,scaleAdjust_y(gt.y)-ror,rod,rod);
	else myfillOval(g,scaleAdjust_x(gt.x)-or,scaleAdjust_y(gt.y)-or,od,od);
	g.setColor(Color.black); 
	GT s=gt.son;				// ѤGTλҶͤ 
	while(s!=null){				
		 mydrawLine(g,scaleAdjust_x(gt.x),scaleAdjust_y(gt.y),scaleAdjust_x(s.x),scaleAdjust_y(s.y));
		s=s.next;			// ˥ХȥϤ 
	}
  }

 void paint_all(Graphics g,GT gt){		// ȷϿޤ褹᥽å 
	if (Dsp_Mode=='t'){
//	    if((scaleAdjust_x(gt.L)>cvw_width)||(scaleAdjust_x(gt.L)+gt.W*cur_mult_h<0)){return;}
	    if((scaleAdjust_x(gt.L)>cvw_width)||(scaleAdjust_x(gt.L)+gt.W<0)){return;}
	}
	paint_single(g,gt);			// ޤ˲² 
        debug_i++;
        GT s=gt.son;				// ѤGTλҶͤ 
	while(s!=null){				
	      paint_all(g,s);			// ҶβȷϿޤ 
	      s=s.next;				// ˥ХȥϤ 
	}
  }

  public void redraw(GT gt,Color cl){
        int ror=root_oval_r,rod=ror*2;
        int or=oval_r,od=or*2;
	if(gf==null){System.out.print("Null Graphics.");}
	gf.setColor(cl);	
	if (gt==root_gt) gf.fillOval(scaleAdjust_x(gt.x)-ror,scaleAdjust_y(gt.y)-ror,rod,rod);
	else gf.fillOval(scaleAdjust_x(gt.x)-or,scaleAdjust_y(gt.y)-or,od,od);
	gf.setColor(Color.black);	
  }


  void coordinate_calc() {
	if (root_gt==null)return;
	if (Dsp_Mode=='t'){
            if (Tree_Mode=='w') 
//                coord_weighted(root_gt,0,lgw_width,50,(lgw_height-50)/root_gt.gs);
                  // 3/7/98 (R.H)
                coord_weighted(root_gt,0,lgw_width,50,(lgw_height-50)/(float)root_gt.gs);
//            else coord_fixed(root_gt,0,lgw_width,50,(lgw_height-50)/root_gt.gs);
                  // 3/7/98 (R.H)
            else coord_fixed(root_gt,0,lgw_width,50,(lgw_height-50)/(float)root_gt.gs);
        }
        if (Dsp_Mode=='r'){
            System.out.println("DSP Mode="+Dsp_Mode+",Tree Mode="+Tree_Mode);
	    //	    if (Tree_Mode=='w')                                        // Funny
	    //                coord_polar_weighted(root_gt,0,360,cvw_width/2,cvw_height/2,
	    //                                            cvw_height/(2*root_gt.gs));
	    //	    else coord_polar_fixed(root_gt,0,360,cvw_width/2,cvw_height/2,
	    //                                          cvw_height/(2*root_gt.gs));
//          if (Tree_Mode=='w')                                                 
//              coord_polar_weighted(root_gt,0,360,lgw_width/2,lgw_height/2,
//                                            cvw_height/(2*root_gt.gs));
//	    else coord_polar_fixed(root_gt,0,360,lgw_width/2,lgw_height/2,     // incomplete
//                                          cvw_height/(2*root_gt.gs),0);      //  3/6/98 
	    if (Tree_Mode=='w')                                                // updated (R.H)
              coord_polar_weighted(root_gt,0,360,lgw_width/2,lgw_height/2,     // 3/6/98 
//                                            cvw_height/(2*root_gt.gs));
                                              // 3/7/98 (R.H)
                                            cvw_height/(float)(2*root_gt.gs));
	    else coord_polar_fixed(root_gt,0,360,lgw_width/2,lgw_height/2,
//                                          cvw_height/(2*root_gt.gs));
                                            // 3/7/98 (R.H)
                                          cvw_height/(float)(2*root_gt.gs));
        }
  }

  public void paint(Graphics g){
        debug_i=0;
	if (root_gt==null) return;
        paint_all(g,root_gt);
	System.out.println("paint: scroll_x="+cur_scroll_x+",L="+px+",w="+lgw_width+",R="+(px+lgw_width+",debug_i="+debug_i));
  }

  public boolean handleEvent(Event evt){
      switch(evt.id){
	 case Event.MOUSE_DOWN:
	    if (zoom_mode==false){
	        GT found_gt;
	        System.out.println("MOUSE_DOWN: evt.x="+evt.x+",evt.y="+evt.y);
	        if (root_gt==null){
		    System.out.println("root_gt=null");
		    break;
		}
                debug_i=0;
                if (Dsp_Mode=='t'){
	            found_gt=find(root_gt,evt.x,evt.y);}
                else {
	            found_gt=find_as(root_gt,evt.x,evt.y);}
                System.out.println("FIND: debug_i="+debug_i);
	        if (found_gt==null){
		    System.out.println("found_gt=null");
		    break;
		}
		if (TwoPointMode){
		    found_gt.p_color=Color.green;
		    agtw.ToNode(found_gt);
		    TwoPointMode=false;
//		    dsp_gt=found_gt;	
		    agtw.mark_gt.addElement(found_gt);
		    redraw(found_gt,Color.green);
		    break;
		}
		found_gt.p_color=Color.red;
//		dsp_gt=found_gt;	
		GTWindow gtw=new GTWindow(found_gt,root_gt,this); 
		gtw.mark_gt.addElement(found_gt);
		redraw(found_gt,Color.red);
		break;
	    }
	    if (zoom_mode==true){
	        int h_val=0;int v_val=0;
		lgw_width=(int)(cvw_width*cur_mult_h);
	        lgw_height=(int)(cvw_height*cur_mult_v);
		System.out.println("MOUSE_DOWN_ZOOM: lgww="+lgw_width+",lgwh="+lgw_height+",old px="+px+" ,evt.x="+evt.x+",old_mult_h="+old_mult_h+",cur_mult_h="+cur_mult_h);
	        if ((old_mult_h!=cur_mult_h)||(old_mult_v!=cur_mult_v)){
		    change_mult(evt.x,evt.y);
                    System.out.println("ZOOM Mode: coordinate_calc, start.");
                    coordinate_calc();
                    System.out.println("ZOOM Mode: coordinate_calc, end.");
		}
		else move_center(evt.x,evt.y);
		repaint();
		zoom_mode=false;	
	        break;
	    }
      	    System.out.println("Other Event Occured.");
      }
      return true;
  }

  void move_window(int dx,int dy){
	px=px-dx;
	py=py-dy;
//        System.out.println("move_window: new px="+px);
  }
  
  void move_center(int x,int y){
	move_window(x-cvw_width/2,y-cvw_height/2);
        set_scroll();
  }	

  void change_mult(int x,int y){
	int new_x,new_y;
//        System.out.println("change_mult: old px="+px);
	new_x=(int)((-px+x)*(cur_mult_h/old_mult_h));	
	new_y=(int)((-py+y)*(cur_mult_v/old_mult_v));	
        px=0;py=0;
	move_center(new_x,new_y);
  }

  void set_scroll(){
	int h_val,v_val,l_h_val,l_v_val;
	l_h_val=cvw_width/2-px;
	l_v_val=cvw_height/2-py;
	h_val=(int)(l_h_val/cur_mult_h);
        h.setValue(h_val);
	v_val=(int)(l_v_val/cur_mult_v);
	v.setValue(v_val);
	cur_scroll_x=l_h_val;
	cur_scroll_y=l_v_val;        
  } 

  int scaleAdjust_x(int x){
//	return (int)(px+x*cur_mult_h);
	return px+x;
  }
  int scaleAdjust_y(int y){
//	return (int)(py+y*cur_mult_v);
	return py+y;
  }

  void coord_weighted(GT gt,int Lo,int Wo,float Yo,float Do){	
     				// ɸ᥽å(üޡ˻) 
     gt.L=Lo;
     gt.W=Wo;
     gt.x=Lo+Wo/2;			// Xɸ׻ 
     gt.y=(int)Yo;			// YɸɸͤȤ 
     GT s=gt.son;			// ǡѤѿͿ 
     int ll=Lo;
     int ww;
     float mf;
     float hh=Yo+Do;
     while(s!=null){		// ûҤޤǣԤ 
           mf=(float)s.ds/(float)gt.ds;
           ww=(int)(Wo*mf);	// տαƽ̾
	   coord_weighted(s,ll,ww,hh,Do);	
                                // ĹˤˤĤƺƵŪܥ᥽åɤ򷫤֤ 
	   ll=ll+ww;		// üä 	
	   s=s.next;		// ˤ˥ХȥϤ 
     }
  }
  
  void coord_fixed(GT gt,int Lo,int Wo,float Yo,float Do){  
				// ɸ᥽å(üɸ⡤˻) 
     gt.L=Lo;			// ͤ򥤥󥹥ѿϤ 
     gt.W=Wo;
     gt.x=Lo+Wo/2;			// Xɸ׻ 
     gt.y=(int)Yo;			// YɸɸͤȤ 
     GT s=gt.son;			// ǡѤѿͿ 
     int ll=Lo;
     int ww;
     float hh=Yo+Do;
     while(s!=null){		// ûҤޤǣԤ 
	   ww=Wo/gt.cs;	        // տαƽ̾ 
           coord_fixed(s,ll,ww,hh,Do); 
                                // ĹˤˤĤƺƵŪܥ᥽åɤ򷫤֤ 
           ll=ll+ww;		// üä 	
           s=s.next;		// ˤ˥ХȥϤ 
     }
  }

  void coord_polar_fixed(GT gt,float Fk,float theta,int xo,int yo,float r){  
  
     int xc,yc;				// ɸ᥽å(üɸ⡤˻) 
     gt.y=yo;			// YɸɸͤȤ 
     gt.x=xo;			// Xɸ׻ 
     gt.F=Fk;
     gt.A=theta;
     GT s=gt.son;			// ǡѤѿͿ 
     float ff=Fk;
     float tt=theta/gt.cs;
     while(s!=null){		// ûҤޤǣԤ 
	   xc=get_x(gt.x,ff+tt/2,r);
	   yc=get_y(gt.y,ff+tt/2,r);
	   coord_polar_fixed(s,ff,tt,xc,yc,r);	// ĹˤˤĤƺƵŪܥ᥽åɤ򷫤֤ 
           ff=ff+tt;
	   s=s.next;		// ˤ˥ХȥϤ 
     }
  }

  /*
  void coord_polar_fixed(GT gt,float Fk,float theta,int xo,int yo,float r,int n){  
  
     int xc,yc;
     gt.x=get_polar_x(xo,theta/2,r,n);	
     gt.y=get_polar_y(yo,theta/2,r,n);
     gt.F=Fk;
     gt.A=theta;
     GT s=gt.son;		
     float ff=Fk;
     float tt=theta/gt.cs;
     while(s!=null){		
	   coord_polar_fixed(s,ff,tt,xo,yo,r,n+1);
           ff=ff+tt;
	   s=s.next;		
     }
  }
  */
  void coord_polar_weighted(GT gt,float Fk,float theta,int xo,int yo,float r){  
  
     int xc,yc;				// ɸ᥽å(üɸ⡤˻) 
     gt.y=yo;			// YɸɸͤȤ 
     gt.x=xo;			// Xɸ׻ 
     gt.F=Fk;
     gt.A=theta;
     GT s=gt.son;			// ǡѤѿͿ 
     float ff=Fk;
     float tt;
     while(s!=null){		// ûҤޤǣԤ 
	   tt=theta*s.ds/gt.ds;
	   xc=get_x(gt.x,ff+tt/2,r);
	   yc=get_y(gt.y,ff+tt/2,r);
	   coord_polar_weighted(s,ff,tt,xc,yc,r); // ĹˤˤĤƺƵŪܥ᥽åɤ򷫤֤ 
           ff=ff+tt;
	   s=s.next;		// ˤ˥ХȥϤ 
     }
  }

  int get_x(float x,float k,float r){
     double rd=3.14159/180; 
//     return (int)(x+r*Math.sin((k-180)*rd));
//     return (int)(x+cur_mult_h*r*Math.sin((k-180)*rd));  // For using lgw_width
//     return (int)(cur_mult_h*(x+r*Math.sin((k-180)*rd)));  // For using cvw_width *Funny 
     return (int)(x+cur_mult_h*r*Math.sin((k-180)*rd));  // For using lgw_ & cvw_width
//     return (int)(x+cur_mult_h*r*Math.cos((k+90)*rd));  // For using lgw_ & cvw_width
                                                          // vertical line not straight
  }

  int get_y(float y,float k,float r){
     double rd=3.14159/180; 
//     return (int)(y+r*Math.cos((k-180)*rd)); 
//     return (int)(y+r*Math.cos((k-180)*rd));             // For using lgw_width
//     return (int)(cur_mult_v*(y+r*Math.cos((k-180)*rd)));  // For using cvw_width
     return (int)(y+cur_mult_v*r*Math.cos((k-180)*rd));  // For using lgw_ & cvw_width
//     return (int)(y-cur_mult_v*r*Math.sin((k+90)*rd));  // For using lgw_ & cvw_width
                                                          // vertical line not straight
  }

  int get_polar_x(float x,float k,float r,int n){
     double rd=3.14159/180; 
     return (int)(x+cur_mult_h*n*r*Math.sin((k-180)*rd));  // For using lgw_ & cvw_width
  }


  int get_polar_y(float y,float k,float r,int n){
     double rd=3.14159/180; 
     return (int)(y+cur_mult_v*n*r*Math.cos((k-180)*rd));  // For using lgw_ & cvw_width
  }


/*
  GT find(int cx,int cy){
     GT s;	
     if ((x-5<cx)&&(cx<x+5)&&(y-5<cy)&&(cy<y+5)){	
	System.out.println("found.");  
	return this;
     }
     if (cy<y) return null;
	 s=son;
	 while(s!=null){
	       if ((s.L<=cx)&&(cx<s.L+s.W)){
	            return s.find(cx,cy);
	       }	
	       s=s.next;	
     }
     return null;
  }
*/

/*
  GT find(GT gt,int cx,int cy){
     GT s;	
     int new_x,new_y;
     new_x=scaleAdjust_x(gt.x);
     new_y=scaleAdjust_y(gt.y);
     debug_i++;
     if ((new_x-5<cx)&&(cx<new_x+5)&&(new_y-5<cy)&&(cy<new_y+5)){	
	System.out.println("found.");  
	return gt;
     }
//     if (cy>new_y) return null;
//     if (cy<new_y+5) return null;
	 s=gt.son;
	 while(s!=null){
	       if ((scaleAdjust_x(s.L)<=cx)&&(cx<=scaleAdjust_x(s.L)+s.W)){
	            return find(s,cx,cy);
	       }	
	       s=s.next;	
     }
     return null;
  }
*/


///* For Tree in use
  GT find(GT gt,int cx,int cy){
     GT s,t;	
     int new_x,new_y;
     new_x=scaleAdjust_x(gt.x);
     new_y=scaleAdjust_y(gt.y);
     debug_i++;
     if ((new_x-5<cx)&&(cx<new_x+5)&&(new_y-5<cy)&&(cy<new_y+5)){	
	System.out.println("found.");  
	return gt;
     }
//     if (cy>new_y) return null;
//     if (cy<new_y+5) return null;
	 s=gt.son;
	 while(s!=null){
	       if ((scaleAdjust_x(s.L)<=cx)&&(cx<=scaleAdjust_x(s.L)+s.W)&&(s.W>=5)){
	            return find(s,cx,cy);
	       }	
               if (s.W<5) {
                   t=find(s,cx,cy);
                   if (t!=null) return t;
               }
	       s=s.next;	
     }
     return null;
  }
//*/


///*
  GT find_as(GT gt,int cx,int cy){
     GT s;	
     int new_x,new_y;
     new_x=scaleAdjust_x(gt.x);
     new_y=scaleAdjust_y(gt.y);
     debug_i++;
     if ((new_x-5<cx)&&(cx<new_x+5)&&(new_y-5<cy)&&(cy<new_y+5)){	
	System.out.println("Specified node found.");  
	return gt;
     }
     if (gt.son!=null){
	 s=find_as(gt.son,cx,cy);
         if (s!=null){return s;}
     }
     if (gt.next!=null){return find_as(gt.next,cx,cy);} 
     else return null;
  } 
//*/

}





