/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * MGTPTerms.java 2.4.5 7-Nov-1997
 */

abstract class Term {
  String name; Term next; Term arg;
  Term() {}
  boolean match(Term x) {return false;}
  boolean vmatch(Term x) {return false;}
  Term ground() {return null;}
  Term vground(Term x) {return null;}
  Term vgroundL() {return null;}
  String unparse() {return "";}
}

class UATerm extends Term {
  UATerm(String s) {name=s;}
  boolean match(Term x) {return this==x;}
  boolean vmatch(Term x) {return this==x;}
  Term ground() {return this;}
  Term vgroundL() {return this;}
  String unparse() {return name;}
}

class ATerm extends Term {
  ATerm() {}
  ATerm(String s) {name=s;}
  ATerm(String s, Term x) {name=s; next=x;}
  boolean match(Term x) {
    if (name!=x.name) return false;
    return next.match(x.next);
  }
  boolean vmatch(Term x) {return name==x.name;}
  Term ground() {return new ATerm(name, next.ground());}
  Term vground(Term x) {return new ATerm(name,x);}
  Term vgroundL() {return new ATermL(name);}
  String unparse() {return name+","+next.unparse();}
}

class ATermL extends ATerm {
  ATermL(String s) {name=s;}
  boolean match(Term x) {return name==x.name;}
  Term ground() {return this;}
  Term vgroundL() {return this;}
  String unparse() {return name;}
}

class ITerm extends Term {
  int val;
  ITerm() {}
  ITerm(int i) {val=i;}
  ITerm(int i, Term x) {val=i; next=x;}
  boolean match(Term x) {
    if (!(x instanceof ITerm)) return false;
    if (val!=((ITerm)x).val) return false;
    return next.match(x.next);
  }
  boolean vmatch(Term x) {
    if (!(x instanceof ITerm)) return false;
    return val==((ITerm)x).val;
  }
  Term ground() {return new ITerm(val, next.ground());}
  Term vground(Term x) {return new ITerm(val,x);}
  Term vgroundL() {return new ITermL(val);}
  String unparse() {return Integer.toString(val)+","+next.unparse();}
}

class ITermL extends ITerm {
  ITermL(int i) {val=i;}
  boolean match(Term x) {
    if (!(x instanceof ITerm)) return false;
    return val==((ITerm)x).val;
  }
  Term ground() {return this;}
  Term vgroundL() {return this;}
  String unparse() {return Integer.toString(val);}
}

class AVar extends Term {
  AVar(String s, Term x) {name=s; next=x;}
  boolean match(Term x) {return next.match(x.next);}
  String unparse() {return name+","+next.unparse();}
}

class AVarL extends Term {
  AVarL(String s) {name=s;}
  boolean match(Term x) {return true;}
  String unparse() {return name;}
}

class FVar extends Term {
  FVar(String s) {name=s;}
  FVar(String s, Term x) {name=s; next=x;}
  boolean match(Term x) {arg=x; return next.match(x.next);}
  String unparse() {return "?"+name+","+next.unparse();}
}

class FVarL extends Term {
  FVarL(String s) {name=s;}
  boolean match(Term x) {arg=x; return true;}
  String unparse() {return "?"+name;}
}

class BVar extends Term {
  BVar(String s, Term t) {name=s; arg=t;}
  BVar(String s, Term t, Term x) {name=s; arg=t; next=x;}
  boolean match(Term x) {
    if (arg.arg.vmatch(x)) {return next.match(x.next);}
    return false;
  }
  Term ground() {return arg.arg.vground(next.ground());}
  String unparse() {return "!"+name+","+next.unparse();}
}

class BVarL extends Term {
  BVarL(String s, Term t) {name=s; arg=t;}
  boolean match(Term x) {return arg.arg.vmatch(x);}
  Term ground() {return arg.arg.vgroundL();}
  String unparse() {return "!"+name;}
}

class CTerm extends Term {
  CTerm() {}
  CTerm(String s, Term a, Term x) {name=s; arg=a; next=x;}
  boolean match(Term x) {
    if (name!=x.name) return false;
    if (arg.match(x.arg)) return next.match(x.next);
    return false;
  }
  boolean vmatch(Term x) {
    if (name!=x.name) return false;
    return arg.match(x.arg);
  }
  Term ground() {return new CTerm(name, arg.ground(), next.ground());}
  Term vground(Term x) {return new CTerm(name,arg,x);}
  Term vgroundL() {return new CTermL(name,arg);}
  String unparse() {return name.substring(0,name.indexOf("/"))
		      +"("+arg.unparse()+"),"+next.unparse();
  }
}

class CTermL extends CTerm {
  CTermL(String s, Term a) {name=s; arg=a;}
  boolean match(Term x) {
    if (name!=x.name) return false;
    return arg.match(x.arg);
  }
  Term ground() {return new CTermL(name, arg.ground());}
  String unparse() {return name.substring(0,name.indexOf("/"))
		      +"("+arg.unparse()+")";
  }
}

// eof
