/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * MGTPClauses.java 2.4.5 7-Nov-1997
 */

class CList {
  Clause head; CList tail;
  CList(Clause h) {head=h;}
  CList(Clause h, CList t) {head=h; tail=t;}
}

class Clauses {
  static String DOM="dom/1".intern();
  CList first; CList last;
  void add(Clause c) {
    if (first==null) {first=new CList(c); last=first;}
    else {last.tail=new CList(c); last=last.tail;}
  }
  String unparse() {
    String s=""; CList x=first;
    while (x!=null) {
      s=s+x.head.unparse()+"\n";
      x=x.tail;
    }
    return s;
  }
  void cjmPos() {
    CList x=first;
    while (x!=null) {
      Term[] c=x.head.cnsq;
      if (c.length>1) x.head.mgtp.disjBuf.enter(c);
      else if (DOM!=c[0].name) x.head.mgtp.unitBuf.enter(c);
      else x.head.mgtp.domsBuf.enter(c);
      x=x.tail;
    }
  }
  boolean cjmNeg(Term delta, Model model) {
    CList x=first;
    while (x!=null) {
      if (((NClause)x.head).cjmNeg(delta,model)) return true;
      x=x.tail;
    }
    return false;
  }
  void cjmMix(Term delta, Model model) {
    CList x=first;
    while (x!=null) {
      ((MClause)x.head).cjmMix(delta,model);
      x=x.tail;
    }
  }
}

abstract class Clause {
  static String DOM="dom/1".intern();
  int id; Term[] ante; int alen; Term[] cnsq; int clen; MGTP mgtp;
  Clause() {}
  String unparse() {return "";}
  String unparseAnte() {
    String s=""; int i;
    for (i=0; i<alen-1; i++) s=s+ante[i].unparse()+", ";
    return s+ante[i].unparse();
  }
  String unparseCnsq() {
    String s=""; int i;
    for (i=0; i<clen-1; i++) s=s+cnsq[i].unparse()+"; ";
    return s+cnsq[i].unparse();
  }
}

class PClause extends Clause {
  PClause(int i, Term[] c, MGTP m) {id=i; cnsq=c; clen=c.length; mgtp=m;}
  String unparse() {return " c"+id+": -> "+unparseCnsq()+".";}
}

class NClause extends Clause {
  Term delta; Model model;
  NClause() {}
  NClause(int i, Term[] a, MGTP m) {id=i; ante=a; alen=a.length; mgtp=m;}
  String unparse() {return " c"+id+": "+unparseAnte()+" -> .";}
  boolean cjmNeg(Term d, Model m) {
    delta=d; model=m;
    //    Counter.eunify++;
    if (ante[0].match(delta)&&cjmNeg(1)) return true;
    for (int i=1; i<alen; i++) {
      //    Counter.eunify++;
      if (ante[i].match(delta)&&cjmNeg(0,i)) return true;
    }
    return false;
  }
  boolean cjmNeg(int n, int i) {
    int n1=n+1;
    if (n==i) return cjmNeg(n1);
    else {
      Term x=ante[n]; Model m=model;
      while (m!=null) {
	//    Counter.aunify++;
	if (x.match(m.head)) {if (cjmNeg(n1,i)) return true;}
	m=m.tail;
      }
    }
    return false;
  }
  boolean cjmNeg(int n) {
    if (n>=alen) return true;
    else {
      Term x=ante[n]; Model m=model; int n1=n+1;
      while (m!=null) {
	//    Counter.aunify++;
	if (x.match(m.head)) {if (cjmNeg(n1)) return true;}
	m=m.tail;
      }
    }
    return false;
  }
}

class ENClause extends NClause {
  ENClause(int i, Term[] a, MGTP m) {
    id=i; ante=a; alen=a.length; mgtp=m;}
  String unparse() {return "ec"+id+": "+unparseAnte()+" -> .";}
  boolean cjmNeg(Term d, Model m) {
    delta=d; model=m;
    //    Counter.eunify++;
    return (ante[0].match(delta)&&cjmNeg(1));
  }
}

class NXClause extends NClause {
  MGTPExternal ext;
  NXClause(int i, Term[] a, MGTPExternal e, MGTP m) {
    id=i; ante=a; alen=a.length; ext=e; mgtp=m;}
  String unparse() {
    return " c"+id+": "+unparseAnte()+",{"+ext.unparse()+"} -> .";}
  boolean cjmNeg(int n) {
    if (n>=alen) return ext.eval();
    else {
      Term x=ante[n]; Model m=model; int n1=n+1;
      while (m!=null) {
	//    Counter.aunify++;
	if (x.match(m.head)) {if (cjmNeg(n1)) return true;}
	m=m.tail;
      }
    }
    return false;
  }
}

class ENXClause extends NClause {
  MGTPExternal ext;
  ENXClause(int i, Term[] a, MGTPExternal e, MGTP m) {
    id=i; ante=a; alen=a.length; ext=e; mgtp=m;}
  String unparse() {
    return "ec"+id+": "+unparseAnte()+",{"+ext.unparse()+"} -> .";}
  boolean cjmNeg(Term d, Model m) {
    delta=d; model=m;
    //    Counter.eunify++;
    return (ante[0].match(delta)&&cjmNeg(1));
  }
  boolean cjmNeg(int n) {
    if (n>=alen) return ext.eval();
    else {
      Term x=ante[n]; Model m=model; int n1=n+1;
      while (m!=null) {
	//    Counter.aunify++;
	if (x.match(m.head)) {if (cjmNeg(n1)) return true;}
	m=m.tail;
      }
    }
    return false;
  }
}

class MClause extends Clause {
  Term delta; Model model;
  MClause() {}
  MClause(int i, Term[] a, Term[] c, MGTP m) {
    id=i; ante=a; alen=a.length; cnsq=c; clen=c.length; mgtp=m;
  }
  String unparse() {
    return " c"+id+": "+unparseAnte()+" -> "+unparseCnsq()+".";
  }
  void cjmMix(Term d, Model m) {
    delta=d; model=m;
    //    Counter.eunify++;
    if (ante[0].match(delta)) {cjmMix(1);}
    for (int i=1; i<alen; i++) {
      //    Counter.eunify++;
      if (ante[i].match(delta)) cjmMix(0,i);
    }
  }
  void cjmMix(int n, int i) {
    int n1=n+1;
    if (n==i) cjmMix(n1);
    else {
      Term x=ante[n]; Model m=model;
      while (m!=null) {
	//    Counter.aunify++;
	if (x.match(m.head)) cjmMix(n1,i);
	m=m.tail;
      }
    }
  }
  void cjmMix(int n) {
    if (n>=alen) {
      Term[] g=new Term[clen];
      for (int i=0; i<clen; i++) g[i]=cnsq[i].ground();
      if (clen>1) mgtp.disjBuf.enter(g);
      else if (DOM!=g[0].name) mgtp.unitBuf.enter(g);
      else mgtp.domsBuf.enter(g);
    } else {
      Term x=ante[n]; Model m=model; int n1=n+1;
      while (m!=null) {
	//    Counter.aunify++;
	if (x.match(m.head)) cjmMix(n1);
	m=m.tail;
      }
    }
  }
}

class EMClause extends MClause {
  EMClause(int i, Term[] a, Term[] c, MGTP m) {
    id=i; ante=a; alen=a.length; cnsq=c; clen=c.length; mgtp=m;
  }
  String unparse() {
    return "ec"+id+": "+unparseAnte()+" -> "+unparseCnsq()+".";
  }
  void cjmMix(Term d, Model m) {
    delta=d; model=m;
    //    Counter.eunify++;
    if (ante[0].match(delta)) cjmMix(1);
  }
}

class MXClause extends MClause {
  MGTPExternal ext;
  MXClause(int i, Term[] a, MGTPExternal e, Term[] c, MGTP m) {
    id=i; ante=a; alen=a.length; ext=e; cnsq=c; clen=c.length; mgtp=m;
  }
  String unparse() {
    return " c"+id+": "+unparseAnte()+",{"+ext.unparse()
      +"} -> "+unparseCnsq()+".";
  }
  void cjmMix(int n) {
    if (n>=alen) {
      if (!ext.eval()) return;
      Term[] g=new Term[clen];
      for (int i=0; i<clen; i++) g[i]=cnsq[i].ground();
      if (clen>1) mgtp.disjBuf.enter(g);
      else if (DOM!=g[0].name) mgtp.unitBuf.enter(g);
      else mgtp.domsBuf.enter(g);
    } else {
      Term x=ante[n]; Model m=model; int n1=n+1;
      while (m!=null) {
	//    Counter.aunify++;
	if (x.match(m.head)) cjmMix(n1);
	m=m.tail;
      }
    }
  }
}

class EMXClause extends MClause {
  MGTPExternal ext;
  EMXClause(int i, Term[] a, MGTPExternal e, Term[] c, MGTP m) {
    id=i; ante=a; alen=a.length; ext=e; cnsq=c; clen=c.length; mgtp=m;
  }
  String unparse() {
    return "ec"+id+": "+unparseAnte()+",{"+ext.unparse()
      +"} -> "+unparseCnsq()+".";
  }
  void cjmMix(Term d, Model m) {
    delta=d; model=m;
    //    Counter.eunify++;
    if (ante[0].match(delta)) cjmMix(1);
  }
  void cjmMix(int n) {
    if (n>=alen) {
      if (!ext.eval()) return;
      Term[] g=new Term[clen];
      for (int i=0; i<clen; i++) g[i]=cnsq[i].ground();
      if (clen>1) mgtp.disjBuf.enter(g);
      else if (DOM!=g[0].name) mgtp.unitBuf.enter(g);
      else {mgtp.domsBuf.enter(g);}
    } else {
      Term x=ante[n]; Model m=model; int n1=n+1;
      while (m!=null) {
	//    Counter.aunify++;
	if (x.match(m.head)) cjmMix(n1);
	m=m.tail;
      }
    }
  }
}

// eof
