/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * MGTP.java 2.4.8p1 16-Jan-1998
 *
 */

import java.io.*;

class MGTP {
  static String version="JavaMGTP 2.4.8p1 16-Jan-1998";
  static String author="fujita@is.kyushu-u.ac.jp";

  public static void main(String args[]) {
    System.out.print(""+version+" by "+author+"\n");
    MGTP mgtp=new MGTP();
    mgtp.doMGTP(args);
  }

  Clauses posCls=new Clauses();
  Clauses negCls=new Clauses();
  Clauses mixCls=new Clauses();
  CnsqBuf unitBuf=new CnsqBuf();
  CnsqBuf disjBuf=new CnsqBuf();
  CnsqBuf domsBuf=new CnsqBuf();
  boolean verbose=false;
  boolean allsol=false;
  boolean ans;
  long time;

  void checkOptions(String args[]) {
    for (int i=0; i<args.length; i++) {
      if ("verbose".startsWith(args[i])) verbose=false;
      if ("allsolution".startsWith(args[i])) allsol=true;
    }
  }

  void doMGTP(String args[]) {
    checkOptions(args);
    time=System.currentTimeMillis();
    if (!MGTPParser.readFrom(this,args)) {
      System.out.print("bye!\n");
      return;
    }
    time=System.currentTimeMillis()-time;
    System.out.print("Problem loading time: "+time+" msec\n");

    if (verbose) {
      System.out.print("\n"
		       +"Positive clauses:\n"+posCls.unparse()
		       +"Negative clauses:\n"+negCls.unparse()
		       +"Mixed clauses:\n"+mixCls.unparse());
    }

    System.out.print("\nProving...\n");
    System.gc();

    time=System.currentTimeMillis();
    posCls.cjmPos();
    prove();
    time=System.currentTimeMillis()-time;

    String Ans;
    if (ans) {Ans="UNSAT";} else {Ans="SAT";}

    System.out.print("\n"
		     +"Number of models: "+models+"\n"
		     +"Number of failed branches: "+failedBranches+"\n"
		     +"Number of total branches: "+branches+"\n"
		     +"Number of total nodes: "+nodes+"\n"
		     +"\nThe answer is "+Ans+"\n"
		     +"Proving time: "+time+" msec\n");

 //   System.out.print(pt_top.son.unparse(0));
  }
  
  GStack gstack; Model model=null; Term[] cnsq;
  Term delta; int idx;
  int atomID=0; int nodes=0;
  int branches=0; int models=0; int failedBranches=0;
  GT pt=new GT(new UATerm("root"));
  GT pt_top=pt;

  void prove() {
    boolean fcheck; boolean skip;
    do {
      skip=false;
      if (unitBuf.first==null &&
	  disjBuf.first==null &&
	  domsBuf.first==null) { /* A model is found! */
	if (verbose) {
	  System.out.print("A model found: "+model.unparse()+".\n");
	}
	branches++; models++;
	ans=false; /* SAT */
	if (!allsol || gstack==null) return;

	/* If all-solution mode then continue. */
	pt=gstack.pt;
	model=gstack.model;
	cnsq=gstack.cnsq;
	idx=gstack.idx;
	unitBuf.first=gstack.unitF;
	unitBuf.last =gstack.unitL;
	if (unitBuf.last!=null) {unitBuf.last.tail=null;}
	disjBuf.first=gstack.disjF;
	disjBuf.last =gstack.disjL;
	if (disjBuf.last!=null) {disjBuf.last.tail=null;}
	domsBuf.first=gstack.domsF;
	domsBuf.last =gstack.domsL;
	if (domsBuf.last!=null) {domsBuf.last.tail=null;}
	delta=cnsq[idx];
	idx++;
	if (idx<cnsq.length) {gstack.idx=idx;}
	else {gstack=gstack.tail;}
	skip=true;
      }
      if (!skip) { /* pickup phase */
	if (unitBuf.first!=null) {
	  cnsq=unitBuf.first.head;
	  unitBuf.first=unitBuf.first.tail;
	} else if (disjBuf.first!=null) {
	  cnsq=disjBuf.first.head;
	  disjBuf.first=disjBuf.first.tail;
	} else {
	  cnsq=domsBuf.first.head;
	  domsBuf.first=domsBuf.first.tail;
	}
	if (model!=null&&model.subsumes(cnsq)) {continue;}
	if (cnsq.length>1) {
	  gstack=new GStack(pt, model, cnsq, 1,
			    unitBuf.first, unitBuf.last,
			    disjBuf.first, disjBuf.last,
			    domsBuf.first, domsBuf.last,
			    gstack);
	}
	delta=cnsq[0]; idx=1;
      }
      fcheck=true;
      while (fcheck) { /* Continue false-check (model rejection) */
	atomID++;
	if (verbose) {
	  System.out.print(""+atomID+": "+delta.unparse()+".\n");
	}
	nodes++;
	model=new Model(delta, model);
	fcheck=false;
	if (negCls.cjmNeg(delta, model)) {
	  if (verbose) {
	    System.out.print("A model candidate rejected: "+model.unparse()
			     +".\n");
	  }
	  branches++; failedBranches++;
/*
if (pt.atom==null) 
System.out.println("top->"+delta.unparse());
else
System.out.println(pt.atom.unparse()+"->"+delta.unparse());
*/
	  if (cnsq.length==1) {
	    pt.son=new GT(delta);
	  } else if (idx==1) {
	    pt.son=new GT(delta);
	    gstack.pt=pt.son;
	  } else if (idx==cnsq.length) {
	    pt.next=new GT(delta);
	  } else {
	    pt.next=new GT(delta);
	    gstack.pt=pt.next;
	  }
	  if (gstack==null) {
	    ans=true; /* UNSAT */
	    return;
	  }
	  /* Continue next branch. */
	  pt=gstack.pt;
	  model=gstack.model;
	  cnsq=gstack.cnsq;
	  idx=gstack.idx;
	  unitBuf.first=gstack.unitF;
	  unitBuf.last =gstack.unitL;
	  if (unitBuf.last!=null) {unitBuf.last.tail=null;}
	  disjBuf.first=gstack.disjF;
	  disjBuf.last =gstack.disjL;
	  if (disjBuf.last!=null) {disjBuf.last.tail=null;}
	  domsBuf.first=gstack.domsF;
	  domsBuf.last =gstack.domsL;
	  if (domsBuf.last!=null) {domsBuf.last.tail=null;}
	  delta=cnsq[idx];
	  idx++;
	  if (idx<cnsq.length) {gstack.idx=idx;}
	  else {gstack=gstack.tail;}
	  fcheck=true;
	}
      }
/*
if (pt.atom==null) 
System.out.println("top->"+delta.unparse());
else
System.out.println(pt.atom.unparse()+"->"+delta.unparse());
*/
      if (cnsq.length==1) {
	pt.son=new GT(delta);
	pt=pt.son;
      } else if (idx==1) {
	pt.son=new GT(delta);
	pt=pt.son;
	gstack.pt=pt;
      } else if (idx==cnsq.length) {
	pt.next=new GT(delta);
	pt=pt.next;
      } else {
	pt.next=new GT(delta);
	pt=pt.next;
	gstack.pt=pt;
      }
      mixCls.cjmMix(delta,model);
    } while (true);
  }
}

class GStack {
  GT pt; Model model; Term[] cnsq; int idx;
  TList unitF; TList unitL; TList disjF; TList disjL;
  TList domsF; TList domsL;
  GStack tail;
  GStack(GT p, Model m, Term[] c, int x,
	 TList uf, TList ul, TList sf, TList sl, TList of, TList ol,
	 GStack s) {
    pt=p; model=m; cnsq=c; idx=x;
    unitF=uf; unitL=ul; disjF=sf; disjL=sl; domsF=of; domsL=ol;
    tail=s;}
}

class TList {
  Term[] head; TList tail;
  TList(Term[] h) {head=h;}
}

class CnsqBuf {
  TList first; TList last;
  CnsqBuf() {}
  void enter(Term[] c) {
    if (first==null) {first=new TList(c); last=first;}
    else {last.tail=new TList(c); last=last.tail;}
  }
  Term[] pickup() {
    Term[] delta; delta=(Term[])first.head; first=first.tail;
    return delta;
  }
}

class Model {
  Term head; Model tail;
  Model(Term delta, Model model) {head=delta; tail=model;}
  boolean subsumes(Term[] c) {
    Term t; Model m;
    for (int i=0; i<c.length; i++) {
      t=c[i]; m=this;
      while (m!=null) {
	if (t.match(m.head)) return true;
	m=m.tail;
      }
    }
    return false;
  }
  String unparse() {
    if (this==null) return "[]";
    String s="[ "; Model m=this;
    while (m.tail!=null) {
      s=s+m.head.unparse()+", ";
      m=m.tail;
    }
    return s+m.head.unparse()+" ]";
  }
}

// eof
