/* Generated By:JavaCC: Do not edit this line. MGTPParser.java */
import java.util.*;

public class MGTPParser implements MGTPParserConstants {
  static String version="2.4.7";
  static String TRUE="true".intern();
  static String FALSE="false".intern();
  static String DOM="dom/1".intern();
  MGTP mgtp;
  MGTPDict uatdict=new MGTPDict();
  MGTPDict vardict=new MGTPDict();
  boolean shared;
  MGTPExternal ext;
  int clsId=1;

  static public boolean readFrom(MGTP m, String args[]) {
    MGTPParser parser;

    if (args.length==0) {
      System.out.println("MGTP Parser Version "+version+": "
                          +"Reading from standard input...");
      parser=new MGTPParser(System.in);
      parser.mgtp=m;
    } else if (args.length>=1) {
      System.out.println("MGTP Parser Version "+version+": "
                          +"Reading from file "+args[0]+"...");
      try {
         parser=new MGTPParser(new java.io.FileInputStream(args[0]));
         parser.mgtp=m;
      } catch (java.io.FileNotFoundException e) {
         System.out.println("MGTP Parser Version "+version+": "
                            +" File "+args[0]+" not found.");
         return false;
      }
    } else {
      System.out.println("MGTP Parser Version "+version+": "
                          +": Usage is one of:");
      System.out.println("         java MGTPParser < inputfile");
      System.out.println("OR");
      System.out.println("         java MGTPParser inputfile");
      return false;
    }
    try {
      parser.CompilationUnit();
      System.out.println("MGTP Parser Version "+version+": "
                          +"MGTP input clauses parsed successfully.");
      return true;
    } catch (ParseError e) {
      System.out.println("MGTP Parser Version "+version+": "
                          +" Encountered errors during parse.");
      return false;
    }
  }

  Term mkCTerm(String n, Vector v, int ln) {
    Term next; int i=v.size()-1;
    next=mkLast((Term)v.elementAt(i),ln);
    for (i=i-1; i>=0; i--) {
      ((Term)v.elementAt(i)).next=next;
      next=(Term)v.elementAt(i);
    }
    return new CTerm(n,next,null);
  }

  Term mkLast(Term t, int ln) {
    if (t instanceof ATerm) {return new ATermL(t.name);}
    else if (t instanceof ITerm) {return new ITermL(((ITerm)t).val);}
    else if (t instanceof AVar) {return new AVarL(t.name);}
    else if (t instanceof FVar) {
      Term v=new FVarL(t.name);
      vardict.put(t.name,new Vpair(ln,v)); return v;
    }
    else if (t instanceof BVar) {return new BVarL(t.name, t.arg);}
    else if (t instanceof CTerm) {return new CTermL(t.name, t.arg);}
    else {return t;}
  }

  Term mkLiteral(Term t, int ln) {
    if (t instanceof ATerm) {return uatdict.uniUATerm(t.name);}
    else if (t instanceof ITerm) {return new ITermL(((ITerm)t).val);}
    else if (t instanceof AVar) {return new AVarL(t.name);}
    else if (t instanceof FVar) {
      Term v=new FVarL(t.name);
      vardict.put(t.name,new Vpair(ln,v)); return v;
    }
    else if (t instanceof BVar) {return new BVarL(t.name, t.arg);}
    else if (t instanceof CTerm) {return new CTermL(t.name, t.arg);}
    else {return t;}
  }

  Term remakeFBVar(Term t, MGTPDict dic) {
    if (t instanceof UATerm||
         t instanceof ATermL||
         t instanceof ITermL||
         t instanceof AVarL) {
      return t;
    } else if (t instanceof ATerm) {
      return new ATerm(t.name, remakeFBVar(t.next,dic));
    } else if (t instanceof ITerm) {
      return new ITerm(((ITerm)t).val, remakeFBVar(t.next,dic));
    } else if (t instanceof AVar) {
      return new AVar(t.name, remakeFBVar(t.next,dic));
    } else if (t instanceof FVarL) {
      return dic.euniVarL(t.name);
    } else if (t instanceof FVar) {
      Term v=dic.euniVar(t.name);
      v.next=remakeFBVar(t.next, dic); return v;
    } else if (t instanceof BVarL) {
      return dic.euniVarL(t.name);
    } else if (t instanceof BVar) {
      Term v=dic.euniVar(t.name);
      v.next=remakeFBVar(t.next, dic); return v;
    } else if (t instanceof CTermL) {
      return new CTermL(t.name,remakeFBVar(t.arg,dic));
    } else if (t instanceof CTerm) {
      return new CTerm(t.name,remakeFBVar(t.arg,dic),
                        remakeFBVar(t.next,dic));
    } else return t;
  }

  void remakeIOVar(MGTPExternal ex, MGTPDict dic) {
    for (int i=0; i<ex.iVars.length; i++) {
      ex.iVars[i]=(Term)dic.get(ex.iVars[i].name.intern());
    }
    for (int i=0; i<ex.oVars.length; i++) {
      dic.put(ex.oVars[i].name.intern(), ex.oVars[i]);
    }
  }

  void mkEClauses(Vector ant, Vector cns) {
    MGTPExternal ex=ext;
    mkEClause(ant, ex, cns);
    for (int i=1; i<ant.size(); i++) {
      Vector eant=(Vector)ant.clone();
      Term ent=(Term)eant.elementAt(i);
      eant.removeElementAt(i);
      eant.insertElementAt(ent,0);
      MGTPDict evdict=new MGTPDict();
      for (int j=0; j<eant.size(); j++) {
         eant.setElementAt(remakeFBVar((Term)eant.elementAt(j),evdict),j);
      }
      if (ext!=null) {
         //	ex=ext.copy();
         try {
           ex=(MGTPExternal)ext.getClass().newInstance();
           ex.iVars=(Term[])ext.iVars.clone();
           ex.oVars=(Term[])ext.oVars.clone();
         } catch (InstantiationException e) {
         } catch (IllegalAccessException e) {
         }
         remakeIOVar(ex,evdict);
      }
      Vector ecns=(Vector)cns.clone();
/*
      for (int j=0; j<ecns.size(); j++) {
	ecns.setElementAt(remakeFBVar((Term)ecns.elementAt(j),evdict),j);
      }
*/
      Vector cv;
      for (int j=0; j<ecns.size(); j++) {
         ecns.setElementAt(((Vector)ecns.elementAt(j)).clone(),j);
         cv=(Vector)ecns.elementAt(j);
         for (int k=0; k<cv.size(); k++) {
          cv.setElementAt(remakeFBVar((Term)cv.elementAt(k),evdict),k);
        }
      }
      mkEClause(eant, ex, ecns);
    }
  }

  void mkEClause(Vector ant, MGTPExternal ex, Vector cns) {
    Term[] aa=new Term[ant.size()]; ant.copyInto(aa);
    if (cns.size()==0) {
      if (ex!=null) {
         mgtp.negCls.add(new ENXClause(clsId,aa,ex,mgtp)); clsId++;
      } else {
         mgtp.negCls.add(new ENClause(clsId,aa,mgtp)); clsId++;
      }
    } else {
      if (ex!=null) {
         mgtp.mixCls.add(new EMXClause(clsId,aa,ex,cns,mgtp)); clsId++;
      } else {
         mgtp.mixCls.add(new EMClause(clsId,aa,cns,mgtp)); clsId++;
      }
    }
  }

  void mkClause(Vector ant, Vector cns) {
    Term[] aa=new Term[ant.size()]; ant.copyInto(aa);
    if (cns.size()==0) {
      if (ext!=null) {
         mgtp.negCls.add(new NXClause(clsId,aa,ext,mgtp)); clsId++;
      } else {
         mgtp.negCls.add(new NClause(clsId,aa,mgtp)); clsId++;
      }
    } else {
      if (ext!=null) {
         mgtp.mixCls.add(new MXClause(clsId,aa,ext,cns,mgtp)); clsId++;
      } else {
         mgtp.mixCls.add(new MClause(clsId,aa,cns,mgtp)); clsId++;
      }
    }
  }

/*****************************************
 * THE MGTP LANGUAGE GRAMMAR STARTS HERE *
 *****************************************/
  final public void CompilationUnit() throws ParseError {
    label_1:
    while (true) {
      if (jj_mask_0[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[0] = jj_gen;
        break label_1;
      }
      Clause();
    }
    jj_consume_token(0);
  }

  static boolean[] jj_mask_0 = new boolean[29];
  static {
    jj_mask_0[ANONVAR] =
    jj_mask_0[VIDENTIFIER] =
    jj_mask_0[CIDENTIFIER] =
    jj_mask_0[INTEGER] =
    jj_mask_0[LBRACE] =
    jj_mask_0[IMPLIES] =
    jj_mask_0[LONGIMPLIES] = true;
  }
  
  final public void Clause() throws ParseError {
         Vector ant=new Vector();
         Vector cns=new Vector();
         vardict.clear();
         shared=false;
         ext=null;
    if (jj_mask_1[getToken(1).kind]) {
      Antecedent(ant);
    } else {
      jj_expLA1[1] = jj_gen;
      ;
    }
    if (jj_mask_3[getToken(1).kind]) {
      jj_consume_token(IMPLIES);
    } else {
      jj_expLA1[3] = jj_gen;
      if (jj_mask_2[getToken(1).kind]) {
        jj_consume_token(LONGIMPLIES);
      } else {
        jj_expLA1[2] = jj_gen;
        jj_consume_token(-1);
        throw new ParseError();
      }
    }
    if (jj_mask_4[getToken(1).kind]) {
      Consequent(cns);
    } else {
      jj_expLA1[4] = jj_gen;
      ;
    }
    jj_consume_token(DOT);
         if (ant.size()==0) {
             if (cns.size()==0) {
                 System.out.print("Empty clause found.\nUNSAT!\n");
             } else {
                 mgtp.posCls.add(new PClause(clsId,cns,mgtp));
                 clsId++;
             }
         } else {
             if (shared) {mkEClauses(ant,cns);}
             else {mkClause(ant,cns);}
         }
  }

  static boolean[] jj_mask_1 = new boolean[29];
  static {
    jj_mask_1[ANONVAR] =
    jj_mask_1[VIDENTIFIER] =
    jj_mask_1[CIDENTIFIER] =
    jj_mask_1[INTEGER] =
    jj_mask_1[LBRACE] = true;
  }
  static boolean[] jj_mask_2 = new boolean[29];
  static {
    jj_mask_2[LONGIMPLIES] = true;
  }
  static boolean[] jj_mask_3 = new boolean[29];
  static {
    jj_mask_3[IMPLIES] = true;
  }
  static boolean[] jj_mask_4 = new boolean[29];
  static {
    jj_mask_4[ANONVAR] =
    jj_mask_4[VIDENTIFIER] =
    jj_mask_4[CIDENTIFIER] =
    jj_mask_4[INTEGER] =
    jj_mask_4[LBRACE] = true;
  }
  
  final public void Antecedent(Vector ant) throws ParseError {
         Term lit; int ln=0;
    lit = Literal(ln);
         if (lit!=null&&lit.name!=TRUE) {ant.addElement(lit);}
    label_2:
    while (true) {
      if (jj_mask_5[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[5] = jj_gen;
        break label_2;
      }
      jj_consume_token(COMMA);
         ln++;
      lit = Literal(ln);
         if (lit!=null&&lit.name!=TRUE) {ant.addElement(lit);}
    }
  }

  static boolean[] jj_mask_5 = new boolean[29];
  static {
    jj_mask_5[COMMA] = true;
  }
  
  final public void Consequent(Vector cns) throws ParseError {
         Vector cnj=new Vector();
    Conjunction(cnj);
         if (!cnj.isEmpty()) cns.addElement(cnj);
    label_3:
    while (true) {
      if (jj_mask_6[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[6] = jj_gen;
        break label_3;
      }
      jj_consume_token(SEMICOLON);
         cnj=new Vector();
      Conjunction(cnj);
         if (!cnj.isEmpty()) cns.addElement(cnj);
    }
  }

  static boolean[] jj_mask_6 = new boolean[29];
  static {
    jj_mask_6[SEMICOLON] = true;
  }
  
  final public void Conjunction(Vector cnj) throws ParseError {
         Term lit;
    lit = Literal(-1);
         if (lit!=null&&lit.name!=FALSE) {cnj.addElement(lit);}
    label_4:
    while (true) {
      if (jj_mask_7[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[7] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      lit = Literal(-1);
         if (lit!=null&&lit.name!=FALSE) {cnj.addElement(lit);}
    }
  }

  static boolean[] jj_mask_7 = new boolean[29];
  static {
    jj_mask_7[COMMA] = true;
  }
  
  final public Term Literal(int ln) throws ParseError {
         Term t;
    if (jj_mask_9[getToken(1).kind]) {
      t = Term(ln);
         return mkLiteral(t,ln);
    } else {
      jj_expLA1[9] = jj_gen;
      if (jj_mask_8[getToken(1).kind]) {
        jj_consume_token(LBRACE);
        ext = ETerm();
        jj_consume_token(RBRACE);
         return null;
      } else {
        jj_expLA1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseError();
      }
    }
  }

  static boolean[] jj_mask_8 = new boolean[29];
  static {
    jj_mask_8[LBRACE] = true;
  }
  static boolean[] jj_mask_9 = new boolean[29];
  static {
    jj_mask_9[ANONVAR] =
    jj_mask_9[VIDENTIFIER] =
    jj_mask_9[CIDENTIFIER] =
    jj_mask_9[INTEGER] = true;
  }
  
  final public Term Term(int ln) throws ParseError {
         Token x; Vector tl=new Vector();
    if (jj_mask_14[getToken(1).kind]) {
      x = jj_consume_token(CIDENTIFIER);
      if (jj_mask_13[getToken(1).kind]) {
        jj_consume_token(LPAREN);
        TermList(tl,ln);
        jj_consume_token(RPAREN);
      } else {
        jj_expLA1[13] = jj_gen;
        ;
      }
         int a=tl.size();
         if (a==0) {return new ATerm(x.image.intern());}
         return mkCTerm((x.image+"/"+a).intern(), tl, ln);
    } else {
      jj_expLA1[14] = jj_gen;
      if (jj_mask_12[getToken(1).kind]) {
        x = jj_consume_token(ANONVAR);
         return new AVar(x.image, null);
      } else {
        jj_expLA1[12] = jj_gen;
        if (jj_mask_11[getToken(1).kind]) {
          x = jj_consume_token(VIDENTIFIER);
         return vardict.uniVar(x.image,ln,this);
        } else {
          jj_expLA1[11] = jj_gen;
          if (jj_mask_10[getToken(1).kind]) {
            x = jj_consume_token(INTEGER);
         return new ITerm(Integer.parseInt(x.image));
          } else {
            jj_expLA1[10] = jj_gen;
            jj_consume_token(-1);
            throw new ParseError();
          }
        }
      }
    }
  }

  static boolean[] jj_mask_10 = new boolean[29];
  static {
    jj_mask_10[INTEGER] = true;
  }
  static boolean[] jj_mask_11 = new boolean[29];
  static {
    jj_mask_11[VIDENTIFIER] = true;
  }
  static boolean[] jj_mask_12 = new boolean[29];
  static {
    jj_mask_12[ANONVAR] = true;
  }
  static boolean[] jj_mask_13 = new boolean[29];
  static {
    jj_mask_13[LPAREN] = true;
  }
  static boolean[] jj_mask_14 = new boolean[29];
  static {
    jj_mask_14[CIDENTIFIER] = true;
  }
  
  final public void TermList(Vector tl, int ln) throws ParseError {
         Term t;
    t = Term(ln);
         tl.addElement(t);
    label_5:
    while (true) {
      if (jj_mask_15[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[15] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      t = Term(ln);
         tl.addElement(t);
    }
  }

  static boolean[] jj_mask_15 = new boolean[29];
  static {
    jj_mask_15[COMMA] = true;
  }
  
  final public MGTPExternal ETerm() throws ParseError {
         Token x; Vector iv=new Vector(); Vector ov=new Vector();
    x = jj_consume_token(CIDENTIFIER);
    jj_consume_token(LPAREN);
    jj_consume_token(LBRA);
    if (jj_mask_16[getToken(1).kind]) {
      IVars(iv);
    } else {
      jj_expLA1[16] = jj_gen;
      ;
    }
    jj_consume_token(RKET);
    jj_consume_token(COMMA);
    jj_consume_token(LBRA);
    if (jj_mask_17[getToken(1).kind]) {
      OVars(ov);
    } else {
      jj_expLA1[17] = jj_gen;
      ;
    }
    jj_consume_token(RKET);
    jj_consume_token(RPAREN);
         Term[] iva=new Term[iv.size()]; iv.copyInto(iva);
         Term[] ova=new Term[ov.size()]; ov.copyInto(ova);
         MGTPExternal ext=null;
         try {
             ext=(MGTPExternal)Class.forName(x.image).newInstance();
         } catch (ClassNotFoundException e) {
         } catch (InstantiationException e) {
         } catch (IllegalAccessException e) {
         }
         ext.iVars=iva; ext.oVars=ova;
         return ext;
  }

  static boolean[] jj_mask_16 = new boolean[29];
  static {
    jj_mask_16[VIDENTIFIER] = true;
  }
  static boolean[] jj_mask_17 = new boolean[29];
  static {
    jj_mask_17[VIDENTIFIER] = true;
  }
  
  final public void IVars(Vector v) throws ParseError {
         Token x;
    x = jj_consume_token(VIDENTIFIER);
         v.addElement(vardict.uniVar(x.image,-1,this).arg);
    label_6:
    while (true) {
      if (jj_mask_18[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[18] = jj_gen;
        break label_6;
      }
      jj_consume_token(COMMA);
      x = jj_consume_token(VIDENTIFIER);
         v.addElement(vardict.uniVar(x.image,-1,this).arg);
    }
  }

  static boolean[] jj_mask_18 = new boolean[29];
  static {
    jj_mask_18[COMMA] = true;
  }
  
  final public void OVars(Vector v) throws ParseError {
         Token x;
    x = jj_consume_token(VIDENTIFIER);
         v.addElement(vardict.uniVar(x.image,-1,this));
    label_7:
    while (true) {
      if (jj_mask_19[getToken(1).kind]) {
        ;
      } else {
        jj_expLA1[19] = jj_gen;
        break label_7;
      }
      jj_consume_token(COMMA);
      x = jj_consume_token(VIDENTIFIER);
         v.addElement(vardict.uniVar(x.image,-1,this));
    }
  }

  static boolean[] jj_mask_19 = new boolean[29];
  static {
    jj_mask_19[COMMA] = true;
  }
  
  public MGTPParserTokenManager token_source;
  public Token token;
  private MGTPParser jj_me;
  private int jj_gen;
  private int[] jj_expLA1 = new int[20];

  public MGTPParser(java.io.InputStream stream) {
    ASCII_UCodeESC_CharStream input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
    token_source = new MGTPParserTokenManager(input_stream);
    token = new Token();
    jj_me = this;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_expLA1[i] = -1;
  }

  public void ReInit(java.io.InputStream stream) {
    ASCII_UCodeESC_CharStream input_stream = new ASCII_UCodeESC_CharStream(stream, 1, 1);
    token_source.ReInit(input_stream);
    token = new Token();
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_expLA1[i] = -1;
  }

  public MGTPParser(MGTPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_me = this;
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_expLA1[i] = -1;
  }

  public void ReInit(MGTPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_gen = 0;
    for (int i = 0; i < 20; i++) jj_expLA1[i] = -1;
  }

  final private Token jj_consume_token(int kind) throws ParseError {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    jj_token_error_setup(token, kind);
    throw new ParseError();
  }

  final public Token getNextToken() throws ParseError {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) throws ParseError {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static final String jj_add_escapes(String str) {
    String retval = "";
    char ch;
    for (int i = 0; i < str.length(); i++) {
      ch = str.charAt(i);
      if (ch == '\b') {
        retval += "\\b";
      } else if (ch == '\t') {
        retval += "\\t";
      } else if (ch == '\n') {
        retval += "\\n";
      } else if (ch == '\f') {
        retval += "\\f";
      } else if (ch == '\r') {
        retval += "\\r";
      } else if (ch == '\"') {
        retval += "\\\"";
      } else if (ch == '\'') {
        retval += "\\\'";
      } else if (ch == '\\') {
        retval += "\\\\";
      } else if (ch < 0x20 || ch > 0x7e) {
        String s = "0000" + Integer.toString(ch, 16);
        retval += "\\u" + s.substring(s.length() - 4, s.length());
      } else {
        retval += ch;
      }
    }
    return retval;
  }

  protected int error_line;
  protected int error_column;
  protected String error_string;
  protected String[] expected_tokens;

  protected void token_error() {
    System.out.println("");
    System.out.println("Parse error at line " + error_line + ", column " + error_column + ".  Encountered:");
    System.out.println("    \"" + jj_add_escapes(error_string) + "\"");
    System.out.println("");
    if (expected_tokens.length == 1) {
      System.out.println("Was expecting:");
    } else {
      System.out.println("Was expecting one of:");
    }
    for (int i = 0; i < expected_tokens.length; i++) {
      System.out.println("    " + expected_tokens[i]);
    }
    System.out.println("");
  }

  private java.util.Vector jj_errortokens = new java.util.Vector();

  final private void jj_token_error_setup(Token current, int kind) throws ParseError {
    jj_errortokens.removeAllElements();
    boolean[] la1tokens = new boolean[29];
    boolean[] mask = null;
    for (int i = 0; i < 29; i++) {
      la1tokens[i] = false;
    }
    if (kind >= 0) la1tokens[kind] = true;
    for (int i = 0; i < 20; i++) {
      if (jj_expLA1[i] == jj_gen) {
        switch (i) {
          case 0: mask = jj_mask_0; break;
          case 1: mask = jj_mask_1; break;
          case 2: mask = jj_mask_2; break;
          case 3: mask = jj_mask_3; break;
          case 4: mask = jj_mask_4; break;
          case 5: mask = jj_mask_5; break;
          case 6: mask = jj_mask_6; break;
          case 7: mask = jj_mask_7; break;
          case 8: mask = jj_mask_8; break;
          case 9: mask = jj_mask_9; break;
          case 10: mask = jj_mask_10; break;
          case 11: mask = jj_mask_11; break;
          case 12: mask = jj_mask_12; break;
          case 13: mask = jj_mask_13; break;
          case 14: mask = jj_mask_14; break;
          case 15: mask = jj_mask_15; break;
          case 16: mask = jj_mask_16; break;
          case 17: mask = jj_mask_17; break;
          case 18: mask = jj_mask_18; break;
          case 19: mask = jj_mask_19; break;
        }
        for (int j = 0; j < 29; j++) {
          if (mask[j]) la1tokens[j] = true;
        }
      }
    }
    if (la1tokens[0]) {
      jj_errortokens.addElement(tokenImage[0] + " ");
    }
    for (int i = 1; i < 29; i++) {
      if (la1tokens[i]) {
        jj_errortokens.addElement(tokenImage[i] + " ...");
      }
    }
    expected_tokens = new String[jj_errortokens.size()];
    for (int i = 0; i < jj_errortokens.size(); i++) {
      expected_tokens[i] = (String)(jj_errortokens.elementAt(i));
    }
    error_line = current.beginLine;
    error_column = current.beginColumn;
    if (current.kind == 0) {
      error_string = tokenImage[0];
    } else {
      error_string = current.image;
    }
    jj_me.token_error();
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

}
