/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * MGTPExternal.java 2.4.6 10-Nov-1997
 */

abstract class MGTPExternal {
  Term[] iVars; Term[] oVars;
  MGTPExternal() {}
  boolean eval() {return false;}
  int getInt(int i) {return ((ITerm)iVars[i].arg).val;}
  String getString(int i) {return ((ATerm)iVars[i].arg).name;}
  void putInt(int i, int j) {oVars[i].arg=new ITerm(j);}
  void putString(int i, String s) {oVars[i].arg=new ATerm(s);}
  String unparse() {
    String s=getClass().getName()+"(["; int i;
    if (iVars.length>0) {
      for (i=0; i<iVars.length-1; i++) s=s+"!"+iVars[i].name+",";
      s=s+"!"+iVars[i].name;
    }
    s=s+"],[";
    if (oVars.length>0) {
      for (i=0; i<oVars.length-1; i++) s=s+"?"+oVars[i].name+",";
      s=s+"?"+oVars[i].name;
    }
    return s+"])";
  }
}

// eof
