/**
 * Copyright (C) 1998 Hasegawa Ryuzo Laboratory,
 *           Graduate School of Information Science and Electrical Engineering,
 *           Kyushu University
 */

/**
 * MGTP.java 2.4.7a 2-Apr-1998
 */

import java.io.*;
import java.util.Vector;

class MGTP {
  static String version="JavaMGTP 2.4.7a 2-Apr-1998";
  static String author="fujita@is.kyushu-u.ac.jp";

  public static void main(String args[]) {
    System.out.print(""+version+" by "+author+"\n");
    MGTP mgtp=new MGTP();
    mgtp.doMGTP(args);
  }

  Clauses posCls=new Clauses();
  Clauses negCls=new Clauses();
  Clauses mixCls=new Clauses();
  UnitBuf unitBuf=new UnitBuf();
  CnsqBuf disjBuf=new CnsqBuf();
  UnitBuf domsBuf=new UnitBuf();
  boolean verbose=false;
  boolean allSol=false;
  boolean sat;
  long time;

  void checkOptions(String args[]) {
    for (int i=0; i<args.length; i++) {
      if ("verbose".startsWith(args[i])) verbose=true;
      if ("all".startsWith(args[i])) allSol=true;
    }
  }

  void doMGTP(String args[]) {
    checkOptions(args);
    time=System.currentTimeMillis();
    if (!MGTPParser.readFrom(this,args)) {
      System.out.print("bye!\n");
      return;
    }
    time=System.currentTimeMillis()-time;
    System.out.print("Problem loading time: "+time+" msec\n");

    if (verbose) {
      System.out.print("\n"
		       +"Positive clauses:\n"+posCls.unparse()
		       +"Negative clauses:\n"+negCls.unparse()
		       +"Mixed clauses:\n"+mixCls.unparse());
    }

    System.out.print("\nProving...\n");
    System.gc();

    time=System.currentTimeMillis();
    posCls.cjmPos();
    sat=false;
    prove();
    time=System.currentTimeMillis()-time;

    String Ans;
    if (sat) {Ans="SAT";} else {Ans="UNSAT";}
/*
  long rtime=time-Counter.atime-Counter.etime-Counter.ctime
  -Counter.gtime-Counter.ptime;
 */
    System.out.print("\n"
		     +"Number of models: "+models+"\n"
		     +"Number of failed branches: "+failedBranches+"\n"
		     +"Number of total branches: "+branches+"\n"
		     +"Number of total nodes: "+nodes+"\n"
		     +"\nThe answer is "+Ans+"\n"
/*
  + "eunify count: "+Counter.eunify+".\n"
  + "aunify count: "+Counter.aunify+".\n"
  + "cunify count: "+Counter.cunify+".\n"
  + "ground count: "+Counter.ground+".\n"
  + "enterb count: "+Counter.enterb+".\n"
  + "pickup count: "+Counter.pickup+".\n"
 */
		     +"Proving time: "+time+" msec\n");
  }
  
  GStack gstack; Model model=null; Vector cnsq; int idx; Term delta;
  int atomID=0;
  int branches=0; int models=0; int failedBranches=0; int nodes=0;

  void prove() {
    boolean fcheck; boolean closed; boolean skip;
    main_loop: do {
      skip=false;
      if (unitBuf.first==null&& disjBuf.first==null && domsBuf.first==null) {
	if (verbose) {
	  System.out.print("A model found: "+model.unparse()+".\n");
	}
	branches++; models++; sat=true;

	if (!allSol||gstack==null) return; /* SAT */

	  model=gstack.model;
	  cnsq=gstack.cnsq;
	  idx=gstack.idx;
	  unitBuf.first=gstack.unitF;
	  unitBuf.last =gstack.unitL;
	  if (unitBuf.last!=null) {unitBuf.last.tail=null;}
	  disjBuf.first=gstack.disjF;
	  disjBuf.last =gstack.disjL;
	  if (disjBuf.last!=null) {disjBuf.last.tail=null;}
	  domsBuf.first=gstack.domsF;
	  domsBuf.last =gstack.domsL;
	  if (domsBuf.last!=null) {domsBuf.last.tail=null;}
	  Vector nextCV=(Vector)cnsq.elementAt(idx);
	  delta=(Term)nextCV.elementAt(0);
	  for (int i=1; i<nextCV.size(); i++) {
	    unitBuf.enter((Term)nextCV.elementAt(i));
	  }
	  idx++;
	  if (idx<cnsq.size()) {gstack.idx=idx;}
	  else {gstack=gstack.tail;}

	  skip=true;
      }

      closed=false;
      if (!skip) {
	delta=null;
	if (unitBuf.first!=null) {
	  delta=unitBuf.first.head;
	  unitBuf.first=unitBuf.first.tail;
	  if (model!=null&&model.subsumesUnit(delta)) continue main_loop;
	} else if (disjBuf.first!=null) {
	  cnsq=disjBuf.first.head;
	  disjBuf.first=disjBuf.first.tail;
	  if (model!=null&&model.subsumes(cnsq)) continue main_loop;
	  gstack=new GStack(model, cnsq, 1,
			    unitBuf.first, unitBuf.last,
			    disjBuf.first, disjBuf.last,
			    domsBuf.first, domsBuf.last,
			    gstack);
	  Vector cv=(Vector)cnsq.elementAt(0);
	  delta=(Term)cv.elementAt(0);
	  for (int i=1; i<cv.size(); i++) {
	    unitBuf.enter((Term)cv.elementAt(i));
	  }
	} else {
	  delta=domsBuf.first.head;
	  domsBuf.first=domsBuf.first.tail;
	}
      }

      fcheck=true;
      while (fcheck) {
	atomID++;
	if (verbose) {
	  System.out.print(""+atomID+": "+delta.unparse()+".\n");
	}
	nodes++;
	model=new Model(delta, model);
	fcheck=false;
	if (negCls.cjmNeg(delta, model)) {
	  if (verbose) {
	    System.out.print("A model candidate rejected: "+model.unparse()
			     +".\n");
	  }
	  branches++; failedBranches++;
	  if (gstack==null) return; /* UNSAT */
	  model=gstack.model;
	  cnsq=gstack.cnsq;
	  idx=gstack.idx;
	  unitBuf.first=gstack.unitF;
	  unitBuf.last =gstack.unitL;
	  if (unitBuf.last!=null) {unitBuf.last.tail=null;}
	  disjBuf.first=gstack.disjF;
	  disjBuf.last =gstack.disjL;
	  if (disjBuf.last!=null) {disjBuf.last.tail=null;}
	  domsBuf.first=gstack.domsF;
	  domsBuf.last =gstack.domsL;
	  if (domsBuf.last!=null) {domsBuf.last.tail=null;}
	  Vector nextCV=(Vector)cnsq.elementAt(idx);
	  delta=(Term)nextCV.elementAt(0);
	  for (int i=1; i<nextCV.size(); i++) {
	    unitBuf.enter((Term)nextCV.elementAt(i));
	  }
	  idx++;
	  if (idx<cnsq.size()) {gstack.idx=idx;}
	  else {gstack=gstack.tail;}
	  fcheck=true;
	}
      }
      mixCls.cjmMix(delta,model);
    } while (true);
  }

  void enter(Vector cnsq) {
    if (cnsq.size()>1) disjBuf.enter(cnsq);
    else enterConj((Vector)cnsq.elementAt(0));
  }
  static String DOM="dom/1".intern();
  void enterConj(Vector conj) {
    for (int i=0; i<conj.size(); i++) {
      Term c=(Term)conj.elementAt(i);
      if (DOM!=c.name) unitBuf.enter(c);
      else domsBuf.enter(c);
    }
  }
}

class GStack {
  Model model; Vector cnsq; int idx;
  UList unitF; UList unitL; VList disjF; VList disjL;
  UList domsF; UList domsL;
  GStack tail;
  GStack(Model m, Vector c, int x,
	 UList uf, UList ul, VList sf, VList sl, UList of, UList ol,
	 GStack s) {
    model=m; cnsq=c; idx=x;
    unitF=uf; unitL=ul; disjF=sf; disjL=sl; domsF=of; domsL=ol;
    tail=s;}
}

class VList {
  Vector head; VList tail;
  VList(Vector h) {head=h;}
}

class CnsqBuf {
  VList first; VList last;
  CnsqBuf() {}
  void enter(Vector c) {
    if (first==null) {first=new VList(c); last=first;}
    else {last.tail=new VList(c); last=last.tail;}
  }
  Vector pickup() {
    Vector delta; delta=first.head; first=first.tail;
    return delta;
  }
}

class UList {
  Term head; UList tail;
  UList(Term h) {head=h;}
}

class UnitBuf {
  UList first; UList last;
  UnitBuf() {}
  void enter(Term c) {
    if (first==null) {first=new UList(c); last=first;}
    else {last.tail=new UList(c); last=last.tail;}
  }
  Term pickup() {
    Term delta; delta=first.head; first=first.tail;
    return delta;
  }
}

class Model {
  Term head; Model tail;
  Model(Term delta, Model model) {head=delta; tail=model;}
  boolean subsumesUnit(Term x) {
    Model m=this;
    while (m!=null) {
      if (x.match(m.head)) return true;
      m=m.tail;
    }
    return false;
  }
  boolean subsumes(Vector c) {
    Term t; Model m; Vector v; int j; int k;
    for (int i=0; i<c.size(); i++) {
      v=(Vector)c.elementAt(i); k=0;
      next_conj: for (j=0; j<v.size(); j++) {
	t=(Term)v.elementAt(j); m=this;
	while (m!=null) {
	  if (t.match(m.head)) continue next_conj;
	  m=m.tail;
	}
	j++; k++;
      }
      if (k==0) return true;
    }
    return false;
  }
  String unparse() {
    if (this==null) return "[]";
    String s="[ "; Model m=this;
    while (m.tail!=null) {
      s=s+m.head.unparse()+", ";
      m=m.tail;
    }
    return s+m.head.unparse()+" ]";
  }
}

// eof
