#include <stdio.h>
#include <math.h>
#define VARSIZE 10
#define VECNUM 200
#define ARRNUM 200
/* Use "%cc -lm file.c -o file" to compile the source code */
struct vector {
  int tail[VECNUM];
  int head[VECNUM];
};
struct pair {
    int first;
    int second;
    struct pair *nextp;
};
struct rebase {
    int base[VECNUM];
    float orbase[VECNUM];
    float alpha[VECNUM];
};
struct vector d[10000],sv;
struct pair *vpair,*vp;
int  A[ARRNUM][ARRNUM],C[ARRNUM],H[ARRNUM][ARRNUM],CX[ARRNUM][ARRNUM],
     B[ARRNUM],S[ARRNUM],OPS[ARRNUM],I[ARRNUM][ARRNUM],
     CC[ARRNUM][ARRNUM],AC[ARRNUM][ARRNUM],RB[ARRNUM][ARRNUM];
float RH[ARRNUM][ARRNUM];
int i,j,k,l,m,n,p,q,r,s,t,sum,row,varnum,vpsum,rex;

struct vector comp(p)/*compare the tail and head, who is more expensive*/
struct vector p;

{int i,order,sum1,sum2,num;
 order=0;
 if(rex==n){/* sort by <_c (computing final RGB) */
    sum1=0;sum2=0;
    for(i=1; i<n+1; i++){
	sum1=sum1+p.tail[i]*C[i];
	sum2=sum2+p.head[i]*C[i];
    }
    if (sum2>sum1){
	for(i=1; i<n+1; i++){
	    num=p.tail[i];
	    p.tail[i]=p.head[i];
	    p.head[i]=num;
       	}
    }
    else {
	if (sum2==sum1){ /* sort by lexicographic order */
	    order=0;
	    for(i=1; i<n+1; i++){
		if (p.tail[i]<p.head[i]){
		    order=1;
		    break;
		}
		else{
		    if(p.tail[i]>p.head[i])
			break;
		}
	    }
	    if(order)
		for(i=1; i<n+1; i++){
	              num=p.tail[i];
	              p.tail[i]=p.head[i];
	              p.head[i]=num;
       	        }
	}
    }
 }
 else{/* sort by graded reserve lex order (computing n GB) */
     sum1=0;sum2=0;
     for(i=1; i<n+1; i++){
	sum1=sum1+p.tail[i];
	sum2=sum2+p.head[i];
     }
     if (sum2>sum1){
	for(i=1; i<n+1; i++){
	    num=p.tail[i];
	    p.tail[i]=p.head[i];
	    p.head[i]=num;
       	}
     }
     else {
       if(sum1==sum2){/* sort by reverse lexicographic order */
         for(i=rex+1;i<n+1;i++){
              if(p.tail[i]>p.head[i]){
	             order=1;
	             break;
	      }
	      else{
	         if(p.tail[i]<p.head[i]){
		     order=2;
		     break;
	         }
	      }
         }
         if(order==1){
	     for(i=1; i<n+1; i++){
	        num=p.tail[i];
	        p.tail[i]=p.head[i];
	        p.head[i]=num;
	     }
         }
         if(order==0){
	    for(i=1; i<rex+1; i++){
		if (p.tail[i]>p.head[i]){
		    order=1;
		    break;
		}
		else{
		    if(p.tail[i]<p.head[i])
			break;
		}
	    }
	    if(order)
		for(i=1; i<n+1; i++){
	              num=p.tail[i];
	              p.tail[i]=p.head[i];
	              p.head[i]=num;
       	        }
	  
	 }
       }
     }
 }

    return p;

}

void Svec(p,q)/* generate S(p,q) */
struct vector p,q;
{ 
    for(i=1; i<n+1; i++){
	if (p.tail[i]>q.tail[i]){
     	    sv.tail[i]=p.head[i];
	    sv.head[i]=p.tail[i]-q.tail[i]+q.head[i];
       	}
       	else {
       	    sv.tail[i]=q.tail[i]-p.tail[i]+p.head[i];
	    sv.head[i]=q.head[i];
	}
    }
    
    sv=comp(sv);
}

struct vector Redu(r)/* reduce S(p,q) */
struct vector r;
{int i,j,t,stop,retail,rehead;

     for(j=1; j<sum+1; j++){
	    retail=1;
	    rehead=1;
	    for(i=1; i<n+1; i++){
	       if (r.tail[i]<d[j].tail[i])
		   retail=0;
	       if (r.head[i]<d[j].tail[i])
		   rehead=0;
	    }
   	    if(retail){/*r can be reduced by d[j] in tail*/
	        for(i=1; i<n+1; i++)
		   r.tail[i]=r.tail[i]-d[j].tail[i]+d[j].head[i];
                /* check whether r parallises d[j], 
                   r.tail-d[j].tail=r.head-d[j].head*/
                stop=0;
                for(i=1;i<n+1;i++)
                  if(r.tail[i]!=r.head[i]){
                     stop=1;
                     break;
                  }
                if(stop){
	          r=comp(r);
		  j=0;
                }
                else{
                  r.tail[1]=-1000;
                  j=sum+1;
                }
	    }
      	    else {
	        if(rehead){/*r can be reduced by d[j] in head*/
		   for(i=1; i<n+1; i++)
	              r.head[i]=r.head[i]-d[j].tail[i]+d[j].head[i];
                     /* check whether r is parallel: r.tail=r.head*/
                   stop=0;
                   for(i=1;i<n+1;i++)
                       if(r.tail[i]!=r.head[i]){
                          stop=1;
                          break;
                       }
                   if(stop){
	              r=comp(r);
		      j=0;
                   }
                   else{
                      r.tail[1]=-1000;
                      j=sum+1;
                   }

	        }
	    }
	}
     return r;
}	    

struct vector GMin(r,u)/* find minial Grobner basis */
struct vector r;
int u;
{int i,j,renum;
    for(j=1; j<sum+1; j++){
      if(j!=u){     
	renum=1;
	for(i=1; i<n+1; i++){
	    if (r.tail[i]<d[j].tail[i]){
		renum=0;
	    }
   	}
	if(renum){
	    r.tail[1]=-1000;
	    j=sum+1;
	}
      }
  }
  return r;
}

struct vector GRedu(r,u)/* find reduced Grobner basis */
struct vector r;
int u;
{int i,j,renum;
   
      	for(j=1; j<sum+1; j++){
           if(j!=u){
	       renum=1;
	       for(i=1; i<n+1; i++)
		 if (r.head[i]<d[j].tail[i]){
		     renum=0;
	             break;
                 }
	      if(renum){
		 for(i=1; i<n+1; i++)
	            r.head[i]=r.head[i]-d[j].tail[i]+d[j].head[i];
		 r=comp(r);
		j=1;
	      }
	   }
	}
        return r;
}	    

ECinput()/* input equations and Min function */

{int coef,sig;
 char str[VARSIZE],c,chr[VARSIZE];


 /*input equations */
    
    printf("\nInput equations :\n");
    
    row=0;varnum=0;
    sig=1;
     while(strcmp(str,".")){
	row++;
	scanf("%s",str);
	
        while(strcmp(str,"=")){
	    
	    if(!(strcmp(str,"+"))){
		scanf("%s",str);
		sig=1;
	    }
	    if(!(strcmp(str,"-"))){
		scanf("%s",str);
		sig=0;
	    }
	    if(strcmp(str,"x")){
		coef=atoi(str);
	        scanf("%s",str);
	    }
	    else{
		coef=1;
	    }
	    scanf("%s",str);
	    n=atoi(str);
	    if(n>varnum)
	       varnum=n;
	    if(sig){
		A[row][n]=coef;
	    }
	    else {
	      A[row][n]=-coef;
	    }
	    scanf("%s",str);
	}
	scanf("%s",str);
	sig=1;
	if(!(strcmp(str,"-"))){
	    scanf("%s",str);
		sig=0;
	}
	if(sig){
	    B[row]=atoi(str);
	}
	else{
	    B[row]=-atoi(str);
	}    
	scanf("%s",str);
	sig=1;
    }
/* input function Min cx */ 
    m=row;n=varnum;
    printf("\nInput function cx\n");
    sig=1;
    scanf("%s",str);
    while(strcmp(str,".")){
	  if(!(strcmp(str,"+"))){
		scanf("%s",str);
		sig=1;
	    }
	    if(!(strcmp(str,"-"))){
		scanf("%s",str);
		sig=0;
	    }
	    if(strcmp(str,"x")){
		coef=atoi(str);
	        scanf("%s",str);
	    }
	    else{
		coef=1;
	    }
	    scanf("%s",str);
	    n=atoi(str);
	    if(sig){
	      C[n]=coef;
	    }
	    else {
	      C[n]=-coef;
	    }
	    scanf("%s",str);
	}
}
void gcd(a,b)
int a,b;
{ int GCD[ARRNUM],P[ARRNUM],Q[ARRNUM];
  int i,j,d,t,gcdlab;

    for(i=0;i<2;i++){
	if(i==0){
	    GCD[i]=a;
	    P[i]=1;
	    Q[i]=0;
	}
	else{
	    GCD[i]=b;
	    P[i]=0;
	    Q[i]=1;
	}
    }
    gcdlab=1;t=1;
    while(gcdlab){
	t++;
	d=GCD[t-2]/GCD[t-1];
	GCD[t]=GCD[t-2]-d*GCD[t-1];
	P[t]=P[t-2]+d*P[t-1];
	Q[t]=Q[t-2]+d*Q[t-1];
	if(GCD[t]==0)
	    gcdlab=0;
    }
    r=GCD[t-1];
    p=P[t-1];
    q=Q[t-1];
    if((p!=0)&&(q!=0)){
	if(a*p>b*q){
	    q=-q;
	}else{
	    p=-p;
	}
	if(r<0)
	    r=-r;
    }
}
void setupC(s,t)
int s,t;
{
    for(k=1;k<n+1;k++){
	for(l=1;l<n+1;l++){
	    CX[k][l]=I[k][l];
	    if((k==s)&&(l==s))
		CX[k][l]=p;
	    if((k==t)&&(l==s))
		CX[k][l]=q;
	    if((k==s)&&(l==t))
		CX[k][l]=-H[i][t]/r;
	    if((k==t)&&(l==t))
		CX[k][l]=H[i][s]/r;
	}
   }
   
}
void updateA()
{int u;
    for(k=1;k<n+1;k++){
	for(l=1;l<n+1;l++){
	    sum=0;
	    for(u=1;u<n+1;u++)
		sum=sum+H[k][u]*CX[u][l];
	    AC[k][l]=sum;
	}
    }
    for(k=1;k<n+1;k++)
	for(l=1;l<n+1;l++)
	   H[k][l]=AC[k][l];
}
void multiC()
{int u;
    for(k=1;k<n+1;k++){
	for(l=1;l<n+1;l++){
	    sum=0;
	    for(u=1;u<n+1;u++)
		sum=sum+CC[k][u]*CX[u][l];
	    AC[k][l]=sum;
	}
    }
    for(k=1;k<n+1;k++)
	for(l=1;l<n+1;l++)
	    CC[k][l]=AC[k][l];
}
void Hnorm()
{int u,div,cycle;
 float divf,fnum,HH[ARRNUM][ARRNUM];
    for(i=1;i<m+1;i++){
	for(j=1;j<n+1;j++){
	    H[i][j]=A[i][j];
	}
    }
    /*set up identity matrix I and CC*/
    for(i=1;i<n+1;i++)
	for(j=1;j<n+1;j++)
	    if(i==j){
		I[i][j]=1;
		CC[i][j]=1;
	    }
            else{
		I[i][j]=0;
		CC[i][j]=0;
	    }
    /*compute Hermite Normal Form*/
    cycle=1;
    i=1;
    while(cycle){
     /*step 1: work on row i, set j <- i+1 */
       j=i+1;
     /*step 2: work on row i and column j>i. make all A[i][j] =0 */
       while(!(j>n)){
	   if(H[i][j]!=0){
	       gcd(H[i][i],H[i][j]);
	       /*setup matrix C*/
	       setupC(i,j);

	       /*update matrix A,set A<-AC */
	       updateA();

	       /* generate matric C by multiplying C_i */
	       multiC();
	   }
	   j++;
       }

       
     /*step 3: work on row i and column i. make all A[i][i]>0 */
       if(H[i][i]<0){
	   /*setup matrix C */
	   for(k=1;k<n+1;k++)
	      for(l=1;l<n+1;l++)
		   if(l==i){
	               CX[k][l]=-I[k][l];
		   }
	           else{
		       CX[k][l]=I[k][l];
		   }

 			 
	   /*update matrix A, set A<-AC */
	   updateA();

	   /* generate matric C by multiplying C_i */
	   multiC();
   
       }
     /*step 4: work on row i and column j<i. make all A[i][j]<=0 and
               |A[i][j]|<A[i][i] */
       for(j=1;j<i;j++){
	   /*setup matrix C */
	    for(k=1;k<n+1;k++)
		for(l=1;l<n+1;l++)
		    if(l==j){
			divf=H[i][i];
                        div=ceil(H[i][j]/divf);
			CX[k][l]=I[k][l]-div*I[k][i];
		    }
	            else{
			CX[k][l]=I[k][l];
		    }


	  /* update matrix A */
	    updateA();

	 /* generate matric C by multiplying C_i */
            multiC();
   
	}
       i++;
       if(i>m)
	   cycle=0;
   }

   /* compute the reverse matrix of H */
   for(i=1;i<m+1;i++){
       for(j=1;j<m+1;j++){
	   if(i==j){
	       RH[i][j]=1;
	   }
           else{
	       RH[i][j]=0;
	   }
	   HH[i][j]=H[i][j];
       }
   }
   for(k=1;k<m+1;k++){
       for(i=1;i<m+1;i++){
	   HH[k][i]=HH[k][i]/HH[k][k];
	   RH[k][i]=RH[k][i]/HH[k][k];
       }
       for(i=1;i<m+1;i++)
	   if(i!=k){
	       fnum=HH[i][k];
	       for(j=k;j<m+1;j++){
		   HH[i][j]=HH[i][j]-HH[k][j]*fnum;
		   RH[i][j]=RH[i][j]-RH[k][j]*fnum;
	       }
	   }
       
   }

    for(k=1;k<m+1;k++){
	for(l=1;l<n+1;l++){
	    sum=0;
	    for(u=1;u<n+1;u++)
		sum=sum+A[k][u]*CC[u][l];
	    AC[k][l]=sum;
	}
    }
    /*printf("\nH =");
    for(i=1;i<m+1;i++){
       printf("\n");
       for(j=1;j<n+1;j++)
         printf("%d ",H[i][j]);
    }
    printf("\nC =");
    for(i=1;i<n+1;i++){
       printf("\n");
       for(j=1;j<n+1;j++)
         printf("%d ",CC[i][j]);
    }*/
    
      	       
}

void Reduce(m)
int m;
{struct rebase d[ARRNUM];
 int i,j,k,l;
 float div,sum,u,sum1,cycle;
    /* let d[i].base be a basis of the lattice */
    for(i=1;i<m+1;i++)
	for(j=1;j<n+1;j++)
	    d[i].base[j]=RB[i][j];
    cycle=1;
   while(cycle){
    /* let d[i].orbase be the Gram-Schmidt orthogonalization
       of the lattice basis d[i].base */
    for(i=1;i<m+1;i++){
	if(i==1){
	    for(j=1;j<n+1;j++)
		d[i].orbase[j]=d[i].base[j];
	    
	}
	else{
	    for(j=1;j<n+1;j++){
		sum=0;
		for(k=1;k<i;k++)
		    sum=sum+d[k].orbase[j]*d[k].alpha[i];
		d[i].orbase[j]=d[i].base[j]-sum;
	    }
	}
	sum=0;
	for(l=1;l<n+1;l++)
	    sum=sum+d[i].orbase[l]*d[i].orbase[l];
	for(k=i+1;k<m+1;k++){
	    div=0;
	    for(j=1;j<n+1;j++)
		div=div+d[i].orbase[j]*d[k].base[j];
	    d[i].alpha[k]=div/sum;
	    if( d[i].alpha[k]>0.5)
		cycle=-2;

	}
    }

    /* update lattica basis by replacing bj */
    for(i=2;i<m+1;i++){
	for(j=1;j<i;j++){
	  if((d[j].alpha[i]>0.5)&&(d[j].alpha[i]<1)){
             k=1;
          }
          else{
	     k=d[j].alpha[i];
          }
          for(l=1;l<n+1;l++)
        	d[i].base[l]=d[i].base[l]-k*d[j].base[l];
	}
    }

    for(j=1;j<m;j++){
	sum=0;sum1=0;
	for(i=1;i<n+1;i++){
	    u=d[j+1].orbase[i]+d[j].alpha[j+1]*d[j].orbase[i];
	    sum=sum+u*u;
	    sum1=sum1+d[j].orbase[i]*d[j].orbase[i];
	}
	if(4*sum<3*sum1){
	    for(i=1;i<n+1;i++){
		k=d[j].base[i];
		d[j].base[i]=d[j+1].base[i];
		d[j+1].base[i]=k;
	    }
	    cycle=-1;
	    j=m+1;
        }
    }

    /*for(j=1;j<m;j++){
	sum=0;sum1=0;
	for(i=1;i<n+1;i++){
	    sum=sum+d[j+1].orbase[i]*d[j+1].orbase[i];
	    sum1=sum1+d[j].orbase[i]*d[j].orbase[i];
	}

	if(2*sum<sum1){
	    for(i=1;i<n+1;i++){
		u=d[j].base[i];
		d[j].base[i]=d[j+1].base[i];
		d[j+1].base[i]=u;
	    }
	    if(cycle==-2)
		cycle=-1;
	    j=m+1;
        }
    }*/
    
    if((cycle==-1)||(cycle==-2)){
	cycle=1;
    }
    else{
	cycle=0;
    }

  }

    for(i=1;i<m+1;i++)
	for(j=1;j<n+1;j++)
	    RB[i][j]=d[i].base[j];
	
}
int Check(r)/* truncated GB method check */
struct vector r;
{int i,j,check,sum,up,down,S[ARRNUM];
 float fsum,SS[ARRNUM];

    check=1;
    for(i=1;i<m+1;i++){
	sum=0;
	for(j=1;j<n+1;j++)
	   sum=sum+A[i][j]*r.tail[j];
	S[i]=B[i]-sum;
	if(S[i]<0)
	    check=0;
    }
    /*for(i=1;i<m+1;i++){
	fsum=0;
	for(j=1;j<m+1;j++)
	    fsum=fsum+RH[i][j]*S[j];
	SS[i]=fsum;
    }
    check=1;
    for(i=1;i<m+1;i++){
	up=ceil(SS[i]);
	down=floor(SS[i]);
	if(up!=down){
	    check=0;
	    break;
	}
    }*/
    return check;
}
     
    
void gengb(t)
int t;
{int check,stop;
    
      for(i=1;i<t+1;i++)
	  d[i]=comp(d[i]);
    /* generate pair of vectors */
    vpair=(struct pair*)malloc(sizeof(struct pair));
    vp=vpair;
    for(i=1;i<t;i++){
	for(j=i+1;j<t+1;j++){
	    vp->first=i;
	    vp->second=j;
            vp->nextp=(struct pair*)malloc(sizeof(struct pair));
            vp=vp->nextp;
            vp->nextp=NULL;
	}
    }
    /* generate S(p,q) and reduce S(p,q) */
    vpair;sum=t;
    while(vpair->nextp!=NULL){
        /* generate S(p,q)*/
	Svec(d[vpair->first],d[vpair->second]);
        vpair=vpair->nextp;
	/*check whether sv.tail==sv.head */
        stop=1;
        for(i=1;i<n+1;i++)
	  if(sv.tail[i]!=sv.head[i]){
             stop=0;
             break;
          }
        if (stop){
           sv.tail[1]=-1000;
	}
        else { /* reduce S(p,q)*/
	     sv=Redu(sv);
        }
      /* add reduced S(p,q) into Grobner basis */	
	 if(sv.tail[1]!=-1000){
	     if(rex==n){
		 check=Check(sv);
		 if(check){
		     sum=sum+1;
	             for(i=1; i<n+1; i++){
	                  d[sum].tail[i]=sv.tail[i];
	                  d[sum].head[i]=sv.head[i];
		      }
	             /* add new pair of vectors */
	             for(i=1;i<sum;i++){
		       /*check whether two vectors are prime,
                          gcd(sv.tail,d[i].tail)=1*/
                         stop=0;
	                 for(j=1;j<n+1;j++)
			   if(sv.tail[j]*d[i].tail[j]!=0){
                              stop=1;
                              break;
                           }
                         if(stop){
		           vp->first=i;
		           vp->second=sum;
                           vp->nextp=(struct pair*)malloc(sizeof(struct pair));
                           vp=vp->nextp;
                           vp->nextp=NULL;
                         }

	             }
		 }
	     }
	     else{
		 sum=sum+1;
	         for(i=1; i<n+1; i++){
	             d[sum].tail[i]=sv.tail[i];
	             d[sum].head[i]=sv.head[i];
                 }
	        /* add new pair of vectors */
	         for(i=1;i<sum;i++){
		       /*check whether two vectors are prime,
                          gcd(sv.tail,d[i].tail)=1*/
                         stop=0;
	                 for(j=1;j<n+1;j++)
			   if(sv.tail[j]*d[i].tail[j]!=0){
                              stop=1;
                              break;
                           }
                         if(stop){
         	           vp->first=i;
		           vp->second=sum;
                           vp->nextp=(struct pair*)malloc(sizeof(struct pair));
                           vp=vp->nextp;
                           vp->nextp=NULL;
                         }

	         }
	     }
         }

    }
    free(vpair);free(vp); 
    /* find the minimal Grobner basis, reduce every vector*/
    for(k=1; k<sum+1; k++){
        d[k]=GMin(d[k],k);
	if(d[k].tail[1]==-1000){
	    for(i=k; i<sum; i++)
		d[i]=d[i+1];
	    sum=sum-1;
	    k=k-1;
	}
    }

    /* find the reduced Grobner basis, reduce every vector*/
    for(k=1; k<sum+1; k++){
        d[k]=GRedu(d[k],k);
    }

     /* output Grobner basis */
    if(rex==n){
        printf("\nreduced Grobner basis :\n");
        k=1;
        while(k<sum+1){
	   printf("[(");
           for(i=1; i<n+1; i++)
	      printf("%d,",d[k].tail[i]);
	   printf(")->(");
	   for(i=1; i<n+1; i++)
	      printf("%d,",d[k].head[i]);
           printf(")]\n");
	   k++;
        }
        printf("\nRGB size=%d",sum);
    }
}
struct vector RRedu(r,u)/* reduce fundamental segments) */
struct vector r;
int u;
{int i,j,t,stop;
     /* detect whether there is a vector paralleling with it */
     for(j=1; j<sum+1; j++){
      if(j!=u){
        stop=1;
        for(i=1; i<n+1; i++){
	   if((r.tail[i]-d[j].tail[i])!=(r.head[i]-d[j].head[i])){
	       stop=0;
	       i=n+1;
	   }
	}
	if (stop){/*there is a vector paralleling with it*/
	    r.tail[1]=-1000;
	    j=sum;
	}
    }
    }
    return(r);
}


main( )
{
    /* call input function*/ 
    ECinput();
    m=row;
    n=varnum;
    /* generate lattice basis B for ker(A) useing
       Hermit normal form Algorithm */
    Hnorm();
    /* reduce the lattice basis B into B_red*/ 
    t=n-m;
    for(k=1; k<t+1; k++)
        for(i=1; i<n+1; i++)
	    RB[k][i]=CC[i][m+k];
    Reduce(t);
    /* print reduced lattice basis B_red */
    /*printf("\n ****** reduced lattice basis B_red ***** \n");
    for(i=1;i<t+1;i++){
      printf("[");
      for(j=1; j<n+1; j++){
	    printf("%d, ",RB[i][j]);
      }
      printf("]\n");
    }*/
    /* generate fundamental segments d1,...,dt */
    
    for(i=1; i<t+1; i++){
        for(j=1; j<n+1; j++){
	    if(RB[i][j]>=0){
	         d[i].tail[j]=RB[i][j];
		 d[i].head[j]=0;
	    }
            else{
		 d[i].tail[j]=0;
		 d[i].head[j]=-RB[i][j];
	     }
	}
     }
    sum=t;    
    for(rex=0;rex<n+1;rex++){
	if(rex){
	    for(i=1;i<sum+1;i++){
		if(d[i].tail[rex]>d[i].head[rex]){
		    d[i].tail[rex]=d[i].tail[rex]-d[i].head[rex];
		    d[i].head[rex]=0;
		}
		else{
		    d[i].head[rex]=d[i].head[rex]-d[i].tail[rex];
            	    d[i].tail[rex]=0;
		}
	    }
	    /*for(i=1;i<sum+1;i++){
		d[i]=RRedu(d[i],i);
		if(d[i].tail[1]==-1000){
		   for(j=i;j<sum;j++)
		       d[j]=d[j+1];
		   sum--;
		   i--;
	       }
	    }*/
		
	}
        gengb(sum);
   }
   /* divide xi for every vector 
   for(i=1;i<sum+1;i++){
       for(j=1;j<n+1;j++){
	   if((d[i].tail[j]>0)&&(d[i].head[j]>0)){
	       if(d[i].tail[j]>d[i].head[j]){
		    d[i].tail[j]=d[i].tail[j]-d[i].head[j];
		    d[i].head[j]=0;
		}
	       else{
  		    d[i].head[j]=d[i].head[j]-d[i].tail[j];
		    d[i].tail[j]=0;
		}

           }
       }
   }*/
    /* find the minimal Grobner basis, reduce every vector
    for(k=1; k<sum+1; k++){
        d[k]=GMin(d[k],k);
	if(d[k].tail[1]==-1000){
	    for(i=k; i<sum; i++)
		d[i]=d[i+1];
	    sum=sum-1;
	    k=k-1;
	}
    }
      output Grobner basis  
    printf("\nReduced Grobner basis :\n");
    k=1;
    while(k<sum+1){
	printf("[(");
        for(i=1; i<n+1; i++)
	  printf("%d,",d[k].tail[i]);
	printf(")->(");
	for(i=1; i<n+1; i++)
	  printf("%d,",d[k].head[i]);
        printf(")]\n");
	k++;
    }
    printf("\nsum=%d",sum);*/
    
     /* find optimal solution */
    printf("\nInput a feasible solution:");
    for(i=1; i<n+1; i++){
	printf("\nS[%d]=",i);
	scanf("%d",&S[i]);
    }
    for(i=1; i<n+1; i++){
	OPS[i]=S[i];
    }
    k=1;
    while(k<sum+1){
	j=1;
	for(i=1; i<n+1; i++){
	    S[i]=S[i]-d[k].tail[i]+d[k].head[i];
	    if (S[i]<0){
		j=0;
		i=n+1;
	    }
	}
       if (j){
	   for(i=1; i<n+1; i++){
	      OPS[i]=S[i];
	   }
	   k=1;
       }
       else {
	 for(i=1; i<n+1; i++)
	      S[i]=OPS[i];
         k++;
       }
    }
    /* output optimal solution */
    printf("\n the optimal solution:\n");
    for(i=1; i<n+1; i++)
	printf("x%d=%d, ",i,OPS[i]);
    printf("\n");

}

	   
	
       
            










