/* sicstus need declaration for assert/retract 
   ===========================================   */
:- dynamic hd_not_done/0.
:- dynamic store/1.
:- dynamic flatn_setting/1.
:- dynamic sharp_and_setting/1.
:- dynamic subst_or_setting/1.
:- dynamic monitor_setting/1.
:- dynamic wr_st_setting/1.
:- dynamic all_vr_k/1.


:-op(950,yfx,lk).
:-op(940,xfx,:).   /* not used */
:-op(930,xfy,->).
:-op(930,xfy,<-).
:-op(930,xfy,<->).
:-op(920,yfx,or).
:-op(910,yfx,and).
:-op(900,fy,not).
:-op(700,xfx,in).
:-op(700,xfx,=>).
:-op(700,xfx,<=).
:-op(650,xfx,to).

/*  Main Procedure.
    ==============   */

try(A) :- wr_hd,
          wr_st('Logic formulation :',A,write),
          monitor('Display all process:',A,write),
          g_gele_form(A,A_gele_form),
          monitor('"ge", "le", "not"  form',A_gele_form,wr_ind),
          g_dw_not(A_gele_form,A_norm_form), monitor('"ge" with "not" against atoms only',A_norm_form,wr_ind),
          ( (flatn_setting(on), !,
             flatn(A_norm_form,A_flat_form), monitor('"and" and "or" structures flattened',A_flat_form,wr_ind))
           ; equal(A_norm_form,A_flat_form)),
          reset_store,
          imply(A_flat_form,null,1,IP),
          write('IP formulation:'), nl,nl,
          name(Sp," "), wr_IP(IP,Sp).


/*  Prededates to convert everything to 'ge', 'le', and 'not'.
    =========================================================    */

g_gele_form(A <= B, A =< B) :- !.
g_gele_form(A => B, A >= B) :- !.
g_gele_form(A and B, R) :- !, g_gele_form(ge(2,[A,B]),R).
g_gele_form(A or B,R) :- !, g_gele_form(ge(1,[A,B]),R).
g_gele_form(A->B,  R) :- !, g_gele_form(ge(1,[not A,B]),R).
g_gele_form(B<-A,  R) :- !, g_gele_form(A->B,R).
g_gele_form(A<->B, R) :- !, g_gele_form((A->B) and (B->A),R).
g_gele_form(not A, not R) :- !, g_gele_form(A,R).
g_gele_form(at_most(M,Ls),Res) :- !, g_gele_form(le(M,Ls),Res).
g_gele_form(at_least(M,Ls),Res) :- !, g_gele_form(ge(M,Ls),Res).
g_gele_form(none(Ls),Res) :- !, g_gele_form(le(0,Ls),Res).
g_gele_form(exist(Ls),Res) :- !, g_gele_form(ge(1,Ls), Res).
g_gele_form(all(Ls),ge(Z_lsR,Z_lsR,LsR)) :- !, cg_at_t_ls(Ls,Ls1), g_gele_form_ls(Ls1,Z_lsR,LsR).
g_gele_form(gef(M,Ls),Res) :- !, cg_at_t_ls(Ls,Ls1), g_not_ls(Ls1,Ls2),
                                 g_gele_form(ge(M,Ls2),Res).
g_gele_form(lef(M,Ls),Res) :- !, cg_at_t_ls(Ls,Ls1), g_not_ls(Ls1,Ls2),
                                 g_gele_form(le(M,Ls2),Res).
g_gele_form(eqf(M,Ls),Res) :- !, cg_at_t_ls(Ls,Ls1), g_not_ls(Ls1,Ls2),
                                 g_gele_form(eq(M,Ls2),Res).
g_gele_form(ge(M,Ls),ge(M,L_LsR,LsR)) :- !, cg_at_t_ls(Ls,Ls1), g_gele_form_ls(Ls1,L_LsR,LsR).
g_gele_form(le(M,Ls),le(M,L_LsR,LsR)) :- !, cg_at_t_ls(Ls,Ls1), g_gele_form_ls(Ls1,L_LsR,LsR).
g_gele_form(eq(M,Ls),Res) :- !, cg_at_t_ls(Ls,Ls1), g_gele_form_ls(Ls1,Z_lsR,LsR),
                                ((equal(M,0), !, equal(le(0,Z_lsR,LsR),Res));
                                (equal(M,Z_lsR), !, equal(ge(M,Z_lsR,LsR),Res));
                                (equal(ge(2,2,[le(M,Z_lsR,LsR), ge(M,Z_lsR,LsR)]),Res))).
g_gele_form(A,A).

g_gele_form_ls([not not H|T],Z,Res) :- !, g_gele_form_ls([H|T],Z,Res).
g_gele_form_ls([not gp(Ix,Ls)|T],Z,Res) :- !, cg_at_t_ls(Ls,Ls1),
                                              g_not_ls(Ls1,Not_ls),
                                              g_gele_form_ls([gp(Ix,Not_ls)|T],Z,Res).
g_gele_form_ls([gp(Ix,Ls)|T], Z, [gp(Ix,LsR)|TR]) :-
       !, cg_at_t_ls(Ls,Ls1),
          g_gele_form_ls(Ls1,Z_lsR,LsR),
          g_ix_z(Ix,Z_ix),
          g_gele_form_ls(T,Z_TR,TR),
          Z is Z_lsR * Z_ix + Z_TR.
g_gele_form_ls([H|T],L,[HR|TR]) :- !, g_gele_form(H,HR), g_gele_form_ls(T,L_TR,TR), L is L_TR + 1.
g_gele_form_ls([],0,[]).

cg_at_t_ls([],[]) :- !.
cg_at_t_ls([H|T],[H|T]) :- !.
cg_at_t_ls(At,[At]).


/*  Predicates to remove 'le' and push 'not' to the bottom.
    ======================================================   */

/* g_dw_not(ge(1,1,[A]),AR) :- !, g_dw_not(A,AR). */
g_dw_not(ge(M,N,L),ge(M,N,LR)) :- !, g_dw_not_ls(L,LR).
g_dw_not(le(M,N,L),Res) :- !, K is N-M, g_not_ls(L,LR1),g_dw_not(ge(K,N,LR1),Res).
g_dw_not(gp(Ix,Ls),gp(Ix,LsR)) :- !, g_dw_not_ls(Ls,LsR).
g_dw_not(not gp(Ix,Ls),gp(Ix,LsR)) :- !, g_not_ls(Ls,Ls1), g_dw_not_ls(Ls1,LsR).
g_dw_not(not ge(M,N,L),Res) :- !, K is N-M+1, g_not_ls(L,LR1), g_dw_not(ge(K,N,LR1),Res).
g_dw_not(not le(M,N,L),Res) :- !, K is M+1,g_dw_not(ge(K,N,L),Res).
g_dw_not(not not A, AR) :- !, g_dw_not(A,AR).
g_dw_not(not A >= B, A < B) :- !.
g_dw_not(not A =< B, A > B) :- !.
g_dw_not(not A > B, A =< B) :- !.
g_dw_not(not A < B, A >= B) :- !.
g_dw_not(A,A).

g_dw_not_ls([H|T],[HR|TR]) :- !, g_dw_not(H,HR), g_dw_not_ls(T,TR).
g_dw_not_ls([],[]).

g_not_ls([H|T],[not H|TR]) :- !, g_not_ls(T,TR).
g_not_ls([],[]).


/*  Predicates to flatten 'and' and 'or' lists.
    ==========================================   */

flatn(ge(Z,Z,Ls),ge(Z_lsR,Z_lsR,LsR)) :- !, flatn_and_ls(Ls,Z_lsR,LsR).
flatn(ge(1,Z,Ls),ge(1,Z_lsR,LsR))     :- !, flatn_or_ls(Ls,Z_lsR,LsR).
flatn(ge(M,N,Ls),ge(M,N,LsR))         :- !, flatn_ls(Ls,LsR).
flatn(gp(Ix,Ls),gp(Ix,LsR)) :- !, flatn_ls(Ls,LsR).
flatn(A,A).

flatn_and_ls([ge(Z,Z,H)|T],Z_R,R) :- !, flatn_and_ls(H,Z_HR,HR),
                                        flatn_and_ls(T,Z_TR,TR),
                                        Z_R is Z_HR + Z_TR,
                                        append(HR,TR,R).
flatn_and_ls([gp(Ix,Ls)|T],Z_R,[gp(Ix,LsR)|TR]) :-
        !, flatn_and_ls(Ls,Z_lsR,LsR),
           g_ix_z(Ix,Z_ix),
           flatn_and_ls(T,Z_TR,TR),
           Z_R is Z_lsR * Z_ix + Z_TR.
flatn_and_ls([H|T],Z_R,[HR|TR])   :- !, flatn(H,HR),
                                        flatn_and_ls(T,Z_TR,TR),
                                        Z_R is Z_TR + 1.
flatn_and_ls([],0,[]).

flatn_or_ls([ge(1,Z,H)|T],Z_R,R) :- !, flatn_or_ls(H,Z_HR,HR),
                                       flatn_or_ls(T,Z_TR,TR),
                                       Z_R is Z_HR + Z_TR,
                                       append(HR,TR,R).
flatn_or_ls([gp(Ix,Ls)|T],Z_R,[gp(Ix,LsR)|TR]) :-
        !, flatn_or_ls(Ls,Z_lsR,LsR),
           g_ix_z(Ix,Z_ix),
           flatn_or_ls(T,Z_TR,TR),
           Z_R is Z_lsR * Z_ix + Z_TR.
flatn_or_ls([H|T],Z_R,[HR|TR])   :- !, flatn(H,HR),
                                       flatn_or_ls(T,Z_TR,TR),
                                       Z_R is Z_TR + 1.
flatn_or_ls([],0,[]).

flatn_ls([H|T],[HR|TR]) :- !, flatn(H,HR), flatn_ls(T,TR).
flatn_ls([],[]).


/*  Predicates to generate the IP.
    =============================   */

imply(ge(1,Z,Ls),Ix,D,IP)
     :-  sharp_or_setting(on), !,
         imply_sharp_or_ls(Ls,Ix,D,IP).

imply(ge(1,Z,Ls),Ix,D,IP) :- subst_or_setting(N), N > 0,
                             !, g_n_in_D(D, N_in_D),
                                Or_z is Z + N_in_D,
                                g_subst_p(Ls,Or_z,Subst_p,Subst_k),
                                K is Subst_k * (Or_z - 2),
                                ( ( (K > Or_z + 4 ; Or_z < Subst_p),
                                   !, imply_ls(Ls,Ix,Z_lsR,LsR,IP1),
                                      g_cnstr(1,LsR,Ix,D,IP2))
                                 ;(imply_or_ls(Ls,Ix,Subst_p,Subst,Z_var_ls,Var_ls,IP1),
                                   sum_ls(Var_ls,Sum,Const),
                                   simpl1(Const,D,Sum,DR),
                                   imply(Subst, Ix, DR, IP2) ) ),
                                 lk_IP(IP1,IP2,IP).
imply(ge(Z,Z,Ls),Ix,D,IP) :- !, imply_and_ls(Ls,Ix,Z_lsR,LsR,D,IP1),
                                g_cnstr(Z_lsR,LsR,Ix,D,IP2), lk_IP(IP1,IP2,IP).
imply(ge(M,N,L),Ix,D,IP)  :- !, imply_ls(L,Ix,L_var_ls,Var_ls,IP1),
                                g_cnstr(M,Var_ls,Ix,D,IP2), lk_IP(IP1,IP2,IP).
imply(A =< B,Ix, 1,A =< B) :- !.
imply(A >= B,Ix, 1,A >= B) :- !.
imply(A < B,Ix, 1,A =< B - eps) :- !.
imply(A > B,Ix, 1,A >= B + eps) :- !.
imply(A =< B,Ix, D,conditional_cmpl(max(Res)>0,Res =< max(Res) * DR)) :- !, sub(A,B,Res), simpl_1_mi_D(D,DR).
imply(A >= B,Ix, D,conditional_cmpl(min(Res)<0,Res >= min(Res) * DR)) :- !, sub(A,B,Res), simpl_1_mi_D(D,DR).
imply(A < B,Ix, D,conditional_cmpl(max(Res)>0,Res =< (max(Res) + eps) * DR - eps)) :- !, sub(A,B,Res), simpl_1_mi_D(D,DR).
imply(A > B,Ix, D, conditional_cmpl(min(Res)<0,Res >= (min(Res) - eps) * DR + eps)) :- !, sub(A,B,Res), simpl_1_mi_D(D,DR).
imply(not A,Ix,D,1-A>=D) :- !.
imply(A,Ix,D,A>=D).

imply_ls([H|T],Ix,L_var_ls,[HR|TR],IP) :-  !, imply_at(H,Ix,HR,IP1),
                                              imply_ls(T,Ix,L_TR,TR,IP2),
                                              L_var_ls is L_TR + 1,
                                              lk_IP(IP1,IP2,IP).
imply_ls([],Ix,0,[],null).

imply_at(gp(Ix,L),Ix1,gp(Ix,LR),Res) :- !, lk_ix(Ix,Ix1,Nw_ix),
                                                 imply_ls(L,Nw_ix,L_var_ls,LR,IP),
                                              ( (equal(IP,null), equal(Res,null)) ;
                                                 equal(Res,gp(Ix,IP)) ).
imply_at(H,Ix,H,null)  :- base(H), !.
imply_at(H,Ix,At,IP) :- g_nm(Ix,At), imply(H,Ix,At,IP).

imply_and_ls([gp(Ix2,Ls)|T],Ix1,Z_R,R,D,IP) :-
                    !, lk_ix(Ix1,Ix2,Ix),
                       imply_and_ls(Ls,Ix,Z_lsR,LsR,D,IP1),
                       imply_and_ls(T,Ix1,Z_TR,TR,D,IP2),
                    ( (equal(Z_lsR,0), !, equal(R,TR))  ;
                       equal(R,[gp(Ix2,LsR)|TR])  ),
                       g_ix_z(Ix2,Ix_z),
                       Z_R is Ix_z * Z_lsR + Z_TR,
                    ( (equal(IP1,null),equal(IP,IP2)) ;
                       lk_IP(gp(Ix2,IP1),IP2,IP) ).
imply_and_ls([H|T],Ix,Z_TR,TR,D,IP)    :- (sharp_and_setting(on) ; non_base(H)), !,
                                           imply(H,Ix,D,IP1),
                                           imply_and_ls(T,Ix,Z_TR,TR,D,IP2),
                                           lk_IP(IP1,IP2,IP).
imply_and_ls([H|T],Ix,Z_R,[H|TR],D,IP) :- !, imply_and_ls(T,Ix,Z_TR,TR,D,IP),
                                             Z_R is Z_TR + 1.
imply_and_ls([],Ix,0,[],D,null).

g_subst_p([A=<B|T],_,1,1) :- !.
g_subst_p([A>=B|T],_,1,1) :- !.
g_subst_p([A<B|T],_,1,1) :- !.
g_subst_p([A>B|T],_,1,1) :- !.
g_subst_p([ge(N,N,Ls)|T],2,1,1) :- !.
g_subst_p([ge(N,N,Ls)|T],Or_z,Subst_p,Subst_k) :-
      !, g_subst_p(T,Or_z,T_subst_p,T_subst_k),
         ( (T_subst_k =< 1, !, equal(Subst_k,T_subst_k), Subst_p is T_subst_p + 1)
          ;(g_and_ls_k(Ls,And_k),
            ( (T_subst_k =< And_k, !, equal(Subst_k,T_subst_k), Subst_p is T_subst_p + 1)
             ;(equal(Subst_k,And_k), equal(Subst_p,1)) ) ) ).
g_subst_p([ge(M,N,Ls)|T],_,1,1) :- !. /* ge(1,M,Ls) will not do 'or substitution' if the
                                         D passed to it is too big, hence it can
                                         be included in this case */
g_subst_p([gp(Ix,Ls)|T],Or_z,Subst_p,Subst_k) :-
     !, g_subst_p(T,Or_z,T_subst_p,Subst_k),  /* should do the group - */
        Subst_p is T_subst_p + 1.
g_subst_p([H|T],Or_z,Subst_p,Subst_k) :- !, g_subst_p(T,Or_z,T_subst_p,Subst_k),
                                            Subst_p is T_subst_p + 1.
g_subst_p([],Or_z,1,10000).

imply_or_ls([H|T],Ix,1,H,Z_var_ls,Var_ls,IP) :-
      !, imply_ls(T,Ix,Z_var_ls,Var_ls,IP).
imply_or_ls([H|T],Ix,Subst_p,Subst,Z_var_ls,[HR|T_var_ls],IP) :-
      !, imply_at(H,Ix,HR,IP1),
         T_subst_p is Subst_p - 1,
         imply_or_ls(T,Ix,T_subst_p,Subst,Z_T_var_ls,T_var_ls,IP2),
         Z_var_ls is Z_T_var_ls + 1,
         lk_IP(IP1,IP2,IP).

g_and_ls_k(A,K) :- g_and_ls_k(A,K1,Z_var_ls),
                   ( (Z_var_ls > 0, !, K is K1 + 1)
                    ;equal(K,K1) ).
g_and_ls_k([H|T],K,Z_var_ls) :- !, g_and_at_k(H,H_k,Z_H),
                                   g_and_ls_k(T,T_k,Z_T),
                                   Z_var_ls is Z_H + Z_T,
                                   K is H_k + T_k.
g_and_ls_k([],0,0).

g_and_at_k(gp(Ix,Ls),K,Z) :- !, g_and_ls_k(Ls,K_ls,Z_var_ls),
                                g_ix_z(Ix,Z_ix),
                                K is K_ls * Z_ix,
                                Z is Z_var_ls * Z_ix.
g_and_at_k(ge(N,N,Ls),K,Z) :- !, /* impossible to get here if flatn has been used */
                                 g_and_ls_k(Ls,K,Z_var_ls),
                                 ( (Z_var_ls > 0, !, equal(Z,1))
                                  ; equal(Z,0) ).
g_and_at_k(H,1,0) :- sharp_and_setting(on), !.
g_and_at_k(A=<B,1,0) :- !.
g_and_at_k(A>=B,1,0) :- !.
g_and_at_k(A<B,1,0)  :- !.
g_and_at_k(A>B,1,0)  :- !.
g_and_at_k(ge(M,N,Ls),1,0) :- !.
g_and_at_k(H,0,1).

g_n_in_D(D,0) :- integer(D), !.
g_n_in_D(A+B,N) :- !, g_n_in_D(A,AN), g_n_in_D(B,BN), N is AN+BN.
g_n_in_D(A-B,N) :- !, g_n_in_D(A,AN), g_n_in_D(B,BN), N is AN+BN.
g_n_in_D(sigma(Ix,A),N) :- !, g_n_in_D(A,AN), g_ix_z(Ix,Ix_z),
                              N is AN * Ix_z.
g_n_in_D(D,1).

base(H) :- non_base(H), !, fail.
base(_).

non_base(A=<B) :- !.
non_base(A>=B) :- !.
non_base(A<B)  :- !.
non_base(A>B)  :- !.
non_base(ge(M,N,Ls)) :- !.
non_base(gp(Ix,Ls)) :- !.

lk_ix(Ix,null,Ix) :- !.
lk_ix(null,Ix,Ix) :- !.
lk_ix(Ix1,Ix2,Ix1 and Ix2).

lk_IP(null,A,A) :- !.
lk_IP(A,null,A) :- !.
lk_IP(A,B,A lk B).

g_cnstr(0,[],Ix,D,null) :- !.
g_cnstr(M,Ls,Ix,D,Constraint) :- sum_ls(Ls,Sum,Const), simpl(Sum,Const,M,D,Constraint).

simpl_1_mi_D(H+T,Res) :- integer(H), !, Z is 1-H, rmv_0(Z-T,Res).
simpl_1_mi_D(H-T,Res) :- integer(H), !, Z is 1-H, rmv_0(Z+T,Res).
/*  PC version
simpl_1_mi_D(~D,1+D) :- !.
*/
simpl_1_mi_D(-D,1+D) :- !.
simpl_1_mi_D(D,1-D).

simpl1(0,D,0,D) :- !.
/* PC version
simpl1(Const,H+T,~Sum,Res) :- integer(H), !, Z is H + Const, rmv_0(Z+T+Sum,Res).
simpl1(Const,H-T,~Sum,Res) :- integer(H), !, Z is H + Const, rmv_0(Z-T+Sum,Res).
simpl1(Const,D,~Sum,Res) :- integer(D), !, Z is D + Const, rmv_0(Z+Sum,Res).
simpl1(Const,D,~Sum,Const+(D+Sum)).
*/
simpl1(Const,H+T,-Sum,Res) :- integer(H), !, Z is H + Const, rmv_0(Z+T+Sum,Res).
simpl1(Const,H-T,-Sum,Res) :- integer(H), !, Z is H + Const, rmv_0(Z-T+Sum,Res).
simpl1(Const,D,-Sum,Res) :- integer(D), !, Z is D + Const, rmv_0(Z+Sum,Res).
simpl1(Const,D,-Sum,Const+(D+Sum)).
simpl1(Const,H+T,Sum,Res) :- integer(H), !, Z is H + Const, rmv_0(Z+T-Sum,Res).
simpl1(Const,H-T,Sum,Res) :- integer(H), !, Z is H + Const, rmv_0(Z-T-Sum,Res).
simpl1(Const,D,Sum,Res) :- integer(D), !, Z is D + Const, rmv_0(Z-Sum,Res).
simpl1(Const,D,Sum,Const+(D-Sum)).

rmv_0(0+T,T) :- !.
/* PC version
rmv_0(0-T,~T) :- !.
*/
rmv_0(0-T,-T) :- !.
rmv_0(A,A).

simpl(Sum,Const,M,D,Constraint) :- integer(D),
                                   !, Const1 is Const + M*D,
                                      equal(Constraint,Sum>=Const1).
simpl(Sum,Const,M,HD+TD,Constraint) :- integer(HD),
                                       !, Const1 is Const + M*HD,
                                          g_M_ti_D(M,TD,MD),
                                          equal(Constraint,Sum-MD>=Const1).
simpl(Sum,Const,M,HD-TD,Constraint) :- integer(HD),
                                       !, Const1 is Const + M*HD,
                                          g_M_ti_D(M,TD,MD),
                                          equal(Constraint,Sum+MD>=Const1).
/* PC version
simpl(Sum,Const,M,~D,Sum+MD>=Const) :- !, g_M_ti_D(M,D,MD).
*/
simpl(Sum,Const,M,-D,Sum+MD>=Const) :- !, g_M_ti_D(M,D,MD).
simpl(Sum,Const,M, D,Sum-MD>=Const) :- !, g_M_ti_D(M,D,MD).

g_M_ti_D(1,D,D) :- !.
g_M_ti_D(M,D,M*D).

sum_ls([],Sum,Sum,0) :- !.
sum_ls([not H|T],Sum,Res,Const) :- !, sum_ls(T,Sum - H, Res, Tconst),
                                     Const is Tconst - 1.
sum_ls([gp(Ix,Ls)|T],Sum,Res,Const) :- !, sum_ls(Ls,Sum1,Const1),
                                          sum_ls(T, Sum+sigma(Ix,Sum1), Res, Const2),
                                      g_ix_z(Ix,Ix_z),
                                      Const is Const2 + Ix_z * Const1.
sum_ls([H|T],Sum,Res,Const) :- sum_ls(T,Sum+H,Res,Const).

/* PC version
sum_ls([not H|T],Res,Const) :- !, sum_ls(T,~H,Res,Tconst),
                                  Const is Tconst - 1.
*/
sum_ls([not H|T],Res,Const) :- !, sum_ls(T,-H,Res,Tconst),
                                  Const is Tconst - 1.
sum_ls([gp(Ix,Ls)|T],Res,Const) :- !, sum_ls(Ls,Sum1,Const1),
                                      sum_ls(T, sigma(Ix,Sum1), Res, Const2),
                                      g_ix_z(Ix,Ix_z),
                                      Const is Const2 + Ix_z * Const1.
sum_ls([H|T],Res,Const) :- sum_ls(T,H,Res,Const).
sum_ls([],0,0).


store(0).

reset_store :- retract(store(N)), assert(store(0)).

g_nm(Ix,NM)  :-  !, retract(store(N)), N1 is N + 1, assert(store(N1)),
                    integer_nm(N1,Ls),  append("d",Ls,Nm_ls), name(Root,Nm_ls),
                    g_ix_ls(Ix,Ix_ls), NM =.. [Root|Ix_ls].

g_ix_z(I=F to L,Ix_z) :- Ix_z is L - F + 1.

g_ix_ls(null,[]).
g_ix_ls(I=R and T,[I|TR]) :- !, g_ix_ls(T,TR).
g_ix_ls(I=R,[I]).

wr_IP(A lk B, Ind) :- !, wr_IP(A,Ind), wr_IP(B,Ind).
wr_IP(gp(Ix,A), Ind) :- !, write(Ind), write('For '), write(Ix), write(' Begin'), nl,
                           name(Ind,Ind_ls), name(Ind_pl,[32|[32|Ind_ls]]),
                           wr_IP(A, Ind_pl),
                           write(Ind), write('End'), nl.
wr_IP(A,Ind)         :- !, write(Ind), write(A), nl.


/*  Standard utilities.
    ==================   */

hd_not_done.


wr_hd :- hd_not_done, !, retract(hd_not_done), nl,nl,
         write('          |===========================================|'),nl,
         write('          |                                           |'),nl,
         write('          |               IP Modeller                 |'),nl,
         write('          |               Version 1.0                 |'),nl,
         write('          |                                           |'),nl,
         write('          |                Qiang Li                   |'),nl,
         write('          |           University of Tsukuba           |'),nl,
         write('          |                Yike Guo                   |'),nl,
         write('          |    Dept. of Computing, Imperial College   |'),nl,
         write('          |                                           |'),nl,
         write('          |            Co-operated under AITEC        |'),nl,
         write('          |             research project 1997         |'),nl,
         write('          |===========================================|'),nl,nl,nl.

wr_hd.

flatn_setting(on).

flatn(N) :- retract(flatn_setting(_)), assert(flatn_setting(N)).

sharp_and_setting(off).

sharp_and(S) :- retract(sharp_and_setting(_)), assert(sharp_and_setting(S)).

subst_or_setting(0).

subst_or(N) :- retract(subst_or_setting(_)), assert(subst_or_setting(N)).

monitor_setting(off).

monitor(A) :- retract(monitor_setting(X)), assert(monitor_setting(A)).

monitor(Message, A, write) :- monitor_setting(on), !, write(Message), nl, write(A), nl,nl.
monitor(Message, A, wr_ind) :- monitor_setting(on), !, write(Message), nl, wr_ind(A).
monitor(_,_,_).

wr_ind(A) :- name(Sp," "), write(Sp), wr_ind(A,Sp), nl,nl.

wr_ind(not A,Sp) :- !, write('not '),
                       name(Sp,Sp_ls), name(Sp1,[32,32,32,32|Sp_ls]),
                       wr_ind(A,Sp1).
wr_ind(gp(Ix,Ls),Sp) :- !, write('gp('), write(Ix), wr_ind_ls(Ls,Sp).
wr_ind(ge(M,N,Ls),Sp) :- !, write('ge('), write(M), write(','), write(N), wr_ind_ls(Ls,Sp).
wr_ind(le(M,N,Ls),Sp) :- !, write('le('), write(M), write(','), write(N), wr_ind_ls(Ls,Sp).
wr_ind(A,Sp) :- write(A).

wr_ind_ls([H|T],Sp) :- !, write(',['),
                          name(Sp,Sp_ls), name(Sp1,[32,32,32|Sp_ls]),
                          nl, write(Sp1), wr_ind(H,Sp1),
                          wr_ind_ls1(T,Sp1).
wr_ind_ls([],Sp) :- write(',[])').

wr_ind_ls1([H|T],Sp) :- !, write(','), nl, write(Sp), wr_ind(H,Sp), wr_ind_ls1(T,Sp).
wr_ind_ls1([],Sp) :- write(' ])').

wr_st_setting(on).

write_status(S) :- retract(wr_st_setting(_)), assert(wr_st_setting(S)).

wr_st(Message, A, write) :- wr_st_setting(on),!, write(Message), nl,nl,
                            write(' '),write(A), nl,nl.
/*( wr_st_setting(on),
           !, flatn_setting(Flatn_S), write(flatn(Flatn_S)), write('   '),
              sharp_and_setting(Sharp_S), write(sharp_and(Sharp_S)),
              write('   '),
              subst_or_setting(Subst_or_S), write(subst_or(Subst_or_S)),
              write('   '),
              wr_st_setting(Wr_st_S), write(write_status(Wr_st_S)),
              write('   '),
              monitor_setting(Monitor_S), write(monitor(Monitor_S)), nl,nl)
              write('Input',nl,A,nl)
        ; true.*/

integer_nm(Int,Ls) :- integer_nm(Int,[],Ls).
integer_nm(I,So_far,[C|So_far]) :- I < 10, !, C is I+48.
integer_nm(I,So_far,Ls) :- Top_half is I/10, Bottom_half is I mod 10,
                           C is Bottom_half + 48,
                           integer_nm(Top_half,[C|So_far],Ls).

sub(A,0,A) :- !.
sub(A,B,A-B).

append([],T,T) :- !.
append([H|T],Ls,[H|LsR]) :- append(T,Ls,LsR).

equal(A,A).

re :- reconsult(ips).

/* ======================================================================== */

imply_sharp_or_ls([H|T], Ix, D, Subst_IP)
     :-  !, g_vr_k_ls(H,All_vr_in_H), all_vr_k(All_vr_in_model),
         vr_also_ou(All_vr_in_H, All_vr_in_model, I_k),
         imply(H,Ix,1,H_IP), g_nm(Ix,Nm),
         subst(H_IP, Nm, I_k, Subst_H_IP),
         imply_sharp_or_ls(T,Ix,D,Subst_T_IP),
         lk_IP(Subst_H_IP,Subst_T_IP, Subst_IP).
imply_sharp_or_ls([], Ix, D, null).

/* The top level ge -> IP form (i.e. T3) transform
   should be done with f_imply. It does the variable counts for use in the
   sharp or formulations.  */
f_imply(Ge_form, IP)
     :- g_vr_k_ls(Ge_form, All_vr_k_ls),
        retract(all_vr_k(_)), assert(all_vr_k(All_vr_k_ls)),
        imply(Ge_form, null, 1, IP).

all_vr_k(null).

/* Replace all variables in IP model in 1st parameter which are also in I
   with new variables */
subst(A lk B, D, I, Subst_IP)
     :- !, subst(A, D, I, Subst_A_IP), subst(B, D, I, Subst_B_IP),
        lk_IP(Subst_A_IP, Subst_B_IP, Subst_IP).
subst(A, D, I, Subst_csr)
     :- subst_csr(A, D, I, Subst_csr).

subst_csr(LHS=RHS, D, I, Subst_LHS_vr=RHS*D)
     :- form_subst_LHS(LHS, D, I, Subst_LHS_vr).

subst_csr(LHS=<RHS, D, I, Subst_LHS_vr=<RHS*D)
     :- form_subst_LHS(LHS, D, I, Subst_LHS_vr).
/* same for  >= */

form_subst_LHS(LHS, D, I, Subst_LHS)
     :- subst_LHS(LHS, D, I, I_sum, Non_I_sum),
        add_terms(I_sum, Non_I_sum, Subst_LHS).

subst_LHS(A+B, D, I, I_sum, Non_I_sum)
     :- !, subst_LHS(A, D, I, A_I_sum, A_Non_I_sum),
        subst_LHS(B, D, I, B_I_sum, B_Non_I_sum),
        add_terms(A_I_sum, B_I_sum, I_sum),
        add_terms(A_Non_I_sum, B_Non_I_sum, Non_I_sum).
subst_LHS(A-B, D, I, I_sum, Non_I_sum)
     :- !, subst_LHS(A, D, I, A_I_sum, A_Non_I_sum),
        subst_LHS(B, D, I, B_I_sum, B_Non_I_sum),
        sub_terms(A_I_sum, B_I_sum, I_sum),
        sub_terms(A_Non_I_sum, B_Non_I_sum, Non_I_sum).
subst_LHS(A, D, I, A_nw, 0)
     :- g_occur(A,I,N), N>0, !,
        g_nm(null, A_nw).
subst_LHS(A, D, I, 0, A).

g_occur(A,[],0) :- !.
g_occur(A,[vr_k(A,N)|T], N) :- !.
g_occur(A,[H|T],N) :- g_occur(A,T,N).

vr_also_ou([], All, []) :- !.
vr_also_ou([vr_k(A,N1)|T], All, [vr_k(A,N)|T_ou])
     :- g_occur(A,All,N2), N2 > N1, N is N2-N1, !,
        vr_also_ou(T, All, T_ou).
vr_also_ou([H|T], All, Ou) :- vr_also_ou(T, All, Ou).

/* add terms in a tidy way */
add_terms(A,0,A) :- !.
add_terms(0,B,B) :- !.
add_terms(A,-B,A-B) :- !.
add_terms(A,B,A+B).

/* subtract terms in a tidy way */
sub_terms(A,0,A) :- !.
sub_terms(0,-A,A) :- !.
sub_terms(0,A,-A) :- !.
sub_terms(A,-B,A+B) :- !.
sub_terms(A,B,A-B).

g_vr_k_ls(ge(M,N,[H|T]), Vr_ls) 
     :- !, g_vr_k_ls(H, H_vr_ls), g_vr_k_ls(T, T_vr_ls),
        merge_k_ls(H_vr_ls, T_vr_ls, Vr_ls).
g_vr_k_ls([H|T], Vr_ls)
     :- !, g_vr_k_ls(H, H_vr_ls), g_vr_k_ls(T, T_vr_ls),
        merge_k_ls(H_vr_ls, T_vr_ls, Vr_ls).
g_vr_k_ls([],[]) :- !.  
g_vr_k_ls(A+B, Vr_ls)
     :- !, g_vr_k_ls(A, A_vr_ls), g_vr_k_ls(B, B_vr_ls),
        merge_k_ls(A_vr_ls, B_vr_ls, Vr_ls).
g_vr_k_ls(A=B, Vr_ls)
     :- !, g_vr_k_ls(A, Vr_ls).
g_vr_k_ls(A=<B, Vr_ls)
     :- !, g_vr_k_ls(A, Vr_ls).
g_vr_k_ls(N,[]) :- number(N), !.
g_vr_k_ls(A,[vr_k(A,1)]).

merge_k_ls([],L2,L2) :- !.
merge_k_ls([H|T], L2, Res)
    :- merge_k_ls(T,L2,T_res), merge_k_el(H,T_res,Res).

merge_k_el(A,[],[A]) :- !.
merge_k_el(vr_k(A,N1),[vr_k(A,N2)|T],[vr_k(A,N)|T]) :- !, N is N1+N2.
merge_k_el(A,[H|T],[H|Res]) :- merge_k_el(A,T,Res).


sharp_or_setting(off).

sharp_or(S) :- retract(sharp_or_setting(_)), assert(sharp_or_setting(S)).

re_nw :- reconsult(nw_ken).

test(X,V) :- merge_k_el(X,[vr_k(y,2),vr_k(x,3)],V).  
test1(V) :- g_vr_k_ls(ge(3,3,[a+b+c,ge(2,2,[a+x,b+c]),b+f]),V).
test2(IP) :- f_imply(ge(1,2,[a+b =< 2, b+c =< 3]), IP).
test3(IP) :- f_imply(ge(2,2,[ge(1,2,[a+b =< 2, b+c =< 3]),a+f=<12]), IP).
test4(IP) :- f_imply(ge(2,2,[ge(1,3,[a+b =< 2, b+c =< 3,
                                     ge(1,2,[a+h=<3, g+l=<4])]),
                             a+f=<12]), IP).






