(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)



(* \[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) *)

(*
NO WARRANTY

The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term "warranty"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
"use" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.	
*)





BeginPackage["Variables`",{"Types`"}];

Off[General::"spell"];



Var::usage=
  "Var[expr] picks out all symbols of expr for which the attribute Temporary \
is set." ;

IsVar::usage=
  "IsVar[term] yields True is a symbol which has the list of attributes \
{Temporary}, and yields False otherwise.";

SetVariables::usage=
  "SetVariables[list] sets the list of attributes of the symbols of list to \
{Temporary}." ;

ClearVariables::usage=
  "ClearVariables[list] sets the list of attributes of the symbols of list to \
{}." ;

NewX::usage="NewX[ ] returns a new Temporary symbol of the form x$nnn" ;

NewY::usage="NewY[ ] returns a new Temporary symbol of the form y$nnn" ;

NewC::usage="NewC[ ] returns a new Temporary symbol of the form c$nnn" ;







NewX:=Function[Module[{x},x]];
NewY:=Function[Module[{y},y]];
NewC:=Function[Module[{z},z]];



Begin["`Private`"];





IsVar[x_] :=
	If[Head[x] === Symbol,
		Attributes[x] === {Temporary}, 
		False];





Var[x_]:=Union [Cases[{x},_Symbol?IsVar,-1]];





SetVariables[l_List]:=Join@@ SetVariables /@ l;
SetVariables[v_Symbol]:=(Attributes[v]={Temporary};{v});
SetVariables[TypeOf[v_Symbol,\[Tau]_]]:=
	If[DeclareType[TypeOf[v,\[Tau]]]=!={},
		Attributes[v]={Temporary};
		Type[v]=FormTypeExpr[{},Type[v][]];
		{v},
		{}];





ClearVariables[{vars___Symbol}]:=
	Function[Attributes[#]={};EraseType[#];#] /@ {vars};



End[];

On[General::"spell"];

EndPackage[];