(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)



(* \[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) *)

(*
NO WARRANTY

The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term "warranty"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
"use" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.	
*)





BeginPackage["Types`",{"TypeSyntax`"}];



TypeConstructor::usage=
  "TypeConstructor[constr1, constr2, \[Ellipsis] ] declares the symbols \
constr1, constr2, \[Ellipsis] as type constructors.";

\!\(\(FormTypeExpr::usage = 
    \*"\"\<FormTypeExpr[type-vars, type] yields the encoding of the \
polymorphic type \!\(\[ForAll] \_\(type - vars\)\) type.\>\""; \)\)

DeclareType::usage=
  "DeclareType[symbol1\[Proportion]type1, symbol2\[Proportion]type2, \
\[Ellipsis] ] assigns the encoding of the polymorphic type specified by typei \
to the value of Type[symboli], and yields the list {symbol1, symbol2, \
\[Ellipsis] }." ;

EraseType::usage=
  "EraseType[symbol1, symbol2, \[Ellipsis] ] clears types for the symboli.";

TyVars::usage=
  "TyVars[type] picks out all type variables of type, i.e. all symbols which \
are not type constructors" ;

IsTypeConstructor::usage=
  "IsTypeConstructor[term] yields True if term is a declared type \
constructor, and yields False otherwise." ;

IsConstructor::usage=
  "IsConstructor[term] yields True if term is a declared constructor, and \
yields False otherwise." ;

IsTyped::usage=
  "IsTyped[symb] yields True if symb is a typed operator or a typed variable, \
and yields False otherwise." ;

IsFunType::usage=
  "IsFunType[type] yields True if type is a function type, and yields False \
otherwise." ;

IsFunOnCPType::usage=
  "IsFunOnCPType[type] yields True if type is a function type defined on a \
Cartesian product, and yields False otherwise." ;

Bool::usage=
  "Bool denotes the type of booleans with the constants True and False.";

Int::usage="Int denotes the type of integers.";

\[Placeholder]::usage="\[Placeholder] denotes the void type." ;

Type::usage=
  "Type[symb][ ] yields a valid type instance of the type of symbol symb." ;

TypeCheck::usage=
  "TypeCheck is an option to TSolve. With TypeCheck->True, type checking is \
imposed on the specified CRRs of a Def or TSolve call, and on the goal of a \
TSolve call. With TypeCheck->False, the decision to perform type checking is \
determined by the default option of TSolve.";





Begin["`Private`"];





Clear[TypeConstructor];
TypeConstructor[c_Symbol]:=
	Block[{},
		IsTypeConstructor[c]=True;
		IsConstructor[c]=True;{c}
	];
TypeConstructor[_]:={};
TypeConstructor[cs__Symbol]:=Join @@ TypeConstructor /@ {cs};





Clear[IsTyped];
IsTyped[x_] := Type[x]\[LeftDoubleBracket]0\[RightDoubleBracket]=!=Type;





TyVars[\[Tau]_]:=
  Union [Cases[{\[Tau]},_Symbol?(Not[IsTypeConstructor[#]]&),-1]];





FormTypeExpr[type\[Dash]vars_List,\[Tau]_]:=
	Function[{},
		Module[type\[Dash]vars,{type\[Dash]vars,\[Tau]}]
	];





DeclareType[TypeOf[f_,\[Tau]_]]:=Block[{},
		If[IsTyped[f],Print["Type of ", f, " already defined"],
			Type[f]=FormTypeExpr[TyVars[\[Tau]],\[Tau]]];{f}
	];

DeclareType[fs___TypeOf]:=Join @@ DeclareType /@ {fs};

DeclareType[fs___]:=(Print["Warning: DeclareType: wrong syntax call"];{});





EraseType[x_] :=If[IsTyped[x],Type[x]=.];
EraseType[xs___] :=Scan[EraseType,{xs}];





IsTypeConstructor[_]:=False;





IsFunType[\[Tau]_FuncType]:=True;
IsFunType[_]:=False;





IsFunOnCPType[\[Tau]_]:= 
  And[IsFunType[\[Tau]],
    \[Tau]\[LeftDoubleBracket]1,0\[RightDoubleBracket]===Cross];



End[];

EndPackage[];