(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)



(* \[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) *)

(*
NO WARRANTY

The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term "warranty"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
"use" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.	
*)





BeginPackage["TypeChecker`",
	{"Calculus`"}];



Tc::usage=
  "Tc[term] yields the type of term if term is well typed, and yields \
\[UpTee] otherwise." ;
TcX::usage=
  "TcX[term,type,type\[Dash]eqs,type\[Dash]vars] yields a pair \
{new\[Dash]type\[Dash]eqs,new\[Dash]type\[Dash]vars} for which the following \
assertions are equivalent\n
		\t\t1.term has type type and the type sharing equations type\[Dash]eqs in \
variables type\[Dash]vars hold,\n
		\t\t2.the type sharing equations new\[Dash]type\[Dash]eqs in variables new\
\[Dash]type\[Dash]vars hold." ;
TcXList::usage=
  "TcXList[{term1,term2,\[Ellipsis]},{type1,type2,\[Ellipsis]},type\[Dash]eqs,\
type\[Dash]vars] yields a pair \
{new\[Dash]type\[Dash]eqs,new\[Dash]type\[Dash]vars} for which the following \
assertions are equivalent\n
		\t\t1.term1 has type type1, term2 has type type2, \[Ellipsis], 
		and the type sharing equations type\[Dash]eqs in variables type\[Dash]vars \
hold,\n
		\t\t2.the type sharing equations new\[Dash]type\[Dash]eqs in variables new\
\[Dash]type\[Dash]vars hold." ;
ListToCons::usage=
  "ListToCons[term] substitutes in term all lists that are not formal \
arguments to \[Lambda]-terms with their corresponding CFLP encodings. The \
CFLP encoding of a list {a,b,\[Ellipsis],z} is \
Cons[a,Cons[\[Ellipsis],Cons[z,\[Bullet]]\[Ellipsis]]] with the wisual \
representation \[LeftAngleBracket]a,b,\[Ellipsis],z,\[Bullet]\
\[RightAngleBracket]";
NewTyVar::usage="NewTyVar[] creates a fresh type variable.";





Begin["`Private`"];

$ContextPath=
	Join[
		{"Variables`","TermSyntax`","TypeSyntax`",
			"Types`","RewriteRules`","Terms`"},
		$ContextPath];





NewTyVar := Function[Module[{Global`\[Alpha]},Global`\[Alpha]]];





Tc[t_] := 
	Module[
		{sol,teqn,tvar,
			saveType=DownValues[Type],
			\[Beta]=NewTyVar[]},
		{teqn,tvar}=TcX [t,\[Beta],{},{\[Beta]}];
		DownValues[Type]=saveType;
		sol=Block[{Global`NSolutions=2},
				CallCFLP[teqn,tvar]
			];
		If[sol=!={},\[Beta]//.sol\[LeftDoubleBracket]1\[RightDoubleBracket],
      "\[UpTee]"]
	];





(* variables *)
TcX[x_?IsVar,\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	If[IsTyped[x],
		Type[x][]/.{\[Alpha]v_,\[Tau]1_}:>{Append[\[Tau]eqn,eq[\[Tau]1,\[Tau]]],
          \[Alpha]v\[Union]\[Alpha]var},
		Type[x]=FormTypeExpr[{},\[Tau]];
		{\[Tau]eqn,\[Alpha]var}];		
(* constant literals *)
TcX[_Real|_Integer,\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:={
    Append[\[Tau]eqn,eq[Real,\[Tau]]],\[Alpha]var};
(* TcX[_Integer,\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:={
      Append[\[Tau]eqn,eq[Int,\[Tau]]],\[Alpha]var}; *)
(* function symbol or symbol literal *)
TcX[x_Symbol,\[Tau]_,\[Tau]eqn_,\[Alpha]var_] :=
	Block[{\[Tau]expr,\[Alpha]v={}},
		{Append[\[Tau]eqn,
        eq[If[IsTyped[x],{\[Alpha]v,\[Tau]expr}=Type[x][];\[Tau]expr,Symbol],
          \[Tau]]],
				\[Alpha]var\[Union]\[Alpha]v}
	];
(* \[Lambda]-terms *)
TcX[\[Lambda][{___,x_,___,x_,___},t_],\[Tau]_,\[Tau]eqn_,
    \[Alpha]var_]:={{eq[Int,Bool]},{}};
TcX[\[Lambda][x_Symbol,t_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
  TcX[\[Lambda][{x},t],\[Tau],\[Tau]eqn,\[Alpha]var];
TcX[\[Lambda][xs_List, t_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_] := 
Block[{xsNew,tNew,\[Beta],newTyVars}, 
		{xsNew,tNew} = (Module[#1, {#1, #2}] & )[xs,t]; 
    Scan[(Type[#1] = FormTypeExpr[{},NewTyVar[]]) & ,xsNew]; 
		newTyVars=(Last[Type[#1][]] & ) /@ xsNew;
		\[Beta] =If[Length[newTyVars]>1,
				FuncType[Cross @@ newTyVars,NewTyVar[]],
				FuncType[First[ newTyVars],NewTyVar[]]
			];
		TcX[tNew, Last[\[Beta]], Append[\[Tau]eqn, eq[\[Beta],\[Tau]]], 
      Append[Union[\[Alpha]var, newTyVars], Last[\[Beta]]]]
	];
(* lists *)
TcX[l_List,\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	Function[TcXList[l,Table[#,{Length[l]}],
		Append[\[Tau]eqn,eq[\[Tau],TyList[#]]],Append[\[Alpha]var,#]]][NewTyVar[]]; 

(*application for flattened functions *)
TcX[Plus[x_,y_]|Times[x_,y_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
		TcXList[{x,y},{Real,Real},Append[\[Tau]eqn,eq[\[Tau],Real]],\[Alpha]var];
TcX[And[x_,y_]|Or[x_,y_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
		TcXList[{x,y},{Bool,Bool},Append[\[Tau]eqn,eq[\[Tau],Bool]],\[Alpha]var];
(* application *)
TcX[f_[],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	TcX[f,FuncType[\[Placeholder],\[Tau]],\[Tau]eqn,\[Alpha]var];
TcX[f_[arg_],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	Function[
      TcXList[{f,arg},{FuncType[#1,\[Tau]],#1},\[Tau]eqn,
        Append[\[Alpha]var,#1]]][NewTyVar[]];
TcX[f_[args__],\[Tau]_,\[Tau]eqn_,\[Alpha]var_]:=
	Function[
		TcXList[{f,args},
			{FuncType[Apply[Cross ,#1],\[Tau]],
				Apply[Sequence,#1]},\[Tau]eqn,Join[\[Alpha]var,#1]]][NewTyVar/@{args}];

TcX[_,_,_,_]:={{eq[Int,Bool]},{}};





TcXList[{},{},\[Tau]eqn_,\[Alpha]var_] :={\[Tau]eqn,\[Alpha]var};
TcXList[{t_,ts___},{\[Alpha]_,\[Alpha]v___},\[Tau]eqn_,\[Alpha]var_]:=
	TcXList[{ts},{\[Alpha]v},Sequence @@ TcX[t,\[Alpha],\[Tau]eqn,\[Alpha]var]];
		
TcXList[_,_,_,_]:={{eq[Int,Bool]},{}};





ListToCons[{}]:=\[Bullet];
ListToCons[{h_,t___}]:=Cons[ListToCons[h],ListToCons[{t}]];
ListToCons[\[Lambda][l_,t_]]:=\[Lambda][l,ListToCons[t]];
ListToCons[t_?AtomQ]:=t;
ListToCons[t_]:=Map[ListToCons,t];



End[];

EndPackage[];