(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)



(* \[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) *)

(*
NO WARRANTY

The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term "warranty"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
"use" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.	
*)





BeginPackage["Terms`",
	{"TermSyntax`",
		"Variables`"}];



$FunctionSymbol::usage=
  "$FunctionSymbol gives the current list of declared function symbols.";

Arity::usage="Arity[symb] yields the arity of the typed symbol symb.";

Constructor::usage=
  "Constructor[sig\[Dash]1, sig\[Dash]2, \[Ellipsis] ] expects arguments sig\
\[Dash]i of the form symb\[Dash]i or symb\[Dash]i\[Proportion]type\[Dash]i, \
and performs the following operations:\n
		I) for every undeclared symbol symb\[Dash]i do\n
		\t 1.assign True to IsConstructor[symb\[Dash]i],\n
		\t 2.append symb\[Dash]i to the list $FunctionSymbol,\n
		\t 3.if type\[Dash]i is specified\n
		\t\t\t then assign the type \[ForAll] type\[Dash]i to Type[symb\[Dash]i],\n
		\t\t\t else assign the type \[Alpha] to Type[symb\[Dash]i], where \[Alpha] \
is a new type constant,\n
		\t 4.assign the arity of Type[symb\[Dash]i] to Arity[symb\[Dash]i],\n
		II) return the list {symb\[Dash]i1, symb\[Dash]i2, \[Ellipsis] } of newly \
declared constructors.\n\n
		Constructor is also an option to TSolve which specifies the set of \
constructors and, optionally, their types. During the solving process also \
the globally declared constructors are considered.";

DefinedFunctionSymbol::usage=
  "DefinedFunctionSymbol[sig\[Dash]1, sig\[Dash]2, \[Ellipsis] ] expects \
arguments sig\[Dash]i of the form symb\[Dash]i or \
symb\[Dash]i\[Proportion]type\[Dash]i, and performs the following operations:\
\n
		I) for every undeclared symbol symb\[Dash]i do\n
		\t 1.assign True to IsDefinedFunctionSymbol[symb\[Dash]i],\n
		\t 2.append symb\[Dash]i to the list $FunctionSymbol,\n
		\t 3.if type\[Dash]i is specified\n
		\t\t\t then assign type \[ForAll] type\[Dash]i to Type[symb\[Dash]i],\n
		\t\t\t else assign type \[Alpha] to Type[symb\[Dash]i], where \[Alpha] is a \
new type constant,\n
		\t 4.assign the arity of Type[symb\[Dash]i] to Arity[symb\[Dash]i],\n
		II) return the list { symb\[Dash]i1, symb\[Dash]i2, \[Ellipsis] } of newly \
declared defined function symbols.\n\n
		DefinedFunctionSymbol is also an option to TSolve which specifies the set \
of defined functions and, optionally, their types. During the solving process \
also the globally declared defined functions are considered.";

External::usage=
  "External symb\[Dash]1\[Proportion]type\[Dash]1, \
symb\[Dash]2\[Proportion]type\[Dash]2, \[Ellipsis] ] performs the following \
operations:\n
		I) for every undeclared symbol symb\[Dash]i do\n
		\t 1.assign True to IsExternal[symb\[Dash]i],\n
		\t 2.assign the type \[ForAll] type\[Dash]i to Type[symb\[Dash]i],\n
		II) return the list {symb\[Dash]i1, symb\[Dash]i2, \[Ellipsis] } of newly \
declared external function symbols.";

IsDefinedFunctionSymbol::usage=
  "IsDefinedFunctionSymbol[term] yields True if term was already declared as \
defined function symbol, and yields False otherwise." ;

IsExternal::usage=
  "IsExternal[term] yields True if term was already declared as external \
symbol, and yields False otherwise." ;

IsDeclared::usage=
  "IsDeclared[symb] yields True if symb is an already declared function \
symbol (i.e. constructor, external, or defined function symbol), and yields \
False otherwise. If symb is already declared, a warning message specifying \
the type of symb is displayed." ;

IsFunctionSymbol::usage=
  "IsFunctionSymbol[symb] yields True if symb is an already declared function \
symbol (i.e. constructor, external, or defined function), and yields False \
otherwise." ;

ClearSignature::usage=
  "ClearSignature[ symb\[Dash]1, symb\[Dash]2, \[Ellipsis] ] undoes all the \
operations performed (eventually) for symb\[Dash]i by a previous Constructor, \
External, or DefinedFunctionSymbol command.";

ResetSignature::usage=
  "ResetSignature[ ] resets the values of Type, Arity, \
IsDefinedFunctionSymbol, IsExternal, IsConstructor and $FunctionSymbol to the \
defaults.";

DefineSignature::usage=
  "DefineSignature[ ] sets the values of Type, Arity, \
IsDefinedFunctionSymbol, IsExternal, IsConstructor and $FunctionSymbol to the \
defaults.";

IsConstructorTerm::usage=
  "IsConstructorTerm[term] yields True if term is a term of the form c or c[ \
term1, term2, \[Ellipsis] ] where c is a constructor, and False otherwise.";

IsNotFlex::usage=
  "IsNotFlex[term] yields False if term is a variable or a term of the form \
X[ term1, term2, \[Ellipsis] ] where X is a variable, and True otherwise.";

IsFunctionTerm::usage=
  "IsFunctionTerm[term] yields True if term is a defined function symbol or a \
term
		of the form f[ term1, term2, \[Ellipsis] ] where f is a defined function \
symbol, and False otherwise .";





Begin["`Private`"];

$ContextPath=Join[{"Types`","TypeSyntax`"},$ContextPath];











Constructor[c_Symbol]:=
	If[IsDeclared[c],
		{},
		Type[c]=FormTypeExpr[{},NewC[]];
		AppendTo[$FunctionSymbol,c];Arity[c]=0;
		IsConstructor[c]=True;
		{c}];
Constructor[TypeOf[c_,\[Tau]_?IsFunType]]:=
	If[IsDeclared[c],
		{},
		IsConstructor[c]=True;
		If[Not[MemberQ[{RewriteRule,eq,ppeq},c]],
			AppendTo[$FunctionSymbol,c];
			Arity[c]=If[IsFunOnCPType[\[Tau]],
					Length[First[\[Tau]]],
					If[First[\[Tau]]===\[Placeholder],0,1]]
		];
		DeclareType[TypeOf[c,\[Tau]]];{c}];
Constructor[TypeOf[c_,\[Tau]_]]:=
	(If[IsDeclared[c],
		{},
		IsConstructor[c]=True;
		AppendTo[$FunctionSymbol,c];
		Arity[c]=0;
		DeclareType[TypeOf[c,FuncType[\[Placeholder],\[Tau]]]];{c}]);
Constructor[cs___]:=Join @@ Constructor /@ {cs};





Clear[DefinedFunctionSymbol];
DefinedFunctionSymbol[f_Symbol]:=
	If[IsDeclared[f],
		{},
		Type[f]=FormTypeExpr[{},NewC[]];
		AppendTo[$FunctionSymbol,f];
		Arity[f]=0;
		IsDefinedFunctionSymbol[f]=True;
		{f}];
DefinedFunctionSymbol[TypeOf[f_,\[Tau]_?IsFunType]]:=
	If[IsDeclared[f],
		{},
		IsDefinedFunctionSymbol[f]=True;
		If[Not[MemberQ[{RewriteRule,eq,ppeq},f]],
			AppendTo[$FunctionSymbol,f];
			Arity[f]=If[IsFunOnCPType[\[Tau]],
					Length[First[\[Tau]]],
					If[First[\[Tau]]===\[Placeholder],0,1]]
		];
		DeclareType[TypeOf[f,\[Tau]]];{f}];
DefinedFunctionSymbol[TypeOf[f_,\[Tau]_]]:=
	If[IsDeclared[f],
		{},
		IsDefinedFunctionSymbol[f]=True;
		AppendTo[$FunctionSymbol,f];
		Arity[f]=0;	
		DeclareType[TypeOf[f,FuncType[\[Placeholder],\[Tau]]]];{f}];
DefinedFunctionSymbol[_]={};
DefinedFunctionSymbol[fs___]:=Join @@ DefinedFunctionSymbol /@ {fs};





External[TypeOf[f_,\[Tau]_?IsFunType]]:=
	If[IsDeclared[f],
		{},
		IsExternal[f]=True;
		(* AppendTo[$FunctionSymbol,
			{f,If[IsFunOnCPType[\[Tau]],
					Length[First[\[Tau]]],
					If[First[\[Tau]]===\[Placeholder], 0, 1 ]]}]; *)
		DeclareType[TypeOf[f,\[Tau]]];{f}];
External[f_\[Proportion]\[Tau]_]:=
	If[IsDeclared[f],
		{},
		IsExternal[f]=True;
		(* AppendTo[$FunctionSymbol,{f,0 }];	*)
		DeclareType[TypeOf[f,FuncType[\[Placeholder],\[Tau]]]];{f}];
External[_]={};
External[fs___]:=Join @@ External /@ {fs};





DefineSignature[]:=
	Block[{},
		$FunctionSymbol={};
		TypeConstructor[Int,Bool,Real,Symbol,\[Placeholder],TyList,FuncType,Cross];
		Constructor[
			TypeOf[True,Bool],
			TypeOf[False,Bool],
			TypeOf[\[Bullet],TyList[Global`\[Alpha]]],
			TypeOf[Cons,
        FuncType[Global`\[Alpha]\[Cross]TyList[Global`\[Alpha]],
          TyList[Global`\[Alpha]]]],
			TypeOf[RewriteRule,
        FuncType[Global`\[Alpha]\[Cross]Global`\[Alpha]\[Cross]Bool,Bool]],
			TypeOf[eq,FuncType[Global`\[Alpha]\[Cross]Global`\[Alpha],Bool]]];
		External[
			TypeOf[Plus,FuncType[Real\[Cross]Real,Real]],
      TypeOf[Times,FuncType[Real\[Cross]Real,Real]],
			TypeOf[Power,FuncType[Real\[Cross]Real,Real]],
			TypeOf[Sin,FuncType[Real,Real]],
			TypeOf[Cos,FuncType[Real,Real]],
			TypeOf[And,FuncType[Bool\[Cross]Bool,Bool]],
			TypeOf[Or,FuncType[Bool\[Cross]Bool,Bool]],
			TypeOf[Not,FuncType[Bool,Bool]]];
	];





Clear[ClearSignature];
ClearSignature[f_Symbol]:=
	Block[{},
		IsDefinedFunctionSymbol[f]=False;
		IsConstructor[f]=False;
		IsExternal[f]=False;
		If[Head[Type[f]]=!=Type,Type[f]=.;Arity[f]=.];
		$FunctionSymbol=$FunctionSymbol/.f->Sequence[];
		{f}
	];
ClearSignature[fs___Symbol]:=Join @@ ClearSignature /@ {fs} ;





Clear[ResetSignature];
ResetSignature[]:=
	(Clear[IsDefinedFunctionSymbol,IsConstructor,Type,Arity];
		IsConstructor[c_?AtomQ]/;
        c\[LeftDoubleBracket]0\[RightDoubleBracket]=!=Symbol=True;
		IsConstructor[_]:=False;
		IsDefinedFunctionSymbol[_]:=False;
		DefineSignature[]);







IsConstructor[c_?AtomQ]/;
    c\[LeftDoubleBracket]0\[RightDoubleBracket]=!=Symbol:=True;
IsConstructor[_]:=False;





IsDefinedFunctionSymbol[_]:=False;





IsExternal[_]:=False;





IsDeclared[f_]:=
	If[IsExternal[f],
		Print["Warning: ",f," is already declared as external function symbol"];
    True,
		If[IsDefinedFunctionSymbol[f],
			Print["Warning: ",f," is already declared as defined function symbol"];
      True,
			If[IsConstructor[f],
				Print["Warning: ",f," is already declared as constructor symbol"];True,
				False
				]
		]
	];





Clear[IsFunctionSymbol];
IsFunctionSymbol[f_]:=
  Or[IsConstructor[f],IsDefinedFunctionSymbol[f],IsExternal[f]];







Clear[NotFlex];
IsNotFlex[x_?IsVar]:=False;
IsNotFlex[x_?IsVar[___]]:=False;
IsNotFlex[_]:=True;





IsConstructorTerm[(_?IsConstructor)[___]|_?IsConstructor]:=True;





IsFunctionTerm[(_?IsDefinedFunctionSymbol)[___]
|_?IsDefinedFunctionSymbol]:=True;



End[];

DefineSignature[];

EndPackage[];