(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)



(* \[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) *)

(*
NO WARRANTY

The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term "warranty"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
"use" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.	
*)





BeginPackage["TSolve`",
	{"TypeChecker`","RewriteRuleDefs`"}
];



TSolve::usage=
  "TSolve[eqns,vars] attempts to solve an equation or a set of equations for \
the variables vars.";

Initialize::usage=
  "Initialize is an option to the function TSolve. With TypeCheck->True ... \
.";

NSolution::usage=
  "NSolution is an option to TSolve which specifies the maximum number of \
solutions to be found.";

Rule::usage=
  "Rule is an option to TSolve which specifies the set of CRRs w.r.t. which \
the system of equations is tried to be solved. During the solving process \
also the globally declared CRRs are used.";





Begin["`Private`"];

$ContextPath=Join[
		{
			"TypeSyntax`",
				"Types`",
				"Variables`",
				"TermSyntax`",
				"Terms`",
				"RewriteRules`",
				"Calculus`"
		},$ContextPath];



Options[TSolve]={
		NSolution->256,
		Rule->{},
		Initialize->False,
		Constructor->{},
		DefinedFunctionSymbol->{},
		TypeCheck->True
	};

TypeCheck[tyChkVal:(True|False)]:=
	(Options[TSolve]=Options[TSolve]/.((TypeCheck->_)->(TypeCheck->tyChkVal)));





BeginRule[];

TSolve[goal_List,vars_List,opts___Rule]:=TSolve[goal,vars,{},opts];
TSolve[goal_List,vars_List,elims_List,opts___Rule]:=
	Block[{
			saveRewriteRuleList=DownValues[RewriteRuleList],
			saveIsDefinedFunctionSymbol=DownValues[IsDefinedFunctionSymbol],
			saveIsConstructor=DownValues[IsConstructor],
			saveType=DownValues[Type],
			Global`NSolutions,
			sol
			},
		Global`NSolutions=NSolution/.{opts}/.Options[TSolve];
		If[Global`NSolutions\[LessEqual]0,
			{},
			If[Initialize/.{opts}/.Options[TSolve],BeginRule[]];
			Constructor @@ Join[Constructor/.{opts}/.Options[TSolve],elims];
			DefinedFunctionSymbol @@ (DefinedFunctionSymbol/.{opts}/.Options[TSolve]);
			If[TypeCheck/.{opts}/.Options[TSolve],
				If[Def[vars,Rule/.{opts}/.Options[TSolve],TypeCheck->True]==="\[DownTee]",
          
					SetVariables[vars];
						sol=
							Function[
								TSolve[Sequence @@ #,TypeCheck->False,NSolution->2]
							][TcX[goal,TyList[Bool],{},{}]];
						sol=
							If[sol==={},
								Print["Type check error : can not type the goal."];{},
								DownValues[Type]=
                DownValues[Type]/.Normalize[
                    sol\[LeftDoubleBracket]1\[RightDoubleBracket]];
								CallCFLP[ListToCons /@ goal,vars]
							];
						ClearVariables[vars]
				],
				Def[vars,Rule/.{opts}/.Options[TSolve],TypeCheck->False];
				sol=CallCFLP[ListToCons /@ goal,vars]
				];
			DownValues[RewriteRuleList]=saveRewriteRuleList;
			DownValues[IsDefinedFunctionSymbol]=saveIsDefinedFunctionSymbol;
			DownValues[IsConstructor]=saveIsConstructor;
			DownValues[Type]=saveType;
			sol
			]
	];

TSolve[goal_,vars_List,args___]:=TSolve[{goal},vars,args];
TSolve[___]:=Print["Error: invalid syntax call."];





Clear[Normalize];
Normalize[\[Theta]_]:=
  Inner[Rule,First /@ \[Theta],Last /@ \[Theta]//.\[Theta],List];



End[];

EndPackage[];