(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)



(* \[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) *)

(*
NO WARRANTY

The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term "warranty"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
"use" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.	
*)





BeginPackage["Scheduler`",
	{"TermSyntax`",
		"TypeSyntax`",
		"Types`"}
];



Constraints::usage;

Scheduler::usage;

CSolve::usage;

CSStart::usage="CSStart[] creates the links to constraint solvers.";

CSEnd::usage=
  "CSEnd[] closes links to all constraint solvers. CSlink[link] closes the \
link object link.";

Ask::usage;

GetVars::usage="GetVars[expr] yields the variables of expr.";

Vars::usage=
  "Vars[{idx}] gives the list of variables of \
Constraints\[LeftDoubleBracket]idx\[RightDoubleBracket]";

Substitution::usage;

SetCSQuery::usage;

Global`goalVar::usage;



Off[Solve::"svars"];



Begin["`Private`"];

















Constraints:={};





Status[_]:="idle";



CnstrIdx:={0};









MethodList:={"Polynomial"};









CSStart[]:=
	Block[{timer=0},
		$LinearLink=
      LinkLaunch[
        "math -mathlink -batchoutput -run \"Off[Solve::\"svars\"]\""];
		$PolyLink=$LinearLink;
		(* wait at most 10 seconds to establish the connection *)
		While[Not[LinkReadyQ[$LinearLink]],
			If[timer++<10,
				Pause[1];Continue[],
				LinkClose[$LinearLink];
				Return["failed to connect to constraint solvers."]
			]
		];
		Return["connection to constraint solvers established."]
	];





CSEnd[]:=CSEnd/@ {$PolyLink,$LinearLink};
CSEnd[link_]:=
	If[MemberQ[Links[],link],
		LinkWrite[link,Unevaluated[EvaluatePacket[Exit[]]]];
		LinkClose[link];"closed",
		"already closed"
	];







SetCSQuery[vars_,subst_,cnstrs_]:=
	Block[{extSolver, eqFilter},
		Vars[++CnstrIdx]=vars;
		Substitution[CnstrIdx]=subst;
		AppendTo[Constraints,cnstrs];
		{extSolver, eqFilter}=CS[First[MethodList]];
		extSolver[eqFilter[cnstrs]];
		"OK"
	];





Ask[link_]:=
	Block[{IDX,sol},
		If[LinkReadyQ[link],
			{IDX,sol}=(LinkRead[link])\[LeftDoubleBracket]1\[RightDoubleBracket];
			Answer[IDX]=Map[Union,sol]/.Rule->eq]
	];



LinSolve[Cs_]:=
	(LinkWrite[#4,
			Unevaluated[EvaluatePacket[{#5,Solve[ #1,#2,Complement[#3,#2]]}]]]&[
			Cs/.eq->Equal,
			GetVars[Global`goalVar//.Substitution[CnstrIdx]],
			Vars[CnstrIdx],
			$LinearLink,
			CnstrIdx];
		LinkId[CnstrIdx]=$LinearLink);



PolySolve[Cs_]:=
	(LinkWrite[#4,
			Unevaluated[EvaluatePacket[{#5,Solve[ #1,#2,Complement[#3,#2]]}]]]&[
			Cs/.eq->Equal,
			GetVars[Global`goalVar//.Substitution[CnstrIdx]],
			Vars[CnstrIdx],
			$PolyLink,
			CnstrIdx];
		LinkId[CnstrIdx]=$PolyLink);







IsVar[x_]:=MemberQ[Vars[CnstrIdx],x];



IsNumericTerm[_?IsVar]:= False;
IsNumericTerm[t_]:=Not[MemberQ[t,_?IsVar,-1]];





IsPolyTerm[_?IsVar]:=True;
IsPolyTerm[_?IsNumericTerm]:= True;
IsPolyTerm[Times[-1,t_]]:=IsPolyTerm[t];
IsPolyTerm[Power[t_,_Integer]]:=IsPolyTerm[t];
IsPolyTerm[t1_+t2_]:=IsPolyTerm[t1]\[And]IsPolyTerm[t2];
IsPolyTerm[t1_ * t2_]:=IsPolyTerm[t1]\[And]IsPolyTerm[t2];
IsPolyTerm[_]:=False;





IsLinTerm[(x_?IsNumericTerm|x_?IsVar)]:= True;
IsLinTerm[Times[-1,x___]]:=IsLinTerm[Times[x]];
IsLinTerm[f_[t___]]/;f===Times:= 
  MatchQ[{t},{___?IsNumericTerm}|{___?IsNumericTerm,
        x_?IsVar,___?IsNumericTerm}];
IsLinTerm[Plus[x_,y_]]:=IsLinTerm[x]\[And]IsLinTerm[y];
IsLinTerm[Plus[x_,y__]]:=IsLinTerm[x] \[And] IsLinTerm[Plus[y]];
IsLinTerm[x_]:= False;







PolyForm[eq[expr1_,expr2_]]:=
	Block[{e1,e2},
		e1=Factor[expr1];
		e2=Factor[expr2];
		eq[Numerator[e1]*Denominator[e2],Numerator[e2]*Denominator[e1]]
	];





GetVars[t_]:=Union[Cases[{t}, _Symbol?IsVar, -1]];





PolyFilter[Cs_]:= 
	Select[Cs,MatchQ[#,eq[_?IsPolyTerm,_?IsPolyTerm]]&];





LinFilter[Cs_]:= 
	 Select[PolyForm /@ Cs,MatchQ[#,eq[_?IsLinTerm,_?IsLinTerm]]&];





GetEqs[Cs_,"Polynomial"]:= 
	PolyForm /@ Select[Cs,MatchQ[#,eq[_?IsPolyTerm,_?IsPolyTerm]]&];



CS["Polynomial"]:={PolySolve,PolyFilter};
CS["Linear"]:={LinSolve,LinFilter};







Clear[CSolve];
CSolve[{{eqs__eq},Ms_List},idx_]:=
	Block[{extSolver, eqFilter,CnstrIdx={First[idx]},result},
		If[Head[Answer[idx]]=!=Answer,
			If[Answer[idx]==={{eqs}},
				{{eqs},Rest[Ms]},
				result=
					If[Answer[idx]=!={},
						Function[{#,Complement[MethodList,{First[Ms]}]}] /@Answer[idx],
						{{eqs},Ms}];
				Answer[idx]=.;
				Status[idx]="idle";
				IsOver=False;
				result],
			Switch[Status[idx],
				"waiting",Ask[LinkId[idx]];
				IsOver=False;
				{{eqs},Ms},
				"idle",
				If[Ms==={},
					LinkWrite[$ParentLink,
						ReturnPacket[
								FilterSubstitution[Substitution[{First[idx]}],
									First[
                  Constraints
                    \[LeftDoubleBracket]Sequence @@ idx\[RightDoubleBracket]]]
                
							]
					];
					Status[idx]="done";{{eqs},Ms},
					{extSolver, eqFilter}=CS[First[Ms]];
					Status[idx]="waiting";
					extSolver[
            eqFilter[
              Constraints
                \[LeftDoubleBracket]Sequence @@ idx\[RightDoubleBracket]]];
					IsOver=False;{{eqs},Ms}
				]
			]
		]
	];
CSolve[xs_,_]:=xs;



Scheduler[]:=
	Block[{Answer,IsWaiting,IsOver=False},
		Module[{pos},
			For[pos=1,pos<=Length[Constraints],pos++,Status[{pos}]="waiting"];
			Constraints=Map[{#,MethodList}&,Constraints];
			While[Not[IsOver],
				IsOver=True;
				Constraints=MapIndexed[CSolve,Constraints,Infinity]
			];
			CnstrIdx={0};
			Constraints={};
			Clear[Substitution,Vars,Status];
			Status[_]:="idle";
			"done."
		]
	];



Clear[FilterSubstitution];
FilterSubstitution[subst_,{u___,eq[x_?IsVar,t_]|eq[t_,x_?IsVar],v___}]:=
	FilterSubstitution[Append[subst,x->t],{u,v}];
FilterSubstitution[u_,v_]:={u,v};



End[];

EndPackage[];