(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)



(* \[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) *)

(*
NO WARRANTY

The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term "warranty"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
"use" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.	
*)





BeginPackage["RewriteRuleDefs`",
	{"RewriteRules`"}];

Off[General::"spell"];



Def::usage=
  "Def[vars, {rule1, rule2, \[Ellipsis] }] appends the results of encoding \
rulei to RewriteRuleList[f], where f is the head function symbol of rulei.";





Begin["`Private`"];

$ContextPath=
	Join[{"Variables`","TermSyntax`","Types`","Terms`",
      "TypeChecker`"},$ContextPath];





FormFunction[par_,localVar_,t_,{c___}]:=
	Function[par,
		Module[localVar,RewritesTo[t,c]]
	];





Def[{},True|False,_Integer] :="\[DownTee]";
Def[V_List,{rs___RewriteRule},opts___]:=
	Block[{answer},
		SetVariables[V];
		answer=Def[Map[TypeChecker`ListToCons,{rs}],
        TypeCheck/.{opts}/.Options[TSolve`TSolve],1];
		ClearVariables[V];
		answer];
Def[{RewriteRule[lhs_,rhs_,cnd_],rs___RewriteRule},tyChk_,n_Integer]:=
	(If[tyChk,
			Block[{saveType=DownValues[Type]},
				If[TypeChecker`Tc[RewriteRule[lhs,rhs,cnd]]==="\[UpTee]",
					Print["Type check error at rule #",n];
					DownValues[Type]=saveType;
					Return["\[UpTee]"],
					DownValues[Type]=saveType]]
		];
		Block[{
				fsymb = If[Head[lhs] === Symbol, lhs, Head[lhs]],
				parameter,cond,lhsV,rhsV,localV},
			If[IsConstructor[fsymb],
					Print["Constructor symbol ", fsymb, " redefined as a defined symbol."]; 
					IsConstructor[fsymb] =. ];
				IsDefinedFunctionSymbol[fsymb] = True;
				IsFunctionSymbol[fsymb] = True;
			{parameter, cond} = Uniform[lhs];
			lhsV = Var[lhs]; 
			rhsV = Var[{rhs, cnd}]; 
			localV = Union[rhsV, lhsV]; 
			Print["Adding rule #",n,": ",RewriteRule[lhs,rhs,cnd]];
			PrintVarDecl[localV, Complement[rhsV,lhsV]];
			AppendTo[RewriteRuleList[fsymb],
				FormFunction[parameter,localV,rhs,
					{cond,
						Switch[cnd,
							(eq|Or)[__],List[cnd],
							True,{},
							_,List @@ cnd
						]}
				]
			]
		];
		Def[{rs},tyChk,n+1]);
Def[___]:=(Print["Error: wrong expressions specified as rewrite rules"];
    "\[UpTee]");



Clear[Flattening];
Flattening[s_]:=
	Module[{Global`w},
		AppendTo[Cond,ppeq[Global`w,s]];
		PatternVar=Join[PatternVar,Var[s]];
		Global`w];



Clear[PrintVarDecl];
PrintVarDecl[argVset_,argXV_]:=
	Module[
		{vset=Sort[argVset],xV=Sort[argXV],suffix1,suffix2,
		myInfix=Function[{x,y},If[Length[x]>1,Infix[x,y],First[x]]],
		suffix=Function[x,If[Length[x]>1,"s",""]]},
		Switch[vset,
			{},-1,
			{__},Print["Symbol",suffix[vset]," ",
				myInfix[vset,","]," declared as  variable", suffix[vset],"."]];
		Switch[xV,
			{},-1,
			{__},Print["Symbol",suffix[xV]," ",
				myInfix[xV,","]," declared as extra variable",suffix[xV],"."]
		]
	];		





Clear[Uniform];
Uniform[s_Symbol]:={{},{}};
Uniform[s_]:=
Block[{Cond = {}, PatternVar = {}}, {List @@ Flattening /@ s, Cond}];



End[];

On[General::"spell"];

EndPackage[];