(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)



(* \[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) *)

(*
NO WARRANTY

The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term "warranty"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
"use" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.	
*)









BeginPackage["Electrical`",
{"TSolve`"}];

















Off[General::spell]





resistor::usage=
  "resistor[R,S,V0,I0,V1,I1] describes a resistor with input voltage/current \
s[V0,I0] and output s[V1,I1]." ;

inductor::usage=
  "inductor[R,S,V0,I0,V1,I1] describes a inductor with input voltage/current \
s[V0,I0] and output s[V1,I1]." ;

capacitor::usage=
  "capacitor[R,S,s[V0,I0],s[V1,I1]] describes a capacitor with input \
voltage/current s[V0,I0] and output s[V1,I]." ;

source::usage=
  "source[R,S,s[V0,I0],s[V1,I1]] describes a voltage source with input \
voltage/current s[V0,I0] and output s[V1,I1]." ;

earth::usage=
  "earth[S,s[V1,I1]] describes earth with output voltage/current s[V1,I1]." ;

junction::usage=
  "junction[L,R] describes a junction of inputs L and outputs R. L and R are \
lists of pairs s[Vi,Ii]." ;

elJoin::usage=
  "elJoin[S,L,V] describes the join operation of inputs L and outputs R. \
Here, L is a list of pairs s[Vi,Ii] modelling the signals, where V equals all \
Vi and I is the sum of Ii." ;

CInst::usage="CInst[C] is the capacitor with characteristic capacity C." ;

LInst::usage="LInst[L] is the inductor with characteristic value L." ;

EInst::usage="EInst[E] is the voltage source with characteristic value E." ;

RInst::usage="RInst[R] is the the resistor with characteristic value R." ;

s::usage; sig::usage;

serial::usage=
  "serial[S, Clist, s[V0,I0], s[V1,I1]] is the electrical component \
representing the serial connection of the unary components of list Clist, \
with input s[V0,I0], output s[V1,I1] and system frequency S.";

parallel::usage=
  "parallel[S, Clist, s[V0,I0], s[V1,I1]] is the electrical component \
representing the serial connection of the unary components of list Clist, \
with input s[V0,I0], output s[V1,I1] and system frequency S.";



Begin["`Private`"];



$ContextPath=Join[
	{"TypeSyntax`","TermSyntax`","Variables`",
		"RewriteRules`","RewriteRuleDefs`","Types`",
		"Terms`","Calculus`","TypeChecker`"},
		$ContextPath];







TypeConstructor[sig];



Constructor[TypeOf[s,FuncType[Cross[Real,Real],sig]]];





















DefinedFunctionSymbol[
	TypeOf[resistor,FuncType[Cross[Real,Real,sig,sig],Bool]],
	TypeOf[inductor,FuncType[Cross[Real,Real,sig,sig],Bool]],
	TypeOf[capacitor,FuncType[Cross[Real,Real,sig,sig],Bool]],
	TypeOf[source,FuncType[Cross[Real,Real,sig,sig],Bool]]
];









Def[{R,S,V0,I0,V1,I1},
	{RewriteRule[resistor[R,S,s[V0,I0],s[V1,I1]],True,
      And[eq[- V0+V1,R * I0],eq[I0,I1]]]}];







Def[{L,S,V0,I0,V1,I1},
	{RewriteRule[inductor[L,S,s[V0,I0],s[V1,I1]],True,
      And[eq[V0-V1,L*S*I0],eq[I0,I1]]]}];







Def[{C,S,V0,I0,V1,I1},
	{RewriteRule[capacitor[C,S,s[V0,I0],s[V1,I1]],True,
      And[eq[V0-V1,I0/C],eq[I0,I1]]]}];







Def[{E,S,V0,I0,V1,I1},
	{RewriteRule[source[E,S,s[V0,I0],s[V1,I1]],True,
      And[eq[V0-V1,E],eq[I0,I1]]]}];















DefinedFunctionSymbol[
	TypeOf[earth,FuncType[Cross[Real,Real,sig],Bool]]]





Def[{E,S,V1,I1},
	{RewriteRule[earth[E,S,s[V1,I1]],True,eq[V1,0]]}];













RInst[x_]:=
	Module[{S,L,R},
		\[Lambda][{S,L,R},resistor[x,S,L,R]]
	]



CInst[x_]:=
	Module[{S,L,R},
		\[Lambda][{S,L,R},capacitor[x,S,L,R]]
	]



LInst[x_]:=
	Module[{S,L,R},
		\[Lambda][{S,L,R},inductor[x,S,L,R]]
	]



EInst[x_]:=
	Module[{S,L,R},
		\[Lambda][{S,L,R},source[x,S,L,R]]
	]



















DefinedFunctionSymbol[
	TypeOf[serial,
    FuncType[Cross[Real,TyList[FuncType[Cross[Real,sig,sig],Bool]],sig,sig],
      Bool]]
	]







Def[{S,L,L1,R,C1,CS},
	{RewriteRule[serial[S,\[Bullet],L,R],True,eq[L,R]],
		RewriteRule[serial[S,Cons[C1,CS],L,R],True,
      And[eq[C1[S,L,L1],True],eq[serial[S,CS,L1,R],True]]]}];























DefinedFunctionSymbol[
	TypeOf[elJoin,FuncType[Cross[TyList[sig],Real],Real]]
	]





Def[{S,V,I0,V0,RS},
	{RewriteRule[elJoin[\[Bullet],V],0,True],
		RewriteRule[elJoin[Cons[s[V0,I0],RS],V],Plus[I0,elJoin[RS,V]],eq[V0,V]]}];















DefinedFunctionSymbol[
	TypeOf[junction,FuncType[Cross[TyList[sig],TyList[sig]],Bool]]
	]



Def[{L,R,V},
	{RewriteRule[junction[L,R],True,eq[elJoin[L,V],elJoin[R,V]]]}];





















DefinedFunctionSymbol[
	TypeOf[parallel,
    FuncType[Cross[Real,TyList[FuncType[Cross[Real,sig,sig],Bool]],sig,sig],
      Bool]]
	]







Def[{S,C,Cs,InS,OutS,InS1,OutS1,InS2,OutS2},
	{RewriteRule[parallel[S,Cons[C,\[Bullet]],InS,OutS],True,
      eq[C[S,InS,OutS],True]],
    RewriteRule[parallel[S,Cons[C,Cs],InS,OutS],True,
      And[eq[C[S,InS1,OutS1],True],eq[parallel[S,Cs,InS2,OutS2],True],
				eq[junction[Cons[InS,\[Bullet]],Cons[InS1,Cons[InS2,\[Bullet]]]],True],
				eq[junction[Cons[OutS1,Cons[OutS2,\[Bullet]]],Cons[OutS,\[Bullet]]],
          True]]]}];





On[General::spell]

End[];



EndPackage[];

