(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)


(* \[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) *)
 
(*
NO WARRANTY
 
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term "warranty"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.
 
Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.
 
Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
"use" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.
 
In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.
*)
 








BeginPackage["Calculus`",
	{"Terms`","RewriteRules`"}];



CallCFLP::usage=
  "CallCFLP[eqn | eqns, vars]\n attempts to solve an equation `eqn` or set of \
equations `eqns` for the variables `vars`.
		It is the designed to be called by TSolve and Tc." ;

CFLP::usage=
  "CFLP[eqns,cnstrs] attempts to solve the system of equations `eqns` and \
constraints `cnstrs` for the set of Temporary symbols of `eqns` and `cnstrs`. \
\n
		It is designed to be called by CallCFLP." ;

Normalize::usage=
  "Normalize[subst] gives the normalization of substitution `subst`.";

CSEnd::usage="CSEnd[ ] closes the Mathlink connections of the CFLP session.";

CSConnect::usage=
  "CSConnect[ ] creates a new Mathlink connections to the CFLP session.";

SetCSVariables::usage;

CSlink::usage=
  "CSlink gives the link object used for communication with the scheduler.";





Begin["`Private`"];

$ContextPath=
  Join[{"Variables`","TermSyntax`","TypeSyntax`","Types`"},$ContextPath];





CSConnect[ ]:=
	If[MemberQ[Links[],CSlink],
		Print["connection to scheduler is already available."],
		CSlink=LinkLaunch["math -mathlink -batchoutput -run \"<<Scheduler.m\""];
		(* wait at most 10 seconds to establish link to scheduler *)
		Block[{timer=0},
			While[Not[LinkReadyQ[CSlink]],
				If[timer++<10,
					Pause[1];Continue[],
					LinkClose[CSlink];
					Return["failed to connect to scheduler."]
				]
			]
		];
		Print["connection to scheduler established."];
		LinkWrite[CSlink,Unevaluated[EvaluatePacket[Scheduler`CSStart[]]]];
		(* wait for a return packet *)
		While[Not[LinkReadyQ[CSlink]],Continue[]];
		Print[LinkRead[CSlink]\[LeftDoubleBracket]1\[RightDoubleBracket]]
	];

CSConnect[];





CSEnd[ ]:=
	If[MemberQ[Links[],CSlink],
		LinkWrite[CSlink,Unevaluated[EvaluatePacket[CSEnd[]]]];
		LinkWrite[CSlink,Unevaluated[EvaluatePacket[Exit[]]]];
		LinkClose[CSlink];
		Print["done."],
		Print["link already disabled."]];



SetCSType[typeDownvals_]:=
	(LinkWrite[CSlink, 
				Unevaluated[EvaluatePacket[DownValues[Types`Type] = #1]; ]]&
			[typeDownvals];
		While[Not[LinkReadyQ[CSlink]],Continue[]];
		LinkRead[CSlink]
	);



SetCSgoalVars[vars_]:=
	(LinkWrite[CSlink, 
				Unevaluated[EvaluatePacket[Global`goalVar= #1];]]&
		[vars];
		While[Not[LinkReadyQ[CSlink]],Continue[]];
		LinkRead[CSlink]
	);



CSSolve[n_]:=
(LinkWrite[CSlink,
				EvaluatePacket[Scheduler`CSolve[n]]];
		While[Not[LinkReadyQ[CSlink]],Continue[]];
		LinkRead[CSlink]);



CSSchedule[]:=
	Block[{pkg,Global`Substitution,cnstr},
		LinkWrite[CSlink,
			Unevaluated[EvaluatePacket[Scheduler`Scheduler[]]]];
		While[True,
			If[Not[LinkReadyQ[CSlink]],Continue[]];
			pkg=LinkRead[CSlink];
			If[pkg===ReturnPacket["done."],
				Break[],
				{Global`Substitution,cnstr}=pkg\[LeftDoubleBracket]1\[RightDoubleBracket];
        
				AppendTo[result,ComputedAnswer[]]
				]
			]
	];



FormSubst:=If[#1===#2,EmptySequence,#1\[Rule]#2]&;





ComputedAnswer[]:=
	MapThread[FormSubst,{Global`goalVar,Global`goalVar//.Global`Substitution}];



NewCFLP[EqType_,Cs_][RewritesTo[t_,{cs1___},{cs2___}],rhs_,eqns___]:=
	Block[{Global`Substitution=Global`Substitution,saveTypes},
		CFLP[{cs1,EqType[t,rhs],cs2,eqns},Cs]];



NewCFLPImitation[EqType_,f_,X_,{params___},t_,{eqns___},Cs_]:=
	Block[
		{mapsTo,newVars=Table[Module[{x},x],{Length[{params}]}],\[Lambda]term,
			Global`Substitution=Global`Substitution},
		\[Lambda]term = Function[#1, #2]&
				[newVars,f @@ Table[Module[{H}, H @@ #]& [newVars],{Arity[f]}]];
		mapsTo=X->\[Lambda]term;
		PrependTo[Global`Substitution,mapsTo]
	];



Clear[NewCFLPProjection];
NewCFLPProjection[EqType_,X_,params_List,t_,{eqns___},Cs_]:=
	Block[{mapsTo,\[Lambda]dummy,\[Lambda]vars=Module[{x},x]& /@ params,
			\[Lambda]term,Global`Substitution=Global`Substitution},
		\[Lambda]term=Function[{x,vars},
				x @@ Table[Module[{H},H @@ vars],{i,Arity[x]}]];	
		Scan[
				(CFLP @@({{
                    EqType[t,
                      \[Lambda]term[#\[LeftDoubleBracket]2
                          \[RightDoubleBracket],params]],eqns},Cs}/.X->
                  Function @@
                     {\[Lambda]vars,
                      \[Lambda]term[#\[LeftDoubleBracket]1
                          \[RightDoubleBracket],\[Lambda]vars]}))&,
		Transpose[{\[Lambda]vars,params}]
		]
	];



EmptySequence:=Sequence[];



NewEqns[h_,s_,t_]:=
  Sequence @@ 
    Table[h[s\[LeftDoubleBracket]i\[RightDoubleBracket],
        t\[LeftDoubleBracket]i\[RightDoubleBracket]],{i,Length[s]}];



VariantsRule[f_[args___]]:=ApplyFunctionList[RewriteRuleList[f],{args}];



ApplyFunctionList[{f___},args_]:=
  Function[If[
        Length[args]==Length[#\[LeftDoubleBracket]1\[RightDoubleBracket]],
        Apply[#,args]]]/@{f};



CallCFLP[eqs_,vars_]:=
	Block[
		{Global`Substitution={},
			Global`Constraints,
			Global`goalVar=vars,
			AnswerList={},
			eqSystem,
			result={},
			CSCalled=False},
		SetVariables[vars];
		SetCSgoalVars[vars];
		SetCSType[DownValues[Type]];
		Catch[CFLP[eqs,{}]];
		If[CSCalled,CSSchedule[]];
		ClearVariables[vars];
		result
	];





CFLP[{},{}]:=
	(AppendTo[result,ComputedAnswer[]];
		If[(Global`NSolutions -= 1) == 0, Throw[1]]);

CFLP[{},Cs_]:=
	(CSCalled=True;
		LinkWrite[CSlink,
		EvaluatePacket[
			Scheduler`SetCSQuery[Var[Cs],Global`Substitution,Cs]]];
		While[Not[LinkReadyQ[CSlink]],Continue[]];
		LinkRead[CSlink]);



CFLP[{(eq[FuncType[\[Placeholder],\[Tau]1_],\[Tau]2_]
		|eq[\[Tau]1_,FuncType[\[Placeholder],\[Tau]2_]]),eqns___},Cs_]:=
	CFLP[{eq[\[Tau]1,\[Tau]2],eqns},Cs];



CFLP[{Or[or\[Dash]eq_,or\[Dash]eqs__],eqns___},Cs_]:=
	Scan[
		Block[
			{Global`Substitution=Global`Substitution},
				CFLP[{#,eqns},Cs]]&,
		{or\[Dash]eq,or\[Dash]eqs}];



CFLP[{And[and\[Dash]eq_,and\[Dash]eqs__],eqns___},Cs_]:=
	CFLP[{and\[Dash]eq,and\[Dash]eqs,eqns},Cs];



CFLP[{Mark[e_],eqns___},Cs_]:=
	CFLP[{eqns},Append[Cs,e]];



CFLP[{(eq|ppeq)[x_?IsVar,y_?IsVar],eqns___},Cs_]:=
	If[x===y,
		CFLP[{eqns},Cs],
		Block[{mapsTo=x\[Rule]y},
			PrependTo[Global`Substitution,mapsTo];
			CFLP[{eqns}/.mapsTo,Cs /.mapsTo]]
	];



CFLP[{ppeq[s_,x_?IsVar]|ppeq[x_?IsVar,s_],eqns___},Cs_]:=
	Block[{mapsTo=x\[Rule]s },
		PrependTo[Global`Substitution,mapsTo];
		CFLP[{eqns}/.mapsTo,Cs /.mapsTo]
	];



CFLP[{EqType_[s_?IsFunctionTerm,t_],eqns___},Cs_]:=
	Scan[NewCFLP[EqType,Cs][#1,t,eqns]&,VariantsRule[s]];
CFLP[{eq[s_,t_?IsFunctionTerm],eqns___},Cs_]:=
	Scan[NewCFLP[eq,Cs][#1,s,eqns]&,VariantsRule[t]];



CFLP[{EqType_[\[Lambda][\[Lambda]args_List,body_][\[Lambda]params___],t_],
      eqns___},Cs_]:=
	CFLP[{EqType[Function[\[Lambda]args,body][\[Lambda]params],t],eqns},Cs];
CFLP[{EqType_[t_,\[Lambda][\[Lambda]args_List,body_][\[Lambda]params___]],
      eqns___},Cs_]:=
	CFLP[{EqType[Function[\[Lambda]args,body][\[Lambda]params],t],eqns},Cs];



CFLP[
	{EqType_[X_?IsVar[params__],t_?IsNotFlex]
	|EqType_[t_?IsNotFlex,X_?IsVar[params__]],eqns___},
	Cs_]:=
	Block[{symbList=Select[$FunctionSymbol,(Arity[#]==Length[{params}])&]},
		Scan[NewCFLPImitation[EqType,#,X,{params},t,{eqns},Cs]&,symbList];
		NewCFLPProjection[EqType,X,{params},t,{eqns},Cs]
	];



CFLP[{eq[x_?IsVar,s_AtomQ]|eq[s_AtomQ,x_?IsVar],eqns___},Cs_]:=
	Block[{mapsTo=x->s},
		PrependTo[Global`Substitution,mapsTo];
		CFLP[{eqns}/.mapsTo,Cs/.mapsTo]
	];

CFLP[{eq[x_?IsVar,s_]|eq[s_,x_?IsVar],eqns___},Cs_]:=
	If[Not[MemberQ[s,x,-1]],
		Block[{cs=NewC/@ s,mapsTo},
			mapsTo=x->cs;
			PrependTo[Global`Substitution,mapsTo];
			CFLP[{NewEqns[eq,s,cs],eqns}/.mapsTo,Cs/.mapsTo]]
	];



CFLP[{EqType_[\[Lambda][{xs__},s_],\[Lambda][{ys__},t_]],eqns___},Cs_]:=
	CFLP[{EqType[Function[#1,s] @@ #3,Function[#2,t] @@ #3]&[{xs},{ys},
        NewX /@ {xs}],eqns},Cs];



CFLP[{_[s_?AtomQ,t_?IsConstructorTerm]
	|_[t_?IsConstructorTerm,s_?AtomQ],eqns___},Cs_]:=
	If[t===s\[Or](s=!=Symbol\[And]t===s[]),CFLP[{eqns},Cs]];
CFLP[{EqType_[(f_?IsConstructor)[fargs___],(g_?IsConstructor)[gargs___]],
      eqns___},Cs_]:=
	If[f===g\[And]Length[{fargs}]==Length[{gargs}],
		Block[{NewGoal=NewEqns[EqType,{fargs},{gargs}]},
			CFLP[{NewEqns[EqType,{fargs},{gargs}],eqns},Cs]
		]
	];



CFLP[{eq[\[Phi]_?IsExternal[args1__],\[Psi]_?IsExternal[args2__]],eqns___},
    Cs_]:=
		Function[CFLP[{NewEqns[eq,{args1},#1],NewEqns[eq,{args2},#2],
				Mark[eq[\[Phi] @@ #1 ,\[Psi] @@ #2]],eqns},Cs]][NewX/@ {args1},
    NewY/@ {args2}];

CFLP[{_[\[Phi]_?IsExternal[args__],t_],eqns___},Cs_]:=
	Function[CFLP[{NewEqns[eq,{args},#],Mark[eq[\[Phi] @@ #,t]],eqns},Cs]][
    NewX/@{args}];

CFLP[{eq[t_,\[Phi]_[args__]],eqns___},Cs_]/;IsExternal[\[Phi]]:=
		Function[CFLP[{NewEqns[eq,{args},#],Mark[\[Phi] @@ eq[#,t]],eqns},Cs]][
    NewX/@ {args}];



End[];

EndPackage[];
