(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     15795,        558]*)
(*NotebookOutlinePosition[     16605,        586]*)
(*  CellTagsIndexPosition[     16561,        582]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Variables", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[{
  "This package contains commands for handling object variables. In our \
setting, an object variable is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol with the list of attributes {",
  StyleBox["Temporary",
    FontFamily->"Courier"],
  "}."
}], "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Variables`\>", {"\<Types`\>"}]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Off[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Var::usage = 
      "\<Var[expr] picks out all symbols of expr for which the attribute \
Temporary is set.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsVar::usage = 
      "\<IsVar[term] yields True is a symbol which has the list of attributes \
{Temporary}, and yields False otherwise.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SetVariables::usage = 
      "\<SetVariables[list] sets the list of attributes of the symbols of \
list to {Temporary}.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(ClearVariables::usage = 
      "\<ClearVariables[list] sets the list of attributes of the symbols of \
list to {}.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(NewX::usage = 
      "\<NewX[ ] returns a new Temporary symbol of the form x$nnn\>"\ ; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(NewY::usage = 
      "\<NewY[ ] returns a new Temporary symbol of the form y$nnn\>"\ ; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(NewC::usage = 
      "\<NewC[ ] returns a new Temporary symbol of the form c$nnn\>"\ ; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["NewX, NewY, NewC", "Section"],

Cell[TextData[{
  StyleBox["Syntax calls\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["NewX[ ];\n\tNewY[ ];\n\tNewC[ ];",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "NewX[ ] returns a ",
  StyleBox["Temporary",
    FontFamily->"Fixed"],
  " variant of symbol x\n\tNewY[ ] returns a ",
  StyleBox["Temporary",
    FontFamily->"Fixed"],
  " variant of symbol y\n\tNewC[ ] returns a ",
  StyleBox["Temporary",
    FontFamily->"Fixed"],
  " variant of symbol c\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(NewX := Function[Module[{x}, x]]; \nNewY := Function[Module[{y}, y]]; \n
    NewC := Function[Module[{z}, z]]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsVar", "Section"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsVar[ ",
    FontWeight->"Bold"],
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta term ",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["t ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a symbol with attribute ",
  StyleBox["Temporary",
    FontFamily->"Courier"],
  "\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(IsVar[x_]\  := \n\t
      If[Head[x]\  === \ Symbol, \n\t\tAttributes[x]\  === \ {Temporary}, \ \n
        \t\tFalse]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Var", "Section"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tVar[ ",
    FontWeight->"Bold"],
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  : a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tthe list of variables of ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " (i.e. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbols with attribute ",
  StyleBox["Temporary)",
    FontFamily->"Courier"],
  "\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(Var[x_] := Union\ [Cases[{x}, _Symbol?IsVar, \(-1\)]]; \)\)], "Input",\

  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetVariables", "Section"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tSetVariables[{ ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["}]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta list of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  symbols or type annotated symbols\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tdeclare variables ",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  ", i.e. set their list of attributes to {",
  StyleBox["Temporary",
    FontFamily->"Courier"],
  "}\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["{",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["}",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(SetVariables[l_List] := Join@@\ \(SetVariables\ /@\ l\); \n
    SetVariables[v_Symbol] := \((Attributes[v] = {Temporary}; {v})\); \n
    SetVariables[TypeOf[v_Symbol, \[Tau]_]] := \n\t
      If[DeclareType[TypeOf[v, \[Tau]]] =!= {}, \n\t\t
        Attributes[v] = {Temporary}; \n\t\t
        Type[v] = FormTypeExpr[{}, \(Type[v]\)[]]; \n\t\t{v}, \n\t\t{}]; \)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClearVariables", "Section"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tClearVariables[{",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["}]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta list of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  symbols\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tundeclare the variables ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  ", i.e. set their list of attributes to {",
  StyleBox[" ",
    FontFamily->"Courier"],
  "}\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["{",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_1\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\_n\),
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["}",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(ClearVariables[{vars___Symbol}] := \n\t
      Function[Attributes[#] = {}; EraseType[#]; #]\ /@\ {vars}; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(On[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{741, 600},
WindowMargins->{{Automatic, 102}, {125, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 65, 1, 104, "Title"],
Cell[1799, 54, 171, 4, 27, "Input",
  InitializationCell->True],
Cell[1973, 60, 3225, 63, 683, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5223, 127, 39, 0, 54, "Subtitle"],
Cell[5265, 129, 291, 9, 50, "Text"],
Cell[5559, 140, 207, 5, 27, "Input",
  InitializationCell->True],
Cell[5769, 147, 131, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5925, 154, 27, 0, 45, "Subsection"],
Cell[5955, 156, 217, 5, 43, "Input",
  InitializationCell->True],
Cell[6175, 163, 245, 5, 43, "Input",
  InitializationCell->True],
Cell[6423, 170, 230, 5, 43, "Input",
  InitializationCell->True],
Cell[6656, 177, 225, 5, 43, "Input",
  InitializationCell->True],
Cell[6884, 184, 196, 5, 27, "Input",
  InitializationCell->True],
Cell[7083, 191, 196, 5, 27, "Input",
  InitializationCell->True],
Cell[7282, 198, 196, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7527, 209, 34, 0, 54, "Subtitle"],

Cell[CellGroupData[{
Cell[7586, 213, 35, 0, 52, "Section"],
Cell[7624, 215, 703, 26, 176, "Text"],
Cell[8330, 243, 211, 4, 59, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8578, 252, 24, 0, 52, "Section"],
Cell[8605, 254, 183, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8825, 264, 24, 0, 52, "Section"],
Cell[8852, 266, 871, 40, 158, "Text"],
Cell[9726, 308, 223, 5, 75, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9986, 318, 22, 0, 52, "Section"],
Cell[10011, 320, 847, 37, 140, "Text"],
Cell[10861, 359, 161, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[11059, 368, 31, 0, 52, "Section"],
Cell[11093, 370, 1721, 68, 176, "Text"],
Cell[12817, 440, 460, 9, 139, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[13314, 454, 33, 0, 52, "Section"],
Cell[13350, 456, 1653, 66, 176, "Text"],
Cell[15006, 524, 212, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[15255, 534, 22, 0, 52, "Section"],
Cell[15280, 536, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[15449, 543, 130, 3, 27, "Input",
  InitializationCell->True],
Cell[15582, 548, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

