(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     29289,       1035]*)
(*NotebookOutlinePosition[     30099,       1063]*)
(*  CellTagsIndexPosition[     30055,       1059]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Types", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["This package contains commands for handling types. ", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Types`\>", {"\<TypeSyntax`\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(TypeConstructor::usage = 
      "\<TypeConstructor[constr1, constr2, \[Ellipsis] ] declares the symbols \
constr1, constr2, \[Ellipsis] as type constructors.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(FormTypeExpr::usage = 
      \*"\"\<FormTypeExpr[type-vars, type] yields the encoding of the \
polymorphic type \!\(\[ForAll] \_\(type - vars\)\) type.\>\""; \)\)], "Input",\

  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(DeclareType::usage = 
      "\<DeclareType[symbol1\[Proportion]type1, symbol2\[Proportion]type2, \
\[Ellipsis] ] assigns the encoding of the polymorphic type specified by typei \
to the value of Type[symboli], and yields the list {symbol1, symbol2, \
\[Ellipsis] }.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EraseType::usage = 
      "\<EraseType[symbol1, symbol2, \[Ellipsis] ] clears types for the \
symboli.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TyVars::usage = 
      "\<TyVars[type] picks out all type variables of type, i.e. all symbols \
which are not type constructors\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsTypeConstructor::usage = 
      "\<IsTypeConstructor[term] yields True if term is a declared type \
constructor, and yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsConstructor::usage = 
      "\<IsConstructor[term] yields True if term is a declared constructor, \
and yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsTyped::usage = 
      "\<IsTyped[symb] yields True if symb is a typed operator or a typed \
variable, and yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsFunType::usage = 
      "\<IsFunType[type] yields True if type is a function type, and yields \
False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsFunOnCPType::usage = 
      "\<IsFunOnCPType[type] yields True if type is a function type defined \
on a Cartesian product, and yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Bool::usage = 
      "\<Bool denotes the type of booleans with the constants True and False.\
\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Int::usage = "\<Int denotes the type of integers.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(\[Placeholder]::usage = 
      "\<\[Placeholder] denotes the void type.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Type::usage = 
      "\<Type[symb][ ] yields a valid type instance of the type of symbol \
symb.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TypeCheck::usage = 
      "\<TypeCheck is an option to TSolve. With TypeCheck->True, type \
checking is imposed on the specified CRRs of a Def or TSolve call, and on the \
goal of a TSolve call. With TypeCheck->False, the decision to perform type \
checking is determined by the default option of TSolve.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["TypeConstructor", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTypeConstructor",
    FontWeight->"Bold"],
  "[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  "]\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a sequence  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  " of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbols\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the list {  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  "}\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tdeclare   ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  " as type constructors by extending the default definition of ",
  StyleBox["IsTypeConstructor\n\t",
    FontWeight->"Bold"],
  "declare   ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  " as constructors by extending the default definition of ",
  StyleBox["IsConstructor",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Clear[TypeConstructor]; \n
    TypeConstructor[c_Symbol] := \n\t
      Block[{}, \n\t\tIsTypeConstructor[c] = True; \n\t\t
        IsConstructor[c] = True; {c}\n\t]; \nTypeConstructor[_] := {}; \n
    TypeConstructor[cs__Symbol] := Join\ @@\ \(TypeConstructor\ /@\ {cs}\); 
    \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsTyped", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsTyped[ ",
    FontWeight->"Bold"],
  StyleBox["term ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["\tterm",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a typed symbol, i.e. a typed variable or a typed operator\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Clear[IsTyped]; \n
    IsTyped[x_]\  := \ 
      \(Type[x]\)\[LeftDoubleBracket]0\[RightDoubleBracket] =!= Type; \)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["TyVars",
  FontWeight->"Bold"]], "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTyVars[\[Tau]]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a type expression\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the set ",
  Cell[BoxData[
      \({\[Alpha]\_1, ..., \[Alpha]\_n}\)]],
  "of type variables appearing in ",
  StyleBox["\[Tau];\n\t",
    FontWeight->"Bold"],
  "type variable is any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol which is not a declared type constructor\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(TyVars[\[Tau]_] := 
      Union\ [Cases[{\[Tau]}, _Symbol?\((Not[IsTypeConstructor[#]]&)\), 
          \(-1\)]]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FormTypeExpr", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["FormTypeExpr[ type\[Dash]vars, \[Tau] ] ",
    FontWeight->"Bold"],
  StyleBox["\t\nInput",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold"],
  Cell[BoxData[
      StyleBox[GridBox[{
            {
              StyleBox["type\[Dash]vars",
                FontWeight->"Bold"], ":", 
              \(a\ set\ {\[Alpha]\_1, ..., \[Alpha]\_n}\ of\ type\ variables
                \)},
            {
              StyleBox["\[Tau]",
                FontWeight->"Bold"], 
              StyleBox[":",
                "NumberedTable"], 
              RowBox[{
                StyleBox["a",
                  "NumberedTable"], " ", "type", " ", "expression"}]}
            }],
        "NumberedTable"]]],
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "an object ",
  StyleBox["F",
    FontWeight->"Bold"],
  " such that every call ",
  StyleBox["F[ ] ",
    FontWeight->"Bold"],
  "returns a pair {",
  StyleBox["type\[Dash]vars', \[Tau]'}",
    FontWeight->"Bold"],
  " where \n\t",
  Cell[BoxData[
      StyleBox[GridBox[{
            {
              StyleBox[\(type - vars'\),
                "NumberedTable",
                FontWeight->"Bold"], ":", 
              \(a\ set\ {\[Alpha]\_1', ..., \[Alpha]\_n'}\ \ of\ \ fresh\ type
                \ variables\)},
            {
              StyleBox[\(\[Tau]'\),
                FontWeight->"Bold"], 
              StyleBox[":",
                "NumberedTable"], 
              RowBox[{
                StyleBox["the",
                  "NumberedTable"], " ", "type", " ", "expression", " ", 
                StyleBox["\[Tau]",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                \({\[Alpha]\_1 \[RightTeeArrow] \[Alpha]\_1', ..., 
                  \[Alpha]\_n \[RightTeeArrow] \[Alpha]\_n'}\)}]}
            }],
        "NumberedTable"]]],
  "\n",
  StyleBox["Usage\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["F",
    FontWeight->"Bold"],
  " is the encoding of the polymorphic type ",
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \_{\[Alpha]\_1, ..., \[Alpha]\_n}\)]],
  StyleBox["\[Tau]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " .\n\tIt can be used for generating valid instances of polymorphic type \
expressions during type checking  (",
  StyleBox["Tc",
    FontWeight->"Bold"],
  " and ",
  StyleBox["TcX ",
    FontWeight->"Bold"],
  "calls).\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(FormTypeExpr[type\[Dash]vars_List, \[Tau]_] := \n\t
      Function[{}, \n\t\tModule[type\[Dash]vars, {type\[Dash]vars, \[Tau]}]\n
        \t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DeclareType", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDeclareType[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  StyleBox["\[Proportion]",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], "1"], TraditionalForm]]],
  StyleBox[", ... ,",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["\[Proportion]",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tA sequence of type signatures  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " ",
  StyleBox["\[Proportion]",
    FontSize->13],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["\[Tau]",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["i",
              FontWeight->"Bold"]]}], TraditionalForm]]],
  " ( 1 \[LessEqual] i \[LessEqual] ",
  StyleBox["n",
    FontWeight->"Bold"],
  " )\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "The list {",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  ",. .. ,",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], "n"], TraditionalForm]]],
  "} of declared function symbols\n",
  StyleBox["Side Effect\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "assign the (polymorphic) type ",
  Cell[BoxData[
      \(TraditionalForm\`\[ForAll] \)]],
  Cell[BoxData[
      \(TraditionalForm\`\[Tau]\_i\)]],
  " to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " ( 1 \[LessEqual] i \[LessEqual] ",
  StyleBox["n",
    FontWeight->"Bold"],
  " )\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(DeclareType[TypeOf[f_, \[Tau]_]] := 
      Block[{}, \n\t\t
        If[IsTyped[f], Print["\<Type of \>", \ f, \ "\< already defined\>"], 
          \n\t\t\tType[f] = FormTypeExpr[TyVars[\[Tau]], \[Tau]]]; {f}\n\t]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(DeclareType[fs___TypeOf] := Join\ @@\ \(DeclareType\ /@\ {fs}\); 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(DeclareType[fs___] := 
      \((Print["\<Warning: DeclareType: wrong syntax call\>"]; {})\); \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EraseType", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tEraseType[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  StyleBox[", ... ,",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tA sequence of symbols  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  "  ( 1 \[LessEqual] i \[LessEqual] ",
  StyleBox["n",
    FontWeight->"Bold"],
  " )\n",
  StyleBox["Effect\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "remove the  type information  attached to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " ( 1 \[LessEqual] i \[LessEqual] ",
  StyleBox["n",
    FontWeight->"Bold"],
  " )\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(EraseType[x_]\  := If[IsTyped[x], Type[x] =. ]; \n
    EraseType[xs___]\  := Scan[EraseType, {xs}]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsTypeConstructor", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsTypeConstructor[ ",
    FontWeight->"Bold"],
  StyleBox["term ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["\tterm",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a declared type constructor\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(IsTypeConstructor[_] := False; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsFunType", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsFunType[ \[Tau]",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  " : a type expression",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  "  is of the form ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox["\[RightArrow]",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold"], 
          StyleBox["2",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "(i.e. a function type)\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(IsFunType[\[Tau]_FuncType] := True; \nIsFunType[_] := False; \)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsFunOnCPType", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsFunOnCPType[ \[Tau] ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  " : a type expression",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  "  is of the form  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], "1"], TraditionalForm]]],
  " \[Cross] \[CenterEllipsis] \[Cross] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], "n"], TraditionalForm]]],
  "\[ShortRightArrow] ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Tau]'\),
          FontWeight->"Bold"], TraditionalForm]]],
  " ( i.e. a Cartesian product)\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(IsFunOnCPType[\[Tau]_] := \ 
      And[IsFunType[\[Tau]], 
        \[Tau]\[LeftDoubleBracket]1, 0\[RightDoubleBracket] === Cross]; \)\)],
   "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{520, 600},
WindowMargins->{{267, Automatic}, {131, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 61, 1, 104, "Title"],
Cell[1795, 54, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[1969, 60, 3225, 63, 1083, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5219, 127, 39, 0, 54, "Subtitle"],
Cell[5261, 129, 67, 0, 32, "Text"],
Cell[5331, 131, 153, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5509, 138, 27, 0, 45, "Subsection"],
Cell[5539, 140, 266, 5, 59, "Input",
  InitializationCell->True],
Cell[5808, 147, 264, 6, 44, "Input",
  InitializationCell->True],
Cell[6075, 155, 376, 7, 75, "Input",
  InitializationCell->True],
Cell[6454, 164, 211, 5, 43, "Input",
  InitializationCell->True],
Cell[6668, 171, 238, 5, 43, "Input",
  InitializationCell->True],
Cell[6909, 178, 253, 5, 59, "Input",
  InitializationCell->True],
Cell[7165, 185, 240, 5, 59, "Input",
  InitializationCell->True],
Cell[7408, 192, 242, 5, 59, "Input",
  InitializationCell->True],
Cell[7653, 199, 225, 5, 43, "Input",
  InitializationCell->True],
Cell[7881, 206, 264, 5, 59, "Input",
  InitializationCell->True],
Cell[8148, 213, 203, 5, 43, "Input",
  InitializationCell->True],
Cell[8354, 220, 158, 3, 27, "Input",
  InitializationCell->True],
Cell[8515, 225, 182, 4, 27, "Input",
  InitializationCell->True],
Cell[8700, 231, 207, 5, 43, "Input",
  InitializationCell->True],
Cell[8910, 238, 413, 7, 107, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9372, 251, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[9431, 255, 24, 0, 52, "Section"],
Cell[9458, 257, 128, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[9611, 264, 37, 0, 45, "Subsection"],
Cell[9651, 266, 2636, 101, 230, "Text"],
Cell[12290, 369, 457, 11, 155, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[12784, 385, 29, 0, 45, "Subsection"],
Cell[12816, 387, 927, 39, 158, "Text"],
Cell[13746, 428, 295, 9, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[14078, 442, 70, 1, 45, "Subsection"],
Cell[14151, 445, 833, 32, 158, "Text"],
Cell[14987, 479, 296, 8, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[15320, 492, 34, 0, 45, "Subsection"],
Cell[15357, 494, 2732, 90, 254, "Text"],
Cell[18092, 586, 247, 5, 75, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[18376, 596, 33, 0, 45, "Subsection"],
Cell[18412, 598, 3092, 116, 177, "Text"],
Cell[21507, 716, 403, 10, 75, "Input",
  InitializationCell->True],
Cell[21913, 728, 253, 7, 27, "Input",
  InitializationCell->True],
Cell[22169, 737, 279, 8, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[22485, 750, 31, 0, 45, "Subsection"],
Cell[22519, 752, 1633, 62, 140, "Text"],
Cell[24155, 816, 279, 7, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[24471, 828, 39, 0, 45, "Subsection"],
Cell[24513, 830, 907, 39, 158, "Text"],
Cell[25423, 871, 214, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[25674, 882, 31, 0, 45, "Subsection"],
Cell[25708, 884, 1321, 54, 158, "Text"],
Cell[27032, 940, 243, 7, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[27312, 952, 35, 0, 45, "Subsection"],
Cell[27350, 954, 1273, 49, 158, "Text"],
Cell[28626, 1005, 317, 9, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28992, 1020, 22, 0, 52, "Section"],
Cell[29017, 1022, 111, 3, 27, "Input",
  InitializationCell->True],
Cell[29131, 1027, 118, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

