(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9174,        283]*)
(*NotebookOutlinePosition[      9984,        311]*)
(*  CellTagsIndexPosition[      9940,        307]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Type Syntax", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains syntax definitions for type expressions and \
type signatures.\
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<TypeSyntax`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(TypeOf::usage = 
      "\<TypeOf[symb,type] is the full form representation of the type \
declaration symb\[Proportion]type.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(FuncType::usage = 
      "\<FuncType[type1,type2] is the full form representation of the type \
expression type1 \[ShortRightArrow] type2\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TyList::usage = 
      "\<TyList[type] is the type of CFLP lists with elements of type \
type.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["TypeOf", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[RowBox[{x_, "\<\[Proportion]\>", \[Tau]_}], 
        StandardForm] := 
      MakeExpression[
        RowBox[{"\<TypeOf\>", "\<[\>", x, "\<,\>", \[Tau], "\<]\>"}], 
        StandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(TypeOf\  /: \ MakeBoxes[TypeOf[x_, \ \[Tau]_], \ StandardForm]\  := \n
      RowBox[\ {MakeBoxes[x, \ StandardForm], \n\ "\<\[Proportion]\>", \ 
          MakeBoxes[\[Tau], \ StandardForm]}\ ]\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FuncType", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[
        RowBox[{\[Tau]1_, "\<\[ShortRightArrow]\>", \[Tau]2_}], StandardForm]
         := MakeExpression[
        RowBox[{"\<FuncType\>", "\<[\>", \[Tau]1, "\<,\>", \[Tau]2, 
            "\<]\>"}], StandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(FuncType\  /: \ 
      MakeBoxes[FuncType[\[Tau]1_, \ \[Tau]2_], \ StandardForm]\  := \n
      RowBox[\ {MakeBoxes[\[Tau]1, \ StandardForm], \n\ 
          "\<\[ShortRightArrow]\>", \ MakeBoxes[\[Tau]2, \ StandardForm]}\ ]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Additional definition ", "Subsubsection"],

Cell[BoxData[
    \(\(FuncType[TypeOf[f_, \[Tau]1_], \[Tau]2_]\  := \ 
      TypeOf[f, FuncType[\[Tau]1, \[Tau]2]]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{681, 600},
WindowMargins->{{245, Automatic}, {156, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 67, 1, 104, "Title"],
Cell[1801, 54, 171, 4, 27, "Input",
  InitializationCell->True],
Cell[1975, 60, 3225, 63, 683, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5225, 127, 39, 0, 54, "Subtitle"],
Cell[5267, 129, 108, 3, 32, "Text"],
Cell[5378, 134, 192, 5, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5595, 143, 27, 0, 45, "Subsection"],
Cell[5625, 145, 235, 5, 43, "Input",
  InitializationCell->True],
Cell[5863, 152, 248, 5, 43, "Input",
  InitializationCell->True],
Cell[6114, 159, 205, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6368, 170, 34, 0, 54, "Subtitle"],

Cell[CellGroupData[{
Cell[6427, 174, 24, 0, 52, "Section"],
Cell[6454, 176, 128, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[6607, 183, 28, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[6660, 187, 47, 0, 42, "Subsubsection"],
Cell[6710, 189, 306, 7, 59, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7053, 201, 43, 0, 42, "Subsubsection"],
Cell[7099, 203, 371, 8, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7519, 217, 30, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[7574, 221, 47, 0, 42, "Subsubsection"],
Cell[7624, 223, 333, 7, 59, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7994, 235, 43, 0, 42, "Subsubsection"],
Cell[8040, 237, 333, 7, 59, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8410, 249, 47, 0, 42, "Subsubsection"],
Cell[8460, 251, 198, 4, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8719, 262, 22, 0, 52, "Section"],
Cell[8744, 264, 190, 6, 27, "Input",
  InitializationCell->True],
Cell[8937, 272, 197, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

