(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32477,        941]*)
(*NotebookOutlinePosition[     33148,        965]*)
(*  CellTagsIndexPosition[     33104,        961]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Type Checker\.07\.07", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[
"This package contains the implementation of the type checker used by the \
CFLP calculus. The type checker is based on the Hindley\[Dash]Milner type \
system."], "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<TypeChecker`\>", \n\t{"\<Calculus`\>"}]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(Tc::usage = 
      "\<Tc[term] yields the type of term if term is well typed, and yields \
\[UpTee] otherwise.\>"\ ; \n
    TcX::usage = 
      "\<TcX[term,type,type\[Dash]eqs,type\[Dash]vars] yields a pair {new\
\[Dash]type\[Dash]eqs,new\[Dash]type\[Dash]vars} for which the following \
assertions are equivalent\n
		\t\t1.term has type type and the type sharing equations type\[Dash]eqs in \
variables type\[Dash]vars hold,\n
		\t\t2.the type sharing equations new\[Dash]type\[Dash]eqs in variables new\
\[Dash]type\[Dash]vars hold.\>"\ ; \n
    TcXList::usage = 
      "\<TcXList[{term1,term2,\[Ellipsis]},{type1,type2,\[Ellipsis]},type\
\[Dash]eqs,type\[Dash]vars] yields a pair \
{new\[Dash]type\[Dash]eqs,new\[Dash]type\[Dash]vars} for which the following \
assertions are equivalent\n
		\t\t1.term1 has type type1, term2 has type type2, \[Ellipsis], 
		and the type sharing equations type\[Dash]eqs in variables type\[Dash]vars \
hold,\n
		\t\t2.the type sharing equations new\[Dash]type\[Dash]eqs in variables new\
\[Dash]type\[Dash]vars hold.\>"\ ; \n
    ListToCons::usage = 
      "\<ListToCons[term] substitutes in term all lists that are not formal \
arguments to \[Lambda]-terms with their corresponding CFLP encodings. The \
CFLP encoding of a list {a,b,\[Ellipsis],z} is \
Cons[a,Cons[\[Ellipsis],Cons[z,\[Bullet]]\[Ellipsis]]] with the wisual \
representation \[LeftAngleBracket]a,b,\[Ellipsis],z,\[Bullet]\
\[RightAngleBracket]\>"; \n
    NewTyVar::usage = "\<NewTyVar[] creates a fresh type variable.\>"; \)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($ContextPath = \n\t
      Join[\n\t\t{"\<Variables`\>", "\<TermSyntax`\>", "\<TypeSyntax`\>", \n
          \t\t\t"\<Types`\>", "\<RewriteRules`\>", "\<Terms`\>"}, \n
        \t\t$ContextPath]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["NewTyVar", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tNewTyVar",
    FontWeight->"Bold"],
  "[ ",
  StyleBox[" ",
    FontWeight->"Bold"],
  "]\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a fresh type variable\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(NewTyVar\  := \ Function[Module[{Global`\[Alpha]}, Global`\[Alpha]]]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tc", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTc",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "]\n",
  StyleBox["Input\n\tterm",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the type of  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  " if ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is well typed\n\t\"\[UpTee]\" otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(Tc[t_]\  := \ \n\t
      Module[\n\t\t{sol, teqn, tvar, \n\t\t\tsaveType = DownValues[Type], \n
          \t\t\t\[Beta] = NewTyVar[]}, \n
        \t\t{teqn, tvar} = TcX\ [t, \[Beta], {}, {\[Beta]}]; \n\t\t
        DownValues[Type] = saveType; \n\t\t
        sol = Block[{Global`NSolutions = 2}, \n\t\t\t\tCallCFLP[teqn, tvar]\n
            \t\t\t]; \n\t\t
        If[sol =!= {}, 
          \[Beta] //. sol\[LeftDoubleBracket]1\[RightDoubleBracket], 
          "\<\[UpTee]\>"]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TcX", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTcX",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  \[Tau] ",
    FontWeight->"Bold"],
  ",  ",
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  ",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[GridBox[{
          {
            StyleBox["term",
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", \(a\ term\)},
          {
            StyleBox["\[Tau]",
              FontWeight->"Bold"], ":", 
            RowBox[{"the", "  ", "expected", " ", "type", " ", "of", " ", 
              StyleBox["t",
                FontWeight->"Bold"]}]},
          {
            StyleBox["type\[Dash]eqs",
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", 
            \(a\ list\ of\ equalities\ representing\ the\ type\ sharing\ 
              constraints\ \n
            collected\ so\ far\)},
          {
            StyleBox["type\[Dash]vars",
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", 
            RowBox[{
            "the", " ", "list", " ", "of", " ", "type", " ", "variables", " ",
               "appearing", " ", "in", " ", 
              StyleBox["type\[Dash]eqs",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}
          }]]],
  "\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a pair  ",
  StyleBox["{",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["', ",
    FontWeight->"Bold"],
  "type\[Dash]vars",
  StyleBox["'}",
    FontWeight->"Bold"],
  "  where\n\t\t",
  Cell[BoxData[GridBox[{
          {
            RowBox[{
              StyleBox["type\[Dash]eqs",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox["'",
                FontWeight->"Bold"]}], ":", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["type\[Dash]eqs",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox["\[Union]",
                    FontWeight->"Bold"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["type\[Dash]eqs",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontWeight->"Bold"]}], 
                    StyleBox["'",
                      FontWeight->"Bold"]}]}], 
                StyleBox[",",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                RowBox[{
                  StyleBox["where",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["type\[Dash]eqs",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontWeight->"Plain"]}], 
                    StyleBox["'",
                      FontWeight->"Plain"]}], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["are",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["the",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["type",
                    FontWeight->"Plain"]}]}], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["\n",
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox["sharing",
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                StyleBox["constraints",
                  FontWeight->"Plain"], 
                StyleBox["  ",
                  FontWeight->"Bold"], 
                StyleBox["collected",
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                StyleBox["by",
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                StyleBox["imposing",
                  FontWeight->"Plain"], 
                StyleBox["  ",
                  FontWeight->"Plain"], 
                StyleBox["type",
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                StyleBox["\[Tau]",
                  FontWeight->"Bold"], " ", "for", " ", 
                StyleBox["t",
                  FontWeight->"Bold"]}]}]},
          {
            RowBox[{
              StyleBox["type\[Dash]vars",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox["'",
                FontWeight->"Bold"]}], ":", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["type\[Dash]vars",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], "\[Union]", 
                  RowBox[{
                    RowBox[{
                      StyleBox["type\[Dash]vars",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontWeight->"Bold"]}], 
                    StyleBox["'",
                      FontWeight->"Bold"]}]}], ",", " ", 
                RowBox[{"where", " ", 
                  RowBox[{
                    RowBox[{
                      StyleBox["type\[Dash]vars",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontWeight->"Bold"]}], 
                    StyleBox["'",
                      FontWeight->"Bold"]}], " ", "are", " ", "the", " ", 
                  "type"}]}], " ", "\n", 
              RowBox[{
              "new", " ", "variables", " ", "introduced", " ", "in", " ", 
                RowBox[{
                  RowBox[{
                    StyleBox["type\[Dash]eqs",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "'"}], "'"}]}]}]}
          }]]],
  "\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[{
    \( (*\ variables\ *) \n
    TcX[x_?IsVar, \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      If[IsTyped[x], \n\t\t
        \(Type[x]\)[] /. {\[Alpha]v_, \[Tau]1_} :> {
              Append[\[Tau]eqn, eq[\[Tau]1, \[Tau]]], 
              \[Alpha]v \[Union] \[Alpha]var}, \n\t\t
        Type[x] = FormTypeExpr[{}, \[Tau]]; \n\t\t{\[Tau]eqn, \[Alpha]var}]; 
    \t\t\n (*\ constant\ literals\ *) \n
    TcX[_Real | _Integer, \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := {
        Append[\[Tau]eqn, eq[Real, \[Tau]]], \[Alpha]var}; 
    \n (*\ TcX[_Integer, \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := {
          Append[\[Tau]eqn, eq[Int, \[Tau]]], \[Alpha]var}; \ *) \n (*\ 
      function\ symbol\ or\ symbol\ literal\ *) \n
    TcX[x_Symbol, \[Tau]_, \[Tau]eqn_, \[Alpha]var_]\  := \n\t
      Block[{\[Tau]expr, \[Alpha]v = {}}, \n
        \t\t{Append[\[Tau]eqn, 
            eq[If[IsTyped[x], {\[Alpha]v, \[Tau]expr} = \(Type[x]\)[]; 
                \[Tau]expr, Symbol], \[Tau]]], \n\t\t\t\t
          \[Alpha]var \[Union] \[Alpha]v}\n\t]; 
    \n (*\ \[Lambda] - terms\ *) \n
    TcX[\[Lambda][{___, x_, ___, x_, ___}, t_], \[Tau]_, \[Tau]eqn_, 
        \[Alpha]var_] := {{eq[Int, Bool]}, {}}; \n
    TcX[\[Lambda][x_Symbol, t_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := 
      TcX[\[Lambda][{x}, t], \[Tau], \[Tau]eqn, \[Alpha]var]; \n
    TcX[\[Lambda][xs_List, \ t_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_]\  := \ \n
      Block[{xsNew, tNew, \[Beta], newTyVars}, \ \n
        \t\t{xsNew, tNew}\  = \ \((Module[#1, \ {#1, \ #2}]\ &\ )\)[xs, t]; \ 
        Scan[\((Type[#1]\  = \ FormTypeExpr[{}, NewTyVar[]])\)\ &\ , xsNew]; 
        \ \n\t\tnewTyVars = \((Last[\(Type[#1]\)[]]\ &\ )\)\ /@\ xsNew; \n\t\t
        \[Beta]\  = 
          If[Length[newTyVars] > 1, \n\t\t\t\t
            FuncType[Cross\ @@\ newTyVars, NewTyVar[]], \n\t\t\t\t
            FuncType[First[\ newTyVars], NewTyVar[]]\n\t\t\t]; \n\t\t
        TcX[tNew, \ Last[\[Beta]], \ 
          Append[\[Tau]eqn, \ eq[\[Beta], \[Tau]]], \ 
          Append[Union[\[Alpha]var, \ newTyVars], \ Last[\[Beta]]]]\n\t]; 
    \n (*\ lists\ *) \n
    \(TcX[l_List, \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      \(Function[
          TcXList[l, Table[#, {Length[l]}], \n\t\t
            Append[\[Tau]eqn, eq[\[Tau], TyList[#]]], Append[\[Alpha]var, #]]]
          \)[NewTyVar[]]; \)\ 
    \n (*application\ for\ flattened\ functions\ *) \), 
    \(TcX[Plus[x_, y_] | Times[x_, y_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := 
      \n\t\tTcXList[{x, y}, {Real, Real}, 
        Append[\[Tau]eqn, eq[\[Tau], Real]], \[Alpha]var]; \n
    TcX[And[x_, y_] | Or[x_, y_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t\t
      TcXList[{x, y}, {Bool, Bool}, Append[\[Tau]eqn, eq[\[Tau], Bool]], 
        \[Alpha]var]; \n (*\ application\ *) \n
    TcX[f_[], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      TcX[f, FuncType[\[Placeholder], \[Tau]], \[Tau]eqn, \[Alpha]var]; \n
    TcX[f_[arg_], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      \(Function[
          TcXList[{f, arg}, {FuncType[#1, \[Tau]], #1}, \[Tau]eqn, 
            Append[\[Alpha]var, #1]]]\)[NewTyVar[]]; \n
    TcX[f_[args__], \[Tau]_, \[Tau]eqn_, \[Alpha]var_] := \n\t
      \(Function[\n\t\t
          TcXList[{f, args}, \n
            \t\t\t{FuncType[Apply[Cross\ , #1], \[Tau]], \n\t\t\t\t
              Apply[Sequence, #1]}, \[Tau]eqn, Join[\[Alpha]var, #1]]]\)[
        NewTyVar/@{args}]; \n\nTcX[_, _, _, _] := {{eq[Int, Bool]}, {}}; 
    \)}], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TcXList", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTcXList",
    FontWeight->"Bold"],
  "[{ ",
  StyleBox["term1, term2, \[Ellipsis] ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "}",
  StyleBox[",  ",
    FontWeight->"Bold"],
  "{ ",
  StyleBox["type1, type2, \[Ellipsis]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "},  ",
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  ",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[GridBox[{
          {
            StyleBox[\(term1, \ term2, \ \[Ellipsis]\),
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", "terms"},
          {
            StyleBox[\(type1, \ type2, \ \[Ellipsis]\),
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", 
            RowBox[{
              RowBox[{"the", " ", "expected", " ", "types", " ", "of", " ", 
                StyleBox["term1",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox["term2",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[",",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox["\[Ellipsis]",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]},
          {
            StyleBox["type\[Dash]eqs",
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", 
            \(a\ list\ of\ equalities\ representing\ the\ type\ sharing\ 
              constraints\ \n
            collected\ so\ far\)},
          {
            StyleBox["type\[Dash]vars",
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", 
            RowBox[{
            "the", " ", "list", " ", "of", " ", "type", " ", "variables", " ",
               "appearing", " ", "in", " ", 
              StyleBox["type\[Dash]eqs",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}
          }]]],
  "\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a pair  ",
  StyleBox["{",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["', ",
    FontWeight->"Bold"],
  StyleBox["type\[Dash]vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["'}",
    FontWeight->"Bold"],
  "  where\n\t\t",
  Cell[BoxData[GridBox[{
          {
            RowBox[{
              StyleBox["type\[Dash]eqs",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox["'",
                FontWeight->"Bold"]}], ":", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["type\[Dash]eqs",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox["\[Union]",
                    FontWeight->"Bold"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["type\[Dash]eqs",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontWeight->"Bold"]}], 
                    StyleBox["'",
                      FontWeight->"Bold"]}]}], 
                StyleBox[",",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Plain"], 
                RowBox[{
                  StyleBox["where",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["type\[Dash]eqs",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontWeight->"Plain"]}], 
                    StyleBox["'",
                      FontWeight->"Plain"]}], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["are",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["the",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["type",
                    FontWeight->"Plain"]}]}], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["\n",
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  StyleBox["sharing",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["constraints",
                    FontWeight->"Plain"], 
                  StyleBox["  ",
                    FontWeight->"Bold"], 
                  StyleBox["collected",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["by",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["imposing",
                    FontWeight->"Plain"], 
                  StyleBox["  ",
                    FontWeight->"Plain"], 
                  StyleBox["type",
                    FontWeight->"Plain"], 
                  StyleBox[" ",
                    FontWeight->"Plain"], 
                  StyleBox["type1",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[
                    RowBox[{
                      StyleBox["f",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], "or"}]], " ", 
                  StyleBox["term1",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "\n", "\t", 
                RowBox[{
                  StyleBox["type2",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[
                    RowBox[{
                      StyleBox["f",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], "or"}]], " ", 
                  StyleBox["term2",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox["\[Ellipsis]",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["type\[Dash]vars",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox["'",
                FontWeight->"Bold"]}], ":", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["type\[Dash]vars",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], "\[Union]", 
                  RowBox[{
                    RowBox[{
                      StyleBox["type\[Dash]vars",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontWeight->"Bold"]}], 
                    StyleBox["'",
                      FontWeight->"Bold"]}]}], ",", " ", 
                RowBox[{"where", " ", 
                  RowBox[{
                    RowBox[{
                      StyleBox["type\[Dash]vars",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["'",
                        FontWeight->"Bold"]}], 
                    StyleBox["'",
                      FontWeight->"Bold"]}], " ", "are", " ", "the", " ", 
                  "type"}]}], " ", "\n", 
              RowBox[{
              "new", " ", "variables", " ", "introduced", " ", "in", " ", 
                RowBox[{
                  RowBox[{
                    StyleBox["type\[Dash]eqs",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "'"}], "'"}]}]}]}
          }]]],
  "\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(TcXList[{}, {}, \[Tau]eqn_, \[Alpha]var_]\  := {\[Tau]eqn, 
        \[Alpha]var}; \n
    TcXList[{t_, ts___}, {\[Alpha]_, \[Alpha]v___}, \[Tau]eqn_, 
        \[Alpha]var_] := \n\t
      TcXList[{ts}, {\[Alpha]v}, 
        Sequence\ @@\ TcX[t, \[Alpha], \[Tau]eqn, \[Alpha]var]]; \t\t\n
    TcXList[_, _, _, _] := {{eq[Int, Bool]}, {}}; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.700008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ListToCons", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tListToCons",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "]\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the expression obtained from ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " by replacing all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists that are not lambda arguments \n\twith the corresponding CFLP \
lists.\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(ListToCons[{}] := \[Bullet]; \n
    ListToCons[{h_, t___}] := Cons[ListToCons[h], ListToCons[{t}]]; \n
    ListToCons[\[Lambda][l_, t_]] := \[Lambda][l, ListToCons[t]]; \n
    ListToCons[t_?AtomQ] := t; \nListToCons[t_] := Map[ListToCons, t]; \)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.700008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{736, 870},
WindowMargins->{{Automatic, 97}, {-314, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 76, 1, 104, "Title"],
Cell[1810, 54, 171, 4, 27, "Input",
  InitializationCell->True],
Cell[1984, 60, 3225, 63, 683, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5234, 127, 39, 0, 54, "Subtitle"],
Cell[5276, 129, 185, 3, 50, "Text"],
Cell[5464, 134, 164, 4, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5653, 142, 27, 0, 45, "Subsection"],
Cell[5683, 144, 1627, 32, 283, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7359, 182, 34, 0, 54, "Subtitle"],

Cell[CellGroupData[{
Cell[7418, 186, 24, 0, 52, "Section"],
Cell[7445, 188, 128, 3, 27, "Input",
  InitializationCell->True],
Cell[7576, 193, 297, 6, 91, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7898, 203, 30, 0, 45, "Subsection"],
Cell[7931, 205, 395, 17, 104, "Text"],
Cell[8329, 224, 179, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8545, 233, 24, 0, 45, "Subsection"],
Cell[8572, 235, 780, 34, 158, "Text"],
Cell[9355, 271, 586, 12, 203, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9978, 288, 25, 0, 45, "Subsection"],
Cell[10006, 290, 6930, 205, 269, "Text"],
Cell[16939, 497, 3621, 67, 811, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[20597, 569, 29, 0, 45, "Subsection"],
Cell[20629, 571, 9443, 273, 285, "Text"],
Cell[30075, 846, 515, 12, 75, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[30627, 863, 32, 0, 45, "Subsection"],
Cell[30662, 865, 931, 39, 158, "Text"],
Cell[31596, 906, 425, 10, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32070, 922, 22, 0, 52, "Section"],
Cell[32095, 924, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[32264, 931, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

