(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     64683,       2207]*)
(*NotebookOutlinePosition[     65354,       2231]*)
(*  CellTagsIndexPosition[     65310,       2227]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Terms", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["This package contains commands for handling terms. ", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Terms`\>", \n
      \t{"\<TermSyntax`\>", \n\t\t"\<Variables`\>"}]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\($FunctionSymbol::usage = 
      "\<$FunctionSymbol gives the current list of declared function symbols.\
\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Arity::usage = 
      "\<Arity[symb] yields the arity of the typed symbol symb.\>"; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Constructor::usage = 
      "\<Constructor[sig\[Dash]1, sig\[Dash]2, \[Ellipsis] ] expects \
arguments sig\[Dash]i of the form symb\[Dash]i or \
symb\[Dash]i\[Proportion]type\[Dash]i, and performs the following operations:\
\n
		I) for every undeclared symbol symb\[Dash]i do\n
		\t 1.assign True to IsConstructor[symb\[Dash]i],\n
		\t 2.append symb\[Dash]i to the list $FunctionSymbol,\n
		\t 3.if type\[Dash]i is specified\n
		\t\t\t then assign the type \[ForAll] type\[Dash]i to Type[symb\[Dash]i],\n
		\t\t\t else assign the type \[Alpha] to Type[symb\[Dash]i], where \[Alpha] \
is a new type constant,\n
		\t 4.assign the arity of Type[symb\[Dash]i] to Arity[symb\[Dash]i],\n
		II) return the list {symb\[Dash]i1, symb\[Dash]i2, \[Ellipsis] } of newly \
declared constructors.\n\n
		Constructor is also an option to TSolve which specifies the set of \
constructors and, optionally, their types. During the solving process also \
the globally declared constructors are considered.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(DefinedFunctionSymbol::usage = 
      "\<DefinedFunctionSymbol[sig\[Dash]1, sig\[Dash]2, \[Ellipsis] ] \
expects arguments sig\[Dash]i of the form symb\[Dash]i or symb\[Dash]i\
\[Proportion]type\[Dash]i, and performs the following operations:\n
		I) for every undeclared symbol symb\[Dash]i do\n
		\t 1.assign True to IsDefinedFunctionSymbol[symb\[Dash]i],\n
		\t 2.append symb\[Dash]i to the list $FunctionSymbol,\n
		\t 3.if type\[Dash]i is specified\n
		\t\t\t then assign type \[ForAll] type\[Dash]i to Type[symb\[Dash]i],\n
		\t\t\t else assign type \[Alpha] to Type[symb\[Dash]i], where \[Alpha] is a \
new type constant,\n
		\t 4.assign the arity of Type[symb\[Dash]i] to Arity[symb\[Dash]i],\n
		II) return the list { symb\[Dash]i1, symb\[Dash]i2, \[Ellipsis] } of newly \
declared defined function symbols.\n\n
		DefinedFunctionSymbol is also an option to TSolve which specifies the set \
of defined functions and, optionally, their types. During the solving process \
also the globally declared defined functions are considered.\>"; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(External::usage = 
      "\<External symb\[Dash]1\[Proportion]type\[Dash]1, symb\[Dash]2\
\[Proportion]type\[Dash]2, \[Ellipsis] ] performs the following operations:\n
		I) for every undeclared symbol symb\[Dash]i do\n
		\t 1.assign True to IsExternal[symb\[Dash]i],\n
		\t 2.assign the type \[ForAll] type\[Dash]i to Type[symb\[Dash]i],\n
		II) return the list {symb\[Dash]i1, symb\[Dash]i2, \[Ellipsis] } of newly \
declared external function symbols.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsDefinedFunctionSymbol::usage = 
      "\<IsDefinedFunctionSymbol[term] yields True if term was already \
declared as defined function symbol, and yields False otherwise.\>"\ ; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsExternal::usage = 
      "\<IsExternal[term] yields True if term was already declared as \
external symbol, and yields False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsDeclared::usage = 
      "\<IsDeclared[symb] yields True if symb is an already declared function \
symbol (i.e. constructor, external, or defined function symbol), and yields \
False otherwise. If symb is already declared, a warning message specifying \
the type of symb is displayed.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsFunctionSymbol::usage = 
      "\<IsFunctionSymbol[symb] yields True if symb is an already declared \
function symbol (i.e. constructor, external, or defined function), and yields \
False otherwise.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["ClearSignature",
            FontWeight->"Bold"], "::", "usage"}], "=", 
        "\"\<ClearSignature[ symb\[Dash]1, symb\[Dash]2, \[Ellipsis] ] undoes \
all the operations performed (eventually) for symb\[Dash]i by a previous \
Constructor, External, or DefinedFunctionSymbol command.\>\""}], ";"}]], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["ResetSignature",
            FontWeight->"Bold"], "::", "usage"}], "=", 
        "\"\<ResetSignature[ ] resets the values of Type, Arity, \
IsDefinedFunctionSymbol, IsExternal, IsConstructor and $FunctionSymbol to the \
defaults.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["DefineSignature",
            FontWeight->"Bold"], "::", "usage"}], "=", 
        "\"\<DefineSignature[ ] sets the values of Type, Arity, \
IsDefinedFunctionSymbol, IsExternal, IsConstructor and $FunctionSymbol to the \
defaults.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(IsConstructorTerm::usage\),
          FontWeight->"Bold"], 
        StyleBox["=",
          FontWeight->"Bold"], 
        "\"\<IsConstructorTerm[term] yields True if term is a term of the \
form c or c[ term1, term2, \[Ellipsis] ] where c is a constructor, and False \
otherwise.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(IsNotFlex::usage\),
          FontWeight->"Bold"], 
        StyleBox["=",
          FontWeight->"Bold"], 
        "\"\<IsNotFlex[term] yields False if term is a variable or a term of \
the form X[ term1, term2, \[Ellipsis] ] where X is a variable, and True \
otherwise.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(IsFunctionTerm::usage\),
          FontWeight->"Bold"], 
        StyleBox["=",
          FontWeight->"Bold"], 
        "\"\<IsFunctionTerm[term] yields True if term is a defined function \
symbol or a term\n\t\tof the form f[ term1, term2, \[Ellipsis] ] where f is a \
defined function symbol, and False otherwise .\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($ContextPath = Join[{"\<Types`\>", "\<TypeSyntax`\>"}, $ContextPath]; 
    \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Function Symbol Declarations", "Subsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["$FunctionSymbol",
  FontWeight->"Bold"]], "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  "The global variable ",
  StyleBox["$FunctionSymbol",
    FontWeight->"Bold"],
  " is the list of declared function symbols. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Constructor", "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tConstructor[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" , \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a sequence  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions. ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " is either a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " \n\tor a type signature ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["\[Proportion]",
    FontSize->13],
  Cell[BoxData[
      FormBox[
        StyleBox[
          SubscriptBox["\[Tau]", 
            StyleBox["i",
              FontSlant->"Plain"]],
          FontWeight->"Bold"], TraditionalForm]]],
  "\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "the list {  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "1"]], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["m",
              FontWeight->"Bold",
              FontSlant->"Plain"]]], TraditionalForm]]],
  "} where 1\[LessEqual] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "\[CenterEllipsis]\[LessEqual]",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["m",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  "\[LessEqual]n such that ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["j",
              FontWeight->"Bold",
              FontSlant->"Plain"]]], TraditionalForm]]],
  " is not an already declared function symbol\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tdeclare   ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "1"]], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["m",
              FontWeight->"Bold",
              FontSlant->"Plain"]]], TraditionalForm]]],
  "as constructors by extending the default definition of ",
  StyleBox["IsConstructor",
    FontWeight->"Bold"],
  ", append ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]],
  " to \n\t",
  StyleBox["$FunctionSymbol,",
    FontWeight->"Bold"],
  " and define  the Arity[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]],
  "] accordingly;\n\tif  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " \[Congruent]",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["c",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox[
              SubscriptBox[
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], "j"],
              FontWeight->"Bold",
              FontSlant->"Plain"]]}], TraditionalForm]]],
  " then assign to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " a unique constant type \n\telse  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  "\[Congruent] ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["c",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox[
              SubscriptBox[
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], "j"],
              FontWeight->"Bold",
              FontSlant->"Plain"]]}], TraditionalForm]]],
  StyleBox["\[Proportion]",
    FontSize->13],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " and then assign to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["c",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " the type \[ForAll]",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["\[Tau]",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[
              SubscriptBox[
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], "j"],
              FontWeight->"Bold",
              FontSlant->"Plain"]]}], TraditionalForm]]],
  ".\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Constructor[c_Symbol] := \n\t
      If[IsDeclared[c], \n\t\t{}, \n\t\tType[c] = FormTypeExpr[{}, NewC[]]; \n
        \t\tAppendTo[$FunctionSymbol, c]; Arity[c] = 0; \n\t\t
        IsConstructor[c] = True; \n\t\t{c}]; \n
    Constructor[TypeOf[c_, \[Tau]_?IsFunType]] := \n\t
      If[IsDeclared[c], \n\t\t{}, \n\t\tIsConstructor[c] = True; \n\t\t
        If[Not[MemberQ[{RewriteRule, eq, ppeq}, c]], \n\t\t\t
          AppendTo[$FunctionSymbol, c]; \n\t\t\t
          Arity[c] = 
            If[IsFunOnCPType[\[Tau]], \n\t\t\t\t\tLength[First[\[Tau]]], \n
              \t\t\t\t\tIf[First[\[Tau]] === \[Placeholder], 0, 1]]\n\t\t]; \n
        \t\tDeclareType[TypeOf[c, \[Tau]]]; {c}]; \n
    Constructor[TypeOf[c_, \[Tau]_]] := \n\t
      \((If[IsDeclared[c], \n\t\t{}, \n\t\tIsConstructor[c] = True; \n\t\t
          AppendTo[$FunctionSymbol, c]; \n\t\tArity[c] = 0; \n\t\t
          DeclareType[TypeOf[c, FuncType[\[Placeholder], \[Tau]]]]; {c}])\); 
    \nConstructor[cs___] := Join\ @@\ \(Constructor\ /@\ {cs}\); \)], "Input",\

  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell["DefinedFunctionSymbol", "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDefinedFunctionSymbol[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" , \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a sequence  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions. ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " is either a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " \n\tor a type signature ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["\[Proportion]",
    FontSize->13],
  Cell[BoxData[
      FormBox[
        StyleBox[
          SubscriptBox["\[Tau]", 
            StyleBox["i",
              FontSlant->"Plain"]],
          FontWeight->"Bold"], TraditionalForm]]],
  "\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "the list {  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "1"]], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["m",
              FontWeight->"Bold",
              FontSlant->"Plain"]]], TraditionalForm]]],
  "} where 1\[LessEqual] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "\[CenterEllipsis]\[LessEqual]",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["m",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  "\[LessEqual]",
  StyleBox["n",
    FontWeight->"Bold"],
  " such that ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["j",
              FontWeight->"Bold",
              FontSlant->"Plain"]]], TraditionalForm]]],
  " is not an already declared function symbol\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tdeclare   ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "1"]], TraditionalForm]]],
  ", ... , ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["m",
              FontWeight->"Bold",
              FontSlant->"Plain"]]], TraditionalForm]]],
  "as constructors by extending the default definition of ",
  StyleBox["IsDefinedFunctionSymbol\n\t",
    FontWeight->"Bold"],
  " and append to ",
  StyleBox["$FunctionSymbol",
    FontWeight->"Bold"],
  "  the pairs {",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]],
  ",",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]],
  "} where ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]],
  "is the arity of ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]],
  ", 1 \[LessEqual] j \[LessEqual] m ;\n\tif  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " \[Congruent]",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["f",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox[
              SubscriptBox[
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], "j"],
              FontWeight->"Bold",
              FontSlant->"Plain"]]}], TraditionalForm]]],
  " then assign to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " a unique constant type \n\telse  ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  "\[Congruent] ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["f",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox[
              SubscriptBox[
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], "j"],
              FontWeight->"Bold",
              FontSlant->"Plain"]]}], TraditionalForm]]],
  StyleBox["\[Proportion]",
    FontSize->13],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Tau]",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " and then assign to ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " the type \[ForAll]",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["\[Tau]",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[
              SubscriptBox[
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], "j"],
              FontWeight->"Bold",
              FontSlant->"Plain"]]}], TraditionalForm]]],
  ".\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Clear[DefinedFunctionSymbol]; \n
    DefinedFunctionSymbol[f_Symbol] := \n\t
      If[IsDeclared[f], \n\t\t{}, \n\t\tType[f] = FormTypeExpr[{}, NewC[]]; \n
        \t\tAppendTo[$FunctionSymbol, f]; \n\t\tArity[f] = 0; \n\t\t
        IsDefinedFunctionSymbol[f] = True; \n\t\t{f}]; \n
    DefinedFunctionSymbol[TypeOf[f_, \[Tau]_?IsFunType]] := \n\t
      If[IsDeclared[f], \n\t\t{}, \n\t\tIsDefinedFunctionSymbol[f] = True; \n
        \t\tIf[Not[MemberQ[{RewriteRule, eq, ppeq}, f]], \n\t\t\t
          AppendTo[$FunctionSymbol, f]; \n\t\t\t
          Arity[f] = 
            If[IsFunOnCPType[\[Tau]], \n\t\t\t\t\tLength[First[\[Tau]]], \n
              \t\t\t\t\tIf[First[\[Tau]] === \[Placeholder], 0, 1]]\n\t\t]; \n
        \t\tDeclareType[TypeOf[f, \[Tau]]]; {f}]; \n
    DefinedFunctionSymbol[TypeOf[f_, \[Tau]_]] := \n\t
      If[IsDeclared[f], \n\t\t{}, \n\t\tIsDefinedFunctionSymbol[f] = True; \n
        \t\tAppendTo[$FunctionSymbol, f]; \n\t\tArity[f] = 0; \t\n\t\t
        DeclareType[TypeOf[f, FuncType[\[Placeholder], \[Tau]]]]; {f}]; \n
    DefinedFunctionSymbol[_] = {}; \n
    DefinedFunctionSymbol[fs___] := 
      Join\ @@\ \(DefinedFunctionSymbol\ /@\ {fs}\); \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell["External", "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tExternal[",
    FontWeight->"Bold"],
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]]],
  StyleBox[" , \[Ellipsis] , ",
    FontWeight->"Bold"],
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["u",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]]],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a sequence  ",
  StyleBox[Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[
              SubscriptBox[
                StyleBox["f",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], 
                StyleBox["1",
                  FontWeight->"Bold",
                  FontSlant->"Plain"]],
              "TraditionalForm"], 
            StyleBox["\[Proportion]",
              FontSize->13], 
            FormBox[
              StyleBox[
                SubscriptBox["\[Tau]", 
                  StyleBox["1",
                    FontSlant->"Plain"]],
                FontWeight->"Bold"],
              "TraditionalForm"]}]}], TraditionalForm]]]],
  ", ... , ",
  StyleBox[Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[
              SubscriptBox[
                StyleBox["f",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], 
                StyleBox["n",
                  FontWeight->"Bold",
                  FontSlant->"Plain"]],
              "TraditionalForm"], 
            StyleBox["\[Proportion]",
              FontSize->13], 
            FormBox[
              StyleBox[
                SubscriptBox["\[Tau]", 
                  StyleBox["n",
                    FontSlant->"Plain"]],
                FontWeight->"Bold"],
              "TraditionalForm"]}]}], TraditionalForm]]]],
  " of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions.\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  "the list { ",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "1"]], TraditionalForm]]]],
  ", ... , ",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["m",
              FontWeight->"Bold",
              FontSlant->"Plain"]]], TraditionalForm]]]],
  "} where 1\[LessEqual] ",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"], "1"], TraditionalForm]]]],
  "\[CenterEllipsis]\[LessEqual]",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["m",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]]],
  "\[LessEqual]",
  StyleBox["n",
    FontWeight->"Bold"],
  " such that ",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["j",
              FontWeight->"Bold",
              FontSlant->"Plain"]]], TraditionalForm]]]],
  " is not an already declared function symbol\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tdeclare   ",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "1"]], TraditionalForm]]]],
  ", ... , ",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["m",
              FontWeight->"Bold",
              FontSlant->"Plain"]]], TraditionalForm]]]],
  "as external function symbols by extending the default definition of ",
  StyleBox["IsExternal\n\t",
    FontWeight->"Bold"],
  " and append to ",
  StyleBox["$FunctionSymbol",
    FontWeight->"Bold"],
  "  the pairs {",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]]],
  ",",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]]],
  "} where ",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]]],
  "is the arity of ",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Plain"], "j"]], TraditionalForm]]]],
  ", 1 \[LessEqual] j \[LessEqual] m ;\n\t assign to ",
  StyleBox[Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox[
            SubscriptBox[
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Plain"], "j"],
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]]],
  " the type \[ForAll]",
  StyleBox[Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["\[Tau]",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[
              SubscriptBox[
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], "j"],
              FontWeight->"Bold",
              FontSlant->"Plain"]]}], TraditionalForm]]]],
  ".\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(External[TypeOf[f_, \[Tau]_?IsFunType]] := \n\t
      If[IsDeclared[f], \n\t\t{}, \n\t\tIsExternal[f] = True; \n
        \t\t (*\ AppendTo[$FunctionSymbol, \n
            \t\t\t{f, 
              If[IsFunOnCPType[\[Tau]], \n\t\t\t\t\tLength[First[\[Tau]]], \n
                \t\t\t\t\t
                If[First[\[Tau]] === \[Placeholder], \ 0, \ 1\ ]]}]; \ *) \n
        \t\tDeclareType[TypeOf[f, \[Tau]]]; {f}]; \n
    External[f_ \[Proportion] \[Tau]_] := \n\t
      If[IsDeclared[f], \n\t\t{}, \n\t\tIsExternal[f] = True; \n
        \t\t (*\ AppendTo[$FunctionSymbol, {f, 0\ }]; \t*) \n\t\t
        DeclareType[TypeOf[f, FuncType[\[Placeholder], \[Tau]]]]; {f}]; \n
    External[_] = {}; \nExternal[fs___] := Join\ @@\ \(External\ /@\ {fs}\); 
    \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell["DefineSignature", "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDefineSignature[ ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta sequence of constructor-, external-,  or defined function symbols\n",
  
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tset the default values for ",
  StyleBox["$FunctionSymbol",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Type",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Arity",
    FontWeight->"Bold"],
  ", ",
  StyleBox["IsConstructor",
    FontWeight->"Bold"],
  ", ",
  StyleBox["IsExternal",
    FontWeight->"Bold"],
  " and ",
  StyleBox["IsDefinedFunctionSymbol",
    FontWeight->"Bold"],
  ". \n\tThese values identify the signature of the CFLP interpreter.\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(DefineSignature[]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({}\), ",", "\n", "\t\t", 
            RowBox[{
            \($FunctionSymbol = {}\), ";", "\n", "\t\t", 
              \(TypeConstructor[Int, Bool, Real, Symbol, \[Placeholder], 
                TyList, FuncType, Cross]\), ";", "\n", "\t\t", 
              RowBox[{"Constructor", "[", "\n", "\t\t\t", 
                RowBox[{
                \(TypeOf[True, Bool]\), ",", "\n", "\t\t\t", 
                  \(TypeOf[False, Bool]\), ",", "\n", "\t\t\t", 
                  \(TypeOf[\[Bullet], TyList[Global`\[Alpha]]]\), ",", "\n", 
                  "\t\t\t", 
                  \(TypeOf[Cons, 
                    FuncType[Global`\[Alpha]\[Cross]TyList[Global`\[Alpha]], 
                      TyList[Global`\[Alpha]]]]\), ",", "\n", "\t\t\t", 
                  RowBox[{"TypeOf", "[", 
                    RowBox[{
                      StyleBox["RewriteRule",
                        FontWeight->"Bold"], 
                      StyleBox[",",
                        FontWeight->"Bold"], 
                      RowBox[{
                        StyleBox["FuncType",
                          FontWeight->"Bold"], 
                        StyleBox["[",
                          FontWeight->"Bold"], 
                        \(Global`\[Alpha]\[Cross]Global`\[Alpha]\[Cross]Bool, 
                        Bool\), "]"}]}], "]"}], ",", "\n", "\t\t\t", 
                  \(TypeOf[eq, 
                    FuncType[Global`\[Alpha]\[Cross]Global`\[Alpha], Bool]]
                    \)}], "]"}], ";", "\n", "\t\t", 
              \(External[\n\t\t\t
                TypeOf[Plus, FuncType[Real\[Cross]Real, Real]], 
                TypeOf[Times, FuncType[Real\[Cross]Real, Real]], \n\t\t\t
                TypeOf[Power, FuncType[Real\[Cross]Real, Real]], \n\t\t\t
                TypeOf[Sin, FuncType[Real, Real]], \n\t\t\t
                TypeOf[Cos, FuncType[Real, Real]], \n\t\t\t
                TypeOf[And, FuncType[Bool\[Cross]Bool, Bool]], \n\t\t\t
                TypeOf[Or, FuncType[Bool\[Cross]Bool, Bool]], \n\t\t\t
                TypeOf[Not, FuncType[Bool, Bool]]]\), ";"}]}], "\n", "\t", 
          "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]],

Cell[CellGroupData[{

Cell["ClearSignature", "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tClearSignature[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" , \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\ta sequence of constructor-, external-,  or defined function symbols\n",
  
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tundeclare ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["i",
            FontWeight->"Bold"]], TraditionalForm]]],
  " (",
  StyleBox["1 \[LessEqual] i \[LessEqual] n",
    FontWeight->"Bold"],
  ")\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", 
        StyleBox["ClearSignature",
          FontWeight->"Bold"], "]"}], ";", "\n", 
      \(ClearSignature[f_Symbol] := \n\t
        Block[{}, \n\t\tIsDefinedFunctionSymbol[f] = False; \n\t\t
          IsConstructor[f] = False; \n\t\tIsExternal[f] = False; \n\t\t
          If[Head[Type[f]] =!= Type, Type[f] =. ; Arity[f] =. ]; \n
          \t\t$FunctionSymbol = $FunctionSymbol /. f -> Sequence[]; \n
          \t\t{f}\n\t]\), ";", "\n", 
      \(ClearSignature[fs___Symbol] := 
        Join\ @@\ \(ClearSignature\ /@\ {fs}\)\), " ", ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]],

Cell[CellGroupData[{

Cell["ResetSignature", "Subsubsection",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tResetSignature[",
    FontWeight->"Bold"],
  " ",
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\treset the type signature context to default.\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  Evaluatable->False,
  FontFamily->"Times New Roman",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(Clear[ResetSignature]; \n
    ResetSignature[] := \n\t
      \((Clear[IsDefinedFunctionSymbol, IsConstructor, Type, Arity]; \n\t\t
        IsConstructor[c_?AtomQ] /; 
            c\[LeftDoubleBracket]0\[RightDoubleBracket] =!= Symbol = True; \n
        \t\tIsConstructor[_] := False; \n\t\t
        IsDefinedFunctionSymbol[_] := False; \n\t\tDefineSignature[])\); \)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Function Recognizers", "Subsection"],

Cell[CellGroupData[{

Cell["IsConstructor", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsConstructor[ ",
    FontWeight->"Bold"],
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if ",
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a constructor symbol\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(IsConstructor[c_?AtomQ] /; 
        c\[LeftDoubleBracket]0\[RightDoubleBracket] =!= Symbol := True; \n
    IsConstructor[_] := False; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["IsDefinedFunctionSymbol",
  FontWeight->"Bold"]], "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsDefinedFunctionSymbol[ ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a defined function symbol \n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(IsDefinedFunctionSymbol[_] := False; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsExternal", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsExternal[ ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  " is an external function symbol\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(IsExternal[_] := False; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsDeclared", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsDeclared[ ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a defined function symbol or a constructor or an external function \
symbol\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Side Efect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tdisplay a warning message if  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  " is already defined\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(IsDeclared[f_] := \n\t
      If[IsExternal[f], \n\t\t
        Print["\<Warning: \>", f, 
          "\< is already declared as external function symbol\>"]; True, \n
        \t\tIf[IsDefinedFunctionSymbol[f], \n\t\t\t
          Print["\<Warning: \>", f, 
            "\< is already declared as defined function symbol\>"]; True, \n
          \t\t\tIf[IsConstructor[f], \n\t\t\t\t
            Print["\<Warning: \>", f, 
              "\< is already declared as constructor symbol\>"]; True, \n
            \t\t\t\tFalse\n\t\t\t\t]\n\t\t]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["IsFunctionSymbol",
  FontWeight->"Bold"]], "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsFunctionSymbol[ ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a defined function symbol or a constructor or an external function \
symbol\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Clear[IsFunctionSymbol]; \n
    IsFunctionSymbol[f_] := 
      Or[IsConstructor[f], IsDefinedFunctionSymbol[f], IsExternal[f]]; \)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Term Recognizers", "Subsection"],

Cell[CellGroupData[{

Cell["NotFlex", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tNotFlex[ ",
    FontWeight->"Bold"],
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["False",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["term ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a is a variable or a term with  variable head.\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Clear[NotFlex]; \nIsNotFlex[x_?IsVar] := False; \n
    IsNotFlex[x_?IsVar[___]] := False; \nIsNotFlex[_] := True; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsConstructorTerm", "Subsubsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsConstructorTerm[ ",
    FontWeight->"Bold"],
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]\n",
    FontWeight->"Bold"],
  StyleBox["Input\n\tt",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is of the form  ",
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  or  ",
  StyleBox["c ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["t",
            FontSlant->"Plain"], "1"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis], ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["t",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSlant->"Plain"]], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox["]",
    FontWeight->"Bold"],
  ", where  ",
  StyleBox["c",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a constructor,\n\t",
  StyleBox["Fals",
    FontWeight->"Bold"],
  "e  otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(IsConstructorTerm[\((_?IsConstructor)\)[___] | _?IsConstructor] := 
      True; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsFunctionTerm", "Subsubsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsFunctionTerm[ ",
    FontWeight->"Bold"],
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]\n",
    FontWeight->"Bold"],
  StyleBox["Input\n\tt",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is of the form  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  or  ",
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["t",
            FontSlant->"Plain"], "1"], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis], ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["t",
            FontSlant->"Plain"], 
          StyleBox["n",
            FontSlant->"Plain"]], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox["]",
    FontWeight->"Bold"],
  ", where  ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a defined function symbol,\n\t",
  StyleBox["Fals",
    FontWeight->"Bold"],
  "e  otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(IsFunctionTerm[
        \((_?IsDefinedFunctionSymbol)\)[___]\n | _?
            IsDefinedFunctionSymbol] := True; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(DefineSignature[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{658, 600},
WindowMargins->{{223, Automatic}, {Automatic, 153}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 61, 1, 104, "Title"],
Cell[1795, 54, 171, 4, 27, "Input",
  InitializationCell->True],
Cell[1969, 60, 3225, 63, 683, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5219, 127, 39, 0, 54, "Subtitle"],
Cell[5261, 129, 67, 0, 32, "Text"],
Cell[5331, 131, 243, 6, 59, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5599, 141, 27, 0, 45, "Subsection"],
Cell[5629, 143, 214, 5, 43, "Input",
  InitializationCell->True],
Cell[5846, 150, 191, 5, 27, "Input",
  InitializationCell->True],
Cell[6040, 157, 1094, 20, 251, "Input",
  InitializationCell->True],
Cell[7137, 179, 1150, 20, 251, "Input",
  InitializationCell->True],
Cell[8290, 201, 562, 10, 123, "Input",
  InitializationCell->True],
Cell[8855, 213, 285, 6, 59, "Input",
  InitializationCell->True],
Cell[9143, 221, 248, 5, 43, "Input",
  InitializationCell->True],
Cell[9394, 228, 397, 7, 75, "Input",
  InitializationCell->True],
Cell[9794, 237, 311, 6, 59, "Input",
  InitializationCell->True],
Cell[10108, 245, 458, 11, 59, "Input",
  InitializationCell->True],
Cell[10569, 258, 400, 10, 59, "Input",
  InitializationCell->True],
Cell[10972, 270, 400, 10, 59, "Input",
  InitializationCell->True],
Cell[11375, 282, 432, 11, 59, "Input",
  InitializationCell->True],
Cell[11810, 295, 422, 11, 59, "Input",
  InitializationCell->True],
Cell[12235, 308, 468, 11, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12752, 325, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[12811, 329, 24, 0, 52, "Section"],
Cell[12838, 331, 183, 5, 27, "Input",
  InitializationCell->True],
Cell[13024, 338, 234, 6, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[13283, 348, 182, 5, 45, "Subsection"],

Cell[CellGroupData[{
Cell[13490, 357, 214, 6, 42, "Subsubsection"],
Cell[13707, 365, 156, 5, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13900, 375, 168, 5, 42, "Subsubsection"],
Cell[14071, 382, 9411, 335, 259, "Text"],
Cell[23485, 719, 1199, 23, 427, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[24721, 747, 178, 5, 28, "Subsubsection"],
Cell[24902, 754, 10104, 360, 257, "Text"],
Cell[35009, 1116, 1357, 25, 475, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[36403, 1146, 165, 5, 28, "Subsubsection"],
Cell[36571, 1153, 7493, 258, 218, "Text"],
Cell[44067, 1413, 931, 19, 283, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[45035, 1437, 172, 5, 28, "Subsubsection"],
Cell[45210, 1444, 938, 37, 176, "Text"],
Cell[46151, 1483, 2333, 45, 347, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[48521, 1533, 171, 5, 28, "Subsubsection"],
Cell[48695, 1540, 1372, 52, 140, "Text"],
Cell[50070, 1594, 676, 14, 187, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[50783, 1613, 171, 5, 28, "Subsubsection"],
Cell[50957, 1620, 555, 22, 104, "Text"],
Cell[51515, 1644, 467, 10, 123, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[52031, 1660, 42, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[52098, 1664, 38, 0, 42, "Subsubsection"],
Cell[52139, 1666, 876, 39, 158, "Text"],
Cell[53018, 1707, 313, 8, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[53368, 1720, 90, 1, 42, "Subsubsection"],
Cell[53461, 1723, 894, 39, 158, "Text"],
Cell[54358, 1764, 220, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[54615, 1775, 35, 0, 42, "Subsubsection"],
Cell[54653, 1777, 922, 41, 158, "Text"],
Cell[55578, 1820, 128, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[55743, 1828, 35, 0, 42, "Subsubsection"],
Cell[55781, 1830, 1179, 50, 194, "Text"],
Cell[56963, 1882, 646, 13, 219, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[57646, 1900, 83, 1, 42, "Subsubsection"],
Cell[57732, 1903, 936, 40, 158, "Text"],
Cell[58671, 1945, 310, 9, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[59030, 1960, 38, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[59093, 1964, 32, 0, 42, "Subsubsection"],
Cell[59128, 1966, 907, 39, 158, "Text"],
Cell[60038, 2007, 214, 4, 75, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[60289, 2016, 64, 1, 42, "Subsubsection"],
Cell[60356, 2019, 1501, 64, 158, "Text"],
Cell[61860, 2085, 263, 7, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[62160, 2097, 61, 1, 42, "Subsubsection"],
Cell[62224, 2100, 1510, 64, 158, "Text"],
Cell[63737, 2166, 297, 8, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[64095, 2181, 22, 0, 32, "Section"],
Cell[64120, 2183, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[64289, 2190, 178, 5, 27, "Input",
  InitializationCell->True],
Cell[64470, 2197, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

