(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14315,        431]*)
(*NotebookOutlinePosition[     15125,        459]*)
(*  CellTagsIndexPosition[     15081,        455]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Term Syntax", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["This package contains syntax definitions for terms.", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<TermSyntax`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Off[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(eq::usage = 
      "\<eq[ term1, term2 ] is the full form representation of the initial \
equation term1 \[TildeTilde] term2.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(ppeq::usage = 
      "\<ppeq[ term1, term2 ] is the full form representation of the \
parameter passing equation term1 \[CupCap] term2.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(Mark::usage = 
      "\<Mark[equation] is the full form representation of the marked \
equation \[LeftCeiling]equation\[RightCeiling]\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(RewriteRule::usage = 
      "\<RewriteRule[lhs, rhs, { equation1, equation2, \[Ellipsis] }] is the \
full form representation of the CRR lhs \[RightArrow] rhs \[DoubleLeftArrow] \
(equation1 \[And] equation2 \[And] \[CenterEllipsis]).\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(Cons::usage = 
      "\<Cons[elem,list\[Dash]term] gives list\[Dash]term with elem \
prepended. It is the full form representation of \[LeftAngleBracket] elem, \
elem\[Dash]list \[RightAngleBracket].\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(\[Bullet]::usage\),
          FontWeight->"Bold"], 
        StyleBox["=",
          FontWeight->"Bold"], 
        \("\<\[Bullet] denotes the empty list term.\>"\)}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(\[Lambda]::usage = 
      "\<\[Lambda] is the lambda term constructor. \[Lambda][x, body] is a \
lambda term with a single formal argument x. \[Lambda][{x1, x2, \[Ellipsis] \
}, body ] is a lambda term with list {x1, x2, \[Ellipsis] } of formal \
arguments.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["eq", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[RowBox[{x_, "\<\[TildeTilde]\>", y_}], StandardForm]
         := \n\tMakeExpression[
        RowBox[{"\<eq\>", "\<[\>", x, "\<,\>", y, "\<]\>"}], \n\t\t
        StandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(eq /: \ MakeBoxes[eq[x_, \ y_], \ StandardForm]\  := \n\t
      RowBox[\ {MakeBoxes[x, \ StandardForm], \n\t\t\t\t"\<\[TildeTilde]\>", 
          \ MakeBoxes[y, \ StandardForm]}\ \n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ppeq", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[RowBox[{x_, "\<\[CupCap]\>", y_}], StandardForm] := \n
      \tMakeExpression[RowBox[{"\<ppeq\>", "\<[\>", x, "\<,\>", y, "\<]\>"}], 
        \n\t\tStandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(ppeq /: \ MakeBoxes[ppeq[x_, \ y_], \ StandardForm]\  := \n\t
      RowBox[\ {MakeBoxes[x, \ StandardForm], \n\t\t\t\t"\<\[CupCap]\>", \ 
          MakeBoxes[y, \ StandardForm]}\ \n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mark", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(\(MakeExpression[
        RowBox[{"\<\[LeftCeiling]\>", x_, "\<\[RightCeiling]\>"}], 
        StandardForm] := \n\t
      MakeExpression[RowBox[{"\<Mark\>", "\<[\>", x, "\<]\>"}], 
        StandardForm]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(Mark /: MakeBoxes[Mark[x_], \ StandardForm] := \n\t\t
      RowBox[{"\<\[LeftCeiling]\>", MakeBoxes[x, \ StandardForm], \ 
          "\<\[RightCeiling]\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RewriteRule", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[
    \(MakeExpression[
        RowBox[{x_, "\<\[RightArrow]\>", y_, "\<\[DoubleLeftArrow]\>", 
              "\<\[Placeholder]\>"}] | RowBox[{x_, "\<\[RightArrow]\>", y_}], 
        StandardForm] := \n\t
      MakeExpression[
        RowBox[{"\<RewriteRule\>", "\<[\>", x, "\<,\>", y, "\<,\>", 
            "\<True\>", "\<]\>"}], \n\t\tStandardForm]; \n
    MakeExpression[
        RowBox[{x_, "\<\[RightArrow]\>", y_, "\<\[DoubleLeftArrow]\>", z_}], 
        StandardForm] := \n\t
      MakeExpression[
        RowBox[{"\<RewriteRule\>", "\<[\>", x, "\<,\>", y, "\<,\>", z, 
            "\<]\>"}], \n\t\tStandardForm]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(RewriteRule\  /: \ 
      MakeBoxes[RewriteRule[x_, \ y_, True], \ StandardForm]\  := \n\t
      RowBox[\ {MakeBoxes[x, \ StandardForm], \n\t\t\t\t"\<\[RightArrow]\>", 
          \ MakeBoxes[y, \ StandardForm]}\n\t]; \n
    RewriteRule\  /: \ MakeBoxes[RewriteRule[x_, \ y_, z_], \ StandardForm]\ 
       := \n\t\ RowBox[
        \ {MakeBoxes[x, \ StandardForm], \n\t\t\t\t"\<\[RightArrow]\>", \ 
          MakeBoxes[y, \ StandardForm], "\<\[DoubleLeftArrow]\>", \n\t\t\t
          MakeBoxes[z, \ StandardForm]}\n\t\t\ ]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cons", "Subsection"],

Cell[CellGroupData[{

Cell["Input (MakeExpression)", "Subsubsection"],

Cell[BoxData[{
    \(MakeExpression[
        RowBox[{"\<\[LeftAngleBracket]\>", RowBox[{x_, "\<,\>", y_}], 
            "\<\[RightAngleBracket]\>"}], StandardForm] := \n\t
      MakeExpression[RowBox[{"\<Cons\>", "\<[\>", x, "\<,\>", y, "\<]\>"}], 
        StandardForm]; \n
    MakeExpression[
        RowBox[{"\<\[LeftAngleBracket]\>", RowBox[{xs__, x_, "\<,\>", y_}], 
            "\<\[RightAngleBracket]\>"}], \n\tStandardForm] := \n\t
      MakeExpression[
        RowBox[{"\<\[LeftAngleBracket]\>", 
            RowBox[{xs, 
                RowBox[{"\<\[LeftAngleBracket]\>", RowBox[{x, "\<,\>", y}], 
                    "\<\[RightAngleBracket]\>"}]}], 
            "\<\[RightAngleBracket]\>"}], \n\t\tStandardForm]\), 
    \(\(MakeExpression[
        RowBox[{"\<\[LeftAngleBracket]\>", x_, "\<\[RightAngleBracket]\>"}], 
        StandardForm] := 
      MakeExpression[
        RowBox[{"\<Cons\>", "\<[\>", x, "\<,\>", "\<\[Bullet]\>", "\<]\>"}], 
        StandardForm]; \)\)}], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output (MakeBoxes)", "Subsubsection"],

Cell[BoxData[
    \(\(Cons /: MakeBoxes[Cons[x_, y_], \ StandardForm] := \n\t\t
      RowBox[{"\<\[LeftAngleBracket]\>", 
          RowBox[{MakeBoxes[x, \ StandardForm], "\<,\>", 
              MakeBoxes[y, \ StandardForm]}], "\<\[RightAngleBracket]\>"}]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(On[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{761, 600},
WindowMargins->{{179, Automatic}, {Automatic, 103}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 67, 1, 104, "Title"],
Cell[1801, 54, 171, 4, 27, "Input",
  InitializationCell->True],
Cell[1975, 60, 3225, 63, 683, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5225, 127, 39, 0, 54, "Subtitle"],
Cell[5267, 129, 67, 0, 32, "Text"],
Cell[5337, 131, 192, 5, 27, "Input",
  InitializationCell->True],
Cell[5532, 138, 131, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5688, 145, 27, 0, 45, "Subsection"],
Cell[5718, 147, 236, 5, 43, "Input",
  InitializationCell->True],
Cell[5957, 154, 246, 5, 43, "Input",
  InitializationCell->True],
Cell[6206, 161, 244, 5, 43, "Input",
  InitializationCell->True],
Cell[6453, 168, 345, 6, 43, "Input",
  InitializationCell->True],
Cell[6801, 176, 310, 6, 43, "Input",
  InitializationCell->True],
Cell[7114, 184, 310, 9, 27, "Input",
  InitializationCell->True],
Cell[7427, 195, 366, 7, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7842, 208, 34, 0, 54, "Subtitle"],

Cell[CellGroupData[{
Cell[7901, 212, 24, 0, 52, "Section"],
Cell[7928, 214, 128, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[8081, 221, 24, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[8130, 225, 47, 0, 42, "Subsubsection"],
Cell[8180, 227, 295, 6, 59, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8512, 238, 43, 0, 42, "Subsubsection"],
Cell[8558, 240, 290, 5, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8897, 251, 26, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[8948, 255, 47, 0, 42, "Subsubsection"],
Cell[8998, 257, 282, 5, 59, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9317, 267, 43, 0, 42, "Subsubsection"],
Cell[9363, 269, 290, 5, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9702, 280, 26, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[9753, 284, 47, 0, 42, "Subsubsection"],
Cell[9803, 286, 306, 7, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[10146, 298, 43, 0, 42, "Subsubsection"],
Cell[10192, 300, 262, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10503, 311, 33, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[10561, 315, 47, 0, 42, "Subsubsection"],
Cell[10611, 317, 713, 15, 107, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[11361, 337, 43, 0, 42, "Subsubsection"],
Cell[11407, 339, 622, 11, 155, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12078, 356, 26, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[12129, 360, 47, 0, 42, "Subsubsection"],
Cell[12179, 362, 1061, 22, 139, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[13277, 389, 43, 0, 42, "Subsubsection"],
Cell[13323, 391, 343, 7, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13727, 405, 22, 0, 52, "Section"],
Cell[13752, 407, 190, 6, 27, "Input",
  InitializationCell->True],
Cell[13945, 415, 130, 3, 27, "Input",
  InitializationCell->True],
Cell[14078, 420, 197, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

