(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13507,        391]*)
(*NotebookOutlinePosition[     14178,        415]*)
(*  CellTagsIndexPosition[     14134,        411]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["TSolve", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementation of the term solver based \
on the CFLP\.03\.03\.03\.03 calculus. \
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<TSolve`\>", \n
      \t{"\<TypeChecker`\>", "\<RewriteRuleDefs`\>"}\n]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(TSolve::usage = 
      "\<TSolve[eqns,vars] attempts to solve an equation or a set of \
equations for the variables vars.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Initialize::usage = 
      "\<Initialize is an option to the function TSolve. With TypeCheck->True \
... .\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(NSolution::usage = 
      "\<NSolution is an option to TSolve which specifies the maximum number \
of solutions to be found.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Rule::usage = 
      "\<Rule is an option to TSolve which specifies the set of CRRs w.r.t. \
which the system of equations is tried to be solved. During the solving \
process also the globally declared CRRs are used.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($ContextPath = 
      Join[\n\t\t{\n\t\t\t"\<TypeSyntax`\>", \n\t\t\t\t"\<Types`\>", \n
          \t\t\t\t"\<Variables`\>", \n\t\t\t\t"\<TermSyntax`\>", \n\t\t\t\t
          "\<Terms`\>", \n\t\t\t\t"\<RewriteRules`\>", \n\t\t\t\t
          "\<Calculus`\>"\n\t\t}, $ContextPath]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Options[TSolve]", "Subsection"],

Cell[BoxData[
    \(\(Options[TSolve] = {\n\t\tNSolution -> 256, \n\t\tRule -> {}, \n\t\t
        Initialize -> False, \n\t\tConstructor -> {}, \n\t\t
        DefinedFunctionSymbol -> {}, \n\t\tTypeCheck -> True\n\t}; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(TypeCheck[tyChkVal : \((True | False)\)] := \n\t
      \((Options[TSolve] = 
          Options[TSolve] /. 
            \((\((TypeCheck -> _)\) -> \((TypeCheck -> tyChkVal)\))\))\); 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TSolve", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tTSolve",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["eqns, vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "]\n",
  StyleBox["Input\n\teqns",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the equation or set of equations to be solved\n\t",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the variables of ",
  StyleBox["eqns",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the set of solutions of ",
  StyleBox["eqns",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(BeginRule[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.501961]],

Cell[BoxData[
    \(TSolve[goal_List, vars_List, opts___Rule] := 
      TSolve[goal, vars, {}, opts]; \n
    TSolve[goal_List, vars_List, elims_List, opts___Rule] := \n\t
      Block[{\n\t\t\tsaveRewriteRuleList = DownValues[RewriteRuleList], \n
          \t\t\tsaveIsDefinedFunctionSymbol = 
            DownValues[IsDefinedFunctionSymbol], \n\t\t\t
          saveIsConstructor = DownValues[IsConstructor], \n\t\t\t
          saveType = DownValues[Type], \n\t\t\tGlobal`NSolutions, \n\t\t\tsol
          \n\t\t\t}, \n\t\t
        Global`NSolutions = \(NSolution /. {opts}\) /. Options[TSolve]; \n\t\t
        If[Global`NSolutions \[LessEqual] 0, \n\t\t\t{}, \n\t\t\t
          If[\(Initialize /. {opts}\) /. Options[TSolve], BeginRule[]]; \n
          \t\t\tConstructor\ @@\ 
            Join[\(Constructor /. {opts}\) /. Options[TSolve], elims]; \n
          \t\t\tDefinedFunctionSymbol\ @@\ 
            \((\(DefinedFunctionSymbol /. {opts}\) /. Options[TSolve])\); \n
          \t\t\tIf[\(TypeCheck /. {opts}\) /. Options[TSolve], \n\t\t\t\t
            If[Def[vars, \(Rule /. {opts}\) /. Options[TSolve], 
                  TypeCheck -> True] === "\<\[DownTee]\>", \n\t\t\t\t\t
              SetVariables[vars]; \n\t\t\t\t\t\t
              sol = \n\t\t\t\t\t\t\t
                \(Function[\n\t\t\t\t\t\t\t\t
                    TSolve[Sequence\ @@\ #, TypeCheck -> False, 
                      NSolution -> 2]\n\t\t\t\t\t\t\t]\)[
                  TcX[goal, TyList[Bool], {}, {}]]; \n\t\t\t\t\t\t
              sol = \n\t\t\t\t\t\t\t
                If[sol === {}, \n\t\t\t\t\t\t\t\t
                  Print["\<Type check error : can not type the goal.\>"]; {}, 
                  \n\t\t\t\t\t\t\t\t
                  DownValues[Type] = 
                    DownValues[Type] /. 
                      Normalize[
                        sol\[LeftDoubleBracket]1\[RightDoubleBracket]]; \n
                  \t\t\t\t\t\t\t\tCallCFLP[ListToCons\ /@\ goal, vars]\n
                  \t\t\t\t\t\t\t]; \n\t\t\t\t\t\tClearVariables[vars]\n
              \t\t\t\t], \n\t\t\t\t
            Def[vars, \(Rule /. {opts}\) /. Options[TSolve], 
              TypeCheck -> False]; \n\t\t\t\t
            sol = CallCFLP[ListToCons\ /@\ goal, vars]\n\t\t\t\t]; \n\t\t\t
          DownValues[RewriteRuleList] = saveRewriteRuleList; \n\t\t\t
          DownValues[IsDefinedFunctionSymbol] = saveIsDefinedFunctionSymbol; 
          \n\t\t\tDownValues[IsConstructor] = saveIsConstructor; \n\t\t\t
          DownValues[Type] = saveType; \n\t\t\tsol\n\t\t\t]\n\t]; \n\n
    TSolve[goal_, vars_List, args___] := TSolve[{goal}, vars, args]; \n
    TSolve[___] := Print["\<Error: invalid syntax call.\>"]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Normalize", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tNormalize",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["subst",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "]\n",
  StyleBox["Input\n\tsubst ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a substitution represented as a set of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " transformation rules.\n",
  StyleBox["Output\n\tsubst  ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "normalized\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Clear[Normalize]; \n
    Normalize[\[Theta]_] := 
      Inner[Rule, First\ /@\ \[Theta], Last\ /@\ \[Theta] //. \[Theta], 
        List]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{736, 887},
WindowMargins->{{179, Automatic}, {-56, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 62, 1, 104, "Title"],
Cell[1796, 54, 171, 4, 27, "Input",
  InitializationCell->True],
Cell[1970, 60, 3225, 63, 683, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5220, 127, 39, 0, 54, "Subtitle"],
Cell[5262, 129, 130, 3, 32, "Text"],
Cell[5395, 134, 192, 4, 59, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5612, 142, 27, 0, 45, "Subsection"],
Cell[5642, 144, 230, 5, 43, "Input",
  InitializationCell->True],
Cell[5875, 151, 215, 5, 43, "Input",
  InitializationCell->True],
Cell[6093, 158, 233, 5, 43, "Input",
  InitializationCell->True],
Cell[6329, 165, 325, 6, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6703, 177, 34, 0, 54, "Subtitle"],

Cell[CellGroupData[{
Cell[6762, 181, 24, 0, 52, "Section"],
Cell[6789, 183, 183, 5, 27, "Input",
  InitializationCell->True],
Cell[6975, 190, 383, 7, 171, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7383, 201, 37, 0, 45, "Subsection"],
Cell[7423, 203, 382, 9, 139, "Input",
  InitializationCell->True],
Cell[7808, 214, 369, 10, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8214, 229, 28, 0, 45, "Subsection"],
Cell[8245, 231, 855, 36, 158, "Text"],
Cell[9103, 269, 117, 3, 27, "Input",
  InitializationCell->True],
Cell[9223, 274, 2766, 47, 715, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[12026, 326, 31, 0, 45, "Subsection"],
Cell[12060, 328, 671, 27, 140, "Text"],
Cell[12734, 357, 317, 9, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13100, 372, 22, 0, 52, "Section"],
Cell[13125, 374, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[13294, 381, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

