(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32536,       1196]*)
(*NotebookOutlinePosition[     33345,       1224]*)
(*  CellTagsIndexPosition[     33301,       1220]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["The Scheduler", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementation of the scheduler. The \
scheduler is the component of the system which handles the solving process of \
constraints by commonicating with specific constraint solvers.\
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Scheduler`\>", \n
      \t{"\<TermSyntax`\>", \n\t\t"\<TypeSyntax`\>", \n\t\t"\<Types`\>"}\n]; 
    \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Constraints::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Scheduler::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSolve::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSStart::usage = 
      "\<CSStart[] creates the links to constraint solvers.\>"; \)\)], "Input",\

  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSEnd::usage = 
      "\<CSEnd[] closes links to all constraint solvers. CSlink[link] closes \
the link object link.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Ask::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(GetVars::usage = "\<GetVars[expr] yields the variables of expr.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Vars::usage = 
      "\<Vars[{idx}] gives the list of variables of Constraints\
\[LeftDoubleBracket]idx\[RightDoubleBracket]\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Substitution::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SetCSQuery::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Global`goalVar::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[BoxData[
    \(\(Off[Solve::"\<svars\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shared Variables", "Section"],

Cell[CellGroupData[{

Cell["Shared Variables Visible from the Outside", "Subsection"],

Cell[CellGroupData[{

Cell["Vars", "Subsubsection"],

Cell[TextData[{
  StyleBox["Vars",
    FontWeight->"Bold"],
  " is a table with entries for the variables of the queries submitted to the \
scheduler. \n",
  StyleBox["Vars[{1}]",
    FontWeight->"Bold"],
  " is the list of variables of the first query, \[Ellipsis], ",
  StyleBox["Vars[{CnstrIdx}]",
    FontWeight->"Bold"],
  " is the list of variables of query ",
  StyleBox["CnstrIdx",
    FontWeight->"Bold"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Substitution", "Subsubsection"],

Cell[TextData[{
  StyleBox["Substitution",
    FontWeight->"Bold"],
  " is a table with entries for the substitutions computed by the CFLP \
calculus for the queries submitted to the scheduler. \n",
  StyleBox["Substitution[{1}]",
    FontWeight->"Bold"],
  " is the substitution computed for the first query, \[Ellipsis], ",
  StyleBox["Substitution[{CnstrIdx}]",
    FontWeight->"Bold"],
  " is the substitution computed for the ",
  StyleBox["CnstrIdx",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\^th\)]],
  " query."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Constraints", "Subsubsection"],

Cell[TextData[{
  StyleBox["Constraints",
    FontWeight->"Bold"],
  " is a nested list that contains pairs of the form ",
  StyleBox["{",
    FontWeight->"Bold"],
  StyleBox["constraints",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontWeight->"Bold"],
  StyleBox["methods",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}",
    FontWeight->"Bold"],
  ", where: \n",
  StyleBox["constraints",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a list of constraints\n",
  StyleBox["methods",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the list of methods that are currently considered for solving \
constraints"
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["Constraints",
          FontWeight->"Bold"], ":=", \({}\)}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shared Variables which are Private", "Subsection"],

Cell[CellGroupData[{

Cell["Status", "Subsubsection"],

Cell[BoxData[
    \(\(Status[_] := "\<idle\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CnstrIdx", "Subsubsection"],

Cell[BoxData[
    \(\(CnstrIdx := {0}; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkId", "Subsubsection"],

Cell[TextData[{
  StyleBox["LinkId[{ ",
    FontWeight->"Bold"],
  StyleBox["idx ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}]",
    FontWeight->"Bold"],
  " stores the link to the constraint solver which currently acts on the set \
of constraints ",
  StyleBox["Constraints[[",
    FontWeight->"Bold"],
  StyleBox["idx",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]]",
    FontWeight->"Bold"]
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["MethodList", "Subsubsection"],

Cell[TextData[{
  StyleBox["MethodList",
    FontWeight->"Bold"],
  " stores the identifiers for the methods that are applied on the systems of \
constraints."
}], "Text"],

Cell[BoxData[
    \(\(MethodList := {"\<Polynomial\>"}; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["External Processes", "Section"],

Cell[CellGroupData[{

Cell["Links to external processes", "Subsection"],

Cell[CellGroupData[{

Cell["CSStart", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["CSStart[ ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["CSStart[ ]",
    FontWeight->"Bold"],
  " attempts to open the links to the external constraint solvers and \
displays a message about the failure or success of the operation.\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(CSStart[] := \n\t
      Block[{timer = 0}, \n
        \t\t$LinearLink = 
          LinkLaunch[
            "\<math -mathlink -batchoutput -run \
\"Off[Solve::\"svars\"]\"\>"]; \n\t\t$PolyLink = $LinearLink; \n\t\t
         (*\ wait\ at\ most\ 10\ seconds\ to\ establish\ the\ connection\ *) 
          \n\t\tWhile[Not[LinkReadyQ[$LinearLink]], \n\t\t\t
          If[\(timer++\) < 10, \n\t\t\t\tPause[1]; Continue[], \n\t\t\t\t
            LinkClose[$LinearLink]; \n\t\t\t\t
            Return["\<failed to connect to constraint solvers.\>"]\n\t\t\t]\n
          \t\t]; \n\t\t
        Return["\<connection to constraint solvers established.\>"]\n\t]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.500008, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CSEnd", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["CSEnd[ ] \n\t",
    FontWeight->"Bold"],
  "or",
  StyleBox["\n\tCSEnd[ ",
    FontWeight->"Bold"],
  StyleBox["link ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["CSEnd[ ]",
    FontWeight->"Bold"],
  " closes all the links to external constraint solvers.\n\t",
  StyleBox["CSEnd[ ",
    FontWeight->"Bold"],
  StyleBox["link ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  " closes link object ",
  StyleBox["link",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(CSEnd[] := CSEnd/@\ {$PolyLink, $LinearLink}; \n
    CSEnd[link_] := \n\t
      If[MemberQ[Links[], link], \n\t\t
        LinkWrite[link, Unevaluated[EvaluatePacket[Exit[]]]]; \n\t\t
        LinkClose[link]; "\<closed\>", \n\t\t"\<already closed\>"\n\t]; \)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.500008, 0]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Communication with external solvers", "Subsection"],

Cell[CellGroupData[{

Cell["SetCSQuery", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["SetCSQuery[ ",
    FontWeight->"Bold"],
  StyleBox["vars, subst, cnstrs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the list of variables of cnstrs\n\t",
  StyleBox["subst",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : variable substitution generated by a CFLP refutation\n\t",
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the list of constraints generated by a CFLP refutation\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tget available data from ",
  StyleBox["link",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " \n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(SetCSQuery[vars_, subst_, cnstrs_] := \n\t
      Block[{extSolver, \ eqFilter}, \n\t\tVars[\(++CnstrIdx\)] = vars; \n\t\t
        Substitution[CnstrIdx] = subst; \n\t\tAppendTo[Constraints, cnstrs]; 
        \n\t\t{extSolver, \ eqFilter} = CS[First[MethodList]]; \n\t\t
        extSolver[eqFilter[cnstrs]]; \n\t\t"\<OK\>"\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ask", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Ask[ ",
    FontWeight->"Bold"],
  StyleBox["link ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["link",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the link object to the external solver\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tget available data from ",
  StyleBox["link",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " \n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(Ask[link_] := \n\t
      Block[{IDX, sol}, \n\t\t
        If[LinkReadyQ[link], \n
          \t\t\t{IDX, sol} = 
            \((LinkRead[link])\)\[LeftDoubleBracket]1\[RightDoubleBracket]; \n
          \t\t\tAnswer[IDX] = Map[Union, sol] /. Rule -> eq]\n\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.500008, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinSolve", "Subsubsection"],

Cell[BoxData[
    \(\(LinSolve[Cs_] := \n\t
      \((\(LinkWrite[#4, \n\t\t\t
              Unevaluated[
                EvaluatePacket[{#5, Solve[\ #1, #2, Complement[#3, #2]]}]]]&
            \)[\n\t\t\tCs /. eq -> Equal, \n\t\t\t
          GetVars[Global`goalVar //. Substitution[CnstrIdx]], \n\t\t\t
          Vars[CnstrIdx], \n\t\t\t$LinearLink, \n\t\t\tCnstrIdx]; \n\t\t
        LinkId[CnstrIdx] = $LinearLink)\); \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.500008, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PolySolve", "Subsubsection"],

Cell[BoxData[
    \(\(PolySolve[Cs_] := \n\t
      \((\(LinkWrite[#4, \n\t\t\t
              Unevaluated[
                EvaluatePacket[{#5, Solve[\ #1, #2, Complement[#3, #2]]}]]]&
            \)[\n\t\t\tCs /. eq -> Equal, \n\t\t\t
          GetVars[Global`goalVar //. Substitution[CnstrIdx]], \n\t\t\t
          Vars[CnstrIdx], \n\t\t\t$PolyLink, \n\t\t\tCnstrIdx]; \n\t\t
        LinkId[CnstrIdx] = $PolyLink)\); \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.500008, 0]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clasifiers", "Section"],

Cell[CellGroupData[{

Cell["IsVar", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsVar[",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\texpr ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  belongs to ",
  StyleBox["Vars[CnstrIdx]",
    FontWeight->"Bold"],
  "\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(IsVar[x_] := MemberQ[Vars[CnstrIdx], x]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsNumericTerm[",
    FontWeight->"Bold"],
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\tterm ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if term is a term without variable\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(IsNumericTerm[_?IsVar] := \ False; \n
    IsNumericTerm[t_] := Not[MemberQ[t, _?IsVar, \(-1\)]]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsPolyTerm", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsPolyTerm[",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\texpr ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  denotes a polynomial term\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(IsPolyTerm[_?IsVar] := True; \nIsPolyTerm[_?IsNumericTerm] := \ True; \n
    IsPolyTerm[Times[\(-1\), t_]] := IsPolyTerm[t]; \n
    IsPolyTerm[Power[t_, _Integer]] := IsPolyTerm[t]; \n
    IsPolyTerm[t1_ + t2_] := IsPolyTerm[t1] \[And] IsPolyTerm[t2]; \n
    IsPolyTerm[t1_\ *\ t2_] := IsPolyTerm[t1] \[And] IsPolyTerm[t2]; \n
    IsPolyTerm[_] := False; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsLinTerm", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsLinTerm[",
    FontWeight->"Bold"],
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\tterm ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a  ",
  StyleBox["linear",
    FontSlant->"Italic"],
  "  term\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(IsLinTerm[\((x_?IsNumericTerm | x_?IsVar)\)] := \ True; \n
    IsLinTerm[Times[\(-1\), x___]] := IsLinTerm[Times[x]]; \n
    IsLinTerm[f_[t___]] /; f === Times := \ \n\ \ 
      MatchQ[{t}, {___?IsNumericTerm} | {___?IsNumericTerm, \n\ \ \ \ \ \ \ \ 
            x_?IsVar, ___?IsNumericTerm}]; \n
    IsLinTerm[Plus[x_, y_]] := IsLinTerm[x] \[And] IsLinTerm[y]; \n
    IsLinTerm[Plus[x_, y__]] := IsLinTerm[x]\  \[And] \ IsLinTerm[Plus[y]]; \n
    IsLinTerm[x_] := \ False; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Constraint Filters ", "Section"],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection"],

Cell[CellGroupData[{

Cell["PolyForm", "Subsubsection"],

Cell[BoxData[
    \(\(PolyForm[eq[expr1_, expr2_]] := \n\t
      Block[{e1, e2}, \n\t\te1 = Factor[expr1]; \n\t\te2 = Factor[expr2]; \n
        \t\teq[Numerator[e1]*Denominator[e2], Numerator[e2]*Denominator[e1]]\n
        \t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GetVars", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tGetVars[",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\texpr ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tThe list of variables of ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(GetVars[t_] := Union[Cases[{t}, \ _Symbol?IsVar, \ \(-1\)]]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PolyFilter", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tPolyFilter[",
    FontWeight->"Bold"],
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\tcnstrs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a list of constraints\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tThe sublist of ",
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " which are polynomial equations\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(PolyFilter[Cs_] := \ \n\t
      Select[Cs, MatchQ[#, eq[_?IsPolyTerm, _?IsPolyTerm]]&]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinFilter", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tPolyFilter[",
    FontWeight->"Bold"],
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\tcnstrs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a list of constraints\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tThe sublist of ",
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " which are linear equations\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(LinFilter[Cs_] := \ \n\t\ 
      Select[PolyForm\ /@\ Cs, MatchQ[#, eq[_?IsLinTerm, _?IsLinTerm]]&]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.6, 0]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Constraint Selectors", "Section"],

Cell[CellGroupData[{

Cell["GetEqs", "Subsection"],

Cell[BoxData[
    \(\(GetEqs[Cs_, "\<Polynomial\>"] := \ \n\t
      PolyForm\ /@\ Select[Cs, MatchQ[#, eq[_?IsPolyTerm, _?IsPolyTerm]]&]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.500008, 0]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CS", "Section"],

Cell[BoxData[
    \(CS["\<Polynomial\>"] := {PolySolve, PolyFilter}; \n
    CS["\<Linear\>"] := {LinSolve, LinFilter}; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0.500008, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Constraint Scheduler", "Section"],

Cell[CellGroupData[{

Cell["CSolve", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tCSolve[{",
    FontWeight->"Bold"],
  StyleBox["eqs,methods",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}",
    FontWeight->"Bold"],
  StyleBox[",idx",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\teqs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "equations to be solved",
  StyleBox["\n\t",
    FontWeight->"Bold"],
  StyleBox["methods",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "list of solving  methods considered for ",
  StyleBox["eqs\n\tidx",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" :",
    FontWeight->"Bold"],
  " position slot for the (partial) solutions of {",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ",",
  StyleBox[" methods",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "} in the nested structure ",
  StyleBox["Sol",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " of solutions\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tsee implementation\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Clear[CSolve]; \n
    CSolve[{{eqs__eq}, Ms_List}, idx_] := \n\t
      Block[{extSolver, \ eqFilter, CnstrIdx = {First[idx]}, result}, \n\t\t
        If[Head[Answer[idx]] =!= Answer, \n\t\t\t
          If[Answer[idx] === {{eqs}}, \n\t\t\t\t{{eqs}, Rest[Ms]}, \n\t\t\t\t
            result = \n\t\t\t\t\t
              If[Answer[idx] =!= {}, \n\t\t\t\t\t\t
                Function[{#, Complement[MethodList, {First[Ms]}]}]\ /@
                  Answer[idx], \n\t\t\t\t\t\t{{eqs}, Ms}]; \n\t\t\t\t
            Answer[idx] =. ; \n\t\t\t\tStatus[idx] = "\<idle\>"; \n\t\t\t\t
            IsOver = False; \n\t\t\t\tresult], \n\t\t\t
          Switch[Status[idx], \n\t\t\t\t"\<waiting\>", Ask[LinkId[idx]]; \n
            \t\t\t\tIsOver = False; \n\t\t\t\t{{eqs}, Ms}, \n\t\t\t\t
            "\<idle\>", \n\t\t\t\t
            If[Ms === {}, \n\t\t\t\t\t
              LinkWrite[$ParentLink, \n\t\t\t\t\t\t
                ReturnPacket[\n\t\t\t\t\t\t\t\t
                  FilterSubstitution[Substitution[{First[idx]}], \n
                    \t\t\t\t\t\t\t\t\t
                    First[Constraints
                        \[LeftDoubleBracket]Sequence\ @@\ idx
                          \[RightDoubleBracket]]]\n\t\t\t\t\t\t\t]\n
                \t\t\t\t\t]; \n\t\t\t\t\t
              Status[idx] = "\<done\>"; {{eqs}, Ms}, \n
              \t\t\t\t\t{extSolver, \ eqFilter} = CS[First[Ms]]; \n\t\t\t\t\t
              Status[idx] = "\<waiting\>"; \n\t\t\t\t\t
              extSolver[
                eqFilter[
                  Constraints
                    \[LeftDoubleBracket]Sequence\ @@\ idx
                      \[RightDoubleBracket]]]; \n\t\t\t\t\t
              IsOver = False; {{eqs}, Ms}\n\t\t\t\t]\n\t\t\t]\n\t\t]\n\t]; \n
    CSolve[xs_, _] := xs; \)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0.500008, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scheduler", "Subsection"],

Cell[BoxData[
    \(\(Scheduler[] := \n\t
      Block[{Answer, IsWaiting, IsOver = False}, \n\t\t
        Module[{pos}, \n\t\t\t
          For[pos = 1, pos <= Length[Constraints], \(pos++\), 
            Status[{pos}] = "\<waiting\>"]; \n\t\t\t
          Constraints = Map[{#, MethodList}&, Constraints]; \n\t\t\t
          While[Not[IsOver], \n\t\t\t\tIsOver = True; \n\t\t\t\t
            Constraints = MapIndexed[CSolve, Constraints, Infinity]\n\t\t\t]; 
          \n\t\t\tCnstrIdx = {0}; \n\t\t\tConstraints = {}; \n\t\t\t
          Clear[Substitution, Vars, Status]; \n\t\t\tStatus[_] := "\<idle\>"; 
          \n\t\t\t"\<done.\>"\n\t\t]\n\t]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0.500008, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FilterSubstitution", "Subsection"],

Cell[BoxData[
    \(Clear[FilterSubstitution]; \n
    FilterSubstitution[
        subst_, {u___, eq[x_?IsVar, t_] | eq[t_, x_?IsVar], v___}] := \n\t
      FilterSubstitution[Append[subst, x -> t], {u, v}]; \n
    FilterSubstitution[u_, v_] := {u, v}; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0.500008, 0],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{839, 751},
WindowMargins->{{Automatic, 103}, {Automatic, 69}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 69, 1, 104, "Title"],
Cell[1803, 54, 171, 4, 27, "Input",
  InitializationCell->True],
Cell[1977, 60, 3225, 63, 683, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5227, 127, 39, 0, 54, "Subtitle"],
Cell[5269, 129, 231, 4, 50, "Text"],
Cell[5503, 135, 275, 7, 91, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5803, 146, 27, 0, 45, "Subsection"],
Cell[5833, 148, 124, 3, 27, "Input",
  InitializationCell->True],
Cell[5960, 153, 122, 3, 27, "Input",
  InitializationCell->True],
Cell[6085, 158, 119, 3, 27, "Input",
  InitializationCell->True],
Cell[6207, 163, 188, 5, 27, "Input",
  InitializationCell->True],
Cell[6398, 170, 225, 5, 43, "Input",
  InitializationCell->True],
Cell[6626, 177, 116, 3, 27, "Input",
  InitializationCell->True],
Cell[6745, 182, 177, 4, 27, "Input",
  InitializationCell->True],
Cell[6925, 188, 233, 5, 27, "Input",
  InitializationCell->True],
Cell[7161, 195, 125, 3, 27, "Input",
  InitializationCell->True],
Cell[7289, 200, 123, 3, 27, "Input",
  InitializationCell->True],
Cell[7415, 205, 127, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7591, 214, 34, 0, 54, "Subtitle"],
Cell[7628, 216, 129, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7782, 223, 24, 0, 52, "Section"],
Cell[7809, 225, 128, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7974, 233, 35, 0, 52, "Section"],

Cell[CellGroupData[{
Cell[8034, 237, 63, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[8122, 241, 29, 0, 42, "Subsubsection"],
Cell[8154, 243, 432, 14, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8623, 262, 37, 0, 42, "Subsubsection"],
Cell[8663, 264, 556, 16, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9256, 285, 36, 0, 42, "Subsubsection"],
Cell[9295, 287, 688, 26, 68, "Text"],
Cell[9986, 315, 199, 6, 27, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10234, 327, 56, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[10315, 331, 31, 0, 42, "Subsubsection"],
Cell[10349, 333, 124, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[10510, 341, 33, 0, 42, "Subsubsection"],
Cell[10546, 343, 116, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[10699, 351, 31, 0, 42, "Subsubsection"],
Cell[10733, 353, 446, 17, 50, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[11216, 375, 35, 0, 28, "Subsubsection"],
Cell[11254, 377, 171, 5, 32, "Text"],
Cell[11428, 384, 133, 3, 27, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11622, 394, 37, 0, 32, "Section"],

Cell[CellGroupData[{
Cell[11684, 398, 49, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[11758, 402, 32, 0, 42, "Subsubsection"],
Cell[11793, 404, 517, 18, 104, "Text"],
Cell[12313, 424, 759, 16, 235, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[13109, 445, 30, 0, 42, "Subsubsection"],
Cell[13142, 447, 869, 37, 158, "Text"],
Cell[14014, 486, 358, 8, 123, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14421, 500, 57, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[14503, 504, 35, 0, 42, "Subsubsection"],
Cell[14541, 506, 1018, 39, 176, "Text"],
Cell[15562, 547, 427, 7, 155, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[16026, 559, 28, 0, 42, "Subsubsection"],
Cell[16057, 561, 730, 31, 140, "Text"],
Cell[16790, 594, 365, 9, 107, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[17192, 608, 33, 0, 42, "Subsubsection"],
Cell[17228, 610, 502, 10, 155, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[17767, 625, 34, 0, 42, "Subsubsection"],
Cell[17804, 627, 499, 10, 155, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18364, 644, 29, 0, 52, "Section"],

Cell[CellGroupData[{
Cell[18418, 648, 27, 0, 45, "Subsection"],
Cell[18448, 650, 900, 41, 158, "Text"],
Cell[19351, 693, 140, 3, 27, "Input",
  InitializationCell->True],
Cell[19494, 698, 725, 31, 158, "Text"],
Cell[20222, 731, 192, 4, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[20451, 740, 32, 0, 45, "Subsection"],
Cell[20486, 742, 859, 38, 158, "Text"],
Cell[21348, 782, 450, 8, 123, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[21835, 795, 31, 0, 45, "Subsection"],
Cell[21869, 797, 831, 38, 158, "Text"],
Cell[22703, 837, 569, 10, 139, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23321, 853, 38, 0, 52, "Section"],

Cell[CellGroupData[{
Cell[23384, 857, 41, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[23450, 861, 33, 0, 42, "Subsubsection"],
Cell[23486, 863, 305, 6, 107, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[23828, 874, 32, 0, 42, "Subsubsection"],
Cell[23863, 876, 694, 30, 140, "Text"],
Cell[24560, 908, 163, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24772, 918, 32, 0, 45, "Subsection"],
Cell[24807, 920, 714, 29, 140, "Text"],
Cell[25524, 951, 187, 4, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[25748, 960, 31, 0, 45, "Subsection"],
Cell[25782, 962, 710, 29, 140, "Text"],
Cell[26495, 993, 205, 5, 43, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26749, 1004, 39, 0, 32, "Section"],

Cell[CellGroupData[{
Cell[26813, 1008, 28, 0, 45, "Subsection"],
Cell[26844, 1010, 225, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27118, 1021, 21, 0, 52, "Section"],
Cell[27142, 1023, 199, 4, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[27378, 1032, 43, 0, 52, "Section"],

Cell[CellGroupData[{
Cell[27446, 1036, 28, 0, 45, "Subsection"],
Cell[27477, 1038, 1360, 56, 176, "Text"],
Cell[28840, 1096, 1915, 37, 587, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[30792, 1138, 31, 0, 45, "Subsection"],
Cell[30826, 1140, 786, 15, 267, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[31649, 1160, 40, 0, 45, "Subsection"],
Cell[31692, 1162, 388, 9, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32129, 1177, 22, 0, 52, "Section"],
Cell[32154, 1179, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[32323, 1186, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

