(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7814,        236]*)
(*NotebookOutlinePosition[      8484,        260]*)
(*  CellTagsIndexPosition[      8440,        256]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Rewrite Rules", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains commands operating on conditional rewrite \
rules.\
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<RewriteRules`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(RewriteRuleList::usage = 
      "\<RewriteRuleList[f] gives the list of representations for the CRRs \
associated to the defined function symbol f.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(RewritesTo::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(BeginRule::usage = 
      "\<BeginRule[ ] clears the downvalues of RewriteRuleList associated to \
the defined function symbols.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.700008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[CellGroupData[{

Cell["BeginRule", "Subsubsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tBeginRule[ ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tclears the downvalues of ",
  StyleBox["RewriteRuleList",
    FontWeight->"Bold"],
  " associated to the defined function \n  symbols.\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(BeginRule[] := \n\t
      \(($RecursionLimit := 8000; \n\t\tClear[RewriteRuleList]; \n\t\t
        RewriteRuleList[_] := {})\); \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.501961],
  Background->None]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.700008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.700008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{520, 600},
WindowMargins->{{311, Automatic}, {81, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 69, 1, 104, "Title"],
Cell[1803, 54, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[1977, 60, 3225, 63, 1083, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5227, 127, 39, 0, 54, "Subtitle"],
Cell[5269, 129, 96, 3, 32, "Text"],
Cell[5368, 134, 194, 5, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5587, 143, 27, 0, 45, "Subsection"],
Cell[5617, 145, 256, 5, 59, "Input",
  InitializationCell->True],
Cell[5876, 152, 123, 3, 27, "Input",
  InitializationCell->True],
Cell[6002, 157, 237, 5, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6288, 168, 34, 0, 54, "Subtitle"],

Cell[CellGroupData[{
Cell[6347, 172, 24, 0, 52, "Section"],
Cell[6374, 174, 183, 5, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[6582, 183, 56, 1, 42, "Subsubsection"],
Cell[6641, 186, 462, 17, 122, "Text"],
Cell[7106, 205, 252, 6, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7407, 217, 22, 0, 52, "Section"],
Cell[7432, 219, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[7601, 226, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

