(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28523,        900]*)
(*NotebookOutlinePosition[     29332,        928]*)
(*  CellTagsIndexPosition[     29288,        924]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Rewrite Rule Definitions", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \( (*\nNO\ WARRANTY\n\n
      The\ program\ was\ produced\ on\ an\ experimental\ basis\ in\ the\n
      course\ of\ the\ research\ and\ development\ conducted\ during\ the\ 
        project\n
      and\ is\ provided\ to\ users\ as\ so\ produced\ on\ an\ experimental\ 
        basis.\nAccordingly, \ 
      the\ program\ is\ provided\ without\ any\ warranty\ whatsoever, \n
      whether\ express, \ implied, \ 
      statutory\ or\ otherwise.\ The\ term\ "\<warranty\>"\n
      used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      any\ warranty\ of\ the\n
      quality, \ performance, \ 
      merchantability\ and\ fitness\ for\ a\ particular\n
      purpose\ of\ the\ program\ and\ the\ nonexistence\ of\ any\ infringement
        \ or\n
      violation\ of\ any\ right\ of\ any\ third\ party.\n\nEach\ user\ of\ the
        \ program\ will\ agree\ and\ understand, \ and\ be\n
      deemed\ to\ have\ agreed\ and\ understood, \ 
      that\ there\ is\ no\ warranty\n
      whatsoever\ for\ the\ program\ and, \ accordingly, \ 
      the\ entire\ risk\ arising\n
      from\ or\ otherwise\ connected\ with\ the\ program\ is\ assumed\ by\ the
        \ user.\n\nTherefore, \ neither\ ICOT, \ the\ copyright\ holder, \ 
      or\ any\ other\n
      organization\ that\ participated\ in\ or\ was\ otherwise\ related\ to\ 
        the\n
      development\ of\ the\ program\ and\ their\ respective\ officials, \ 
      directors, \n
      officers\ and\ other\ employees\ shall\ be\ held\ liable\ for\ any\ and
        \ all\n
      damages, \ including, \ without\ limitation, \ general, \ special, \ 
      incidental\n
      and\ consequential\ damages, \ 
      arising\ out\ of\ or\ otherwise\ in\ connection\n
      with\ the\ use\ or\ inability\ to\ use\ the\ program\ or\ any\ product, 
      \ material\n
      or\ result\ produced\ or\ otherwise\ obtained\ by\ using\ the\ program, 
      \nregardless\ of\ whether\ they\ have\ been\ advised\ of, \ 
      or\ otherwise\ had\n
      knowledge\ of, \ 
      the\ possibility\ of\ such\ damages\ at\ any\ time\ during\ the\n
      project\ or\ thereafter.\ Each\ user\ will\ be\ deemed\ to\ have\ agreed
        \ to\ the\n
      foregoing\ by\ his\ or\ her\ commencement\ of\ use\ of\ the\ 
        program.\ The\ term\n
      "\<use\>"\ as\ used\ herein\ includes, \ but\ is\ not\ limited\ to, \ 
      the\ use, \nmodification, \ 
      copying\ and\ distribution\ of\ the\ program\ and\ the\n
      production\ of\ secondary\ products\ from\ the\ program.\n\nIn\ the\ 
        case\ where\ the\ program, \ whether\ in\ its\ original\ form\ or\n
      modified, \ 
      was\ distributed\ or\ delivered\ to\ or\ received\ by\ a\ user\ from\n
      any\ person, \ organization\ or\ entity\ other\ than\ ICOT, \ 
      unless\ it\ makes\ or\n
      grants\ independently\ of\ ICOT\ any\ specific\ warranty\ to\ the\ user
        \ in\n
      writing, \ such\ person, \ organization\ or\ entity, \ 
      will\ also\ be\ exempted\n
      from\ and\ not\ be\ held\ liable\ to\ the\ user\ for\ any\ such\ damages
        \ as\ noted\n
      above\ as\ far\ as\ the\ program\ is\ \(concerned.\)\t\n*) \)], "Input",\

  InitializationCell->True],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementation of command Def for \
defining rewrite rules.\
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<RewriteRuleDefs`\>", \n\t{"\<RewriteRules`\>"}]; 
    \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Off[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Def::usage = 
      "\<Def[vars, {rule1, rule2, \[Ellipsis] }] appends the results of \
encoding rulei to RewriteRuleList[f], where f is the head function symbol of \
rulei.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($ContextPath = \n\t
      Join[{"\<Variables`\>", "\<TermSyntax`\>", "\<Types`\>", "\<Terms`\>", 
          "\<TypeChecker`\>"}, $ContextPath]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["FormFunction", "Subsubsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tFormFunction[ ",
    FontWeight->"Bold"],
  StyleBox["params,lvars,term,cnd",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["params,lvars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : lists of Mathematica symbols\n\t",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  : a term,\n\t",
  StyleBox["cnd",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : pair of the form ",
  StyleBox["{ ",
    FontWeight->"Bold"],
  StyleBox["ppeqs, eqs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}",
    FontWeight->"Bold"],
  " where ",
  StyleBox["ppeqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a list of parameter passing equations and ",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a list of initial equations.\n\n\tThese four terms are those involved \
in the encoding of a conditional rewrite rule ",
  StyleBox["R.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tthe encoding corresponding to ",
  StyleBox["R",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". \n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    StyleBox[
      \(FormFunction[par_, localVar_, t_, {c___}] := \n\t
        Function[par, \n\t\tModule[localVar, RewritesTo[t, c]]\n\t]; \),
      FontFamily->"Courier"]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Def", "Subsubsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDef[",
    FontWeight->"Bold"],
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  {",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["rule",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["rule",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["}] \n   or\n   \tDef[",
    FontWeight->"Bold"],
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  {",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["rule",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["rule",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["}, TypeCheck->",
    FontWeight->"Bold"],
  StyleBox["b",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[GridBox[{
          {
            StyleBox[
              RowBox[{
                FormBox[
                  SubscriptBox[
                    StyleBox["rule",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox["1",
                      FontWeight->"Bold"]],
                  "TraditionalForm"], ",", " ", "\[Ellipsis]", " ", ",", " ", 
                
                FormBox[
                  SubscriptBox[
                    StyleBox["rule",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox["n",
                      FontWeight->"Bold",
                      FontSlant->"Plain"]],
                  "TraditionalForm"]}],
              FontWeight->"Bold"], ":", \(conditional\ rewrite\ rules\)},
          {
            StyleBox["vars",
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", 
            RowBox[{
              RowBox[{
              "the", " ", "list", " ", "of", " ", "variables", " ", 
                "appearing", " ", "in", " ", 
                StyleBox[
                  FormBox[
                    RowBox[{" ", 
                      SubscriptBox[
                        StyleBox["rule",
                          FontWeight->"Bold",
                          FontSlant->"Italic"], 
                        StyleBox["1",
                          FontWeight->"Bold"]]}],
                    "TraditionalForm"],
                  FontWeight->"Bold"]}], 
              StyleBox[",",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox["\[Ellipsis]",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox[",",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox[
                FormBox[
                  SubscriptBox[
                    StyleBox["rule",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox["n",
                      FontWeight->"Bold",
                      FontSlant->"Plain"]],
                  "TraditionalForm"],
                FontWeight->"Bold"]}]},
          {
            StyleBox["b",
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", 
            RowBox[{
              StyleBox["True",
                FontWeight->"Bold"], " ", "or", " ", 
              StyleBox["False",
                FontWeight->"Bold"]}]}
          }]]],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tfor every conditional rewrite rule ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["rule",
          FontWeight->"Bold",
          FontSlant->"Italic"], 
        StyleBox["i",
          FontWeight->"Bold"]]]],
  " of the form  ",
  StyleBox["f[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" , \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["m",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox["] \[RightArrow] t \[DoubleLeftArrow] ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  " \[And]\[CenterEllipsis]\[And] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["p",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " perform the following steps\n\t\[Diamond] type check ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["rule",
          FontWeight->"Bold",
          FontSlant->"Italic"], 
        StyleBox["i",
          FontWeight->"Bold"]]]],
  " only if the option ",
  StyleBox["TypeCheck ->True",
    FontWeight->"Bold"],
  " is specified, or no ",
  StyleBox["TypeCheck",
    FontWeight->"Bold"],
  " option is specified but \n\ttype-checking is switched on; \n\t if ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["rule",
          FontWeight->"Bold",
          FontSlant->"Italic"], 
        StyleBox["i",
          FontWeight->"Bold"]]]],
  " is ill typed then give an error message and return \"\[UpTee]\",\n\t\
\[Diamond] add ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["rule",
          FontWeight->"Bold",
          FontSlant->"Italic"], 
        StyleBox["i",
          FontWeight->"Bold"]]]],
  " to the list of conditional rewrite rules associated with ",
  StyleBox["f",
    FontWeight->"Bold"],
  ". \n\t\[Diamond] Return \"\[DownTee]\" if all conditional rewrite rules \
were successfully inserted in the corresponding rewrite rule lists.\n",
  StyleBox["Remarks",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tThe encoding of a CRR of the form  ",
  StyleBox["f[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" , \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["m",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox["] \[RightArrow] t \[DoubleLeftArrow] ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  " \[And]\[CenterEllipsis]\[And] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["p",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " is \n\t",
  StyleBox["Function[{",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`x\_m\)],
    FontWeight->"Bold"],
  StyleBox["}, Module[{",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`v\_1\)],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`v\_r\)],
    FontWeight->"Bold"],
  StyleBox["}, RewritesTo[t , {",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1 \[CupCap] \)\)],
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ s\_1\)\)],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`x\_m\)],
    FontWeight->"Bold"],
  StyleBox["\[CupCap]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`s\_m\)],
    FontWeight->"Bold"],
  StyleBox["}, {",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] ,",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["e",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["p",
              FontWeight->"Bold",
              FontSlant->"Plain"]]}], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox["}]]] ",
    FontWeight->"Bold"],
  ",",
  StyleBox["\n\t",
    FontWeight->"Bold"],
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`v\_1\)],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`v\_r\)],
    FontWeight->"Bold"],
  " are the rule variables,",
  StyleBox[" ",
    FontWeight->"Bold"],
  "and is added to the list ",
  StyleBox["RewriteRuleList[f]",
    FontWeight->"Bold"],
  " of conditional rewrite rules \n\tassociated with ",
  StyleBox["f",
    FontWeight->"Bold"],
  ".\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    RowBox[{
    \(Def[{}, True | False, _Integer]\  := "\<\[DownTee]\>"\), ";", "\n", 
      \(Def[V_List, {rs___RewriteRule}, opts___] := \n\t
        Block[{answer}, \n\t\tSetVariables[V]; \n\t\t
          answer = 
            Def[Map[TypeChecker`ListToCons, {rs}], 
              \(TypeCheck /. {opts}\) /. Options[TSolve`TSolve], 1]; \n\t\t
          ClearVariables[V]; \n\t\tanswer]\), ";", "\n", 
      RowBox[{
        RowBox[{"Def", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                StyleBox[\(RewriteRule[lhs_, rhs_, cnd_]\),
                  ShowSpecialCharacters->False,
                  ShowStringCharacters->True], ",", "rs___RewriteRule"}], 
              "}"}], ",", "tyChk_", ",", "n_Integer"}], "]"}], ":=", "\n", 
        "\t", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"If", "[", 
              RowBox[{"tyChk", ",", "\n", "\t\t\t", 
                RowBox[{"Block", "[", 
                  RowBox[{
                  \({saveType = DownValues[Type]}\), ",", "\n", "\t\t\t\t", 
                    RowBox[{"If", "[", 
                      RowBox[{
                        RowBox[{
                          RowBox[{"TypeChecker`Tc", "[", 
                            StyleBox[\(RewriteRule[lhs, rhs, cnd]\),
                              ShowSpecialCharacters->False,
                              ShowStringCharacters->True], "]"}], "===", 
                          "\"\<\[UpTee]\>\""}], ",", "\n", "\t\t\t\t\t", 
                        \(Print["\<Type check error at rule #\>", n]; \n
                        \t\t\t\t\tDownValues[Type] = saveType; \n\t\t\t\t\t
                        Return["\<\[UpTee]\>"]\), ",", "\n", "\t\t\t\t\t", 
                        \(DownValues[Type] = saveType\)}], "]"}]}], "]"}]}], 
              "\n", "\t\t", "]"}], ";", "\n", "\t\t", 
            RowBox[{"Block", "[", 
              RowBox[{
              \({\n\t\t\t\t
                  fsymb\  = \ 
                    If[Head[lhs]\  === \ Symbol, \ lhs, \ Head[lhs]], \n
                  \t\t\t\tparameter, cond, lhsV, rhsV, localV}\), ",", "\n", 
                "\t\t\t", 
                RowBox[{
                \(If[IsConstructor[fsymb], \n\t\t\t\t\t
                    Print["\<Constructor symbol \>", \ fsymb, \ 
                      "\< redefined as a defined symbol.\>"]; \ \n\t\t\t\t\t
                    IsConstructor[fsymb]\  =. \ ]\), ";", "\n", "\t\t\t\t", 
                  \(IsDefinedFunctionSymbol[fsymb]\  = \ True\), ";", "\n", 
                  "\t\t\t\t", \(IsFunctionSymbol[fsymb]\  = \ True\), ";", 
                  "\n", "\t\t\t", \({parameter, \ cond}\  = \ Uniform[lhs]\), 
                  ";", "\n", "\t\t\t", \(lhsV\  = \ Var[lhs]\), ";", " ", 
                  "\n", "\t\t\t", \(rhsV\  = \ Var[{rhs, \ cnd}]\), ";", " ", 
                  "\n", "\t\t\t", \(localV\  = \ Union[rhsV, \ lhsV]\), ";", 
                  " ", "\n", "\t\t\t", 
                  RowBox[{"Print", "[", 
                    RowBox[{
                    "\"\<Adding rule #\>\"", ",", "n", ",", "\"\<: \>\"", 
                      ",", 
                      StyleBox[\(RewriteRule[lhs, rhs, cnd]\),
                        ShowSpecialCharacters->False,
                        ShowStringCharacters->True]}], "]"}], ";", "\n", 
                  "\t\t\t", 
                  \(PrintVarDecl[localV, \ Complement[rhsV, lhsV]]\), ";", 
                  "\n", "\t\t\t", 
                  \(AppendTo[RewriteRuleList[fsymb], \n\t\t\t\t
                    FormFunction[parameter, localV, rhs, \n
                      \t\t\t\t\t{cond, \n\t\t\t\t\t\t
                        Switch[cnd, \n\t\t\t\t\t\t\t\((eq | Or)\)[__], 
                          List[cnd], \n\t\t\t\t\t\t\tTrue, {}, \n
                          \t\t\t\t\t\t\t_, List\ @@\ cnd\n\t\t\t\t\t\t]}\n
                      \t\t\t\t]\n\t\t\t]\)}]}], "\n", "\t\t", "]"}], ";", 
            "\n", "\t\t", \(Def[{rs}, tyChk, n + 1]\)}], ")"}]}], ";", "\n", 
      \(Def[___] := 
        \((Print["\<Error: wrong expressions specified as rewrite rules\>"]; 
          "\<\[UpTee]\>")\)\), ";"}]], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Flattening", "Subsubsection",
  Evaluatable->False],

Cell[BoxData[
    RowBox[{\(Clear[Flattening]\), ";", "\n", 
      StyleBox[
        \(Flattening[s_] := \n\t
          Module[{Global`w}, \n\t\tAppendTo[Cond, ppeq[Global`w, s]]; \n\t\t
            PatternVar = Join[PatternVar, Var[s]]; \n\t\tGlobal`w]\),
        FontFamily->"Courier"], 
      StyleBox[";",
        FontFamily->"Courier"]}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PrintVarDecl", "Subsubsection",
  Evaluatable->False],

Cell[BoxData[
    \(\(Clear[PrintVarDecl]; \n
    PrintVarDecl[argVset_, argXV_] := \n\t
      Module[\n\t\t{vset = Sort[argVset], xV = Sort[argXV], suffix1, suffix2, 
          \n\t\tmyInfix = 
            Function[{x, y}, If[Length[x] > 1, Infix[x, y], First[x]]], \n\t\t
          suffix = Function[x, If[Length[x] > 1, "\<s\>", "\<\>"]]}, \n\t\t
        Switch[vset, \n\t\t\t{}, \(-1\), \n\t\t\t{__}, 
          Print["\<Symbol\>", suffix[vset], "\< \>", \n\t\t\t\t
            myInfix[vset, "\<,\>"], "\< declared as  variable\>", \ 
            suffix[vset], "\<.\>"]]; \n\t\t
        Switch[xV, \n\t\t\t{}, \(-1\), \n\t\t\t{__}, 
          Print["\<Symbol\>", suffix[xV], "\< \>", \n\t\t\t\t
            myInfix[xV, "\<,\>"], "\< declared as extra variable\>", 
            suffix[xV], "\<.\>"]\n\t\t]\n\t]; \t\t\)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Uniform", "Subsubsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tUniform[ ",
    FontWeight->"Bold"],
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  : a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tif  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a constant then return",
  StyleBox[" {{},{}}",
    FontWeight->"Bold"],
  "\n\tif  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is of the form  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              StyleBox["f",
                FontSlant->"Plain"], "[", \(term\_1\)}],
            "TraditionalForm"], ",", "\[Ellipsis]", ",", \(term\_n\)}], 
        TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox["]",
    FontWeight->"Bold"],
  " then return a pair ",
  StyleBox["{vars,eqs}",
    FontWeight->"Bold"],
  " where ",
  StyleBox["vars",
    FontWeight->"Bold"],
  " is a \n\tlist of ",
  StyleBox["n",
    FontSlant->"Italic"],
  " fresh variables ",
  Cell[BoxData[
      \(TraditionalForm\`w\_1\)],
    FontWeight->"Bold"],
  StyleBox[",\[Ellipsis],",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`w\_n\)],
    FontWeight->"Bold"],
  " and eqs is the list of parameter passing equations ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(w\_i\),
            "TraditionalForm"], "\[CupCap]", \(term\_i\)}], TraditionalForm]],
    
    FontWeight->"Bold"],
  "\n",
  StyleBox["Example\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Uniform[f[x,r[a],b]]",
    FontWeight->"Bold"],
  " returns the pair \n\t\
{{w$144,w$145,w$146},{w$144\[CupCap]x,w$145\[CupCap]r[a],w$146\[CupCap]b}}\n",
  
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    RowBox[{
    \(Clear[Uniform]\), ";", "\n", \(Uniform[s_Symbol] := {{}, {}}\), ";", 
      "\n", 
      StyleBox[
        \(Uniform[s_] := \n
          Block[{Cond\  = \ {}, \ PatternVar\  = \ {}}, 
            \ {List\ @@\ \(Flattening\ /@\ s\), \ Cond}]\),
        FontFamily->"Courier"], 
      StyleBox[";",
        FontFamily->"Courier"]}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(On[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{741, 600},
WindowMargins->{{Automatic, 180}, {56, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 80, 1, 104, "Title"],
Cell[1814, 54, 171, 4, 27, "Input",
  InitializationCell->True],
Cell[1988, 60, 3225, 63, 683, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5238, 127, 39, 0, 54, "Subtitle"],
Cell[5280, 129, 109, 3, 32, "Text"],
Cell[5392, 134, 229, 6, 43, "Input",
  InitializationCell->True],
Cell[5624, 142, 131, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5780, 149, 27, 0, 45, "Subsection"],
Cell[5810, 151, 282, 6, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6141, 163, 34, 0, 54, "Subtitle"],

Cell[CellGroupData[{
Cell[6200, 167, 24, 0, 52, "Section"],
Cell[6227, 169, 183, 5, 27, "Input",
  InitializationCell->True],
Cell[6413, 176, 303, 7, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[6741, 187, 59, 1, 42, "Subsubsection"],
Cell[6803, 190, 1485, 59, 212, "Text"],
Cell[8291, 251, 293, 7, 75, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8621, 263, 50, 1, 42, "Subsubsection"],
Cell[8674, 266, 10636, 365, 386, "Text"],
Cell[19313, 633, 4310, 83, 715, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[23660, 721, 57, 1, 42, "Subsubsection"],
Cell[23720, 724, 448, 11, 107, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[24205, 740, 59, 1, 42, "Subsubsection"],
Cell[24267, 743, 980, 19, 267, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[25284, 767, 54, 1, 42, "Subsubsection"],
Cell[25341, 770, 2122, 85, 230, "Text"],
Cell[27466, 857, 468, 13, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27983, 876, 22, 0, 52, "Section"],
Cell[28008, 878, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[28177, 885, 130, 3, 27, "Input",
  InitializationCell->True],
Cell[28310, 890, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

