(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     24035,        761]*)
(*NotebookOutlinePosition[     24844,        789]*)
(*  CellTagsIndexPosition[     24800,        785]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["The CFLP Calculus", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[TextData[
"\[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz)"], 
  "Text"],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[
"This package contains the implementation of the CFLP calculus. The program \
implementing the calculus is CFLP. CFLP is an extension with rules for \
handling constraints, of the Hlnc implementation developed by Tetsuo Ida. \
Now, the former syntax call of Hlnc\n\nHlnc[{eqns}], where eqns are the \
equations to be solved\n\nis extended to \n\nCFLP[{eqns}, {cnstrs_1,\
\[Ellipsis],cnstrs_n}]\n\nwhere cnstrs1_, \[Ellipsis], cnstrs_n are sequences \
of equations that can not be solved in the functional logic calculus (so \
called constraints). The semantics of a CFLP call is\n\nsolve the  system of \
equations + constraints\n\n\t{eqns, cnstr_1,. ..,  cnstr_n}\n \nRecursive \
CFLP calls correspond to succesive applications of CFLP inference rules. "], 
  "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Calculus`\>", \n
      \t{"\<Terms`\>", "\<RewriteRules`\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(CallCFLP::usage = 
      "\<CallCFLP[eqn | eqns, vars]\n attempts to solve an equation `eqn` or \
set of equations `eqns` for the variables `vars`.
		It is the designed to be called by TSolve and Tc.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLP::usage = 
      "\<CFLP[eqns,cnstrs] attempts to solve the system of equations `eqns` \
and constraints `cnstrs` for the set of Temporary symbols of `eqns` and \
`cnstrs`. \n
		It is designed to be called by CallCFLP.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Normalize::usage = 
      "\<Normalize[subst] gives the normalization of substitution \
`subst`.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSEnd::usage = 
      "\<CSEnd[ ] closes the Mathlink connections of the CFLP session.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSConnect::usage = 
      "\<CSConnect[ ] creates a new Mathlink connections to the CFLP session.\
\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SetCSVariables::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSlink::usage = 
      "\<CSlink gives the link object used for communication with the \
scheduler.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($ContextPath = 
      Join[{"\<Variables`\>", "\<TermSyntax`\>", "\<TypeSyntax`\>", 
          "\<Types`\>"}, $ContextPath]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " control programs"
}], "Subsection"],

Cell[CellGroupData[{

Cell[" CSConnect", "Subsubsection"],

Cell[BoxData[
    \(\(CSConnect[\ ] := \n\t
      If[MemberQ[Links[], CSlink], \n\t\t
        Print["\<connection to scheduler is already available.\>"], \n\t\t
        CSlink = 
          LinkLaunch[
            "\<math -mathlink -batchoutput -run \"<<Scheduler.m\"\>"]; \n
        \t\t (*\ wait\ at\ most\ 10\ seconds\ to\ establish\ link\ to\ 
            scheduler\ *) \n\t\t
        Block[{timer = 0}, \n\t\t\t
          While[Not[LinkReadyQ[CSlink]], \n\t\t\t\t
            If[\(timer++\) < 10, \n\t\t\t\t\tPause[1]; Continue[], \n
              \t\t\t\t\tLinkClose[CSlink]; \n\t\t\t\t\t
              Return["\<failed to connect to scheduler.\>"]\n\t\t\t\t]\n
            \t\t\t]\n\t\t]; \n\t\t
        Print["\<connection to scheduler established.\>"]; \n\t\t
        LinkWrite[CSlink, Unevaluated[EvaluatePacket[Scheduler`CSStart[]]]]; 
        \n\t\t (*\ wait\ for\ a\ return\ packet\ *) \n\t\t
        While[Not[LinkReadyQ[CSlink]], Continue[]]; \n\t\t
        Print[\(LinkRead[CSlink]\)\[LeftDoubleBracket]1\[RightDoubleBracket]]
          \n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CSConnect[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \("connection to scheduler is already available."\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CSEnd", "Subsubsection"],

Cell[BoxData[
    \(\(CSEnd[\ ] := \n\t
      If[MemberQ[Links[], CSlink], \n\t\t
        LinkWrite[CSlink, Unevaluated[EvaluatePacket[CSEnd[]]]]; \n\t\t
        LinkWrite[CSlink, Unevaluated[EvaluatePacket[Exit[]]]]; \n\t\t
        LinkClose[CSlink]; \n\t\tPrint["\<done.\>"], \n\t\t
        Print["\<link already disabled.\>"]]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetCSType", "Subsubsection"],

Cell[BoxData[
    \(\(SetCSType[typeDownvals_] := \n\t
      \((\(LinkWrite[CSlink, \ \n\t\t\t\t
              Unevaluated[EvaluatePacket[DownValues[Types`Type]\  = \ #1]; 
                \ ]]&\)\n\t\t\t[typeDownvals]; \n\t\t
        While[Not[LinkReadyQ[CSlink]], Continue[]]; \n\t\tLinkRead[CSlink]\n
        \t)\); \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0.500008, 0, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetCSgoalVars", "Subsubsection"],

Cell[BoxData[
    \(\(SetCSgoalVars[vars_] := \n\t
      \((\(LinkWrite[CSlink, \ \n\t\t\t\t
              Unevaluated[EvaluatePacket[Global`goalVar = \ #1]; ]]&\)\n\t\t[
          vars]; \n\t\tWhile[Not[LinkReadyQ[CSlink]], Continue[]]; \n\t\t
        LinkRead[CSlink]\n\t)\); \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0.500008, 0, 0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CSSolve", "Subsubsection"],

Cell[BoxData[
    \(\(CSSolve[n_] := \n
      \((LinkWrite[CSlink, \n\t\t\t\tEvaluatePacket[Scheduler`CSolve[n]]]; \n
        \t\tWhile[Not[LinkReadyQ[CSlink]], Continue[]]; \n\t\t
        LinkRead[CSlink])\); \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CSSchedule", "Subsubsection"],

Cell[BoxData[
    \(\(CSSchedule[] := \n\t
      Block[{pkg, Global`Substitution, cnstr}, \n\t\t
        LinkWrite[CSlink, \n\t\t\t
          Unevaluated[EvaluatePacket[Scheduler`Scheduler[]]]]; \n\t\t
        While[True, \n\t\t\tIf[Not[LinkReadyQ[CSlink]], Continue[]]; \n\t\t\t
          pkg = LinkRead[CSlink]; \n\t\t\t
          If[pkg === ReturnPacket["\<done.\>"], \n\t\t\t\tBreak[], \n
            \t\t\t\t{Global`Substitution, cnstr} = 
              pkg\[LeftDoubleBracket]1\[RightDoubleBracket]; \n\t\t\t\t
            AppendTo[result, ComputedAnswer[]]\n\t\t\t\t]\n\t\t\t]\n\t]; 
    \)\)], "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" FormSubst", "Subsection"],

Cell[BoxData[
    \(\(FormSubst := If[#1 === #2, EmptySequence, #1 \[Rule] #2]&; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]],

Cell[BoxData[""], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ComputedAnswer", "Subsection"],

Cell[BoxData[
    \(\(ComputedAnswer[] := \n\t
      MapThread[
        FormSubst, {Global`goalVar, Global`goalVar //. Global`Substitution}]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" NewCFLP", "Subsection"],

Cell[BoxData[
    \(\(\(NewCFLP[EqType_, Cs_]\)[RewritesTo[t_, {cs1___}, {cs2___}], rhs_, 
        eqns___] := \n\t
      Block[{Global`Substitution = Global`Substitution, saveTypes}, \n\t\t
        CFLP[{cs1, EqType[t, rhs], cs2, eqns}, Cs]]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->None]
}, Open  ]],

Cell[CellGroupData[{

Cell[" NewCFLPImitation", "Subsection"],

Cell[BoxData[
    \(\(NewCFLPImitation[EqType_, f_, X_, {params___}, t_, {eqns___}, Cs_] := 
      \n\tBlock[\n
        \t\t{mapsTo, newVars = Table[Module[{x}, x], {Length[{params}]}], 
          \[Lambda]term, \n\t\t\tGlobal`Substitution = Global`Substitution}, 
        \n\t\t\[Lambda]term\  = \ 
          \(Function[#1, \ #2]&\)\n\t\t\t\t[newVars, 
            f\ @@\ Table[
                \(Module[{H}, \ H\ @@\ #]&\)\ [newVars], {Arity[f]}]]; \n\t\t
        mapsTo = X -> \[Lambda]term; \n\t\t
        PrependTo[Global`Substitution, mapsTo]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" NewCFLPProjection", "Subsection"],

Cell[BoxData[
    \(Clear[NewCFLPProjection]; \n
    NewCFLPProjection[EqType_, X_, params_List, t_, {eqns___}, Cs_] := \n\t
      Block[{mapsTo, \[Lambda]dummy, 
          \[Lambda]vars = \(Module[{x}, x]&\)\ /@\ params, \n\t\t\t
          \[Lambda]term, Global`Substitution = Global`Substitution}, \n\t\t
        \[Lambda]term = 
          Function[{x, vars}, \n\t\t\t\t
            x\ @@\ Table[Module[{H}, H\ @@\ vars], {i, Arity[x]}]]; \t\n\t\t
        Scan[\n\t\t\t\t
          \((CFLP\ @@
                \(({{EqType[t, 
                          \[Lambda]term[#\[LeftDoubleBracket]2
                              \[RightDoubleBracket], params]], eqns}, Cs} /. 
                    X -> Function\ @@
                        \ {\[Lambda]vars, 
                          \[Lambda]term[#\[LeftDoubleBracket]1
                              \[RightDoubleBracket], \[Lambda]vars]})\))\)&, 
          \n\t\tTranspose[{\[Lambda]vars, params}]\n\t\t]\n\t]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" EmptySequence", "Subsection"],

Cell[BoxData[
    \(\(EmptySequence := Sequence[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" NewEqns", "Subsection"],

Cell[BoxData[
    \(\(NewEqns[h_, s_, t_] := 
      Sequence\ @@\ 
        Table[h[s\[LeftDoubleBracket]i\[RightDoubleBracket], 
            t\[LeftDoubleBracket]i\[RightDoubleBracket]], {i, Length[s]}]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" VariantsRule", "Subsection"],

Cell[BoxData[
    \(\(VariantsRule[f_[args___]] := 
      ApplyFunctionList[RewriteRuleList[f], {args}]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->None]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ApplyFunctionList", "Subsection"],

Cell[BoxData[
    \(\(ApplyFunctionList[{f___}, args_] := 
      Function[If[
            Length[args] == 
              Length[#\[LeftDoubleBracket]1\[RightDoubleBracket]], 
            Apply[#, args]]]/@{f}; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->None]
}, Open  ]],

Cell[CellGroupData[{

Cell[" CallCFLP", "Subsection"],

Cell[BoxData[
    \(\(CallCFLP[eqs_, vars_] := \n\t
      Block[\n\t\t{Global`Substitution = {}, \n\t\t\tGlobal`Constraints, \n
          \t\t\tGlobal`goalVar = vars, \n\t\t\tAnswerList = {}, \n\t\t\t
          eqSystem, \n\t\t\tresult = {}, \n\t\t\tCSCalled = False}, \n\t\t
        SetVariables[vars]; \n\t\tSetCSgoalVars[vars]; \n\t\t
        SetCSType[DownValues[Type]]; \n\t\tCatch[CFLP[eqs, {}]]; \n\t\t
        If[CSCalled, CSSchedule[]]; \n\t\tClearVariables[vars]; \n\t\tresult\n
        \t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->None]
}, Open  ]],

Cell[CellGroupData[{

Cell[" CFLP", "Subsection"],

Cell[CellGroupData[{

Cell["[cs] Call the constraint solver (CSolve)", "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{}, {}] := \n\t
      \((AppendTo[result, ComputedAnswer[]]; \n\t\t
        If[\((Global`NSolutions\  -= \ 1)\)\  == \ 0, \ Throw[1]])\); \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLP[{}, Cs_] := \n\t
      \((CSCalled = True; \n\t\t
        LinkWrite[CSlink, \n\t\t
          EvaluatePacket[\n\t\t\t
            Scheduler`SetCSQuery[Var[Cs], Global`Substitution, Cs]]]; \n\t\t
        While[Not[LinkReadyQ[CSlink]], Continue[]]; \n\t\tLinkRead[CSlink])
        \); \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" [tc] Special Rule  for the Type Checker ", "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{
          \((eq[FuncType[\[Placeholder], \[Tau]1_], \[Tau]2_]\n\t\t | 
              eq[\[Tau]1_, FuncType[\[Placeholder], \[Tau]2_]])\), eqns___}, 
        Cs_] := \n\tCFLP[{eq[\[Tau]1, \[Tau]2], eqns}, Cs]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" [or] OR rule", "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{Or[or\[Dash]eq_, or\[Dash]eqs__], eqns___}, Cs_] := \n\t
      Scan[\n\t\t
        Block[\n\t\t\t{Global`Substitution = Global`Substitution}, \n\t\t\t\t
            CFLP[{#, eqns}, Cs]]&, \n\t\t{or\[Dash]eq, or\[Dash]eqs}]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" [and] AND rule", "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{And[and\[Dash]eq_, and\[Dash]eqs__], eqns___}, Cs_] := \n\t
      CFLP[{and\[Dash]eq, and\[Dash]eqs, eqns}, Cs]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" [xfer] Transfer to the Constraint Store", "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{Mark[e_], eqns___}, Cs_] := \n\tCFLP[{eqns}, Append[Cs, e]]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["[t] Removal of trivial equations & Variable elimination", 
  "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{\((eq | ppeq)\)[x_?IsVar, y_?IsVar], eqns___}, Cs_] := \n\t
      If[x === y, \n\t\tCFLP[{eqns}, Cs], \n\t\t
        Block[{mapsTo = x \[Rule] y}, \n\t\t\t
          PrependTo[Global`Substitution, mapsTo]; \n\t\t\t
          CFLP[{eqns} /. mapsTo, Cs\  /. mapsTo]]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" [vp] Variable elimination  for parameter passing equations", 
  "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{ppeq[s_, x_?IsVar] | ppeq[x_?IsVar, s_], eqns___}, Cs_] := \n\t
      Block[{mapsTo = x \[Rule] s\ }, \n\t\t
        PrependTo[Global`Substitution, mapsTo]; \n\t\t
        CFLP[{eqns} /. mapsTo, Cs\  /. mapsTo]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" [on] Outermost narrowing", "Subsubsection"],

Cell[BoxData[
    \(CFLP[{EqType_[s_?IsFunctionTerm, t_], eqns___}, Cs_] := \n\t
      Scan[\(NewCFLP[EqType, Cs]\)[#1, t, eqns]&, VariantsRule[s]]; \n
    CFLP[{eq[s_, t_?IsFunctionTerm], eqns___}, Cs_] := \n\t
      Scan[\(NewCFLP[eq, Cs]\)[#1, s, eqns]&, VariantsRule[t]]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" [onbeta] Outermost beta-reduction", "Subsubsection"],

Cell[BoxData[
    \(CFLP[{
          EqType_[\(\[Lambda][\[Lambda]args_List, body_]\)[
              \[Lambda]params___], t_], eqns___}, Cs_] := \n\t
      CFLP[{EqType[\(Function[\[Lambda]args, body]\)[\[Lambda]params], t], 
          eqns}, Cs]; \n
    CFLP[{EqType_[t_, 
            \(\[Lambda][\[Lambda]args_List, body_]\)[\[Lambda]params___]], 
          eqns___}, Cs_] := \n\t
      CFLP[{EqType[\(Function[\[Lambda]args, body]\)[\[Lambda]params], t], 
          eqns}, Cs]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
" [ovi] Outermost narrowing on flex terms with imitation binding &\n [ovp]  \
Outermost narrowing on flex terms with projection binding",
  FontSize->14]], "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[\n
        \t{EqType_[X_?IsVar[params__], t_?IsNotFlex]\n\t | 
            EqType_[t_?IsNotFlex, X_?IsVar[params__]], eqns___}, \n\tCs_] := 
      \n\tBlock[{
          symbList = 
            Select[$FunctionSymbol, \((Arity[#] == Length[{params}])\)&]}, \n
        \t\tScan[NewCFLPImitation[EqType, #, X, {params}, t, {eqns}, Cs]&, 
          symbList]; \n\t\t
        NewCFLPProjection[EqType, X, {params}, t, {eqns}, Cs]\n\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["[i] Imitation & Variable elimination", "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{eq[x_?IsVar, s_AtomQ] | eq[s_AtomQ, x_?IsVar], eqns___}, 
        Cs_] := \n\t
      Block[{mapsTo = x -> s}, \n\t\tPrependTo[Global`Substitution, mapsTo]; 
        \n\t\tCFLP[{eqns} /. mapsTo, Cs /. mapsTo]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(CFLP[{eq[x_?IsVar, s_] | eq[s_, x_?IsVar], eqns___}, Cs_] := \n\t
      If[Not[MemberQ[s, x, \(-1\)]], \n\t\t
        Block[{cs = NewC/@\ s, mapsTo}, \n\t\t\tmapsTo = x -> cs; \n\t\t\t
          PrependTo[Global`Substitution, mapsTo]; \n\t\t\t
          CFLP[{NewEqns[eq, s, cs], eqns} /. mapsTo, Cs /. mapsTo]]\n\t]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " [de] Decomposition rule ",
  "for \[Lambda]\[Dash]terms"
}], "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{EqType_[\[Lambda][{xs__}, s_], \[Lambda][{ys__}, t_]], 
          eqns___}, Cs_] := \n\t
      CFLP[{\(EqType[Function[#1, s]\ @@\ #3, Function[#2, t]\ @@\ #3]&\)[{
              xs}, {ys}, NewX\ /@\ {xs}], eqns}, Cs]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" [d] Decomposition rule for constructor terms", "Subsubsection"],

Cell[BoxData[
    \(CFLP[{_[s_?AtomQ, t_?IsConstructorTerm]\n
            \t | _[t_?IsConstructorTerm, s_?AtomQ], eqns___}, Cs_] := \n\t
      If[t === s \[Or] \((s =!= Symbol \[And] t === s[])\), 
        CFLP[{eqns}, Cs]]; \n
    CFLP[{EqType_[\((f_?IsConstructor)\)[fargs___], 
            \((g_?IsConstructor)\)[gargs___]], eqns___}, Cs_] := \n\t
      If[f === g \[And] Length[{fargs}] == Length[{gargs}], \n\t\t
        Block[{NewGoal = NewEqns[EqType, {fargs}, {gargs}]}, \n\t\t\t
          CFLP[{NewEqns[EqType, {fargs}, {gargs}], eqns}, Cs]\n\t\t]\n\t]; 
    \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" [sp] Imitation rule for external functions", "Subsubsection"],

Cell[BoxData[
    \(\(CFLP[{eq[\[Phi]_?IsExternal[args1__], \[Psi]_?IsExternal[args2__]], 
          eqns___}, Cs_] := \n\t\t
      \(Function[
          CFLP[{NewEqns[eq, {args1}, #1], NewEqns[eq, {args2}, #2], \n\t\t\t\t
              Mark[eq[\[Phi]\ @@\ #1\ , \[Psi]\ @@\ #2]], eqns}, Cs]]\)[
        NewX/@\ {args1}, NewY/@\ {args2}]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(CFLP[{_[\[Phi]_?IsExternal[args__], t_], eqns___}, Cs_] := \n\t
      \(Function[
          CFLP[{NewEqns[eq, {args}, #], Mark[eq[\[Phi]\ @@\ #, t]], eqns}, 
            Cs]]\)[NewX/@{args}]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(CFLP[{eq[t_, \[Phi]_[args__]], eqns___}, Cs_] /; 
        IsExternal[\[Phi]] := \n\t\t
      \(Function[
          CFLP[{NewEqns[eq, {args}, #], Mark[\[Phi]\ @@\ eq[#, t]], eqns}, 
            Cs]]\)[NewX/@\ {args}]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{657, 900},
WindowMargins->{{Automatic, 170}, {Automatic, 13}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 73, 1, 104, "Title"],
Cell[1807, 54, 102, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[1934, 60, 39, 0, 54, "Subtitle"],
Cell[1976, 62, 783, 11, 338, "Text"],
Cell[2762, 75, 183, 4, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2970, 83, 27, 0, 45, "Subsection"],
Cell[3000, 85, 310, 6, 59, "Input",
  InitializationCell->True],
Cell[3313, 93, 333, 7, 75, "Input",
  InitializationCell->True],
Cell[3649, 102, 205, 5, 43, "Input",
  InitializationCell->True],
Cell[3857, 109, 200, 5, 27, "Input",
  InitializationCell->True],
Cell[4060, 116, 208, 5, 43, "Input",
  InitializationCell->True],
Cell[4271, 123, 127, 3, 27, "Input",
  InitializationCell->True],
Cell[4401, 128, 208, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4658, 139, 34, 0, 54, "Subtitle"],

Cell[CellGroupData[{
Cell[4717, 143, 24, 0, 52, "Section"],
Cell[4744, 145, 183, 5, 27, "Input",
  InitializationCell->True],
Cell[4930, 152, 229, 5, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5184, 161, 104, 4, 45, "Subsection"],

Cell[CellGroupData[{
Cell[5313, 169, 35, 0, 42, "Subsubsection"],
Cell[5351, 171, 1141, 22, 331, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[6517, 197, 117, 3, 27, "Input",
  InitializationCell->True],
Cell[6637, 202, 80, 1, 23, "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6766, 209, 30, 0, 42, "Subsubsection"],
Cell[6799, 211, 413, 8, 123, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7249, 224, 34, 0, 42, "Subsubsection"],
Cell[7286, 226, 401, 8, 123, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7724, 239, 38, 0, 42, "Subsubsection"],
Cell[7765, 241, 360, 7, 123, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8162, 253, 32, 0, 42, "Subsubsection"],
Cell[8197, 255, 292, 6, 91, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8526, 266, 35, 0, 42, "Subsubsection"],
Cell[8564, 268, 638, 12, 235, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9251, 286, 32, 0, 45, "Subsection"],
Cell[9286, 288, 223, 6, 27, "Input",
  InitializationCell->True],
Cell[9512, 296, 26, 0, 27, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9575, 301, 37, 0, 45, "Subsection"],
Cell[9615, 303, 286, 8, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9938, 316, 30, 0, 45, "Subsection"],
Cell[9971, 318, 375, 8, 59, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[10383, 331, 39, 0, 45, "Subsection"],
Cell[10425, 333, 637, 12, 155, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[11099, 350, 40, 0, 45, "Subsection"],
Cell[11142, 352, 1035, 20, 203, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[12214, 377, 36, 0, 45, "Subsection"],
Cell[12253, 379, 190, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[12480, 389, 30, 0, 45, "Subsection"],
Cell[12513, 391, 370, 10, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[12920, 406, 35, 0, 45, "Subsection"],
Cell[12958, 408, 236, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[13231, 419, 40, 0, 45, "Subsection"],
Cell[13274, 421, 341, 9, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[13652, 435, 31, 0, 45, "Subsection"],
Cell[13686, 437, 633, 12, 283, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[14356, 454, 27, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[14408, 458, 65, 0, 42, "Subsubsection"],
Cell[14476, 460, 250, 6, 59, "Input",
  InitializationCell->True],
Cell[14729, 468, 391, 9, 123, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[15157, 482, 66, 0, 42, "Subsubsection"],
Cell[15226, 484, 320, 6, 59, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[15583, 495, 38, 0, 42, "Subsubsection"],
Cell[15624, 497, 416, 10, 107, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[16077, 512, 40, 0, 42, "Subsubsection"],
Cell[16120, 514, 302, 7, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[16459, 526, 65, 0, 42, "Subsubsection"],
Cell[16527, 528, 255, 7, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[16819, 540, 83, 1, 42, "Subsubsection"],
Cell[16905, 543, 460, 10, 123, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[17402, 558, 87, 1, 42, "Subsubsection"],
Cell[17492, 561, 406, 9, 91, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[17935, 575, 50, 0, 42, "Subsubsection"],
Cell[17988, 577, 435, 9, 75, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[18460, 591, 59, 0, 42, "Subsubsection"],
Cell[18522, 593, 561, 12, 75, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[19120, 610, 196, 3, 60, "Subsubsection"],
Cell[19319, 615, 543, 12, 139, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[19899, 632, 61, 0, 42, "Subsubsection"],
Cell[19963, 634, 403, 9, 91, "Input",
  InitializationCell->True],
Cell[20369, 645, 506, 11, 123, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[20912, 661, 97, 3, 42, "Subsubsection"],
Cell[21012, 666, 329, 6, 75, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[21378, 677, 70, 0, 42, "Subsubsection"],
Cell[21451, 679, 727, 15, 171, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[22215, 699, 68, 0, 42, "Subsubsection"],
Cell[22286, 701, 500, 11, 59, "Input",
  InitializationCell->True],
Cell[22789, 714, 375, 9, 59, "Input",
  InitializationCell->True],
Cell[23167, 725, 400, 10, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23628, 742, 22, 0, 52, "Section"],
Cell[23653, 744, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[23822, 751, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

