(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    103271,       2245]*)
(*NotebookOutlinePosition[    103954,       2270]*)
(*  CellTagsIndexPosition[    103910,       2266]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Package Demo", "Subtitle"],

Cell[BoxData[
    \( (*\ 
      \[Copyright]1998\ Research\ Institute\ for\ Symbolic\ Computation\ 
        \((RISC - Linz)\)\ *) \)], "Input",
  InitializationCell->True],

Cell[TextData[{
  "We illustrate here how to use the package ",
  StyleBox["Electrical.m.",
    FontWeight->"Bold"],
  " For a full description of the package functionality, see notebook ",
  StyleBox["Electrical.nb",
    FontWeight->"Bold"],
  ". Also, usage messages for the symbols defined  in the package are \
available. \nThe commands to the CFLP interpreter are given in input cells. \
these cells can be recognized by the presence of an ",
  StyleBox["In[_]",
    FontWeight->"Bold"],
  " prompt to the left side. For executing them, the user must reach with the \
cursor in the cell area\[LongDash]either by clicking with the mouse on the \
cell, or with the arrow keys\[LongDash]and press SHIFT-ENTER."
}], "Text"],

Cell["First, we read in the package by issuing the command", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< Electrical`\)], "Input"],

Cell[BoxData[
    \("connection to scheduler established."\)], "Print"],

Cell[BoxData[
    \("connection to constraint solvers established."\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(resistor[R, S, s[V0, I0], 
            s[V1, I1]] \[RightArrow] True \[DoubleLeftArrow] 
          \(\(-V0\) + V1 \[TildeTilde] I0\ R && I0 \[TildeTilde] I1\)\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          resistor[ R, S, 
            s[ V0, I0], 
            s[ V1, I1]], True, 
          And[ 
            eq[ 
              Plus[ 
                Times[ -1, V0], V1], 
              Times[ I0, R]], 
            eq[ I0, I1]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(I0, I1, R, S, V0, V1\),
          Infix[ {I0, I1, R, S, V0, V1}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {I0, I1, R, S, V0, V1}, ","], " declared as  variable", "s", 
        "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(inductor[L, S, s[V0, I0], 
            s[V1, I1]] \[RightArrow] True \[DoubleLeftArrow] 
          \(V0 - V1 \[TildeTilde] I0\ L\ S && I0 \[TildeTilde] I1\)\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          inductor[ L, S, 
            s[ V0, I0], 
            s[ V1, I1]], True, 
          And[ 
            eq[ 
              Plus[ V0, 
                Times[ -1, V1]], 
              Times[ I0, L, S]], 
            eq[ I0, I1]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(I0, I1, L, S, V0, V1\),
          Infix[ {I0, I1, L, S, V0, V1}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {I0, I1, L, S, V0, V1}, ","], " declared as  variable", "s", 
        "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(capacitor[C, S, s[V0, I0], 
            s[V1, I1]] \[RightArrow] True \[DoubleLeftArrow] 
          \(V0 - V1 \[TildeTilde] I0\/C && I0 \[TildeTilde] I1\)\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          capacitor[ C, S, 
            s[ V0, I0], 
            s[ V1, I1]], True, 
          And[ 
            eq[ 
              Plus[ V0, 
                Times[ -1, V1]], 
              Times[ 
                Power[ C, -1], I0]], 
            eq[ I0, I1]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(C, I0, I1, S, V0, V1\),
          Infix[ {C, I0, I1, S, V0, V1}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {C, I0, I1, S, V0, V1}, ","], " declared as  variable", "s", 
        "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(source[E, S, s[V0, I0], 
            s[V1, I1]] \[RightArrow] True \[DoubleLeftArrow] 
          \(V0 - V1 \[TildeTilde] E && I0 \[TildeTilde] I1\)\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          source[ E, S, 
            s[ V0, I0], 
            s[ V1, I1]], True, 
          And[ 
            eq[ 
              Plus[ V0, 
                Times[ -1, V1]], E], 
            eq[ I0, I1]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(E, I0, I1, S, V0, V1\),
          Infix[ {E, I0, I1, S, V0, V1}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {E, I0, I1, S, V0, V1}, ","], " declared as  variable", "s", 
        "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(earth[E, S, s[V1, I1]] 
          \[RightArrow] True \[DoubleLeftArrow] V1 \[TildeTilde] 0\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          earth[ E, S, 
            s[ V1, I1]], True, 
          eq[ V1, 0]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(E, I1, S, V1\),
          Infix[ {E, I1, S, V1}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {E, I1, S, V1}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(serial[S, \[Bullet], L, R] 
          \[RightArrow] True \[DoubleLeftArrow] L \[TildeTilde] R\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          serial[ S, \[Bullet], L, R], True, 
          eq[ L, R]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(L, R, S\),
          Infix[ {L, R, S}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {L, R, S}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(serial[S, 
            \[LeftAngleBracket]C1, CS\[RightAngleBracket], L, R] 
          \[RightArrow] True \[DoubleLeftArrow] 
          \(C1[S, L, L1] \[TildeTilde] True && 
            serial[S, CS, L1, R] \[TildeTilde] True\)\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          serial[ S, 
            Cons[ C1, CS], L, R], True, 
          And[ 
            eq[ 
              C1[ S, L, L1], True], 
            eq[ 
              serial[ S, CS, L1, R], True]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(C1, CS, L, L1, R, S\),
          Infix[ {C1, CS, L, L1, R, S}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {C1, CS, L, L1, R, S}, ","], " declared as  variable", "s", 
        "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]L1
        \[InvisibleSpace]" declared as extra variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", L1, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(elJoin[\[Bullet], V] 
          \[RightArrow] 0\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          elJoin[ \[Bullet], V], 0, True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]V
        \[InvisibleSpace]" declared as  variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", V, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(elJoin[
            \[LeftAngleBracket]s[V0, I0], RS\[RightAngleBracket], V] 
          \[RightArrow] I0 + elJoin[RS, V] \[DoubleLeftArrow] 
          V0 \[TildeTilde] V\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          elJoin[ 
            Cons[ 
              s[ V0, I0], RS], V], 
          Plus[ I0, 
            elJoin[ RS, V]], 
          eq[ V0, V]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(I0, RS, V, V0\),
          Infix[ {I0, RS, V, V0}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {I0, RS, V, V0}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(junction[L, R] \[RightArrow] 
          True \[DoubleLeftArrow] elJoin[L, V] \[TildeTilde] elJoin[R, V]\)\),
      
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          junction[ L, R], True, 
          eq[ 
            elJoin[ L, V], 
            elJoin[ R, V]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(L, R, V\),
          Infix[ {L, R, V}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {L, R, V}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]V
        \[InvisibleSpace]" declared as extra variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", V, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(parallel[S, 
            \[LeftAngleBracket]C, \[Bullet]\[RightAngleBracket], InS, OutS] 
          \[RightArrow] True \[DoubleLeftArrow] 
          C[S, InS, OutS] \[TildeTilde] True\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          parallel[ S, 
            Cons[ C, \[Bullet]], InS, OutS], True, 
          eq[ 
            C[ S, InS, OutS], True]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(C, InS, OutS, S\),
          Infix[ {C, InS, OutS, S}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {C, InS, OutS, S}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(parallel[S, 
            \[LeftAngleBracket]C, Cs\[RightAngleBracket], InS, OutS] 
          \[RightArrow] True \[DoubleLeftArrow] 
          \(C[S, InS1, OutS1] \[TildeTilde] True && 
            parallel[S, Cs, InS2, OutS2] \[TildeTilde] True && 
            junction[\[LeftAngleBracket]InS, \[Bullet]\[RightAngleBracket], 
                \[LeftAngleBracket]InS1, 
                  \[LeftAngleBracket]InS2, 
                    \[Bullet]\[RightAngleBracket]\[RightAngleBracket]] 
              \[TildeTilde] True && 
            junction[
                \[LeftAngleBracket]OutS1, 
                  \[LeftAngleBracket]OutS2, 
                    \[Bullet]\[RightAngleBracket]\[RightAngleBracket], 
                \[LeftAngleBracket]OutS, \[Bullet]\[RightAngleBracket]] 
              \[TildeTilde] True\)\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          parallel[ S, 
            Cons[ C, Cs], InS, OutS], True, 
          And[ 
            eq[ 
              C[ S, InS1, OutS1], True], 
            eq[ 
              parallel[ S, Cs, InS2, OutS2], True], 
            eq[ 
              junction[ 
                Cons[ InS, \[Bullet]], 
                Cons[ InS1, 
                  Cons[ InS2, \[Bullet]]]], True], 
            eq[ 
              junction[ 
                Cons[ OutS1, 
                  Cons[ OutS2, \[Bullet]]], 
                Cons[ OutS, \[Bullet]]], True]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(C, Cs, InS, InS1, InS2, OutS, OutS1, OutS2, S\),
          Infix[ {C, Cs, InS, InS1, InS2, OutS, OutS1, OutS2, S}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {C, Cs, InS, InS1, InS2, OutS, OutS1, OutS2, S}, ","], 
        " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(InS1, InS2, OutS1, OutS2\),
          Infix[ {InS1, InS2, OutS1, OutS2}, ","],
          Editable->False], "\[InvisibleSpace]", 
        \(" declared as extra variable"\), "\[InvisibleSpace]", \("s"\), 
        "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {InS1, InS2, OutS1, OutS2}, ","], 
        " declared as extra variable", "s", "."],
      Editable->False]], "Print"]
}, Open  ]],

Cell[TextData[{
  "The reading command for Electrical.m executes all the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands called in the package. The first two message lines"
}], "Text"],

Cell[BoxData[
    \("connection to scheduler established."\)], "Print"],

Cell[BoxData[
    \("connection to constraint solvers established."\)], "Print"],

Cell[TextData[{
  "notify the user on the success of establishing ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connections between CFLP interpreter and scheduler, and between scheduler \
and constraint solvers \nThe subsequent messages refer to the conditional \
rewrite rules defined for electrical components and electrical connections. \
For example, the messages:"
}], "Text"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(serial[S, \[Bullet], L, R] 
          \[RightArrow] True \[DoubleLeftArrow] L \[TildeTilde] R\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          serial[ S, \[Bullet], L, R], True, 
          eq[ L, R]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(L, R, S\),
          Infix[ {L, R, S}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {L, R, S}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(serial[S, 
            \[LeftAngleBracket]C1, CS\[RightAngleBracket], L, R] 
          \[RightArrow] True \[DoubleLeftArrow] 
          \(C1[S, L, L1] \[TildeTilde] True && 
            serial[S, CS, L1, R] \[TildeTilde] True\)\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          serial[ S, 
            Cons[ C1, CS], L, R], True, 
          And[ 
            eq[ 
              C1[ S, L, L1], True], 
            eq[ 
              serial[ S, CS, L1, R], True]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(C1, CS, L, L1, R, S\),
          Infix[ {C1, CS, L, L1, R, S}, ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {C1, CS, L, L1, R, S}, ","], " declared as  variable", "s", 
        "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]L1
        \[InvisibleSpace]" declared as extra variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", L1, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell["\<\
refer to the conditional rewrite rules (CRRs) that were defined for \
serial connections: there are two rules defined, the first one with variables \
S, L, R, and the second one with variables C1,CS,L,L1,R,S, and L1 being an \
extra variable (i.e. a variable that does not appear in the left hand side of \
the CRR).\
\>", "Text"],

Cell["\<\
From now on, the CFLP interpreter and the definitions provided in \
the sample package Electrical.m are accesible to the user. For getting a list \
of the symbols created in this sample package, we type in \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Electrical`*\)\)], "Input"],

Cell["\<\
capacitor earth     EInst     elJoin    inductor  junction  LInst   \
  parallel  resistor  RInst     s         serial    sig       source
CInst\
\>", "Print"]
}, Open  ]],

Cell[TextData[{
  "All this symbols have attached a ",
  StyleBox["usage",
    FontFamily->"Courier"],
  " message, which can me displayed with the command "
}], "Text"],

Cell[TextData[{
  "?",
  StyleBox["symbol",
    FontSlant->"Italic"]
}], "Text",
  TextAlignment->-0.5],

Cell["For example, ", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?capacitor\)\)], "Input"],

Cell[BoxData[
    \("capacitor[R,S,s[V0,I0],s[V1,I1]] describes a capacitor with input \
voltage/current s[V0,I0] and output s[V1,I]."\)], "Print"]
}, Open  ]],

Cell[TextData[{
  "indicates the syntax of the ",
  StyleBox["capacitor",
    FontWeight->"Bold"],
  " predicate for expressing the behavior of an electrical capacitor. (A more \
detailed description of our model is available in the notebook ",
  StyleBox["Electrical.nb",
    FontWeight->"Bold"],
  ")"
}], "Text"],

Cell[TextData[{
  StyleBox["Remark:",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\nThe pallete ",
  StyleBox["CFLPsyntax.nb",
    FontWeight->"Bold"],
  " is provided for typing in CFLP expressions.For using it, use the menu \
option ",
  StyleBox["File/Opem\[Ellipsis]",
    FontWeight->"Bold"],
  "  and select the file",
  StyleBox[" CFLPsyntax.nb.",
    FontWeight->"Bold"],
  " The pallete contains templates for the language constructs of the \
interepreter and looks as shown below. ",
  StyleBox["\n",
    FontWeight->"Bold"]
}], "Text"],

Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox[\(Types\ \),
              FontColor->RGBColor[0, 0, 1]]], 
          ButtonBox[
            StyleBox["Terms",
              FontColor->RGBColor[0, 0, 1]]], 
          ButtonBox[
            StyleBox["Miscellaneous",
              FontColor->RGBColor[0, 0, 1]]]},
        {
          ButtonBox[\(\[SelectionPlaceholder] \[Proportion] \[Placeholder]\)],
           
          
          ButtonBox[
            \(\[SelectionPlaceholder] \[ShortRightArrow] 
              \(\[Placeholder] \[RightArrow] \[Placeholder]\)\)], 
          ButtonBox["DefinedFunctionSymbol"]},
        {
          ButtonBox[\(TyList[\[SelectionPlaceholder]]\)], 
          
          ButtonBox[
            \(\[SelectionPlaceholder] \[RightArrow] \[Placeholder] 
              \[DoubleLeftArrow] \[Placeholder]\)], 
          ButtonBox["Constructor"]},
        {
          
          ButtonBox[
            \(\[SelectionPlaceholder] \[ShortRightArrow] \[Placeholder]\)], 
          ButtonBox[\(And[\[SelectionPlaceholder]]\)], 
          ButtonBox["TypeConstructor"]},
        {
          ButtonBox[\(Cross[\[SelectionPlaceholder]]\)], 
          ButtonBox[\(\[SelectionPlaceholder] \[TildeTilde] \[Placeholder]\)],
           
          ButtonBox["Rule"]},
        {
          ButtonBox["Real"], 
          
          ButtonBox[
            \(\[LeftAngleBracket]\[SelectionPlaceholder]\[RightAngleBracket]\)\
], 
          ButtonBox["TypeCheck"]},
        {
          ButtonBox["Bool"], 
          ButtonBox["\[Bullet]"], 
          ButtonBox[\(TSolve[\[SelectionPlaceholder]]\)]},
        {
          ButtonBox["Int"], 
          ButtonBox[\({\[SelectionPlaceholder]}\)], 
          ButtonBox[\(\[SelectionPlaceholder], \[Placeholder]\)]},
        {
          ButtonBox["Symbol"], 
          ButtonBox[\((\[SelectionPlaceholder])\)], 
          ButtonBox[\(\[SelectionPlaceholder] -> {\[Placeholder]}\)]}
        },
      RowSpacings->0,
      ColumnSpacings->0,
      GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]]], "Input"],

Cell[TextData[{
  "Using the palette is very simple: a click with the mouse on the palette \
cell containing the needed template will copy the template to the current \
cursor position in your ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook. The user is required to fill in the placeholders (represented \
as squares), and jumping from a placeholder to the next one is possible by \
clicking TAB. \n\[Placeholder]"
}], "Text"],

Cell[BoxData[
    \(Off[General::spell]\)], "Input"],

Cell[TextData[{
  "This command switches off the warning messages printed by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " when the user defines symbols with similar names."
}], "Text"],

Cell[TextData[{
  "We can now formulate queries about the behavior of elementary components, \
e.g.:\n\[Diamond] dependency of the input signal s[V1,I1] on the output \
signal s[V2,I2] for a (capacitor or resistor)  with characteristic C0",
  Cell[BoxData[""], "Input"],
  Cell[BoxData[""], "Input"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[{
        Or[capacitor[C0, S, s[V1, I1], s[V2, I2]] \[TildeTilde] True, 
          resistor[C0, S, s[V1, I1], s[V2, I2]] \[TildeTilde] True, 
          inductor[C0, S, s[V1, I1], s[V2, I2]] \[TildeTilde] True]}, {I1, 
        V1}, {I2, V2}, Constructor -> {C0, S}]\)], "Input"],

Cell[BoxData[
    \({{I1 \[Rule] I2, V1 \[Rule] \(-\(\(\(-I2\) - C0\ V2\)\/C0\)\)}, {
        I1 \[Rule] I2, V1 \[Rule] \(-C0\)\ I2 + V2}, {I1 \[Rule] I2, 
        V1 \[Rule] C0\ I2\ S + V2}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\[Diamond] dependency of the output signal s[V2,I2] on the input signal \
s[V1,I1] for a inductor  with characteristic L0",
  Cell[BoxData[""], "Input"],
  Cell[BoxData[""], "Input"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[{inductor[L0, S, s[V1, I1], s[V2, I2]] \[TildeTilde] True}, {I1, 
        V1}, {L0, I2, V2, S}]\)], "Input"],

Cell[BoxData[
    \({{I1 \[Rule] I2, V1 \[Rule] I2\ L0\ S + V2}}\)], "Output"]
}, Open  ]],

Cell[TextData[
"\[Diamond] dependency of the output signal s[V2,I2] on the output signal \
s[V1,I1] for a resistor with characteristic R0"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[{resistor[R0, S, s[V1, I1], s[V2, I2]] \[TildeTilde] True}, {I2, 
        V2}, Constructor -> {R0, I1, V1, S}]\)], "Input"],

Cell[BoxData[
    \({{I2 \[Rule] I1, V2 \[Rule] I1\ R0 + V1}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Serial connections", "Subsection"],

Cell[TextData[{
  "Serial connections are expressed by the predicate ",
  StyleBox["serial",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?serial\)\)], "Input"],

Cell[BoxData[
    \("serial[S, Clist, s[V0,I0], s[V1,I1]] is the electrical component \
representing the serial connection of the unary components of list Clist, \
with input s[V0,I0], output s[V1,I1] and system frequency S."\)], "Print"]
}, Open  ]],

Cell[TextData[
"A system consisting of a serial connection of n components C1,\[Ellipsis],Cn \
"], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005W0000;@P10`4000010?ooo`00
0?ool?l00;jn_W20T5mOGenNX2m?D8GNh000T000/000d8O>o`2@0000o`2`0?oo003@
002@T02`/03@d9000;000=000900T;00/=00d80`0:100<1P0?n0P?nPX?o0`?oPh?oG
04NjhIW:<J5A:03o003ooaj>6]WIfNc/k:>SXol0ok0`H<?3`m0PT:0Pl3bcLLk>c[Zj
^[6a/JRXZ:2PX=Rof8:2PXj>S/3Ph3USH`00<`00IP00V@00c00c000c<`0cIP0cV@0c
c00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2IIP2IV@2Ic02Io`3<003<<`3<IP3<
V@3<c03<o`3o<`3oIP3oV@3oc4000400<d00IT00VD00c400od0c040c<d0cIT0cVD0c
c40cod1V041V<d1VIT1VVD1Vc41Vod2I042I<d2IIT2IVD2Ic42Iod3<043<<d3<IT3<
VD3<c43<od3o043o<d3oIT3oVD3oc43ooh00<h00IX00VH00c800oh0c080c<h0cIX0c
VH0cc80coh1V081V<h1VIX1VVH1Vc81Voh2I082I<h2IIX2IVH2Ic82Ioh3<083<<h3<
IX3<VH3<c83<oh3o083o<h3oIX3oVH3oc83ookl00;l0<kl0I[l0VKl0c;l0oklc0;lc
<klcI[lcVKlcc;lcokmV0;mV<kmVI[mVVKmVc;mVoknI0;nI<knII[nIVKnIc;nIoko<
0;o<<ko<I[o<VKo<c;o<okoo0;oo<kooI[ooVKooc;ooool0<ol0I_l0VOl0c?lc0?lc
<olcI_lcVOlcc?lcoomV0?mV<omVI_mVVOmVc?mVoonI0?nI<onII_nIVOnIc?nIooo<
0?o<<oo<I_o<VOo<c?o<oooo<oooI_ooVOGN/l000>00001002100410061008100:10
0<100>1007:OolCGociGS=WIfLc<c8b<S?o/W9Af0<c<Xhb<L<C4a>[ZjWAdM:NWYol0
J0000?l0J0000?l0J0000?l0J0000?l0J0000?l0J0000?l0J0000?l0J0000?l0J000
0?l0J0000?l0J00003/07`4P01l1HP0O0Dd0000k00030@0001/000<100007P000`40
000K00030@00060000<100006`000`40001;0000>`000`40000K00030@0001h000<1
00006`000`40001P00030@0001/000<10000B`0003/000<100006`000`40000N0003
0@0001/000<10000H0000`40000K00030@0004/0000k00030@0001/000<100007P00
0`40000K00030@00060000<100006`000`40001;0000>`000`40000K00030@0001h0
00<100006`000`40001P00030@0001/000<10000B`0003/000<100006`000`40000N
00030@0001/000<10000H0000`40000K00030@0004/0000k00030@0000P0104300<1
2@000`40000N00030@0000P0104200D120000`40001P00030@0000P0104200<100<0
0@401`000`40001;0000>`000`40000700810P020@<000<1000020000`40000N0003
0@0000L00P42008100<00@000P000`40000600030@00060000<100001`020@800P42
00040@000@P000<10000B`0003/000<100001`000`40000200050@0000402P000`40
000N00030@0000L000<100000P001040004;00030@00060000<100001`000`400002
00040@000@8000<100001P000`40001;0000<@020@P000<100001P000`4000070003
0@0000P000<1000050020@P000<100001P000`40000700030@0000P000<100005002
0@l000@100010P000`40000300040@000@8000<1000070020@P000<100001P000`40
000600040@000@P000<10000<P020AL0000a00H110000`40000600030@0000L000<1
000020000`40000D00H110000`40000600030@0000P000<100001`000`40000D00H1
?0060@@000<100001P000`40000600040@000@P000<10000<P060A<0000503D100<0
0@001`000`40000700030@0000P080400`01000700030@0000T000<100001P0P0B80
80400`01000700030@0000D000@100412@0n0A00000D00<16P060@@000<100001`00
0`40000200050@0100402P000`40000D00H110000`40000700030@00008000<10000
0`000`40000600030@0001@01P4l00H110000`40000700030@00008000<100003000
0`40000E00<16P060A<0000C00050@0000406@020@P000<100001`020@800P420081
2P000`40000D008120000`40000700810P020@030040008000<100001P000`40000D
0081@0020@P000<100001`020@800P4>00030@0001@000D100000@0I00815`0001<0
00D100000@0S00030@0000P00`400`01000200030@0000P000<100007P000`400008
00<100@00@000`4900030@00060000<1000020030@03004000d000<1000050001@40
00010380000800030@0100810P030@800`401@010@4000<100<00@406@000`40000K
00030@0001h000<100006`000`40001P00030@0001/000<100002@000`400@020@80
0`4200<10`040@D00P40100100020Al0000800810P020@8000D100000@0400050@00
00400P000`40000H00030@0001/000<100007P000`40000K00030@00060000<10000
6`000`40000900810P020@8000D100000@0400810P020@<000@100010P000`40000O
000020000`40000200040@000@800`4300050@0000400P000`40000H00030@0001/0
00<100007P000`40000K00030@00060000<100006`000`40000900030@00008000@1
00010P030@<000<100000P001@400001008000@100018@0000`00P4200040@000@80
00@100010`001040004J00030@0001/000<100007P000`40000K00030@00060000<1
00006`000`40000=00810P001040004200030@0100H000@100010P001040004Q0000
2P030@<000@100010P001040004300040@000AX000<100006`000`40000N00030@00
01/000<10000H0000`40000K00030@0000/00`4300040@000@8000<100401P001040
004200040@000B400009008110020@<010401P01000100816`0O0B007`5R01l13002
0@@00P4300D11P001@400@40008100<00@400P4O000020000`40000200030@0000T0
00<10000o`0:00030@00008000<100002@000`40000200030@0000L000<100007`00
00P000@100000P4;00030@000?l02P00104000020@/00P420081:`0000T00`401@01
000100L00`7o00`00`401@01000100T0104/0000o`1X0000o`1X0000o`1X0000o`1X
0000o`1X0000o`1X0000o`1X0000o`1X0000o`1X0000\
\>"], "Graphics",
  ImageSize->{359, 45},
  ImageMargins->{{60, 0}, {0, 3}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["is described by the predicate", "Text"],

Cell[TextData[StyleBox["serial[S,{C1,C2,\[Ellipsis],Cn},SignIn,SignOut]",
  FontWeight->"Bold"]], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Queries for serial connections", "Subsection"],

Cell[TextData[
"\[Diamond] dependency of the input signal s[V1,I1]  on s[V2,I2] for a serial \
resistor/capacitor/capacitor connection"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[\n
      \t{serial[S, {RInst[R], CInst[C1], CInst[C2]}, s[V1, I1], s[V2, I2]] 
          \[TildeTilde] True}, \n\t{I1, V1}, 
      Constructor -> {S, R, C1, C2, I2, V2}]\)], "Input"],

Cell[BoxData[
    \({{I1 \[Rule] I2, V1 \[Rule] I2\/C1 + I2\/C2 - I2\ R + V2}}\)], "Output"]
}, Open  ]],

Cell[TextData[
"\[Diamond] serial connection of 3 capacitors: dependency of input signal on \
output signal; capacitor eqiuvalent to a serial connection of 3 capacitors"], 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[\n
      \t{serial[S, {CInst[C1], CInst[C2], CInst[C3]}, s[V0, I0], s[V1, I1]] 
          \[TildeTilde] serial[S, {CInst[C0]}, s[V0, I0], s[V1, I1]]}, \n
      \t{I0, V0, C0}, 
      Constructor -> {S \[Proportion] Real, C0 \[Proportion] Real, 
          C1 \[Proportion] Real, C2 \[Proportion] Real, 
          C3 \[Proportion] Real, I1 \[Proportion] Real, 
          V1 \[Proportion] Real}]\)], "Input"],

Cell[BoxData[
    \({{I0 \[Rule] I1, V0 \[Rule] I1\/C1 + I1\/C2 + I1\/C3 + V1, 
        C0 \[Rule] \(C1\ C2\ C3\)\/\(C1\ C2 + C1\ C3 + C2\ C3\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["How does it work", "Subsubsection"],

Cell["\<\
We illustrate on this example how the calculus proceeds. The \
initial goal of the calculus is\
\>", "Text",
  TextAlignment->Left],

Cell[TextData[StyleBox[
"G1 \[Congruent] {serial[S,{RInst[R],CInst[C1],CInst[C2]},s[I0,V0],s[I1,V1]]\
\[TildeTilde]True}",
  FontWeight->"Bold"]], "Text"],

Cell["The infernce rule applied to G1 is outermost narrowing", "Text",
  TextAlignment->Left],

Cell[TextData[{
  "[on] ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{\(f[s\_1,  ... , s\_n]\), 
                  StyleBox["\[TildeTilde]",
                    FontWeight->"Bold"], "t"}], ",", "E"}], "}"}], 
            "\[DoubleVerticalBar]", " ", 
            RowBox[{"{", 
              RowBox[{
                StyleBox["C",
                  FontSlant->"Italic"], ",", 
                StyleBox[
                  OverscriptBox[
                    StyleBox["C",
                      FontSlant->"Italic"], "_"],
                  FontSlant->"Italic"]}], 
              StyleBox["}",
                FontSlant->"Italic"]}]}], 
          RowBox[{
          \({s\_1 \[CupCap] l\_1,  ... , s\_n \[CupCap] l\_n, 
              r \[TildeTilde] t, e\_1, \[Ellipsis], e\_p, E}\), 
            "\[DoubleVerticalBar]", 
            RowBox[{"{", 
              RowBox[{
                StyleBox["C",
                  FontSlant->"Italic"], ",", 
                StyleBox[
                  OverscriptBox[
                    StyleBox["C",
                      FontSlant->"Italic"], "_"],
                  FontSlant->"Italic"]}], 
              StyleBox["}",
                FontSlant->"Italic"]}]}]], TextForm]], "Text"],
  " where f[",
  Cell[BoxData[
      \(TraditionalForm\`l\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`l\_n\)]],
  "]\[RightArrow]r\[DoubleLeftArrow]",
  Cell[BoxData[
      \(TraditionalForm\`e\_1\)]],
  "\[And]\[CenterEllipsis]\[And]",
  Cell[BoxData[
      \(TraditionalForm\`e\_p\)]],
  " is a fresh variuant of a CRR\n"
}], "Text",
  TextAlignment->Left],

Cell[BoxData[
    StyleBox[
      \(RewriteRule[serial[S, Cons[C1, CS], L, R], True, 
        And[eq[C1[S, L, L1], True], eq[serial[S, CS, L1, R], True]]]\),
      ShowSpecialCharacters->False,
      ShowStringCharacters->True]], "Input"],

Cell[TextData[{
  "since ",
  StyleBox["serial",
    FontWeight->"Bold"],
  " is a defined function symbol with two conditional rewrite rules:\n(R1) \
serial[S,\[Bullet],L,R]\[RightArrow]True\[DoubleLeftArrow]L\[TildeTilde]R\n\
(R2) serial[S,\[LeftAngleBracket]C1,CS\[RightAngleBracket],L,R]\[RightArrow]\
True \[DoubleLeftArrow] (C1[S,L,L1]\[TildeTilde]True \[And] serial[S,CS,L1,R]\
\[TildeTilde]True)"
}], "Text"],

Cell["First we apply outermost narrowing [on] w.r.t. (R1) and get", "Text"],

Cell[TextData[StyleBox[
"G21\[Congruent]{S\[CupCap]S$1079,\n         \[LeftAngleBracket]RInst[R],\
\[LeftAngleBracket]CInst[C1],\[LeftAngleBracket]CInst[C2],\[Bullet]\
\[RightAngleBracket]\[RightAngleBracket]\[RightAngleBracket]\[CupCap]\[Bullet]\
,\n        \
s[V0,I0]\[CupCap]L$1079,s[V1,I1]\[CupCap]R$1079,True\[TildeTilde]True,L$1079\
\[TildeTilde]R$1079}",
  FontWeight->"Bold"]], "Text"],

Cell[TextData[
"Next we apply the variable elimination rule [vp] for the parameter passing \
equation S\[CupCap]S$1079 and obtain, by applying substitution \
\[Theta]={S$1079\[RightTeeArrow]S} (since S is a constructor), the goal "], 
  "Text",
  TextAlignment->Left],

Cell[TextData[StyleBox[
"G31\[Congruent]{\[LeftAngleBracket]RInst[R],\[LeftAngleBracket]CInst[C1],\
\[LeftAngleBracket]CInst[C2],\[Bullet]\[RightAngleBracket]\[RightAngleBracket]\
\[RightAngleBracket]\[CupCap]\[Bullet], s[V0,I0]\[CupCap]L$1079,s[V1,I1]\
\[CupCap]R$1079,True\[TildeTilde]True,L$1079\[TildeTilde]R$1079}",
  FontWeight->"Bold"]], "Text"],

Cell["Next, we apply outermost narrowing wrt (R.2.) and get", "Text"],

Cell[TextData[StyleBox[
"G22\[Congruent]{S\[CupCap]S$1080,\n\t\[LeftAngleBracket]RInst[R],\
\[LeftAngleBracket]CInst[C1],\[LeftAngleBracket]CInst[C2],\[Bullet]\
\[RightAngleBracket]\[RightAngleBracket]\[RightAngleBracket]\[CupCap]\
\[LeftAngleBracket]C1$1080,CS$1080\[RightAngleBracket],s[V0,I0]\[CupCap]L$\
1080,\n          \t\
s[V1,I1]\[CupCap]R$1080,True\[TildeTilde]True,C1$1080[S$1080,L$1080,L1$1080]\
\[TildeTilde]True,\n  \t\
serial[S$1080,CS$1080,L1$1080,R$1080]\[TildeTilde]True}",
  FontWeight->"Bold"]], "Text"],

Cell[TextData[
"to which we apply [vp] with \[Theta]={S$1080\[RightTeeArrow]S} and next the \
decomposition rule [d] for constructor terms. We get"], "Text"],

Cell[TextData[StyleBox[
"G32\[Congruent]{RInst[R]\[CupCap]C1$1080,\n\t\[LeftAngleBracket]CInst[C1],\
\[LeftAngleBracket]CInst[C2],\[Bullet]\[RightAngleBracket]\[RightAngleBracket]\
\[CupCap]CS$1080,\n\ts[V0,I0]\[CupCap]L$1080,\n          \t\
s[V1,I1]\[CupCap]R$1080,\n          \tTrue\[TildeTilde]True,\n          \t\
C1$1080[S,L$1080,L1$1080]\[TildeTilde]True,\n  \t\
serial[S,CS$1080,L1$1080,R$1080]\[TildeTilde]True}",
  FontWeight->"Bold"]], "Text"],

Cell[TextData[{
  "The next four [vp] inference steps reduce G32 w.r.t. substitution \
\[Theta]={C$1080\[RightTeeArrow]RInst[R], CS$1080\[RightTeeArrow]",
  StyleBox["\[LeftAngleBracket]",
    FontWeight->"Bold"],
  "CInst[C1],\[LeftAngleBracket]CInst[C2],\[Bullet]\[RightAngleBracket]\
\[RightAngleBracket], L$1080\[RightTeeArrow]s[V0,I0], \
R$1080\[RightTeeArrow]s[V1,I1]} to goal"
}], "Text"],

Cell[TextData[StyleBox[
"G42\[Congruent]{True\[TildeTilde]True,\n          \t\
RInst[R][S,s[I0,V0],L1$1080]\[TildeTilde]True,\n  \tserial[S,\
\[LeftAngleBracket]CInst[C1],\[LeftAngleBracket]CInst[C2],\[Bullet]\
\[RightAngleBracket]\[RightAngleBracket],L1$1080,s[V1,I1]]\[TildeTilde]True}",
  
  FontWeight->"Bold"]], "Text"],

Cell[TextData[{
  "Equation ",
  StyleBox["True\[TildeTilde]True",
    FontWeight->"Bold"],
  " is eliminated by a [d] inference step. Since ",
  StyleBox["RInst[R]",
    FontWeight->"Bold"],
  " is a placeholder for the \[Lambda]-term"
}], "Text"],

Cell[TextData[StyleBox[
" \[Lambda][{S$496,L$496,R$496}, resistor[R,S$496,L$496,R$496]], ",
  FontWeight->"Bold"]], "Text"],

Cell[TextData[
"the next inference step is outermost \[Beta]-reduction [onbeta]. We get the \
goal"], "Text"],

Cell[TextData[StyleBox[
"G52\[Congruent]{resistor[R,S,s[V0,I0],L$1080]\[TildeTilde]True,\n  \t\
serial[S,\[LeftAngleBracket]CInst[C1],\[LeftAngleBracket]CInst[C2],\[Bullet]\
\[RightAngleBracket]\[RightAngleBracket],L1$1080,s[V1,I1]]\[TildeTilde]True}",
  
  FontWeight->"Bold"]], "Text"],

Cell["which reduces in an [on] inference step to", "Text"],

Cell[TextData[StyleBox[
"G62\[Congruent]{R\[CupCap]R$1081,\n\tS\[CupCap]S$1081,\n  \t\
s[V0,I0]\[CupCap]s[V0$1081,I0$1081],\n  \tL1$1080\[CupCap]s[V1$1081,I1$1081],\
\n  \tTrue\[TildeTilde]True,\n  \t-V0$1081+V1$1081\[TildeTilde]I0$1081 * \
R$1081,\n  \tI0$1081\[TildeTilde]I1$1081,\n  \t\
serial[S,\[LeftAngleBracket]CInst[C1],\[LeftAngleBracket]CInst[C2],\[Bullet]\
\[RightAngleBracket]\[RightAngleBracket],L1$1080,s[I1,V1]]\[TildeTilde]True}",
  
  FontWeight->"Bold"]], "Text"],

Cell["\<\
After the inference derivation are [vp],[vp],[d],[vp],[d] we \
get\
\>", "Text"],

Cell[TextData[StyleBox[
"G72\[Congruent]{-V0+V1$1081\[TildeTilde]I0 * R,\n  \t\
I0$1081\[TildeTilde]I1$1081,\n  \tserial[S,\[LeftAngleBracket]CInst[C1],\
\[LeftAngleBracket]CInst[C2],\[Bullet]\[RightAngleBracket]\[RightAngleBracket]\
,s[V1$1081,I1],s[V1,I1]]\[TildeTilde]True}",
  FontWeight->"Bold"]], "Text"],

Cell[TextData[{
  "The first equation has both sides built up by external function symbols (",
  
  StyleBox["Plus",
    FontWeight->"Bold"],
  " and respectively ",
  StyleBox["Times",
    FontWeight->"Bold"],
  "), and therefore we can only aply a [sp] inference step. This will result \
in putting equation ",
  StyleBox["-V0+V1$1081\[TildeTilde]I0 * R",
    FontWeight->"Bold"],
  " into the constraint store. Next, apply [v] inference step and get"
}], "Text"],

Cell[TextData[StyleBox[
"G82\[Congruent]{serial[S,\[LeftAngleBracket]CInst[C1],\[LeftAngleBracket]\
CInst[C2],\[Bullet]\[RightAngleBracket]\[RightAngleBracket],s[V1$1081,I1],s[\
V1,I1]]\[TildeTilde]True}",
  FontWeight->"Bold"]], "Text"],

Cell[TextData[{
  "for which there are two alternative outermost narrowing inference steps. \
The first choice of [on] derives the goal\n",
  StyleBox[
  "G821\[Congruent]{S\[CupCap]S$1082,\n         \[LeftAngleBracket]CInst[C1],\
\[LeftAngleBracket]CInst[C2],\[Bullet]\[RightAngleBracket]\[RightAngleBracket]\
\[CupCap] \[Bullet],\n        \
s[V1$1081,I1]\[CupCap]L$1082,s[V1,I1]\[CupCap]R$1082,\n        True\
\[TildeTilde]True,L$1082\[TildeTilde]R$1082}",
    FontWeight->"Bold"]
}], "Text"],

Cell[TextData[{
  "which can not result in a refutation because of the equation ",
  StyleBox[
  "\[LeftAngleBracket]CInst[C1],\[LeftAngleBracket]CInst[C2],\[Bullet]\
\[RightAngleBracket]\[RightAngleBracket]\[CupCap] \[Bullet].",
    FontWeight->"Bold"],
  "\nThe second choice of [on] derives trhe goal\n",
  StyleBox[
  "G822\[Congruent]{S\[CupCap]S$1083,\n         \[LeftAngleBracket]CInst[C1],\
\[LeftAngleBracket]CInst[C2],\[Bullet]\[RightAngleBracket]\[RightAngleBracket]\
\[CupCap] \[LeftAngleBracket]C1$1083,CS$1083\[RightAngleBracket],\n        \
s[V1$1081,I1]\[CupCap]L$1083,s[V1,I1]\[CupCap]R$1083,\n        True\
\[TildeTilde]True,\n        \
CInst[C1][S$1083,L$1083,L1$1083]\[TildeTilde]True,\n        serial[S$1083,\
\[LeftAngleBracket]CInst[C2],\[Bullet]\[RightAngleBracket],L1$1083,R$1083]\
\[TildeTilde]True\n        }",
    FontWeight->"Bold"]
}], "Text",
  FontWeight->"Plain"],

Cell["\<\
The calculus proceeds until no more equation remains in the goal. \
At that point, the scheduler is invoked to solve the constraints accumulated \
so far in the constraint store. Finally, the solutions returned by the \
scheduler are used to complete the partial solution computed by the CFLP \
interpreter.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parallel connections", "Subsection"],

Cell[TextData[{
  "Parallel connections are expressed by the predicate ",
  StyleBox["parallel.",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?parallel\)\)], "Input"],

Cell[BoxData[
    \("parallel[S, Clist, s[V0,I0], s[V1,I1]] is the electrical component \
representing the serial connection of the unary components of list Clist, \
with input s[V0,I0], output s[V1,I1] and system frequency S."\)], "Print"]
}, Open  ]],

Cell["\<\
A system consisting of a parallel connection \
resistor/capacitor/capacitor with specified characteristic values\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000390000Q0P10`4000010?ooo`00
0?ool?l00;jn_W20T5mOGenNX2m?D8GNh000T000/000d8O>o`2@0000o`2`0?oo003@
002@T02`/03@d9000;000=000900T;00/=00d80`0:100<1P0?n0P?nPX?o0`?oPh?oG
04NjhIW:<J5A:03o003ooaj>6]WIfNc/k:>SXol0ok0`H<?3`m0PT:0Pl3bcLLk>c[Zj
^[6a/JRXZ:2PX=Rof8:2PXj>S/3Ph3USH`00<`00IP00V@00c00c000c<`0cIP0cV@0c
c00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2IIP2IV@2Ic02Io`3<003<<`3<IP3<
V@3<c03<o`3o<`3oIP3oV@3oc4000400<d00IT00VD00c400od0c040c<d0cIT0cVD0c
c40cod1V041V<d1VIT1VVD1Vc41Vod2I042I<d2IIT2IVD2Ic42Iod3<043<<d3<IT3<
VD3<c43<od3o043o<d3oIT3oVD3oc43ooh00<h00IX00VH00c800oh0c080c<h0cIX0c
VH0cc80coh1V081V<h1VIX1VVH1Vc81Voh2I082I<h2IIX2IVH2Ic82Ioh3<083<<h3<
IX3<VH3<c83<oh3o083o<h3oIX3oVH3oc83ookl00;l0<kl0I[l0VKl0c;l0oklc0;lc
<klcI[lcVKlcc;lcokmV0;mV<kmVI[mVVKmVc;mVoknI0;nI<knII[nIVKnIc;nIoko<
0;o<<ko<I[o<VKo<c;o<okoo0;oo<kooI[ooVKooc;ooool0<ol0I_l0VOl0c?lc0?lc
<olcI_lcVOlcc?lcoomV0?mV<omVI_mVVOmVc?mVoonI0?nI<onII_nIVOnIc?nIooo<
0?o<<oo<I_o<VOo<c?o<oooo<oooI_ooVOGN/l000>00001002100410061008100:10
0<100>1007:OolCGociGS=WIfLc<c8b<S?o/W9Af0<c<Xhb<L<C4a>[ZjWAdM:NWYlT0
00390000b@000<T000390000b@000<T000390000b@000<T000390000E00O0EH0001D
00030@0001/000<10000E00005@000<100006`000`40001D0000E0000`40000K0003
0@0005@0001D00030@0001/000<10000E00005@000<100006`000`40001D0000E000
0`40000K00030@0005@0001:008120000`40000800@10P030@03004100L000<10000
E00004X01P4400030@0000L00P4200810P001040004800030@0005@0000`02<100<0
0@0020000`40000200040@000@8000<100001P0O0CP0000`00030@0001L01P440003
0@0000H000<100001P001040004800030@0001/000<10000=P00030000<100005`02
0@P000<100001P000`40000600040@000@P000<100006`000`40000f0000<0000`40
000Q00030@0000H000<100001@0010400@4900030@0001/000<10000=P00030000<1
00008@000`40000700030@00008000<1000030000`40000K00030@0003H0000`0003
0@00024000<100001`020@800P4>00030@0001/000<10000=P00030000<100008@00
0`40000800<100<00@003@000`40000K00030@0003H0000`00030@00024000<10000
6`000`40000K00030@0003H0000`00030@00024000<100006`000`40000K00030@00
03H0000`00030@00024000<100006`000`40000K00030@0003H0000`00030@000240
00<100006`000`40000K00030@0003H0000`00030@00024000<100006`000`40000K
00030@0003H0000`00030@0002407`4M00030@0003H0000`00030@0005d000<10000
=P00030000<10000G@000`40000f0000<0000`40001M00030@0003H0000`00030@00
05d000<10000=P00030000<10000G@000`40000f0000<0000`40001M00030@0003H0
000`00030@0005d000<10000=P00030000<10000G@000`40000f0000<0000`40001M
00030@0003H0000`00030@0005d000<10000=P00030000<10000G@000`40000f0000
<0000`40001M00030@0003H0000`00030@0001@00P5700030@0003H0000`00030@00
01@01P5300030@0003H0000`02018P0O0CP0000`00030@0001@01P4>00040@000@80
00<100000`001040004200030@00020000<10000=P00030000<1000050020DL000<1
0000=P00030000<10000G@000`40000f0000<0000`40001M00030@0003H0000`0003
0@0005d000<10000=P00030000<10000G@000`40000f0000<0000`40001M00030@00
03H0000`00030@0005d000<10000=P00030000<10000G@000`40000f0000<0000`40
001M00030@0003H0000`00030@0005d000<10000=P00030000<10000G@000`40000f
0000<0000`40001M00030@0003H0000`00030@0005d000<10000=P0000T0:05O0003
0@0003H0000`00030@0005d000<10000=P00030000<10000G@000`40000f0000<000
0`40001M00030@0003H0000K00<14P000`40001M00030@0001d00P4G00006P001@40
0001014000<10000G@000`40000M00H14`0001X000D100000@0A00030@0005d0:@4@
00003`000`400@020@800`4200<100D00@4100030@03004100L000<10000G@000`40
000M00H14`0000l00P4200810P001@40000100@000D100000@0200030@0000H000<1
0000G@000`40000M00815`0000l000<100000P001040004200<10`001@4000010080
00<100001P000`40000Q01l17@000`40000f00004`020@8000@100010P0010400043
00040@000@P000<100008@000`40000K00030@0001/000<100004P030B40000A00<1
0`001040004200040@000@<000@1000120000`40000Q00030@0001/000<100006`00
0`40000A00050@000040800001000P4400810`040@06004000400P4900030@000240
00<100006`000`40000K00030@00014000D100000@0P00003`000`40000200030@00
00T000<100003@000`40000Q00030@0001/000<100006`000`40000600030@010081
0P030@800`4300@11@020@04004000813@0000l000@100000P4;00030@0000d000<1
00008@000`40000K00030@0001/000<100001P020@800P4200050@00004010020@80
0P4300040@000@8000<100003@0001000`401@01000100L00`4>00030@00024000<1
00006`000`40000K00030@0000H000<100000P001040004200<10`000`4000020005
0@0000400P001040004?0000<0000`40000Q00030@0000P0104200D120000`40000K
00030@0000X00P4200040@000@8000<100401P001040004200040@000@l0000`0003
0@00024000<100001`020@800P400`01000200030@0000H000<100006`000`400008
00<10`001040004200030@0100H000@100010P001040004?0000<0000`40000Q0003
0@0000L000<100000P001040004;00030@0001/000<100001`020@@00P4300D11P00
1@400@40008100<00@400P4=0000<0000`40000G008120000`40000600030@0000L0
00<1000020000`40000K00030@0000H000<100000P000`40000900030@00008000<1
00001`000`40000=0000<0000`40000G00H110000`40000600030@0000P000<10000
1`000`40000K00030@0000H000@100000P4;00810P020AT0000`02<100<00@001`00
0`40000900030@0000H07`4900<100D00@000@0900@16P00030000<100005`060@@0
00<100001`000`40000200030@0000<000<100001P000`40000K00030@0003H0000`
00030@0001L00P4800030@0000L00P42008100<00@000P000`40000600030@0001/0
00<10000=P00030000<100008@000`40000800<100@00@000`4900030@0001/000<1
0000=P00030000<100008@000`40000K00030@0001/000<10000=P00030000<10000
8@000`40000K00030@0001/000<10000=P00030000<100008@000`40000K00030@00
01/000<10000=P00030000<100008@000`40000K00030@0001/000<10000=P000300
00<100008@000`40000K00030@0001/000<10000=P00030000<100008@0O0Ad000<1
0000=P00030000<10000G@000`40000f0000<0000`40001M00030@0003H0000`0003
0@0005d000<10000=P00030000<10000G@000`40000f0000<0000`40001M00030@00
03H0000`00030@0005d000<10000=P00030000<10000G@000`40000f0000<0000`40
001M00030@0003H0000`00030@0002407`4M00030@0003H0000`00030@00024000<1
00006`000`40000K00030@0003H0000`00030@00024000<100006`000`40000K0003
0@0003H0000`00030@00024000<100006`000`40000K00030@0003H0000`00030@00
024000<100006`000`40000K00030@0003H0000`00030@00024000<100006`000`40
000K00030@0003H0000`00030@00024000<100006`000`40000K00030@0003H0000`
00030@00024000<1000020040@<00`4900030@0001/000<10000=P00030000<10000
8@000`40000700810P020@<000<1000020000`40000K00030@0003H0000`00030@00
024000<100001`000`40000200050@0000402P000`40000K00030@0003H0000`0003
0@0001L00P4800030@0000H000<100001`000`40000800030@0001/000<10000=P00
030000<100005`060@@000<100001P000`40000700030@0000P000<100006`000`40
000f0000<00S0@03004000L000<100001`000`40000801l1>00004X01P4400030@00
00L000<100000P001@400@0100X000<10000E00004X00P4800030@0000L00P420081
0P020@X000<10000E00005@000<1000020030@030040008000<1000020000`40001D
0000E0000`40000K00030@0005@0001D00030@0001/000<10000E00005@000<10000
6`000`40001D0000E0000`40000K00030@0005@0001D00030@0001/000<10000E000
05@07`5F0000b@000<T000390000b@000<T000390000b@000<T000390000\
\>"], "Graphics",
  ImageSize->{201, 132},
  ImageMargins->{{0, Inherited}, {Inherited, 0}}],

Cell["is described by the predicate", "Text"],

Cell[TextData[StyleBox["parallel[S,{C1,C2,\[Ellipsis],Cn},SignIn,SignOut]",
  FontWeight->"Bold"]], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Queries for parallel connections", "Subsection"],

Cell[TextData[
"\[Diamond] dependency of SigIn on SigOut for a parallel \
resistor/capacitor/capacitor conmnection"], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[\n
      \t{parallel[S, {RInst[R], CInst[C1], CInst[C2]}, s[V0, I0], s[V1, I1]] 
          \[TildeTilde] True}, \n\t{I0, V0}, 
      Constructor -> {S, R, C1, C2, I1, V1}]\)], "Input"],

Cell[BoxData[
    \({{I0 \[Rule] I1, 
        V0 \[Rule] 
          \(-\(\(\(-I1\)\ R + V1 - C1\ R\ V1 - C2\ R\ V1\)\/\(\(-1\) + 
                  C1\ R + C2\ R\)\)\)}}\)], "Output"]
}, Open  ]],

Cell[TextData[
"\[Diamond] dependency of SigIn on SigOut for a parallel \
capacitor/capacitor/capacitor conmnection, \n   and the capacitor equivalent \
to such a connection "], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003M0000Z`P10`4000010?ooo`00
0?ool;jn_W20T5mOGenNX2m?D8GNh?l00?GN/lC4a000<`00IP00V@00c000o`0c000c
<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2IIP2IV@2Ic02Io`3<
003<<`3<IP3<V@3<c03<o`3o003o<`3oIP3oV@3oc03ooc<003<0<c<0IS<0VC<0c3<0
oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=Vc3=Voc>I03>I<c>IIS>IVC>I
c3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o<c?oIS?oVC?oc3?oofH006H0<fH0IVH0
VFH0c6H0ofHc06Hc<fHcIVHcVFHcc6HcofIV06IV<fIVIVIVVFIVc6IVofJI06JI<fJI
IVJIVFJIc6JIofK<06K<<fK<IVK<VFK<c6K<ofKo06Ko<fKoIVKoVFKoc6KooiT009T0
<iT0IYT0VIT0c9T0oiTc09Tc<iTcIYTcVITcc9TcoiUV09UV<iUVIYUVVIUVc9UVoiVI
09VI<iVIIYVIVIVIc9VIoiW<09W<<iW<IYW<VIW<c9W<oiWo09Wo<iWoIYWoVIWoc9Wo
ol`00<`0<l`0I/`0VL`0c<`0ol`c0<`c<l`cI/`cVL`cc<`colaV0<aV<laVI/aVVLaV
c<aVolbI0<bI<lbII/bIVLbIc<bIolc<0<c<<lc<I/c<VLc<c<c<olco0<co<lcoI/co
VLcoc<coool0<ol0I_l0VOl0c?l0oolc0?lc<olcI_lcVOlcc?lcoomV0?mV<omVI_mV
VOmVc?mVoonI0?nI<onII_nIVOnIc?nIooo<0?o<<oo<I_o<VOo<c?o<oooo0?oo<ooo
I_ooVOooc>[ZjWAdM:NWYj0Pl=WIfJj^[WMgM`000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000=d0
003M0000g@000=d0003M0000g@000=d0003M0000g@000=d0003M0000A00j0El00014
00030@0003H000<10000G@0004@000<10;L03@000kL0]`0E0003]`0000/000Bg0001
G`0004@000<10000=P000`40001M0000A0000`40000P00<13P001[L10@400El00014
00030@00020000<100004@000`400@1O0000@P000kL00@070003]`0000L000>g0000
3P000`4000020003]`0000L000>g00000P000`400@1O0000A0000`40000500@10P03
0@0500410@000P4010010@44008100<00@0010040@<00`4400030@0105l000140003
0@0000@00P4200810P001@400001008000L10;L1]`01008000D100000@04008100Fg
004100020@030041008000Bg0@01G`0004@000<1000010000`40000200040@000@<0
00@1000110001@4f000100<000<100000P000`40000200030@0100<000L100000@01
05l0000j008120000`40000300030@0000H000D100000@0200030@00008100H0]`00
0KL200050@00004010001KL0006g008000P100000@01]c/000>g0@40800003X000<f
0@400`4400030@0000<000<100001P001@400001008000@100010P0013H000430005
0@0000401`001@40000100<000<10040?@060A`0000@0003]`41030100@00@2g0`00
0`40000600050@000@000P420003]`01008100<00@400P400`01000200030KL000D0
00D1]`2g0@0300030@0104H100>g00005P0003X01P4400030@0000@000<100000P00
1040004?00050@00004010000cH0000200030@0100<000L100000@0103d01@400cH0
000J0000>0001;L00@420003]`0000<000<1000010020@800P4200030@0000@000>g
00002P000`6g000200810P020@04004100810`000`400@0j0003]`0000810`001kL0
002g0;L05P0004@000<100001@030@03004000<14P030@<00`40100100030@800`40
0`01001N000070000kL0000700<16`000`40000f00030@00010000>g00001@030D80
000U00050@0000406P000`40000f00030@0000T000>g00002`001@4000010440000T
0003]`40008000<1000060000`40000c0004]`000AT000D100000@1100006P000`40
0@020@800`4200<100D00@4100030@030041010000<10000=P000`40000<0003=P01
00810P030@800`43008100<f0@0010020@0400400081;P0001X00P4200810P001@40
000100@000D100000@0200030@0000d000>g0040=`000kL1000=00810P020@8000D1
00000@0400810P020@<000@100010P000`40000^00006P000`40000200040@000@80
0`4300050@0000400P000`40000?03X13P000`40000200040@000@800`4300030@00
008000D100000@0200040@000C00000N00810P001040004200040@000@8000Fg0@00
0@0?0003]`0004/00P4200040@000@8000D10040]`030005]`4000400P001040004`
000070030@<000@f00010P001040004300040@000E/00`4300040@000@8000<10040
1P001040004200040@000C00000K008110020@<010401P0100010081F`020@@00P43
00D11P001@400@40008100<00@400P4^00006P000cH0000200030@0000T000<10000
0`000kL0001H00030@00008000<100002@000`40000200030@0000L000<10000;P00
01X000@100000P4;00030@0002`000>g0000;`00104000020@P000>g00000P420081
0`000kL0000d00006`030@05004000401`000cH10@1P00<100D00@000@0900@1>`00
02H000>g0000H`000kL0]`0O0003]`0002`0002E0003]`0004D0000R0003]`0003L0
00<10;L0;`000kL0001<0000F`000`400@1o0000E0000kL0000300050@0000400`00
0kL0001h0000F@000`40]`0300050@000;L0N@0005H000>g00401`000`40001j0000
E`000`40000700030@0007T0001F00030@0000T000D10000]`1f0000E@000`40000;
00030@0007L0001D00030@0000d000<10000MP0005<01`4500L1M`0005T000<10000
0`000`40001k0000F@000`40000300030@0007/0001I00030@0000<000<10000N`00
05T000<100000`000`40001k0000F@000`40000300030@0007/0001I00030@0000<0
00<10000N`0005T000<100000`000`40001k0000F@000`40000300030@0007/0001C
00L11@070GL0001D00030@0000d000<10000MP0005D000<100002`000`40001g0000
EP000`40000900030@0007P0001@0003]`0000@000<1]`000P000kL0]`0200030@00
07T0001H0003=P0000D000<10000NP0005T000<100000P000kL100030003]`0007H0
001J00050@000040OP0005/000<10040O`0005`000<10000OP000=d0003M0000G000
0kL0]`1n0000g@000=d0003M0000g@000=d000100004]`0003X1G`0004@000<f0000
8P000kL0000A00030@0005d0001400030@00034000Jg0;L0]`5O0000A0000`40000f
00030@0005d0001400030@0001l000Bg0@4110000kL0000800<100>g0@00GP0004@0
00<1000080000`40000A00030@0105l0001400030@00020000<100004@000`400@1O
0000>P020@P000<100001@020@04=P4000<100P00@4103H100<110020@03004000@0
1043008100<f00000P000`400@1O0000>P060@@000<1000010020@800P4200050@00
00400P001040]`4200040@000@8000>g0@000`020@800P400`01000200070KL00040
0@1O0000=@000`4f0@0;0@03004000D000<100000P001040004300040@000@@00P42
00050@00004010000`40000200030@0000<000L100000@0105l0000e00030KL00080
1P4400030@0000<000<100001P001@6g0001008000<100000P4400050@00]`400`00
0`40000900070@0000400@1O0000=@000`400002008120000`40000300030@0000H0
00D100000@0200040@000@8000@100010`001@40]`0100P00`4400030@0105l0000e
00030@00008000>g00001`000`40000300030@0000H000D1]`0100020@8000>g0040
0P400`010@020@030040008000<1000020000`40000200030@010181C@0003D000<1
000030000`40000400030@00008000@100013`001@40000100@000<100000P000`40
000300070@0000400@0A00030@0004/0000e00030@0000`000<1000010020@800P42
00030@00014000<100000P020@800P400kL1000200070@0000400@0A00030@0004/0
000e00030@0000`000<100001@030@03004000<14P030@<000D1=P400@0200<10P03
0@030040010000<10000B`0003D000<1000030000`4000070003]`0000D000>g0000
5@000kL000050003]`0000@000<1]`003`000`40001;0000=@000`40000<00030@00
03H000<100003`000`40001;0000=@000`40000<00030@2g00/000>g0000:0000`40
000?00030@0004/0000e00030@0000`000<10000=P000`40000?00030@0004/0000e
00030@0000P000Fg00000@0U0003]`00010000<1]`003`000`40001;0000=@000`40
000<03X14@000`40001;0000=@000`40001G00030@0004/0000e00030@0005L000<1
0000B`0003D000<10000E`000`40001;0000=@000`40001G00030@0004/0000e0003
0@0005L000<10000B`0003D000<10000E`000`40001;0000=@000`40001G00030@00
04/0000e00030@0005L000<10000B`0003D000<10000E`000`40001;0000=@000`40
001G00030@0004/0000e00030@0003h000>g00005P000`40001;0000=@000`40000<
03X14@000`40001;0000=@000`40000<00030@0001/000>g000060000`40000?0003
0@0004/0000e00030@0000`000<10000=P000`40000?00030@0004/0000e00030@00
00`000<100007`000kL0000=0003]`2g00@000<100003`000`40001;0000=@000`40
000<00030@0001d00`4?00<110000`40000?00030@0004/0000e00030@0000`000<1
00007@000`40000A00030@00008000<100003`000`40000j0003]`0000h0000e0003
0@0000`000<100007@000`40000A00030@00008000<100003`000`40000_0003]`00
01T0000`0006]`000;L110020@P000D10000]`040@800`401@010@40008100@00@41
100013H1004500@10P050@<000<100000P000`6g000?00030@0003@000>g00005000
03D000<100000P000cH10@030@@000@100000P4200810P001@400001008000@10001
0P001040004300030@0000800P42008100<00@000P001@40000100@000<100003`00
0`40001;0000200k0@030040008000<100000P001040004300040@000@8000Bg0041
0P001@40000100@000<100000P001040004600030@00008000<100002P000kL00002
00030@0004/0000e00030@0000801P4400040@000@P000D100000@0200050@2g=P40
10001@40000f00<000<100001`000`40000300030@00008000<100003`000`40000b
00815`0003D000D1002g00020@8000>g00000`001`40006g0;L01@00204000010;L1
0P001040004200050@0000400`000`40000800030KL0008000<100000P000`6g000>
0003]`4003<01P4C0000=@000`40000<00040@000@P000D1000100020@@00`400`01
0@020@030040008000<100002@001CH0000100@04@400cH10@0e0@03=P4f00@14000
010000>g0;L02P030AD000<1000030001@40000100@000@100013`001@40000100@0
00<100000P000`40000300050@00004010000`40000?00030@00018000>g00007@06
0A<0000L00050@00004050000`40000<00040@0000810P020@8000<100004@000`40
000200810P020@030040008000D10000=P0400030@0000l000<10000<P020@<000>g
00004@00010000>g00002@001@40000101@000<1000030000`40000200<100<00KL0
0`4B00<10`030@04004000<100>g00400P401KL00001014000<100003P000kL0000S
0003]`0001@0000A00030@0100810P030@800`401@010@4000<100<00@402P000`40
000<00030@0003H000<100003`000`40000B008100<f0000=00001400P4200810P00
1@40000100@000D100000@0200030@0000T000<1000030000`40000=0003]`0001<0
00>g00001`000kL0000600030@0000l000<1000020001KL0002g00<000>g0@000P00
0`40000H0003]`0001P0000A00030@00008000@100010P030@<000D100000@020003
0@0000T000<1000030000`40000f00030@0000l000<100004@001@40000103D0000E
00810P001040004200040@000@<000D10001]`0:00030@0000`000<100002@000kL0
]`030003]`00014000>g000040000`40000?00030@0000H000<100400P4200<100>g
00400P4300@110001KL10@0100800P450003]`0001X0000C00030CH100<000@10001
0P001040004300040@000@/000<1000030000`40000f00030@0000l000<100001P02
0@800P4200050@00004010020@800P430004=P000@8000<100008P0001800P440081
0`040@060040006g0P4<00030@0000`0>P4A00030@0000H000<100000P0010400042
00<10`000`40000200050@0000400P001040004T00004@000`4000020003=P0000T0
00<1000040000`4000150003]`0000l000<100002P020@8000@100010P000`400@06
00040@000@8000@100019000014000@100000P450003]`0000<000<1000040000`40
00160003]`0000h000<1000020030@<000@10;L10P000`400@0600040@000@8000@1
0001900001800`401@01000100L00`4A00030@0005L000<100001`020@@00P4300D1
1P0020400@6g=P40104R0000=@000`40001G00030@0000H000<10;L00P000`400009
00030@00008000<100001`000`40000R0000=@000`40001G00030@0000H000@f0000
0P4;00810P020Bh0000e00030@0005L000<100001`030@05006g00402@040Bl0000e
00030@0005L000<10000B`0003D000<10000?P000kL0000F00030@0004/0000e0003
0@0000`0>P4A00030@0004/0000e00030@0000`000<10000<`001;L0004A00030@00
04/0000e00030@0000`000<10000=P000`40000?00030@0004/0000e00030@0000`0
00<100006`000kL0000;0003]`0000<000>g000010000`40000?00030@0004/0000e
00030@0000`000<100007@020@03=P0000P000>g00000P030@@000<100003`000`40
001;0000=@000`40000<00030@0001T000Ng00000@2g014000<100000P000`40000?
00030@0004/0000e00030@0000`000<100007@000`40000A00030@00008000<10000
3`000`40001;0000=@000`40000<00030@2g0080104200<100D00@4100020@040041
0@@00P400`01000400@10P001;L10@4400030@00008000<1]`003`000`40001;0000
=@000`40000<00040@0000810P020@8000D100000@0200040@000@8000@100010`00
0`40000200810P020@<000<100000`000`40000200030@0000l000<10000B`0003D0
00<1000030001@40]`0100@000@100010`0010400044008100>g00400`001`40002g
0KL00`001@40000100D000<100000P000`40000:0003]`00008000<10000B`0003D0
00<100000P020@P000@1000120001@400001008000<100000P4400050@0000400`00
0cH0000700030@0000<000<f00000P000`40000?00030@0004/0000e00030KL00080
1P4400050@000KL01@000kL00@0300040@000@8000L10001]`0100<000D100000@09
00030@0000<000<100000P000`6g000>0003]`4004`0000e00030CH100/100D00@00
0@0800050@000@000P4400<100<00@400P400`01000200030@0000L000<100000`00
0cJg000200030CH100h100<f0@00C000038000>g00001@060@@000D100000@040004
0@000@l000L10;L00@2g008000<100000P001`400@010;L00`000`40000200030@00
05d0000j00812000104000020@800P4200030@00014000<100000P020@800P420081
1@000`40000200030@0005d0001400030@0000800`400`0100030A800`4300<100<0
0@000P00104000030@050;L00040G`0004@000<100002P000kL0000G0003]`0000l0
00<10000G@0004@000D10000]`050003]`0001L000>g00002@000kL0000600030KL0
05d0001400030@0003H000<10000G@0004@000<100001@000kL0000[0004]`000El0
00140003=P0003H000<10000G@0004@0>P5O0000g@000=d0003M0000g@000=d0003M
0000g@000=d0003M0000\
\>"], "Graphics",
  ImageSize->{221, 171},
  ImageMargins->{{0, Inherited}, {Inherited, 0}}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[\n
      \t{parallel[S, {CInst[C1], CInst[C2], CInst[C3]}, s[V0, I0], s[V1, I1]] 
          \[TildeTilde] \(CInst[C0]\)[S, s[V0, I0], s[V1, I1]]}, \n
      \t{I0, V0, C0}, 
      Constructor -> {S \[Proportion] Real, C0 \[Proportion] Real, 
          C1 \[Proportion] Real, C2 \[Proportion] Real, 
          C3 \[Proportion] Real, I1 \[Proportion] Real, 
          V1 \[Proportion] Real}]\)], "Input"],

Cell[BoxData[
    \({{I0 \[Rule] I1, 
        V0 \[Rule] \(I1 + C1\ V1 + C2\ V1 + C3\ V1\)\/\(C1 + C2 + C3\), 
        C0 \[Rule] C1 + C2 + C3}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Mixed connections", "Subsection"],

Cell[TextData[{
  "For expressing electric components that do not consist only of \
parallel/serial connections, we make use of the predicate ",
  StyleBox["junction",
    FontWeight->"Bold"],
  " which expresses junctions of electric signals."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(?? junction\)], "Input"],

Cell[BoxData[
    \("junction[L,R] describes a junction of inputs L and outputs R. L and R \
are lists of pairs s[Vi,Ii]."\)], "Print"]
}, Open  ]],

Cell["For example, an electric component of the form", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000X@P10`4000010?ooo`00
0?ool?l00;jn_W20T5mOGenNX2m?D8GNh000T000/000d8O>o`2@0000o`2`0?oo003@
002@T02`/03@d9000;000=000900T;00/=00d80`0:100<1P0?n0P?nPX?o0`?oPh?oG
04NjhIW:<J5A:03o003ooaj>6]WIfNc/k:>SXol0ok0`H<?3`m0PT:0Pl3bcLLk>c[Zj
^[6a/JRXZ:2PX=Rof8:2PXj>S/3Ph3USH`00<`00IP00V@00c00c000c<`0cIP0cV@0c
c00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2IIP2IV@2Ic02Io`3<003<<`3<IP3<
V@3<c03<o`3o<`3oIP3oV@3oc4000400<d00IT00VD00c400od0c040c<d0cIT0cVD0c
c40cod1V041V<d1VIT1VVD1Vc41Vod2I042I<d2IIT2IVD2Ic42Iod3<043<<d3<IT3<
VD3<c43<od3o043o<d3oIT3oVD3oc43ooh00<h00IX00VH00c800oh0c080c<h0cIX0c
VH0cc80coh1V081V<h1VIX1VVH1Vc81Voh2I082I<h2IIX2IVH2Ic82Ioh3<083<<h3<
IX3<VH3<c83<oh3o083o<h3oIX3oVH3oc83ookl00;l0<kl0I[l0VKl0c;l0oklc0;lc
<klcI[lcVKlcc;lcokmV0;mV<kmVI[mVVKmVc;mVoknI0;nI<knII[nIVKnIc;nIoko<
0;o<<ko<I[o<VKo<c;o<okoo0;oo<kooI[ooVKooc;ooool0<ol0I_l0VOl0c?lc0?lc
<olcI_lcVOlcc?lcoomV0?mV<omVI_mVVOmVc?mVoonI0?nI<onII_nIVOnIc?nIooo<
0?o<<oo<I_o<VOo<c?o<oooo<oooI_ooVOGN/l000>00001002100410061008100:10
0<100>1007:OolCGociGS=WIfLc<c8b<S?o/W9Af0<c<Xhb<L<C4a>[ZjWAdM:NWYol0
BP000?l0BP000?l0BP000?l0BP000?l0BP000?l0BP000?l0BP000?l0BP000?l0BP00
0?l0BP000?l0BP000?l0BP0002T00`5200<1<`030DP00`5G0000:0001@4000010400
00D100000@0a00050@000040AP001@40000105H0000X00050@000040@0001@400001
034000D100000@1600050@000040EP0001d000<100400P4200<10P030@0500410@00
0`400`010@050BH000<100400P4200<10P030@<01045008100@00@001`4>00030@01
00810P030@800`401@010@4000<100@00@400`4]00030@0100810P030@800`4300@1
1@020@040040008100@00@41?`0001d00P4200810P001@40000100@000D100000@02
00030@0100<000<1000090020@800P4200050@00004010020@800P4300040@000@80
00@100010`000`40000<00810P020@8000D100000@0400050@0000400P000`400@02
0081;0020@800P4200050@00004010020@800P4300040@000@8000@100010P020Ch0
000M00030@00008000@100010P030@<000D100000@0200040@000@d05@4700030@00
008000@100010P030@<000<100000P001@400001008000@100010`000`40000?0003
0@00008000@100010P030@<000D100000@0200030@0000<000<100002`0E0@X000<1
00000P001040004200<10`000`40000200050@0000400P001040004600030@0003`0
000Q00810P001040004200040@000@<000@100010`000`40000800815@020@T00P42
00040@000@8000<100401P001040004200040@000@@000<100004P020@8000@10001
0P001040004300040@000@D000<100002@020AD00P4<00810P001040004200030@01
00H000@100010P001040004600030@0003`0000O00<10`001040004200040@000@<0
00@1000110000`40000600030@0001L000<1000010030@<000@100010P000`400@06
00040@000@8000@100011@000`40000?00<10`001040004200040@000@<000@10001
10020@X000<100005`000`40000700<10`001040004200030@0100H000@100010P00
104000450081?P0001h00P4400810`040@06004000400P4600030@0000@000<10000
6@000`400002008110020@<01@4600050@010@000P400`010@020@@000<100003@02
0@@00P4300@100H00@000@020@<00`4:00030@0001T000<100001@020@@00P4300D1
1P001@400@40008100<00@400P4010010@4o00007@000`40000200030@0000T000<1
00002P000`40000400030@0001T000D100000@0400030@0000T000<100000P000`40
000700030@0000@000<1000030000`40000200030@0000T000<100001`000`40000:
00030@0001T000<1000010000`40000200030@0000T000<100000P000`4000070005
0@000040@@0001d000@100000P4;00030@0000H000D100000@0500030@0001/000@1
00010`020@/00P42008130001@40000100h000@100000P4;00030@0000L000<10000
2@000`40000K00030@0000<000@100000P4;00810P020@d000<10000?`0001h00`40
1@01000100L00`4800<11P000`40000K00040@0000<100D00@000@0900@13P030A00
0`401@01000100L00`4900<120000`40000K00030@0000@00`401@01000100T0104?
00<1?P00044000<1000020020@03004100<12`000`40001M00030@0000P00P4200<1
30000`40001Y0000@@000`40000700030@0000810`000`40000900030@0005d000<1
00001`000`4000020@800P4;00030@0006T0001100030@0000L000<100000P000`40
000<00030@0005d000<100001`000`40000500030@0000T000<10000J@0003L00P48
00030@0000L000<100000`000`40000;00030@0002<00P4^008120000`4000070003
0@0000D000<100002@000`40001Y0000=`060@@000<100001`001040004300030@00
00X000<100008`060BX01P4400030@0000L000@100010`020@/000<10000J@0002H0
6P400`01000900811@000`40000902l100<00@40;@400`01000900810P030@`0:`51
00009P000`40000>00H110000`40000?00030@0000T000<100008`060BX01P440003
0@0000`000<1000030000`40000W00030@0003l0000V00030@0000h00P4800030@00
00/000D100000@0;00030@0002<00P4800030@0002<00P4800030@0000`000<10000
30000`40000W00030@0003l0000V00030@0001P000<1000030030@`000<10000;@00
0`40000]00030@0000d00`4;00030@0002L000<10000?`0002H000<1000060000`40
000K00030@0002d000<10000;@000`40000K00030@0002L000<10000?`0002H000<1
00006@000`40000I00030@0002d00`4_00030@0001T000<10000:0000`40000o0000
9P000`40000I00030@0001T000<10000;@030Bl000<100006@000`40000X00030@00
03l0000V00030@0001X000<100005`000`40000^00<1<0000`40000G00030@0002T0
00<10000?`0002H000<100006`020AD00P4a00<1<@020AD00P4/00030@0003l0000V
00030@0001d05@4b00D1<P0E0Bh000<10000?`0002H000<10000I0050GD000<10000
?`0002H000<10000IP000`40001e00030@0003l0000V00030@0006H000<10000M@00
0`40000o00009P000`40001V00030@0007D000<10000?`0002H000<10000IP000`40
001e00030@0003l0000V00030@0006H000<10000M@000`40000o00009P000`40001V
00030@0007D000<10000?`0002H000<10000IP000`40001e00030@0003l0000V0003
0@0006H000<10000M@000`40000o00009P000`40001V00030@0007D000<10000?`00
02H000<10000IP000`40001e00030@0003l0000V00030@0006H000<10000M@000`40
000o00009P000`40001V00030@0007D000<10000?`0002H000<10000IP000`40001e
00030@0003l0000V00030@0006H000<10000M@000`40000o00009P000`40001V0003
0@0007D000<10000?`0002H000<10000IP000`40001e00030@0003l0000V00030@00
06H000<10000M@000`40000o00009P000`40001V00030@0007D000<10000?`0002H0
00<10000IP000`40001e00030@0003l0000V00030@0006H000<10000M@000`40000o
00009P000`40001V00030@0000l00`5S00030@0003l0000V00030@0006H000<10000
3P001@400001068000<10000?`0002H000<10000IP000`40000>00050@000040HP00
0`40000o00009P000`40001V00030@0000<000<100400P4200<10P030@<010450081
00@00@000P4010010@5;00030@0003l0000V00030@0006H000<100000`020@800P42
00050@00004010020@800P4300040@000@8000@100010`000`40001800030@0003l0
000V00030@0006H000<100000`000`40000200040@000@800`4300030@00008000D1
00000@0200040@000@H000<10000B0000`40000o00009P000`40001V00030@0000L0
0P4200040@000@8000<100401P001040004200040@000@H000<10000B0000`40000o
00009P000`40001V00030@0000D00`4300040@000@8000<100401P00104000420004
0@000@<00`5;00030@0003l0000V00030@0006H000<1000010020@@00P4300D11P00
1@400@40008100<00@400P4300030@0004T000<10000?`0002H000<10000IP000`40
000300030@00008000<100002@000`40000200030@0000L000<1000010000`400018
00030@0003l0000V00030@0006H000<100000`00104000020@/00P42008130001@40
000104X000<10000?`0002H000<10000IP000`40000400<100D00@000@0900@13P03
0D/000<10000?`0002H000<10000IP000`40001e00030@0003l0000V00030@0006H0
00<10000M@000`40000o00009P000`40001V00030@0007D000<10000?`0002H000<1
0000IP000`40001e00030@0003l0000V00030@0006H000<10000M@000`40000o0000
9P000`40001L01D1K@000`40000o00009P000`40001J00815@020F/000<10000?`00
02H000<10000F@000`40000G00030@0006P000<10000?`0002H000<10000F0000`40
000I00030@0006L000<10000?`0002H000<10000F0000`40000I00030@0006L000<1
0000?`0002H000<10000E`000`40000K00030@0006H000<10000?`0002H000<10000
E`000`40000K00030@0006H000<10000?`0002H000<10000E`000`40000800810P03
0@`000<10000IP000`40000V00815`0002H000<10000E`000`40000700030@000081
0`000`40000900030@0006H000<100009P060A<000050281F@000`40000700030@00
00D000<100002@000`40001V0381400001@00`4?00030@0005L000<100001`000`40
000500030@0000T000<10000IP000`40000V00H14`0001<000D100000@0>00030@00
05L000<100001`001@40004000<130000`40001V00030@0002H00P4G00004`001@40
000100h000<10000E`000`400008008110000`40000:00030@0006H000<10000?`00
00P000<100400P4200<10P030@0500410@000`400`010@0400030@0005L000<10000
3`000`40000900030@0006H000<1000030030C00000800810P020@8000D100000@04
00050@0000400P000`40000300030@0005L000<100002`001@40000100/000<10000
IP000`40000;00050@000040;`0000P000<100000P001040004200<10`001@400001
008000<100000`000`40001G00030@0000`00`4<00030@0006H000<100002`001@40
000102l0000<00810P001040004200040@000@<000@100011@000`40001G00030@00
01/000<10000IP001@40004000<10P030@800`4300@11@020@0400400081700000X0
0`4300040@000@8000@100010`001040004500030@0005P000<100006@000`40001W
00030@0000810P020@8000D100000@0400810P020@<000@100010P000`40000L0000
2@020@@00P4300@100H00@000@020@H000<10000F0000`40000I00030@0006L000@1
000110001040004200<10`000`40000200050@0000400P001040004N000020000`40
000200030@0000T000<100002P000`40001I00030@0001L000<10000J0000`400004
00810P001040004200030@0100H000@100010P001040004N00002000104000020@/0
00<100002P000`40001J00815@020F/000<100000P030@<000@100010P000`400@06
00040@000@8000@100017P0000T00`401@01000100L00`4;00030@0005`05@5]0004
0@00008110020@<01@4600050@010@000P400`010@020A`0000V00030@000=h000@1
000110000`40000900030@00008000<100001`000`40000L00009P000`40001V0003
0@0007D000@100010`020@/00P420081:00002H000<10000IP000`40001e00040@00
00<100D00@000@0900@1:@0002H000<10000IP000`40001e00030@0003l0000V0003
0@0006D00`5f00030@0003l0000V00030@0006D00`5f00030@0003l0000V00030@00
06D00`4@00<1H`000`40000o00009P000`40001U00<13`001@400001068000<10000
?`0002H000<10000I0050@h000D100000@1R00030@0003l0000V00030@0006@01@43
00030@0100810P030@800`401@010@4000<100@00@400`5D00030@0003l0000V0003
0@0006H000<100000`020@800P4200050@00004010001@400001008000<100400`00
0`40001A00030@0003l0000V00030@0006H000<100000`000`40000200040@000@80
0`4300050@0000400P000`40000300030@00054000<10000?`0002H000<10000IP00
0`40000700810P001040004200040@000@<000@100011@000`40001A00030@0003l0
000V00030@0006H000<100001@030@<000@100010P001040004300040@000@800`5D
00030@0003l0000V00030@0006H000<1000010020@@00P4300@100H00@000@020@D0
00<10000DP000`40000o00009P000`40001V00030@0000<000<100000P000`400009
00030@0000X000<10000D@000`40000o00009P000`40001V00030@0000<000@10000
0P4;00030@0000H000D100000@1C00030@0003l0000V00030@0006H000<100001003
0@05004000401`030@P00`5D00030@0003l0000V00030@0006H000<10000M@000`40
000o00009P000`40001V00030@0007D000<10000?`0002H000<10000IP000`40001e
00030@0003l0000V00030@0006H000<10000M@000`40000o00009P000`40001V0003
0@0007D000<10000?`0002H000<10000IP000`40001e00030@0003l0000V00030@00
05<00P4300<12`000`40001e00030@0003l0000V00030@0006H000<10000M@000`40
000o00009P000`40001A00H10P020@/000<10000M@000`40000o00009P000`40001V
00030@0007D000<10000?`0002H000<10000IP000`40001e00030@0003l0000V0003
0@0006H000<10000M@000`40000o00009P000`40001V00030@0007D000<10000?`00
02H000<10000IP000`40001e00030@0003l0000V00030@0001d05@4d00030@000380
5@4^00030@0003l0000V00030@0001/00P4E0081<P000`40000`00815@020B`000<1
0000?`0002H000<100006P000`40000G00030@0002l000<10000;`000`40000G0003
0@0002T000<10000?`0002H000<100006@000`40000I00030@0002h000<10000;P00
0`40000I00030@0002P000<10000?`0002H000<100006@000`40000I00030@0002h0
00<10000;P000`40000I00030@0002P000<10000?`0002H000<1000060000`40000K
00030@0002d000<10000;@000`40000K00030@0002L000<10000?`0002H000<10000
60000`40000K00030@0002d000<10000;@000`40000K00030@0002L000<10000?`00
02H000<1000060000`40000800810P030@`000<10000;@000`40000]00030@0000P0
0P4400030@0000X000<100009`000`40000o00009P000`40000H00030@0000L000@1
00010P000`40000;00030@0002d000<10000;@000`40000700040@000@<000<10000
2P000`40000W00030@0003l0000V00030@0001P000<100001`000`40000300030@00
00/000<10000;@000`40000]00030@0000L000@100001@4;00030@0002L000<10000
?`0002H000<100003P020@P000<100001`000`40000300030@0000/000<100008`02
0@P000<100008`020@P000<100001`001@400001008000<100002P000`40000W0003
0@0003l0000V00030@0000h01P4400030@0000L000@100010P000`40000;00030@00
02<01P4400030@0002<01P4400030@0000L000P1000100400@`000<100009`000`40
000o00009P0J0@03004000T00P4300030@0000/0;`400`010@0]0@03004000T00P42
00030@0100`0:`510000=`060@@000<100002`000`400@0=00030@0002<01P4Z00H1
10000`40000=008130000`40001Y0000=`020@P000<1000030020@d000<100008`02
0Bh00P4800030@0000d00P4<00030@0006T0001100030@0000d000<100002`000`40
001M00030@0000h000<100002P000`40001Y0000:@030AD000<100006`000`40000<
00<1<0030A/000<100006`000`40000<00<1FP0002P000D100000@0E00030@0001T0
00<1000030001@40000102h000D100000@0K00030@0001T000<1000030001@400001
05T0000X00050@0000405@000`40000I00030@0000`000D100000@0^00050@000040
6`000`40000I00030@0000`000D100000@1I00007@000`400@020@800`4200<100D0
0@4100030@04004100<120000`40000G00030@00008000<100400P4200<10P030@<0
1045008100@00@000P4010010@4<00030@0100810P030@800`401@010@4000<100<0
0@400`000`40000<00030@0001L000<100000P000`400@020@800`4200<10`040@D0
0P40100100020@<000<10000@00001d00P4200810P001@40000100@000D100000@02
00050@0000402P020AD00P4500810P020@8000D100000@0400810P020@<000@10001
0P000`40000200030@0000/00P4200810P001@40000100@000D100000@0200030@00
008000<100003@020AD00P4500810P020@8000D100000@0400810P020@<000@10001
0P000`40000300030@000400000M00030@00008000@100010P030@<000D100000@02
00050@000040300E0@L000<100000P001040004200<10`000`40000200050@000040
0P001040004400030@0000/000<100000P001040004200<10`001@400001008000<1
0040104@01D11`000`40000200040@000@800`4300030@00008000D100000@020004
0@000@801@5100008@020@8000@100010P001040004300040@000@<000<10000:P02
0@8000@100010P000`400@0600040@000@8000@1000110000`40000?00810P001040
004200040@000@<000H10001004200030@0002l00P4200040@000@8000<100401P00
1040004200040@000@8000@10001@P0001l00`4300040@000@8000@100010`001040
004300030@0002P00`4300040@000@8000<100401P001040004200040@000@@000<1
00003@030@<000@100010P001040004300040@000@8000<10040;`030@<000@10001
0P000`400@0600040@000@8000@100010`000`400@1200007P020@@00P4300@100H0
0@000@020@@000<100009`020@@00P4300D11P001@400@40008100<00@400P420003
0@0000`00P4400810`040@06004000400P4300030@0102h00P4400810`050@H000D1
004100020@030041008100@00@01@P0001d000<100000P000`40000900030@0000H0
00<10040:0000`40000200030@0000T000<100000P000`40000700060@000@013@00
0`40000200030@0000T000<1000020020Bd000<100000P000`40000900030@000080
00<100001`000`4000020081@P0001d000@100000P4;00030@0000L00P4X00040@00
00812`020@800P4=00813@00104000020@/000<1000020020Bd000@100000P4;0081
0P020@h00P5200007P030@05004000401`030@T000<100009`030@05004000402@04
0@l000<1000030030@05004000401`030@X000<10000;0030@05004000402@040A00
00<10000@0000?l0BP000?l0BP000001\
\>"], "Graphics",
  ImageSize->{329, 161},
  ImageMargins->{{0, Inherited}, {Inherited, 0}}],

Cell[TextData[{
  "is characterized by the the following conjunction of predicates\n\n",
  StyleBox[
  "junction[{SigIn},{SigIn1,SigIn2}]\[TildeTilde]True,\nc1[S,SigIn1,SigOut1]\
\[TildeTilde]True,\nc2[S,SigIn2,SigOut2]\[TildeTilde]True,\n\
junction[{SigOut1},{SigIn3,SigIn4}]\[TildeTilde]True,\nc3[S,SigIn3,SigOut3]\
\[TildeTilde]True,\njunction[{SigOut2,SigOut3},{SigIn5}]\[TildeTilde]True,\n\
c4[S,SigIn4,SigOut4]\[TildeTilde]True,\n\
c5[S,SigIn5,SigOut5]\[TildeTilde]True,\njunction[{SigOut4,SigOut5},{SigOut}]\
\[TildeTilde]True.",
    FontWeight->"Bold"],
  "\n\nWe define predicate Config1[S,{c1,c2,c3,c4,c5},SignIn,SignOut] for \
such an electric component"
}], "Text"],

Cell[BoxData[
    \(\(DefinedFunctionSymbol[
      Config1 \[Proportion] 
          Real\[Cross]TyList[
              Real\[Cross]sig\[Cross]sig \[ShortRightArrow] Bool]\[Cross]sig
            \[Cross]sig \[ShortRightArrow] Bool]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Def[\n
      \t{S, c1, c2, c3, c4, c5, SigIn, SigOut, \n\t\tSigIn1, SigIn2, SigIn3, 
        SigIn4, SigIn5, \n\t\tSigOut1, SigOut2, SigOut3, SigOut4, SigOut5}, \n
      \t{Config1[S, 
            \[LeftAngleBracket]c1, c2, c3, c4, c5, 
              \[Bullet]\[RightAngleBracket], SigIn, SigOut] \[RightArrow] True
          \n\t\t \[DoubleLeftArrow] 
          And[junction[{SigIn}, {SigIn1, SigIn2}] \[TildeTilde] True, \n
            \t\t\t\tc1[S, SigIn1, SigOut1] \[TildeTilde] True, \n\t\t\t\t
            c2[S, SigIn2, SigOut2] \[TildeTilde] True, 
            junction[{SigOut1}, {SigIn3, SigIn4}] \[TildeTilde] True, 
            c3[S, SigIn3, SigOut3] \[TildeTilde] True, \n\t\t\t\t
            junction[{SigOut2, SigOut3}, {SigIn5}] \[TildeTilde] True, \n
            \t\t\t\tc4[S, SigIn4, SigOut4] \[TildeTilde] True, \n\t\t\t\t
            c5[S, SigIn5, SigOut5] \[TildeTilde] True, \n\t\t\t\t
            junction[{SigOut4, SigOut5}, {SigOut}] \[TildeTilde] True]}]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(Config1[S, 
            \[LeftAngleBracket]c1, 
              \[LeftAngleBracket]c2, 
                \[LeftAngleBracket]c3, 
                  \[LeftAngleBracket]c4, 
                    \[LeftAngleBracket]c5, 
                      \[Bullet]\[RightAngleBracket]\[RightAngleBracket]\
\[RightAngleBracket]\[RightAngleBracket]\[RightAngleBracket], SigIn, SigOut] 
          \[RightArrow] True \[DoubleLeftArrow] 
          \(junction[\[LeftAngleBracket]SigIn, \[Bullet]\[RightAngleBracket], 
                \[LeftAngleBracket]SigIn1, 
                  \[LeftAngleBracket]SigIn2, 
                    \[Bullet]\[RightAngleBracket]\[RightAngleBracket]] 
              \[TildeTilde] True && 
            c1[S, SigIn1, SigOut1] \[TildeTilde] True && 
            c2[S, SigIn2, SigOut2] \[TildeTilde] True && 
            junction[
                \[LeftAngleBracket]SigOut1, \[Bullet]\[RightAngleBracket], 
                \[LeftAngleBracket]SigIn3, 
                  \[LeftAngleBracket]SigIn4, 
                    \[Bullet]\[RightAngleBracket]\[RightAngleBracket]] 
              \[TildeTilde] True && 
            c3[S, SigIn3, SigOut3] \[TildeTilde] True && 
            junction[
                \[LeftAngleBracket]SigOut2, 
                  \[LeftAngleBracket]SigOut3, 
                    \[Bullet]\[RightAngleBracket]\[RightAngleBracket], 
                \[LeftAngleBracket]SigIn5, \[Bullet]\[RightAngleBracket]] 
              \[TildeTilde] True && 
            c4[S, SigIn4, SigOut4] \[TildeTilde] True && 
            c5[S, SigIn5, SigOut5] \[TildeTilde] True && 
            junction[
                \[LeftAngleBracket]SigOut4, 
                  \[LeftAngleBracket]SigOut5, 
                    \[Bullet]\[RightAngleBracket]\[RightAngleBracket], 
                \[LeftAngleBracket]SigOut, \[Bullet]\[RightAngleBracket]] 
              \[TildeTilde] True\)\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          Config1[ S, 
            Cons[ c1, 
              Cons[ c2, 
                Cons[ c3, 
                  Cons[ c4, 
                    Cons[ c5, \[Bullet]]]]]], SigIn, SigOut], True, 
          And[ 
            eq[ 
              junction[ 
                Cons[ SigIn, \[Bullet]], 
                Cons[ SigIn1, 
                  Cons[ SigIn2, \[Bullet]]]], True], 
            eq[ 
              c1[ S, SigIn1, SigOut1], True], 
            eq[ 
              c2[ S, SigIn2, SigOut2], True], 
            eq[ 
              junction[ 
                Cons[ SigOut1, \[Bullet]], 
                Cons[ SigIn3, 
                  Cons[ SigIn4, \[Bullet]]]], True], 
            eq[ 
              c3[ S, SigIn3, SigOut3], True], 
            eq[ 
              junction[ 
                Cons[ SigOut2, 
                  Cons[ SigOut3, \[Bullet]]], 
                Cons[ SigIn5, \[Bullet]]], True], 
            eq[ 
              c4[ S, SigIn4, SigOut4], True], 
            eq[ 
              c5[ S, SigIn5, SigOut5], True], 
            eq[ 
              junction[ 
                Cons[ SigOut4, 
                  Cons[ SigOut5, \[Bullet]]], 
                Cons[ SigOut, \[Bullet]]], True]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(c1, c2, c3, c4, c5, S, SigIn, SigIn1, SigIn2, 
          SigIn3, SigIn4, SigIn5, SigOut, SigOut1, SigOut2, SigOut3, SigOut4, 
          SigOut5\),
          Infix[
           {c1, c2, c3, c4, c5, S, SigIn, SigIn1, SigIn2, SigIn3, SigIn4, 
            SigIn5, SigOut, SigOut1, SigOut2, SigOut3, SigOut4, SigOut5}, 
            ","],
          Editable->False], "\[InvisibleSpace]", \(" declared as  variable"\),
         "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[
         {c1, c2, c3, c4, c5, S, SigIn, SigIn1, SigIn2, SigIn3, SigIn4, 
          SigIn5, SigOut, SigOut1, SigOut2, SigOut3, SigOut4, SigOut5}, ","], 
        " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \("Symbol"\), "\[InvisibleSpace]", \("s"\), "\[InvisibleSpace]", 
        \(" "\), "\[InvisibleSpace]", 
        InterpretationBox[\(SigIn1, SigIn2, SigIn3, SigIn4, SigIn5, SigOut1, 
          SigOut2, SigOut3, SigOut4, SigOut5\),
          Infix[
           {SigIn1, SigIn2, SigIn3, SigIn4, SigIn5, SigOut1, SigOut2, SigOut3,
             SigOut4, SigOut5}, ","],
          Editable->False], "\[InvisibleSpace]", 
        \(" declared as extra variable"\), "\[InvisibleSpace]", \("s"\), 
        "\[InvisibleSpace]", \("."\)}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[
         {SigIn1, SigIn2, SigIn3, SigIn4, SigIn5, SigOut1, SigOut2, SigOut3, 
          SigOut4, SigOut5}, ","], " declared as extra variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \("\[DownTee]"\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Querries for mixed connections", "Subsection"],

Cell[CellGroupData[{

Cell["\<\
Dependency of output signal on input signal for Config1 instance \
witht resistors\
\>", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[{
        Config1[S, {RInst[R1], RInst[R2], RInst[R3], RInst[R4], RInst[R5]}, 
            s[V1, I1], s[V2, I2]] \[TildeTilde] True}, {I2, V2}, 
      Constructor -> {R1, R2, R3, R4, R5, S, I1, V1}]\)], "Input"],

Cell[BoxData[
    \({{I2 \[Rule] I1, 
        V2 \[Rule] 
          \(-\(\(\(-\((R2\ R3 + \((R1 + R2 + R3)\)\ R5)\)\)\ 
                    \((I1\ R2\ R4 - R2\ \((\(-I1\)\ R1 - V1)\) + R1\ V1)\) + 
                  \((\(-R2\)\ R4 + R1\ R5)\)\ 
                    \((\(-\((\(-R1\) - R3)\)\)\ V1 + R2\ \((I1\ R1 + V1)\))
                      \)\)\/\(R1\ R2\ R3 + R2\^2\ R3 + R1\ R2\ R4 + 
                  R2\^2\ R4 + R2\ R3\ R4 + R1\ R2\ R5 + R2\^2\ R5 + 
                  R2\ R3\ R5\)\)\)}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
determine the characteristic value R1 for the following instance of \
a Config1 configuration:\
\>", "Subsubsection"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000590000V`P10`4000010?ooo`00
0?ool;jn_W20T5mOGenNX2m?D8GNh?l00?GN/lC4a000<`00IP00V@00c000o`0c000c
<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2IIP2IV@2Ic02Io`3<
003<<`3<IP3<V@3<c03<o`3o003o<`3oIP3oV@3oc03ooc<003<0<c<0IS<0VC<0c3<0
oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=Vc3=Voc>I03>I<c>IIS>IVC>I
c3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o<c?oIS?oVC?oc3?oofH006H0<fH0IVH0
VFH0c6H0ofHc06Hc<fHcIVHcVFHcc6HcofIV06IV<fIVIVIVVFIVc6IVofJI06JI<fJI
IVJIVFJIc6JIofK<06K<<fK<IVK<VFK<c6K<ofKo06Ko<fKoIVKoVFKoc6KooiT009T0
<iT0IYT0VIT0c9T0oiTc09Tc<iTcIYTcVITcc9TcoiUV09UV<iUVIYUVVIUVc9UVoiVI
09VI<iVIIYVIVIVIc9VIoiW<09W<<iW<IYW<VIW<c9W<oiWo09Wo<iWoIYWoVIWoc9Wo
ol`00<`0<l`0I/`0VL`0c<`0ol`c0<`c<l`cI/`cVL`cc<`colaV0<aV<laVI/aVVLaV
c<aVolbI0<bI<lbII/bIVLbIc<bIolc<0<c<<lc<I/c<VLc<c<c<olco0<co<lcoI/co
VLcoc<coool0<ol0I_l0VOl0c?l0oolc0?lc<olcI_lcVOlcc?lcoomV0?mV<omVI_mV
VOmVc?mVoonI0?nI<onII_nIVOnIc?nIooo<0?o<<oo<I_o<VOo<c?o<oooo0?oo<ooo
I_ooVOooc>[ZjWAdM:NWYj0Pl=WIfJj^[WMgMnc/k:>SXk0`H<?3`m0PT3bcLLk>c[Zj
^[6a/JRXZ:2PX=Rof8:2PXj>SWEeMDNjhIW:<J5A:1j>6P2@002`003@002@T02`/?l0
BP000?l0BP000?l0BP000?l0BP000?l0BP000?l0BP000?l0BP000?l0BP000?l0BP00
0?l0BP000?l0BP00048000Bg0000>@4f03T1F`0004@00P4i0081<P020CT00P5I0000
@`000`4000060003]`00038000@1]`2g;@000`40000I0003]`0001l000<10000EP00
048000<10000?@000`40000/00030@0002T000>g00004@000`40001E0000@P000`40
000I0006]`000;L00`430003]`0000L000>g00400P4900030@2g02`000<100000P00
0kL0000=0005]`000;L02`030@D000>g0;L00`001;L000030@H000<10000E@000440
00<1000080000`40000A00030@0000P000<10000:P000`40000H0003]`0000P000<f
00004@000`40000500030@0005@0001100030@0001H000>g00001`000`40000A0003
0@2g00P000<1]`00:P000`40000?0003]`0000T000>g00001@000`40000A00030@00
00D000<10000E000044000<100000`030@<01@401@010@40008100@00@4110020@03
004000800`430003=P4100@10`000`40000800030@0002X000<100001P030@<01@40
1@010@40008100@00@4110020@03004000800`43008100@00@4110000`4000050003
0@0005@0001100030@0000@000<100000P001040004300040@000@8000@100010P00
1`4000010;L00P000`6g000200030@0100<000D100000@0:00030@0002X000<10000
1`000`40000200040@000@<000@100010P001040004200050@00004010000`400002
00030@0100800P4300030@0000D000<10000E000044000<1000010001@40000100<0
00Df00000@0200030@0000800P4200050@00004010001@40000100<000<100001000
0`40000800030@0002X000<100001`001@40000100<000Df00000@0200030@000080
0P4200050@00004010001@40000100H000D100000@0700030@0005@0000^0005]`00
0;L010020@P000<1000010001040004400050@0000400P000`4000020@@000D10000
0@0400040@000@D000<10;L00`000`40000800030@0000H000>g00008@000`400007
00040@000@@000D100000@0200030@00008110001@40]`0100@000@100011`001@40
000100L000<10000E00003L01P4400030@0000@01@4300050@0000400P0010400042
00040@000@<000<100000P050@D000<100000P000`40000800030@0002X000<10000
1`050@<000D100000@0200040@000@8000@100010`000cH0000200D11@020@<000<1
00001@000`40001D0000;P000kL10@0?0@03004000D000@100000P4200050@000@00
0P4400<100<00@400P400`01000300040@0000811@001@40]`0100T000>g0@40;049
00040@0000810P001@400040008110030@030041008100<00@000`00106g00020@80
0`420003]`0100L05P510000;`000`40000500H110000`40000400030@00008000@1
00013`001@40000100@000<100000P000`40000300050@0000402P000`4000090003
]`0001h000<100001`000`40000200040@000@l000D100000@0400030@00008000@1
00011P000`40000500030@00018000<10000?`0002l000H1002g0;L2008120000`40
000400040@0000810P001@40002g00/000Fg00000@0400040@00008100<00@000P00
1@40000100L000Bg00012P000kL1000O00030@0000L000@100000P4200050@000;L0
1`000kL0000500030@00008000@1]`000P4200040@00]`<000<100001@000`40000?
0004]`000D40000_00030@0000l000<100000`060@800`4B00<100<00@40104300<1
0P030@X000<100002@000`40000N00030@0000H01P4200<14P030@03004100@11003
0@0400410@L000<100004P000`40000o0000;`000`40000?00030@0003l000<10000
2@000`40000N00030@0003l000<100004P000`40000o0000;`000`40000@0003=P00
03d000<f00002@030B0000<10000?@000`40000C00030@0003l0000_00030@000100
00<10000>@001KL0000100/00`400`2g000M00030@0003d000<100000P000kL0000>
00030@0003l0000_00030@00014000<10000>`000`40000:00<18@000`40000k0003
0@0001@000<10000?`0002l000<100004P020C@000>g00000P020@<000>g00001`03
0B800P4i008110000kL0000@00030@0003l0000_00030@0001@0=0400cH10@020@h0
00<1=P400P4S03T16@000`40000o0000;`000`4000180003]`0001001@5L0003]`2g
01H000<10000?`0002l000<10000G@000`40001e00030@0003l0000_00030@0005d0
00<10000M@000`40000o0000;`000`40001M00030@0007D000<10000?`0002l000<1
0000G@000`40001e00030@0003l0000_00030@0005d000<10000M@000`40000o0000
;`000`40001M00030@0007D000<10000?`0002l000<10000G@000`40001e00030@00
03l0000_00030@0005d000<10000M@000`40000o0000;`000`40001M00030@0007D0
00<10000?`0002l000<10000G@000`40001e00030@0003l0000_00030@0005d000<1
0000M@000`40000o0000;`000`40001M00030@0007D000<10000?`0002l000<10000
G@000`40001e00030@0003l0000_00030@0005d000<10000M@000`40000o0000;`00
0`40001M00030@0007D000<10000?`0002l000<10000G@000`40001e00030@0003l0
000_00030@0005d000<10000M@000`40000o0000;`000`40001M00030@0007D000<1
0000?`0002l000<10000G@000`40001e00030@0003l0000_00030@0005d000<10000
M@000`40000o0000;`000`40001M00030@0007D000<10000?`0002l000<10000G@00
0`40001e00030@0003l0000_00030@0005d000<10000M@000`40000o0000;`000`40
001M00030@0007D000<10000?`0002l000<10000G@000`40001e00030@0003l0000_
00030@0005d000<10000M@000`40000o0000;`000`40001M00030@0007D000<10000
?`0002l000<10000G@000`40001e00030@0003l0000_00030@0005d000<10000M@00
0`40000o0000;`000`40001M00030@0007D000<10000?`0002l000<10000G@000`40
001e00030@0003l0000_00030@0005d000<10000M@000`40000o0000;`000`40001M
00030@0007D000<10000?`0002l000<10000G@000`40000T0003]`0004h000<10000
?`0002l000<10000G@000`40001e00030@0003l0000_00030@00048000>g00005@00
1;L0004R0003]`00058000<10000?`0002l000<10000G@000`40001e00030@0003l0
000_00030@0004@0>@5H00030@0003l0000_00030@0004800P4i0081EP000`40000o
0000;`000`40001100040@00]cL000Bg00010P000kL0001@00030@0003l0000_0003
0@00040000<10000?@000`40001B00030@0003l000020003]`0002L000Bg0001@P00
0`4000050003]`00014000>g00001@000kL0000I00030@00058000<10000?`0002l0
00<10000?`000`40000o00030@00054000<10000?`0000h000>g00006@000kL00002
00030@0003h000>g0@005P000kL0000B0003]`00018000<10000D@000`40000/0003
]`000100000_00030@0003l000<100008`030@l00`4700030@00054000<100009P02
0AL000000kL0]`070003]`2g028000<10000?`000`4000060003]`0000/000>g0000
0`000kL0000600030@0000H000>g000020000`40000500030@00054000<100009P06
0A<000000`2g000200L100<f0@408@5100030@0002<000<100004@000`4000050003
0@000540<P420003]`0000/000000kL0000600<100>g00000`000kL0000C0005]`41
0KL00P000`40000o00030@00008000Bg00000`400`2g00050@0500410@000P401;L1
0@44008100D00@00]`030@<00P4010010@4400030@00008000Bg0001D`000`40000V
00H14`0000T000<100002`000`40000A00050@000040@@000`40000700030@000080
00@100010`00104003H200040@000@8000D100000@0400030@00008000<100400`00
1@40000100L000<10000D@000`40000V00815`0000T000<1000030000`4000030003
]`0000D000>g00000P001@400001044000<100000P000kL0000200050@0000400`00
1@400001008000<100000P020@8000D100000@0400050@0000401P001@40000100L0
00@1002gD0000`40000<0003]`000300000300<10`00104000030@800`4300030@00
00<000<f00000`030@@000D100000@1100030@0000L000@1000110001@4000010080
00<100000P4400050@00004010001040004700050@0000401`000`40001A00030@00
00X00`4M0003=P410180000300040@000@8000H1002g004400030@0000P000D10000
]`0200030@0000<000D100000@1100040@00]`H01@4300050@00]`400P001040]`42
00040@000@<000<100000P050@<00`4400030@0000D000<10000D@000`4000040007
]`2g0;L00@030003]`0000<000Fg00000@0;0003]`0000D000<10000400000D00P42
00030@00008000<100000P000`40000700<11@000`40000300050@000040@@000`40
000700040@0000810P001@400040008110030@030041008100<00@000`0010400002
0@@000<100000P000`40000500030@00054000<100002P000`40000<00030@000100
00<f0000400000<00P4400030@00008000H10000]`4900030@0100D000<100000`00
1@400001044000<100001`000`40000200040@000@H000>g00001P001@4000010080
00>g004010000`40000300050@0000401`000`40001A00030@0000@00`4300040@00
00<100<00@400`4200030@0000<000<100000`030@@000<10000400000<000@1000f
0P000`40000200030@00008000<100001`000`400@0500030@0000<000D100000@12
00030@0000H000H100000CH200030@00014000<100000P00106g00020@0300400080
00D100000@0600030@00058000<1000010001040004200030@00008000@100010`00
10400;L500030@0000@000<100000`000`40000@000010030@8000<100000P000`40
000200030@0000H000D100000@0400030@0000<000D100000@1200030@0000D01P42
00<13`000kL0]`030@03]`4100@10`030@800`4600030@2g058000<100001P020@80
00<100000P001@40000100X00`4500030@0000<000<10000400000T000<100000P00
1P4000400@P000D100000@0200030@0100D000D100000@1300030@0003/000<10000
D`000`400004008110000`40000200030@00008000<100001`000`400@0500030@00
00<000<10000400000T000<100000P00104000020@L000<100000P001;L100020@D0
00D100000@120004]`010C@000>g0;L00P020EH000@1002g0`001040004200030@00
008000<100000`000`40000600030@0100D000L10000]`010180000900<100@00@41
0`000`4000030004]`410@<00`4200040@0000<10`000`40001401P100<f0@406@40
0cH10@020EP000<100001@030@8000<1]`000P000`40000400030@0000@000D10000
0@0400030@0000<000<f0000400001H000>g00000`000kL0000@00030@00048000>g
0000T0000`40000:00030@00008000<1000010000`40000400050@0000400P000`40
0@0500030@000100000_00030@0005d000<10000M@000`40000:00030@00008000@1
00010`000`40000300030@0000<000<100000P450003=P000100000D0003]`0001D0
00Bg0001AP000kL0000E0003]`4007H000@1002g2@030@0400410@800`4500<10`03
0@8000@100000`4B0000;`000`40001M00030@0007D000<10000?`0000P000>g0;L0
6@000kL0000800030@0005`00`450003]`0006h000@1002g3`000kL0000E0003]`00
01@0000_00030@0005`00`5f00030@0003l0000_00030@0005`00`5f00030@0003l0
000_00030@0005`00`5f00030@0003l0000_00030@0005H000>g00000P050@8000>g
0000L0000`40000o0000;`000`40001K00D1M@000`40000o0000;`000`40001J0004
]`000@8000>g0000LP000`40000o0000;`000`40001M00030@0007D000<10000?`00
02l000<10000G@000`40001e00030@0003l0000_00030@0005d000<10000M@000`40
000o0000;`000`40001M00030@0007D000<10000?`0002l000<10000G@000`40001e
00030@0003l0000_00030@0005d000<10000M@000`40000o0000;`000`40001M0003
0@0007D000<10000?`0002l000<10000G@000`40001e00030@0003l0000_00030@00
05d000<10000M@000`40000o0000;`000`40001M00030@0007D000<10000?`0002l0
00<10000G@000`40001e00030@0003l0000_00030@0005d000<10000M@000`40000o
0000;`000`40001M00030@0007D000<10000?`0002l000<10000G@000`40001e0003
0@0003l0000_00030@0005d000<10000M@000`40000o0000;`000`40001M00030@00
07D000<10000?`0002l000<10000G@000`40001e00030@0003l0000_00030@0005d0
00<10000M@000`40000o0000;`000`40001M00030@0007D000<10000?`0002l000<1
0000B0000kL0000B00030@0005`000>g00005P000`40000o0000;`000`40001M0003
0@0007D000<10000?`0002l000<1000050000kL0000g0003]`0000`000<100007P00
0kL0000i0007]`000;L0]`0D00030@0003l0000_00030@0005d000<10000M@000`40
000o0000;`000`40001M00030@0002@000>g0000>`000kL0000@00030@0003l0000_
00030@0001@0=0400cH10@020A0000<100008`0i0AT000<10000?`0002l000<10000
4P020C@000>g00000P020@h000<100007P000kL000020CT00P400kL0000D00030@00
03l0000_00030@00014000<10000>`000`40000;00030@00020000<10000>`000cH0
000D00030@0003l0000_00030@00008000>g00002`000`40000=0003]`0000T000>g
00005@000kL0000900050@000;L020000`40000O00030@0000H000Fg0000]`0;0003
]`0002@000<100004`000`40000o0000;`000`40000@00030@0002800`4?00<11P00
0`40000:00030@0001l000<100008P030@l00`4600030@0001<000<10000?`0002l0
00<100002P000kL0000200030@0001P000>g00000`000kL0000200030@0000@000>g
00002P000`40000500040@00]`P000<100007P000`40000;0003]`0000<000>g0000
0`000kL0000900030@0000d000Fg00000@0700030@00018000<10000?`0002l000<1
00003`000`40000S00030@00014000<100001@000`40000900030@0001h000<10000
5P000kL0000:00030@00014000<100001@000`40000B00030@0003l0000_00030@00
00@000>g0@400`000kL0000200030KL000H00`4300D100D00@4100020@0400410@80
00Jg0041004300<10`020@0400410@@000<100001@000`6g000900030@0001h000<1
00001P030@8000>g0@400`401@010@40008100@00@4110020@050040]`000`430081
00Bg0;L110000`40000500030@00018000<10000?`0002l000<100001@060@@000<1
00001`000`40000200040@000@<000@100010P001040004200050@00004010000`40
000200050@0000401@000`40000500030@0000T000<100007P000`40000700030@00
008000@100010`0013H0004200040@000@8000D100000@0400030@00008000<10000
0P000`40000200030@0000D000<100004P000`40000o0000;P000kL10@0?0@030040
00P000D100000@0300050KL0]`400P000`40000200810P001P6g0001]`<000D10000
0@0400030@0000<000<100001@0^0@T000D100000@0300050@2g00400P000`400002
00810P001@40000100@000L1]`000KL000D10`000`40000501H1@@0003L01P440003
0@0000L000@1000110001@400001008000<100000P4400050@000040100010400045
00030@0000<000<100001@000`40000Z00030@0000L000@f000110001@4000010080
00<100000P4400050@0003H010001040004300040@000@@000<100001@000`40001D
0000<P001KL0002g008120000`40000700D10`001@400001008000@100010P001040
00420003]`4000<01@4400030@0000<000<100001@000`40000Z00050@000;L01@05
0@<000D100000@0200040KL00@8000P100010;L00@@01@420004]`400@@000<10;L0
1@000`40001D0000@@000`40000700040@0000810P001@400040008110030@030041
008100<00@000`00104000020@<000<100000`000`40000500030@0002X000<10000
1`00104000020@8000D1000100020@@00`401`010@4f00401000104000020@8000<1
004010000`40000500030@0005@000100003]`4000P000<100000P001040]`4?0005
0@00004010000`40000200050@01]`401@000`40000500030@0002X000<100001`00
0`40000200040@000@<000>g00002@001@40000100@000<100000P00104000020@05
]`0000401`000`40001D0000@@000`40000700040@0000810P000`40000A00030@00
008000@f00000P4200811@000`40000500030@0002X000<100001`001P40000f0@80
00<f00004@000`40000200040@0000810`000cH1000300030@0000D000<f0000E000
040000>g0@001`060@800`4B00<100<00@40104400040@0000<11P000kL1000[0003
0@0000H01P4200<14P030@03004100@110001kLf0001=P401`000`40001D0000@@00
0`40000e0003]`0000L000<10000:P000`40000o00030@0005@0001200030@0000T0
00>g00002`000kL000030003]`0000T000>g00004@000`40000/00030@0000`000>g
00001@000kL0000E0003]`0000h000<10000E@00048000<10000?0000kLf000]0003
0@0003d000<10000E@0004<000<10000>`000`40000^00030@0003/000<10000EP00
04@00P4i0081<P000`4f000h0081F@0004H0>@450003]`0002h0>@5K0000o`1:0000
O0000kL000030003]`000<@0003o04X0002d0003]`2g0980003o04X00000\
\>"], "Graphics",
  ImageSize->{329, 155},
  ImageMargins->{{89, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["when the input/output signals s[I1,V1]/s[I2,V1] are known", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[
      Config1[S, {RInst[R1], RInst[R2], RInst[R3], RInst[R4], RInst[R5]}, 
          s[V1, I1], s[V2, I1]] \[TildeTilde] True, {R1}, 
      Constructor -> {I2, R2, R3, R4, R5, S, I1, V1}, TypeCheck -> False]\)], 
  "Input"],

Cell[BoxData[
    \({{R1 \[Rule] 
          \((\(-I1\)\ R2\ R3\ R4 - I1\ R2\ R4\ R5 - I1\ R3\ R4\ R5 - 
                R2\ R3\ V1 - R2\ R4\ V1 - R3\ R4\ V1 - R2\ R5\ V1 - 
                R3\ R5\ V1 + R2\ R3\ V2 + R2\ R4\ V2 + R3\ R4\ V2 + 
                R2\ R5\ V2 + R3\ R5\ V2)\)/
            \((I1\ R2\ R3 + I1\ R2\ R4 + I1\ R2\ R5 + I1\ R3\ R5 + 
                I1\ R4\ R5 + R3\ V1 + R4\ V1 + R5\ V1 - R3\ V2 - R4\ V2 - 
                R5\ V2)\)}}\)], "Output"]
}, Open  ]],

Cell["\<\
We end the CFLP session by closing the connections \
interpreter/scheduler and scheduler/constraint solvers.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CSEnd[]\)], "Input"],

Cell[BoxData[
    \("done."\)], "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->None,
WindowSize->{1095, 735},
WindowMargins->{{Automatic, 57}, {57, Automatic}},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 32, 0, 54, "Subtitle"],
Cell[1766, 53, 171, 4, 27, "Input",
  InitializationCell->True],
Cell[1940, 59, 724, 15, 86, "Text"],
Cell[2667, 76, 68, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[2760, 80, 47, 1, 27, "Input"],
Cell[2810, 83, 71, 1, 23, "Print"],
Cell[2884, 86, 80, 1, 23, "Print"],
Cell[2967, 89, 628, 17, 23, "Print"],
Cell[3598, 108, 577, 12, 23, "Print"],
Cell[4178, 122, 629, 17, 23, "Print"],
Cell[4810, 141, 577, 12, 23, "Print"],
Cell[5390, 155, 654, 18, 40, "Print"],
Cell[6047, 175, 577, 12, 23, "Print"],
Cell[6627, 189, 588, 16, 23, "Print"],
Cell[7218, 207, 577, 12, 23, "Print"],
Cell[7798, 221, 405, 10, 23, "Print"],
Cell[8206, 233, 544, 11, 23, "Print"],
Cell[8753, 246, 397, 9, 23, "Print"],
Cell[9153, 257, 529, 11, 23, "Print"],
Cell[9685, 270, 659, 17, 23, "Print"],
Cell[10347, 289, 574, 12, 23, "Print"],
Cell[10924, 303, 335, 7, 23, "Print"],
Cell[11262, 312, 326, 8, 23, "Print"],
Cell[11591, 322, 316, 6, 23, "Print"],
Cell[11910, 330, 553, 15, 23, "Print"],
Cell[12466, 347, 547, 11, 23, "Print"],
Cell[13016, 360, 452, 12, 23, "Print"],
Cell[13471, 374, 529, 11, 23, "Print"],
Cell[14003, 387, 333, 7, 23, "Print"],
Cell[14339, 396, 548, 13, 23, "Print"],
Cell[14890, 411, 553, 11, 23, "Print"],
Cell[15446, 424, 1590, 38, 39, "Print"],
Cell[17039, 464, 652, 12, 23, "Print"],
Cell[17694, 478, 608, 13, 23, "Print"]
}, Open  ]],
Cell[18317, 494, 204, 5, 32, "Text"],
Cell[18524, 501, 71, 1, 23, "Print"],
Cell[18598, 504, 80, 1, 23, "Print"],
Cell[18681, 507, 391, 8, 50, "Text"],
Cell[19075, 517, 397, 9, 23, "Print"],
Cell[19475, 528, 529, 11, 23, "Print"],
Cell[20007, 541, 659, 17, 23, "Print"],
Cell[20669, 560, 574, 12, 23, "Print"],
Cell[21246, 574, 335, 7, 23, "Print"],
Cell[21584, 583, 340, 6, 50, "Text"],
Cell[21927, 591, 230, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[22182, 599, 50, 1, 27, "Input"],
Cell[22235, 602, 169, 4, 38, "Print"]
}, Open  ]],
Cell[22419, 609, 169, 5, 32, "Text"],
Cell[22591, 616, 103, 5, 32, "Text"],
Cell[22697, 623, 29, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[22751, 627, 47, 1, 27, "Input"],
Cell[22801, 630, 147, 2, 23, "Print"]
}, Open  ]],
Cell[22963, 635, 315, 9, 32, "Text"],
Cell[23281, 646, 555, 18, 86, "Text"],
Cell[23839, 666, 2082, 59, 212, "Input"],
Cell[25924, 727, 446, 9, 68, "Text"],
Cell[26373, 738, 52, 1, 27, "Input"],
Cell[26428, 741, 198, 5, 32, "Text"],
Cell[26629, 748, 311, 6, 50, "Text"],

Cell[CellGroupData[{
Cell[26965, 758, 304, 5, 43, "Input"],
Cell[27272, 765, 205, 3, 44, "Output"]
}, Open  ]],
Cell[27492, 771, 213, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[27730, 780, 135, 2, 27, "Input"],
Cell[27868, 784, 78, 1, 27, "Output"]
}, Open  ]],
Cell[27961, 788, 148, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[28134, 794, 150, 2, 27, "Input"],
Cell[28287, 798, 75, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28399, 804, 40, 0, 45, "Subsection"],
Cell[28442, 806, 128, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[28595, 814, 44, 1, 27, "Input"],
Cell[28642, 817, 238, 3, 39, "Print"]
}, Open  ]],
Cell[28895, 823, 106, 2, 32, "Text"],
Cell[29004, 827, 4397, 66, 56, 4305, 63, "GraphicsData", 
"Bitmap", "Graphics"],
Cell[33404, 895, 45, 0, 32, "Text"],
Cell[33452, 897, 130, 2, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33619, 904, 52, 0, 45, "Subsection"],
Cell[33674, 906, 145, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[33844, 912, 209, 4, 59, "Input"],
Cell[34056, 918, 92, 1, 44, "Output"]
}, Open  ]],
Cell[34163, 922, 182, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[34370, 929, 432, 8, 59, "Input"],
Cell[34805, 939, 159, 2, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35001, 946, 41, 0, 42, "Subsubsection"],
Cell[35045, 948, 141, 4, 32, "Text"],
Cell[35189, 954, 154, 3, 32, "Text"],
Cell[35346, 959, 93, 1, 32, "Text"],
Cell[35442, 962, 1703, 52, 58, "Text"],
Cell[37148, 1016, 238, 5, 27, "Input"],
Cell[37389, 1023, 416, 9, 68, "Text"],
Cell[37808, 1034, 75, 0, 32, "Text"],
Cell[37886, 1036, 393, 7, 68, "Text"],
Cell[38282, 1045, 267, 5, 32, "Text"],
Cell[38552, 1052, 352, 5, 32, "Text"],
Cell[38907, 1059, 69, 0, 32, "Text"],
Cell[38979, 1061, 522, 9, 86, "Text"],
Cell[39504, 1072, 157, 2, 32, "Text"],
Cell[39664, 1076, 453, 7, 140, "Text"],
Cell[40120, 1085, 395, 8, 32, "Text"],
Cell[40518, 1095, 324, 6, 68, "Text"],
Cell[40845, 1103, 248, 8, 32, "Text"],
Cell[41096, 1113, 123, 2, 32, "Text"],
Cell[41222, 1117, 109, 2, 32, "Text"],
Cell[41334, 1121, 287, 5, 50, "Text"],
Cell[41624, 1128, 58, 0, 32, "Text"],
Cell[41685, 1130, 481, 8, 158, "Text"],
Cell[42169, 1140, 90, 3, 32, "Text"],
Cell[42262, 1145, 310, 5, 68, "Text"],
Cell[42575, 1152, 465, 13, 50, "Text"],
Cell[43043, 1167, 237, 4, 32, "Text"],
Cell[43283, 1173, 494, 10, 104, "Text"],
Cell[43780, 1185, 896, 18, 176, "Text"],
Cell[44679, 1205, 331, 6, 50, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45059, 1217, 42, 0, 45, "Subsection"],
Cell[45104, 1219, 133, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[45262, 1227, 46, 1, 27, "Input"],
Cell[45311, 1230, 240, 3, 39, "Print"]
}, Open  ]],
Cell[45566, 1236, 136, 3, 32, "Text"],
Cell[45705, 1241, 6742, 99, 140, 6667, 97, "GraphicsData", 
"Bitmap", "Graphics"],
Cell[52450, 1342, 45, 0, 32, "Text"],
Cell[52498, 1344, 132, 2, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52667, 1351, 54, 0, 45, "Subsection"],
Cell[52724, 1353, 125, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[52874, 1359, 211, 4, 59, "Input"],
Cell[53088, 1365, 183, 4, 44, "Output"]
}, Open  ]],
Cell[53286, 1372, 185, 3, 50, "Text"],
Cell[53474, 1377, 11256, 165, 179, 11181, 163, "GraphicsData", 
"Bitmap", "Graphics"],

Cell[CellGroupData[{
Cell[64755, 1546, 428, 8, 59, "Input"],
Cell[65186, 1556, 158, 3, 44, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[65393, 1565, 39, 0, 45, "Subsection"],
Cell[65435, 1567, 256, 6, 32, "Text"],

Cell[CellGroupData[{
Cell[65716, 1577, 44, 1, 27, "Input"],
Cell[65763, 1580, 135, 2, 23, "Print"]
}, Open  ]],
Cell[65913, 1585, 62, 0, 32, "Text"],
Cell[65978, 1587, 13959, 204, 169, 13884, 202, "GraphicsData", 
"Bitmap", "Graphics"],
Cell[79940, 1793, 677, 13, 248, "Text"],
Cell[80620, 1808, 246, 5, 27, "Input"],

Cell[CellGroupData[{
Cell[80891, 1817, 1015, 17, 203, "Input"],
Cell[81909, 1836, 3323, 79, 71, "Print"],
Cell[85235, 1917, 959, 19, 39, "Print"],
Cell[86197, 1938, 831, 17, 23, "Print"],
Cell[87031, 1957, 46, 1, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[87126, 1964, 52, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[87203, 1968, 115, 3, 42, "Subsubsection"],

Cell[CellGroupData[{
Cell[87343, 1975, 238, 4, 43, "Input"],
Cell[87584, 1981, 509, 9, 45, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[88142, 1996, 127, 3, 42, "Subsubsection"],
Cell[88272, 2001, 13867, 203, 163, 13774, 200, "GraphicsData", 
"Bitmap", "Graphics"],
Cell[102142, 2206, 73, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[102240, 2210, 251, 5, 43, "Input"],
Cell[102494, 2217, 470, 8, 43, "Output"]
}, Open  ]],
Cell[102979, 2228, 132, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[103136, 2235, 40, 1, 27, "Input"],
Cell[103179, 2238, 40, 1, 23, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

