%{// -*-Mode: C++ -*-
  // Copyright (C) 1996,1997 Buntarou Shizuki(shizuki@is.titech.ac.jp)
  
#include "parse.h"
#include "kl.tab.h"

static struct opt_table {
  char *token_name;
  int token_id;
} table[] = {
  {"define",	Opt_define},
  {"port",	Opt_port},
  {"size",	Opt_size},
  {"point",	Opt_point},
  {"type",	Opt_type},
  {"guard",	Opt_guard},
  {"rule",	Opt_rule},
  {"rule_id",	Opt_rule_id},
  {"atom",	Opt_atom},
  {"mesg",	Opt_mesg},
  {"merge",	Opt_merge},
  {"from",	Opt_from},
  {"into",	Opt_into},
  {"link",	Opt_link},
  {"unify",	Opt_unify},
  {"assign",	Opt_assign},
  {"list",	Opt_list},
  {"proc",	Opt_proc},
  {"begin",	Opt_begin},
  {"proc_part",	Opt_proc_part},
  {"other_part",Opt_other_part},
  {"end",	Opt_end},
  {"comment",	Opt_comment},
  {"creator",	Opt_creator},
  {"normal",	Opt_normal},
  {"network",	Opt_network},
  {"vanishing",	Opt_vanishing},
  {"continuous",Opt_continuous},
  {"transition",Opt_transition},
  {"single",	Opt_single},
  {"stream",	Opt_stream},
  {"left",	Opt_left},
  {"right",	Opt_right},
  {"arrange",	Opt_arrange},
  {"rightward",	Opt_rightward},
  {"downward",	Opt_downward},
  {"pattern_top", Opt_pattern_top},
  {"pattern",	Opt_pattern},
  {"layout",	Opt_layout},
  {NULL,	-1}
};

static int line_num;

%}

%x operator comment

newline		\n
ws		[ \t]+
digit		[0-9]
alnum		[_A-Za-z0-9]
symbol		[a-z]{alnum}*(:[a-z]{alnum}*)?
variable	[_A-Z]{alnum}*

%%

{ws}			/* skip blanks */
{newline}		++line_num;
"mod"			{ return Mod; }
{symbol}		{ char *sym_head = yytext;
			  char *sym_tail = strchr(yytext, ':');
			  char *sym_module, *sym_name;
			  if (sym_tail) {
			    *sym_tail = '\0';
			    sym_tail++;
			    sym_module = (NAMETYPE) get_symbol(sym_head);
			    sym_name   = (NAMETYPE) get_symbol(sym_tail);
			  } else {
			    sym_module = (NAMETYPE) NULL;
			    sym_name   = (NAMETYPE) get_symbol(sym_head);
			  }
// 			  printf("SYMBOL module=%s : name=%s\n",
// 				 sym_module ? sym_module : "NULL", sym_name);
			  rrlval.rrSymbol.module = (NAMETYPE) sym_module;
			  rrlval.rrSymbol.name =   (NAMETYPE) sym_name;
			  return Symbol; }
{variable}		{ rrlval.rrVariable.name = (NAMETYPE) get_symbol(yytext);
			  return Variable; }
{digit}+		{ rrlval.rrInteger.value = atol(yytext);
			  return Integer; }
'[^\n']*'		{ yytext[strlen(yytext)-1] = '\0';
			  rrlval.rrString.str = (NAMETYPE) get_symbol(yytext+1);
			  return String; }
"+"			{ return '+'; }
"-"			{ return '-'; }
"*"			{ return '*'; }
"/"			{ return '/'; }
"("			{ return '('; }
")"			{ return ')'; }
"["			{ return '['; }
"]"			{ return ']'; }
"{"			{ return '{'; }
"}"			{ return '}'; }
"<"			{ return '<'; }
">"			{ return '>'; }
"."			{ return '.'; }
","			{ return ','; }
"|"			{ return '|'; }
"="			{ return '='; }
"~"			{ return '~'; }
"\\"			{ return '\\'; }
"/\\"			{ return Land; }
"\\/"			{ return Lor; }
"=:="			{ return '='; }
":="			{ return Assign; }
":-"			{ return Imply; }
"?"			{ return '?'; }	// for tracing
":"			{ return ':'; }	// for tracing
"!"			{ return '!'; }	// for tracing
"%"			{ BEGIN(operator); }

<operator>{ws}
<operator>{variable}	{ rrlval.rrOpt_VARIABLE.name = (NAMETYPE) get_symbol(yytext);
			  return Opt_VARIABLE; }
<operator>'{symbol}	{ rrlval.rrOpt_SYMBOL.name = (NAMETYPE) get_symbol(&yytext[1]);
			  return Opt_SYMBOL; }
<operator>'{variable}	{ rrlval.rrOpt_SYMBOL.name = (NAMETYPE) get_symbol(&yytext[1]);
			  return Opt_SYMBOL; } // crazy!!!
<operator>{symbol}	{ struct opt_table *p;
			  //
			  // if symbol is a reserved word
			  //
			  for (p = &table[0]; p->token_name != NULL; p++) {
			    if (strcmp(yytext, p->token_name) == 0) {
			      return p->token_id;
			    }
			  }
			  //
			  // otherwise, return NULL
			  //
			  return NULL;
			}
<operator>{digit}+	{ rrlval.rrInteger.value = atol(yytext);
			  return Integer; }
<operator>'[^\n']*'	{ yytext[strlen(yytext)-1] = '\0';
			  rrlval.rrString.str = (NAMETYPE) strdup(yytext+1); // XXX
			  return String; }

<operator>"/"		{ return '/'; }
<operator>"-"		{ return '-'; }
<operator>"+"		{ return '+'; }
<operator>\n		{ ++line_num;
			  BEGIN(INITIAL); }

"/*"			BEGIN(comment);

<comment>[^*\n]*
<comment>"*"+[^*/\n]*
<comment>\n		++line_num;
<comment>"*"+"/"	BEGIN(INITIAL);

%%

int fghc_parse(char *path)
{
  FILE *fp;

  fp = fopen(path, "r");
  if (fp == NULL) {
    return 1;
  }
  yyin = fp;
  line_num = 1;
  yyparse();
  fclose(fp);

  return 0;
}

int tracer_parse(FILE *in)
{
  yyin = in;
  line_num = 1;
  int ret = yyparse();
  return 0;
}

extern "C"
int yyerror(char *message)
{
  fprintf(stderr, "near line %d: %s\n", line_num, message);
  return 0;
}

/* eof */
