// Copyright (C) 1997  Toyoda Masashi (toyoda@is.titech.ac.jp)

#ifndef _INTERNAL_

// ------------------------------------------------------------
// Objects
// ------------------------------------------------------------

extern Am_Object ProcessModel;
extern Am_Object ProcessProto;
extern Am_Object HoleModel;
extern Am_Object HoleProto;
extern Am_Object ReplHolesProto;
extern Am_Object ImplDialog;

// ------------------------------------------------------------
// Functions
// ------------------------------------------------------------

Am_Object Process_Get_Interface(Am_Object proc);
void Process_Set_Module(Am_Object proc, Am_Object module);
Am_Object Process_Goal_Create(Am_Object proc);
Am_Object Process_Inter_Module_Goal_Create(Am_Object proc);
Am_Object Process_Inter_Module_Goal_New(Am_String name, Am_String mname);
bool Single_Hole_Replace(Am_Object hole, Am_Object proc);
bool Single_Hole_Recover(Am_Object proc);
bool Hole_Recover(Am_Object proc);

void Popup_Wait_Impl_Selection_Dialog(Am_Object hole, int x, int y);

// ------------------------------------------------------------
// Initialize
// ------------------------------------------------------------

void InitializeProcess(void);
#endif

enum ProcessType { ProcessInterface = 0, ProcessGoal = 1, ProcessInterGoal = 2 };
