%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%  tclIF.pl: Tcl/Tk interface in PRISM
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Copyright (C) 1998
%%%    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
%%%      Dept. of Computer Science, Tokyo Institute of Technology.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

filewindow(X,Filename) :-
	tk_new([name('PRISM: Please select a PRISM program to OPEN..')],Interp),
%	tcl_eval(Interp,'set currentfont -adobe-courier-bold-r-normal-*-18-*',_),
	tcl_eval(Interp,'set currentfont *courier*bold-r*-18-*',_),
	tcl_eval(Interp,'
## show *.psm in current directory
    proc getfile fd {
    set pwd [pwd]
    set tmp [setFileList $pwd]
    .interface.dirname configure -text $tmp
    .filelist.box.listbox delete 0 end
    set filelist [glob -nocomplain $pwd/*]
    set filelist [lsort $filelist]
    if [catch {set files [glob .*]}] {
	set files {}
    }
## set default width of a window for filename
    set max 20
    set filelist2 [concat $files $filelist]
    foreach i $filelist2 {
	set check 0
## procedure for *.psm
	if {[file isfile $i]&&[string match *.psm $i]} {
	    .filelist.box.listbox insert end "[file tail $i]"
	    set check 1
	}
## procedure for directory
	if {[file isdirectory $i]} {
	    .filelist.box.listbox insert end "[file tail $i]/"
	    set check 1
	}
## check whether the width is sufficient
	if {$check==1} {
	    set tmp [string length [file tail $i]]
	    if {$max < $tmp} {
		set max $tmp
		set tmp2 [file tail $i]
	    }
	}	
    }
##    .interface.l1 configure -text $i
    .filelist.box.listbox configure -width $max
    .filelist.box.listbox selection anchor end
}
',_),tcl_eval(Interp,'
proc setFileList f {
## Show current path
    set pwd [pwd]
    set max 20
## Show only last $max letters
## if the length of current path is more than $max.
    if {[string length $pwd] > $max} {
## Transform current path into a list of directories,
## and re-connect directories from last one till the length is under $max.
     set list [split [string trim $pwd "/"] "/"]
     set len [llength $list]
     set prev ""
     for {set i $len} {1} {incr i -1} {
## $cur have the elements from rightmost to current one.
## $prev have the connection of the elements without current one.
       set elem [lindex $list [expr $i - 1]]
       set cur "$elem/$prev"
## if the length of $cur exceeds $max - 5, 
       if {[string length $cur] > [expr $max-5]} {
## Set the name as current directory "/.../"$prev
         if {$i == $len} {set prev $elem} 
         set pwd "/.../$prev"
         break;
       }
       set prev $cur
     }
  }
  return $pwd
}
',_),tcl_eval(Interp,'
## Choose a loading file
proc see {} {
    global selected
    set index [.filelist.box.listbox curselection]
## If no choice, ignore.
    if {$index == ""} {
        tk_dialog .warning "PRISM: WARNING" "Choose a PRISM program or a directory." \
            warning 0 OK
	set data ""
    } else {
	set data [.filelist.box.listbox get $index]
## Check chosen one is not "/". 
	if {$data  != "/"} {
	    set data [string trimright $data "/"]
	}
## If a directory is chosen, move directory.
	if [file isdirectory $data] {
	    set pwd [pwd]
	    set newpath $pwd/$data
	    cd $newpath
	    set pwd [pwd]
	    set tmp [setFileList $pwd]
	    .interface.dirname configure -text $tmp
	    getfile .
	}
## If a file is chosen, load the file.
	if [file isfile $data] {
##	    .interface.l1 configure -text $data
	    set selected $data
	}
    }
}',_),
tcl_eval(Interp,'
proc cancel {} {
    global selected con
    set selected ""
    set con 0
}
',_),
tcl_eval(Interp,'
## Show a window.
proc window fd {
    global selected currentfont con
    frame .filelist
    frame .filelist.box
    frame .interface
    frame .interface.button
    frame .interface.radio

    set con 0
    scrollbar .filelist.box.scroll -bd 2 -relief ridge \
	-command ".filelist.box.listbox yview" 
    listbox .filelist.box.listbox -width 20 -height 10 -bd 2 -relief ridge \
    -font $currentfont -yscrollcommand ".filelist.box.scroll set" -selectmode browse
    # To prohibit choose more than one element in the listbox
    # tk_listboxSingleSelect .filelist.box.listbox
    bind .filelist.box.listbox <Double-ButtonPress-1> { .interface.button.b1 invoke }
    # Force to load the double-clicked file.
    button .interface.button.b1 -text "OK" -command see -font $currentfont
    # Force to load the chosen file.
    button .interface.button.b3 -text "Cancel" -command cancel -font $currentfont
    # Cancel to load a file
    radiobutton .interface.radio.compile -text "compile" -value 1 -variable con \
                                         -font $currentfont
    radiobutton .interface.radio.consult -text "consult" -value 2 -variable con \
					 -font $currentfont
    .interface.radio.compile select
    # select to consult/compile a file
    label .interface.l0 -text "Directory" -font $currentfont
    label .interface.dirname -relief ridge -bd 2 -width 20 -anchor w -font $currentfont

    pack .filelist.box.listbox .filelist.box.scroll -in .filelist.box \
	    -side left -padx 1m -pady 1m -fill y
    pack .interface.l0 -in .interface -side top -padx 1m -pady 1m
    pack .interface.dirname -in .interface -side top -padx 2m -pady 1m -anchor w
    pack .filelist.box -in .filelist -side top -padx 1m -pady 1m
    pack .interface.button.b1 .interface.button.b3 -side left -padx 1m -pady 2m
    pack .interface.button 
    pack .interface.radio.compile .interface.radio.consult -side left -padx 1m -pady 2m
    pack .interface.radio

##    pack .interface.l1
    pack .filelist .interface -side left -fill y
    getfile .
## Wait till user chooses a file.
    tkwait variable selected
    destroy .
#    return [string trimright $selected .psm]
    return [list $con [string range $selected 0 [expr [string length $selected]-5]]]
#    return [split $selected .]
}',_),!,
tcl_eval(Interp,'window .',Result),tk_main_loop,tcl_delete(Interp),
Result=[X,_|Result2],name(Filename,Result2),!.

prism :- 
	filewindow(X,Filename),!,
	((X=48, !, write('{PRISM WARNING: Loading a PRISM program is cancelled.}'),nl);
	 (X=49, !, prism([compile],Filename));                           % X='1'
	 (X=50, !, prism([consult],Filename))).                          % X='2'
