/************************************************************************
 **  random.c: pseudorandom number generator
 **
 **  Copyright (C) 1998
 **    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
 **      Dept. of Computer Science, Tokyo Institute of Technology.
 ************************************************************************/

#include "prism.h"
long seed;

/*
 *  Using mixed congruential method 
 *  X(n+1) = (a*X(n)+c) mod m
 */

void set_seed(long s)
{
    seed = (long) s;
	printf("{set_seed(%lu) -- random seed set to %lu.}\n",s,s);
}

/* for set_seed_time/0 */
void set_seed_time(void)
{
  long seed_time;

  seed_time = (long)time(NULL);
  seed = seed_time;
  printf("{set_seed_time -- random seed set to %lu.}\n",seed_time);
}

/* for set_seed_time/1 */
long set_seed_time1(void)
{
  long seed_time;

  seed_time = (long)time(NULL);
  seed = seed_time;
  return seed_time;
}

void show_seed(void)
{
  printf("random seed is set to %lu.\n",seed);
}

long random_generator(long *s)
{
    *s = ((*s)*A+C) % M;
    return (*s -= (*s < 0 ? M:0));
}

/* generate double number in [0,f] */
double random_float(double f)
{
  return (double) (f * ((double)random_generator(&seed)/(double)M));
}

int random_int(int i)
{
  return (int)(i * random_float(1.0));
}
