/************************************************************************
 **  prob.c: C part of probability calculation.
 **
 **  Copyright (C) 1998
 **    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
 **      Dept. of Computer Science, Tokyo Institute of Technology.
 ************************************************************************/
 
#include "prism.h"

/* Global variables */
struct swlink *PRoot;
struct swlink *PCrr;
int PCount; /* The number of explanations for "prob" goal */

/* prob $B%3%^%s%IMQ$N(B global $BJQ?t(B:
 *  [NOTE1] $B3FJQ?t$O(B idNum,idNum1,..., theta $B$K3F!9BP1~$9$k!%(B
 *  [NOTE2] PRISM $B$N(B prob $B%3%^%s%I$O(B1$B$D$N%4!<%k$N3NN($r7W;;$9$k$@$1(B
 *          $B$J$N$G!$(BPG $B$O%]%$%s%?$G$J$/$F$h$$!%(B
 */
int pidNum,pidNum1,pvalueNum,pvalueNum1,pvalueNum2,pivNum11;  
struct goal PG; 
struct switchInfo *Pswitch_info;
double *ptheta;

/* [NOTE]
 * $B3NN($r7W;;$9$k$N$_$N$H$-$O(B Gamma $B$NItJ,$OI,MW$J$$0Y!$(BEM learning $BMQ(B
 * $B$N(B table $B$H$O0[$J$j!$(Bprob $B%3%^%s%IMQ$N(B explanation table $B$O(B Gamma $B$N(B
 * $BMs$r;}$?$J$$!%(B
 */

/*
 * For initialization, cancellation,..
 */

/* (Prolog name) really_init_prob */
void initProb(void)
{
  PRoot=LNULL;
  PCrr=LNULL;
  PG.table=(int *)NULL;
  Pswitch_info=(struct switchInfo *)NULL;
  ptheta=(double *)NULL;
  set_PidInfo(-2,(int)NULL);
}

/* (Prolog name) init_prob_table */
void freePMemory(void)
{
  int flag=0;

  if (PG.table != (int *)NULL){
	free(PG.table);
	PG.table=(int *)NULL;
	flag=1;
  }
  if (Pswitch_info != (struct switchInfo *)NULL){
	free(Pswitch_info);
	Pswitch_info=(struct switchInfo *)NULL;
	flag=1;
  }
  if (ptheta != (double *)NULL){
	free(ptheta);
	ptheta=(double *)NULL;
	flag=1;
  }
  set_PidInfo(-2,(int)NULL);

  /*
	if(flag) printf("{Previos explanation table for 'prob' cleaned up.}\n"); 
  */
}

/* (Prolog name) prepare_prob_trie */
int prepare_prob_trie(void)
{
  /* [NOTE] PRoot $B$O(B struct swlink $B$X$N%]%$%s%?(B */

  get_Ptrie(-1,(int)NULL,(int)NULL,(int)NULL);
  /* get_Ptrie $B$N(B static $BJQ?t(B pignore $B$r(B 0 $B$K=i4|2=(B */
  if ((PRoot = lalloc())==LNULL) return(0);
  else {
	PRoot->Sw=SNULL;
	PRoot->NextSw=LNULL;
	PCrr=PRoot;
	return(1);
  }
}

/* (Prolog name) cancel_prob
 * added by kame on Nov/20/1997.
 */
void cancelProb(void)
{
  free(PRoot);
  PRoot=LNULL;
  PCount=0;
  PCrr=LNULL;

  freePMemory();
}

void return_to_prob_root(void)
{
  PCrr=PRoot;
}

void add_prob_count(int n)
{
  PCount += n;
}

int get_Ptrie(int flag, int g_id, int t_id, int val)
{
  static int pignore=0;

  if (flag==-1) { pignore=0; return(1); }

  if (pignore)
	switch(flag){
	case 1: return(1);
	case 0: pignore=0; return_to_prob_root(); return(1);
	default: return(0);
	}

  if (PCrr->Sw==SNULL) {

	if((PCrr->Sw=salloc())==SNULL) return(0);

	PCrr->Sw->G_id = (short)g_id;
	PCrr->Sw->T_id = (short)t_id;
	PCrr->Sw->Val  = (short)val;

	switch(flag){
	case 1:
	  if ((PCrr->Sw->Child=lalloc())==LNULL) return(0);
	  PCrr->Sw->Child->Sw=SNULL;
	  PCrr->Sw->Child->NextSw=LNULL;
	  PCrr=PCrr->Sw->Child;
	  break;
	case 0:
	  PCrr->Sw->Child=LNULL;
	  add_prob_count(1);
	  return_to_prob_root();
	  break;
	default:
	  printf("{PRISM INTERNAL ERROR: get_Ptrie(%d,_,_,_) -- ",flag);
	  printf("%d must be 0 or 1.}",flag);
	  return(0);
	}
	return(1);
  }
  else {
	while(1){
	  if (compare_sw(PCrr->Sw,g_id,t_id,val)){ /* $B0JA0$N(B trie $B$H%N!<%I6&M-(B */

		if (PCrr->Sw->Child==LNULL)
		  switch(flag){
		  case 1:     /* $BF~NO$HESCf$^$GF1$8(B explanation $B$,0JA0$K$bB8:_$7$?(B */
			pignore=1;         /* flag $B$,(B 0 $B$N8F$S=P$7$,$"$k$^$G2?$b$7$J$$(B */
			break;
		  case 0:         /* $BF~NO$HA4$/F1$8(B explanation $B$,0JA0$K$bB8:_$7$?(B */
			return_to_prob_root();    /*      PRoot $B$KLa$k0J30$O2?$b$7$J$$(B */
			break;                    /* (modified by kame on Dec/13/1997) */
		  default:
			printf("{PRISM INTERNAL ERROR: get_Ptrie(%d,_,_,_) -- ",flag);
			printf("%d must be 0 or 1.}",flag);
			return(0);
		  }
		else {
		  switch(flag){
		  case 1:
			PCrr=PCrr->Sw->Child;                /* $B99$K0JA0$N(B trie $B$rC)$k(B */
			break;
		  case 0:
			/* $B?7$7$$(B explanation $B$NJ}$,0JA0$N(B explanation $B$r(B subsume $B$9$k(B
             * $B$N$G0JA0$N(B explanation $B$r:o=|!%(B
             * <ex.>
             *   $B4{$K(B B & C v B & D $B$,$"$C$?;~!$?7$?$K(B B $B$,F~NO$5$l$?$i(B
             *   B & C v B & D v B <=> B $B$J$N$G(B C, D $B$r:o=|$7!$(BB $B$@$1$K(B
             *   $B$7$J$1$l$P$J$i$J$$!%(B
             *
			 * explanation $B$N?t$O>C$7$?;R6!$N?t(B-1 $B$r0z$$$F$*$/!%(B
             * (add_prob_count()$B$r;HMQ(B)
             */
			add_prob_count(1-freeChild(PCrr->Sw->Child));
			PCrr->Sw->Child=LNULL;
			return_to_prob_root();
			break;
		  defalut:
			printf("{PRISM INTERNAL ERROR: get_Ptrie(%d,_,_,_) -- ",flag);
			printf("%d must be 0 or 1.}",flag);
			return(0);
		  }
		} /* else{.. */
		break;
	  } /* if (compare_sw(...)){ */
	  else if (PCrr->NextSw==LNULL) {

		if ((PCrr->NextSw = lalloc())==LNULL) return(0);
		if ((PCrr->NextSw->Sw = salloc())==SNULL) return(0);
		PCrr->NextSw->NextSw=LNULL;

		PCrr->NextSw->Sw->G_id = (short)g_id;
		PCrr->NextSw->Sw->T_id = (short)t_id;
		PCrr->NextSw->Sw->Val  = (short)val;
		
		switch(flag){
		case 1:
		  if ((PCrr->NextSw->Sw->Child = lalloc())==LNULL) return(0);
		  PCrr=PCrr->NextSw->Sw->Child;
		  PCrr->Sw=SNULL;
		  PCrr->NextSw=LNULL;
		  break;
		case 0:
		  PCrr->NextSw->Sw->Child=LNULL;
		  add_prob_count(1);
		  return_to_prob_root();
		  break;
		default:
		  printf("{PRISM INTERNAL ERROR: get_Ptrie(%d,_,_,_) -- ",flag);
		  printf("%d must be 0 or 1.}",flag);
		  return(0);
		}
		break;
	  } /* else if (...){ */
	  else PCrr=PCrr->NextSw;
	} /* while(1){ */
	return(1);
  } /* else { */
}

void free_Ptrie(void)
{
  int de; /* deleted explanations */

  if (PRoot != LNULL) {
	de = freeChild(PRoot);
	/* printf("Prob_Goal(%d) deleted %d expls\n",PCount,de); */
	PRoot=LNULL;
  }
  PCount=0;
  PCrr=LNULL;
}

int set_PGstatus(void)
{
  PG.Snum = PCount;
  if ((PG.table=(int *)malloc(sizeof(int)*pivNum11*PCount))==(int *)NULL)
	return(0);
  PG.observedNum=1;   /* $B3NN(7W;;$K$OI,MW$J$$$N$G(B 1 $B$H$$$&CM$K0UL#$O$J$$!%(B*/
  return(1);
}

int count_expls_P(void)
{
  int *ebuf;
  int i;

  /* copy_to_table_P $B$N(B static $BJQ?t(B index $B$r=i4|2=(B */
  copy_to_table_P(0,(int *)NULL);

  if ((ebuf=(int *)malloc(sizeof(int)*pivNum11))==(int *)NULL)
	return(0);
  for(i=0;i<pivNum11;i++) ebuf[i]=0;
  
  return count_an_expl_P(PRoot,ebuf);
}

int count_an_expl_P(struct swlink *swlp, int *ebuf)
{
  struct sw *swp;
  int *ebufcopy;
  int i,g,flag,r1,r2;

  swp=swlp->Sw;

  /* $BJ,4t$,$"$k$H$-$K$O@h$:(B ebuf $B$r(B ebufcopy $B$K%3%T!<$7$F$*$/(B */

  if(swlp->NextSw != LNULL){
	if((ebufcopy=(int *)malloc(sizeof(int)*pivNum11))==(int *)NULL)
	  return(0);
	for(i=0;i<pivNum11;i++) ebufcopy[i]=ebuf[i];
  }

  /* swp->G_id $B$O(B Prolog $BCf$G3d$jEv$F$i$l$?@0?t%3!<%I$G(B
   * 0 $B$+$i(B pidNum $B$^$GO"B3CM$r$H$k$H$O8B$i$J$$$?$a!$(B
   * Pswitch_info[i].idInProlog $B$H%^%C%A$9$k(B i $B$rC5$7!$(Bg $B$KBeF~$9$k!%(B
   */
  flag=0;
  for(i=0;i<=pidNum;i++)
	if(swp->G_id==Pswitch_info[i].idInProlog){ g=i; flag=1; }

  if (flag==0) {
	printf("{PRISM INTERNAL ERROR: Unknown switch %d occurs in trie.}\n",
		   swp->G_id);
	return(0);
  }
  
  ebuf[g*pvalueNum1+swp->Val] += 1;    /* $B=P8=$7$?(B switch $B$r%+%&%s%H(B */

  /* $BJ,4t$9$kA0$K<+J,$N;R$K$D$$$F%+%&%s%H(B
   * (explanation table $B$N9T$N=gHV$KH?1G(B)
   */
  if (swp->Child == LNULL) {
	copy_to_table_P(1,ebuf);
	r1=1;
  }
  else r1=count_an_expl_P(swp->Child, ebuf);

  /* $BJ,4t(B */
  if (swlp->NextSw != LNULL)
	r2=count_an_expl_P(swlp->NextSw, ebufcopy);
  else r2=1;

  return r1&&r2;
}

void copy_to_table_P(int flag, int *ebuf)
{
  static int index=0;
  int i,j;

  if (flag==0) index=0;                   /* flag==0 $B$J$iFCJL$K=i4|2=(B */
  else {
	for(i=0;i<pivNum11;i++)
	  *(PG.table+index+i)=ebuf[i];                    /* $BC1=c$K%3%T!<(B */
	index += pivNum11;
	free(ebuf);                               /* $B%3%T!<$7=*$o$C$?$i>C$9(B */
  }
}

int set_Pvalues(int id, int mmvalue)
{
  pidNum=id;  pidNum1=pidNum+1;
  pvalueNum=mmvalue;  pvalueNum1=mmvalue+1;  pvalueNum2=mmvalue+2;
  pivNum11=pidNum1*pvalueNum1;

  if ((Pswitch_info =
	   (struct switchInfo *)malloc(sizeof(struct switchInfo)*
								   pidNum1))==(struct switchInfo *)NULL)
	return(0);
  if ((ptheta = (double *)malloc(pivNum11*sizeof(double)))==NULL)
	return(0);

  return set_PGstatus();
}

/* $B3F(B switch $B$K4X$9$k>pJs$r@_Dj(B */
int set_PidInfo(int id, int maxval)
{
  /* Prolog $BB&$GEO$5$l$k(B switch $B$N(B G_id $B$OO"B3$7$?(B 0,...,pidNum $B$G(B
   * $B$"$k$H$O8B$i$J$$$N$G(B static $BJQ?t(B num $B$G4IM}$9$k(B	 
   */
  static int num=0;  

  if(id < 0){
	num=0; return(1);                /* id < 0 $B$N$H$-$OFCJL$K=i4|2=(B*/
  }

  if (num > pidNum) {
	printf("{PRISM INTERNAL ERROR: set_PidInfo(%d,%d)",id,maxval);
	printf("-- num(%d) exceeds idNum(%d)\n",num,pidNum);
	return(0);
  }

  Pswitch_info[num].idInProlog = id;
  Pswitch_info[num].maxValue   = maxval;
  Pswitch_info[num].Tnum       = 0;  /* $B;HMQ$7$J$$$N$G(B 0 $B$H$$$&?t$K0UL#$J$7(B */
  Pswitch_info[num].fixed      = NOTFIXED;

  num++;
  return(1);
}

int set_Ptheta(int id, int v, double param)
{
  int i,g_id,flag;

  flag=0;
  for(i=0;i<=pidNum;i++)
	if(id==Pswitch_info[i].idInProlog){ g_id=i; flag=1; }

  if (flag==0) {
	printf("{PRISM INTERNAL ERROR: Unknown switch %d occurs in trie.}\n",id);
	return(0);
  }
  
  ptheta[g_id*pvalueNum1+v]=param;

  return(1);
}

double calc_prob(void)
{
  double Pf, Pdb=0.0;
  int s,i,v,tmps;

  for(s=0; s<PG.Snum; s++){
	Pf=1.0;
	for(i=0; i<=pidNum; i++)
	  for(v=0; v<=Pswitch_info[i].maxValue; v++){
		/* We redefine pow() such that pow(x,0)=1.0 for any x.
         * Modified by kame on Nov/26/1997
         */
		tmps = PSeq1(s,i,v);
		Pf *= (tmps==0)? 1.0: pow(PTheta(i,v),tmps);
	  }
	Pdb += Pf;
  }
  return Pdb;
}

/*
 *   PRINTER FUNCTIONS:
 */
void show_Ptable(void)
{
  int s,i,v;

  printf("\n|Expl|\n+----+\n");
  for(s=0;s<PG.Snum;s++){
	printf("|%4d|",s);
	for(i=0;i<=pidNum;i++)
	  for(v=0;v<=Pswitch_info[i].maxValue;v++){
		printf("%1d",PSeq1(s,i,v));
		if(v != Pswitch_info[i].maxValue) printf(" ");
		else printf("|");
	  }
	printf("\n");
  }
}

void show_Ptrie(void)
{
  if (PRoot != LNULL) show_expl(0,PRoot);
}
